/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import io.confluent.auditlogapi.entities.AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinations;
import io.confluent.auditlogapi.entities.AuditLogConfigMetadata;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategories;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_AuditLogConfigSpec
extends AuditLogConfigSpec {
    private final AuditLogConfigDestinations destinations;
    private final ImmutableSortedSet<String> excludedPrincipals;
    private final AuditLogConfigDefaultTopics defaultTopics;
    private final ImmutableSortedMap<String, AuditLogConfigRouteCategories> routes;
    private final AuditLogConfigMetadata metadata;

    private AutoValue_AuditLogConfigSpec(AuditLogConfigDestinations destinations, ImmutableSortedSet<String> excludedPrincipals, AuditLogConfigDefaultTopics defaultTopics, ImmutableSortedMap<String, AuditLogConfigRouteCategories> routes, @Nullable AuditLogConfigMetadata metadata) {
        this.destinations = destinations;
        this.excludedPrincipals = excludedPrincipals;
        this.defaultTopics = defaultTopics;
        this.routes = routes;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="destinations")
    public AuditLogConfigDestinations getDestinations() {
        return this.destinations;
    }

    @Override
    @JsonProperty(value="excluded_principals")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableSortedSet<String> getExcludedPrincipals() {
        return this.excludedPrincipals;
    }

    @Override
    @JsonProperty(value="default_topics")
    public AuditLogConfigDefaultTopics getDefaultTopics() {
        return this.defaultTopics;
    }

    @Override
    @JsonProperty(value="routes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableSortedMap<String, AuditLogConfigRouteCategories> getRoutes() {
        return this.routes;
    }

    @Override
    @Nullable
    @JsonProperty(value="metadata")
    public AuditLogConfigMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "AuditLogConfigSpec{destinations=" + this.destinations + ", excludedPrincipals=" + this.excludedPrincipals + ", defaultTopics=" + this.defaultTopics + ", routes=" + this.routes + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditLogConfigSpec) {
            AuditLogConfigSpec that = (AuditLogConfigSpec)o;
            return this.destinations.equals(that.getDestinations()) && this.excludedPrincipals.equals(that.getExcludedPrincipals()) && this.defaultTopics.equals(that.getDefaultTopics()) && this.routes.equals(that.getRoutes()) && (this.metadata == null ? that.getMetadata() == null : this.metadata.equals(that.getMetadata()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.destinations.hashCode();
        h$ *= 1000003;
        h$ ^= this.excludedPrincipals.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultTopics.hashCode();
        h$ *= 1000003;
        h$ ^= this.routes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.metadata == null ? 0 : this.metadata.hashCode();
    }

    @Override
    public AuditLogConfigSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AuditLogConfigSpec.Builder {
        private AuditLogConfigDestinations destinations;
        private ImmutableSortedSet.Builder<String> excludedPrincipalsBuilder$;
        private ImmutableSortedSet<String> excludedPrincipals;
        private AuditLogConfigDefaultTopics defaultTopics;
        private ImmutableSortedMap.Builder<String, AuditLogConfigRouteCategories> routesBuilder$;
        private ImmutableSortedMap<String, AuditLogConfigRouteCategories> routes;
        private AuditLogConfigMetadata metadata;

        Builder() {
        }

        private Builder(AuditLogConfigSpec source) {
            this.destinations = source.getDestinations();
            this.excludedPrincipals = source.getExcludedPrincipals();
            this.defaultTopics = source.getDefaultTopics();
            this.routes = source.getRoutes();
            this.metadata = source.getMetadata();
        }

        @Override
        public AuditLogConfigSpec.Builder destinations(AuditLogConfigDestinations destinations) {
            if (destinations == null) {
                throw new NullPointerException("Null destinations");
            }
            this.destinations = destinations;
            return this;
        }

        @Override
        public AuditLogConfigSpec.Builder excludedPrincipals(Collection<String> excludedPrincipals) {
            if (this.excludedPrincipalsBuilder$ != null) {
                throw new IllegalStateException("Cannot set excludedPrincipals after calling excludedPrincipalsBuilder()");
            }
            this.excludedPrincipals = ImmutableSortedSet.copyOf(excludedPrincipals);
            return this;
        }

        @Override
        ImmutableSortedSet.Builder<String> excludedPrincipalsBuilder() {
            if (this.excludedPrincipalsBuilder$ == null) {
                if (this.excludedPrincipals == null) {
                    this.excludedPrincipalsBuilder$ = ImmutableSortedSet.naturalOrder();
                } else {
                    this.excludedPrincipalsBuilder$ = ImmutableSortedSet.naturalOrder();
                    this.excludedPrincipalsBuilder$.addAll(this.excludedPrincipals);
                    this.excludedPrincipals = null;
                }
            }
            return this.excludedPrincipalsBuilder$;
        }

        @Override
        public AuditLogConfigSpec.Builder defaultTopics(AuditLogConfigDefaultTopics defaultTopics) {
            if (defaultTopics == null) {
                throw new NullPointerException("Null defaultTopics");
            }
            this.defaultTopics = defaultTopics;
            return this;
        }

        @Override
        public AuditLogConfigSpec.Builder routes(Map<String, AuditLogConfigRouteCategories> routes) {
            if (this.routesBuilder$ != null) {
                throw new IllegalStateException("Cannot set routes after calling routesBuilder()");
            }
            this.routes = ImmutableSortedMap.copyOf(routes);
            return this;
        }

        @Override
        ImmutableSortedMap.Builder<String, AuditLogConfigRouteCategories> routesBuilder() {
            if (this.routesBuilder$ == null) {
                if (this.routes == null) {
                    this.routesBuilder$ = ImmutableSortedMap.naturalOrder();
                } else {
                    this.routesBuilder$ = ImmutableSortedMap.naturalOrder();
                    this.routesBuilder$.putAll(this.routes);
                    this.routes = null;
                }
            }
            return this.routesBuilder$;
        }

        @Override
        public AuditLogConfigSpec.Builder metadata(AuditLogConfigMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        @Nullable
        Optional<AuditLogConfigMetadata> getMetadata() {
            if (this.metadata == null) {
                return Optional.empty();
            }
            return Optional.of(this.metadata);
        }

        @Override
        AuditLogConfigSpec autoBuild() {
            if (this.excludedPrincipalsBuilder$ != null) {
                this.excludedPrincipals = this.excludedPrincipalsBuilder$.build();
            } else if (this.excludedPrincipals == null) {
                this.excludedPrincipals = ImmutableSortedSet.of();
            }
            if (this.routesBuilder$ != null) {
                this.routes = this.routesBuilder$.build();
            } else if (this.routes == null) {
                this.routes = ImmutableSortedMap.of();
            }
            String missing = "";
            if (this.destinations == null) {
                missing = missing + " destinations";
            }
            if (this.defaultTopics == null) {
                missing = missing + " defaultTopics";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AuditLogConfigSpec(this.destinations, this.excludedPrincipals, this.defaultTopics, this.routes, this.metadata);
        }
    }
}

