/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.store;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.errors.RetriableException;

public class AuditLogConfigStorePartialSuccessException
extends RetriableException {
    private final AuditLogConfigSpec spec;
    private final ImmutableSet<String> successes;
    private final ImmutableMap<String, Throwable> failures;

    public AuditLogConfigStorePartialSuccessException(AuditLogConfigSpec spec, Set<String> successes, Map<String, Throwable> failures) {
        this.spec = spec;
        this.successes = ImmutableSet.copyOf(successes);
        this.failures = ImmutableMap.copyOf(failures);
        if (failures.isEmpty()) {
            throw new IllegalArgumentException("failures required for partial success exception");
        }
    }

    public AuditLogConfigSpec getSpec() {
        return this.spec;
    }

    public Set<String> getSuccesses() {
        return this.successes;
    }

    public Map<String, Throwable> getFailures() {
        return this.failures;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Partial success! Audit log configuration was saved, but only synced to ");
        sb.append(this.successes.size());
        sb.append(" of ");
        sb.append(this.successes.size() + this.failures.size());
        sb.append(" managed clusters.");
        if (!this.successes.isEmpty()) {
            sb.append(" Successfully synced configuration to these clusters: ");
            sb.append(String.join((CharSequence)", ", this.successes));
            sb.append(".");
        }
        sb.append(" Failed to sync configuration to these clusters: ");
        sb.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)this.failures.keySet()));
        return sb.toString();
    }
}

