/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.store;

import com.google.common.collect.ImmutableSortedSet;
import io.confluent.auditlogapi.credentials.ExtractedCredentials;
import io.confluent.auditlogapi.entities.AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinationConfig;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinations;
import io.confluent.auditlogapi.entities.AuditLogConfigMetadata;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.store.AuditLogConfigConcurrentModificationException;
import io.confluent.auditlogapi.store.AuditLogConfigStore;
import io.confluent.auditlogapi.store.FutureUtil;
import io.confluent.auditlogapi.store.TopicRetentionLookup;
import io.confluent.auditlogapi.store.TopicRetentionUpdateCallback;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.errors.RetriableException;

abstract class BaseAuditLogConfigStore
implements AuditLogConfigStore {
    public static final AuditLogConfigSpec DEFAULT_SPEC = AuditLogConfigSpec.builder().destinations(AuditLogConfigDestinations.builder().topic("confluent-audit-log-events", AuditLogConfigDestinationConfig.builder().retentionMs(2592000000L).build()).build()).excludedPrincipals(Collections.emptySet()).defaultTopics(AuditLogConfigDefaultTopics.builder().allowed("confluent-audit-log-events").denied("confluent-audit-log-events").build()).routes(Collections.emptyMap()).metadata(AuditLogConfigMetadata.builder().resourceVersion("unknown").updatedAt(Instant.now()).build()).build().withCalculatedMetadataResourceVersion();

    BaseAuditLogConfigStore() {
    }

    protected abstract AuditLogConfigSpec get();

    protected abstract CompletionStage<AuditLogConfigSpec> asyncCompareAndSet(AuditLogConfigSpec var1, AuditLogConfigSpec var2);

    protected abstract CompletionStage<AuditLogConfigSpec> asyncBroadcast(ExtractedCredentials var1, AuditLogConfigSpec var2);

    @Override
    public final AuditLogConfigSpec getConfig() {
        return this.get();
    }

    @Override
    public final AuditLogConfigSpec getLiveConfig(TopicRetentionLookup retentionLookup) {
        return BaseAuditLogConfigStore.currentSpec(this.get(), retentionLookup);
    }

    private CompletionStage<AuditLogConfigSpec> putConfigLocallyOnly(ExtractedCredentials extractedCredentials, AuditLogConfigSpec putSpec, TopicRetentionLookup retentionLookup) {
        AuditLogConfigSpec configuredSpec = this.get();
        AuditLogConfigSpec currentSpec = BaseAuditLogConfigStore.currentSpec(configuredSpec, retentionLookup);
        if (putSpec.equals(currentSpec)) {
            return CompletableFuture.completedFuture(putSpec);
        }
        String expectedVersion = currentSpec.getMetadata().getResourceVersion();
        if (!putSpec.getMetadata().getResourceVersion().equals(expectedVersion)) {
            return FutureUtil.exceptionalFuture(new AuditLogConfigConcurrentModificationException(currentSpec));
        }
        AuditLogConfigSpec newSpec = putSpec.toBuilder().metadata(AuditLogConfigMetadata.builder().resourceVersion(putSpec.getCalculatedChecksum()).updatedAt(Instant.now()).build()).build();
        return this.asyncCompareAndSet(configuredSpec, newSpec);
    }

    @Override
    public final CompletionStage<AuditLogConfigSpec> putConfig(ExtractedCredentials extractedCredentials, AuditLogConfigSpec putSpec, TopicRetentionLookup retentionLookup, TopicRetentionUpdateCallback retentionCallback) {
        CompletionStage<AuditLogConfigSpec> future = this.putConfigLocallyOnly(extractedCredentials, putSpec, retentionLookup);
        return FutureUtil.exceptionallyComposeAsync(future, error -> error instanceof RetriableException ? this.putConfigLocallyOnly(extractedCredentials, putSpec, retentionLookup) : FutureUtil.exceptionalFuture(error)).thenComposeAsync(spec -> this.asyncBroadcast(extractedCredentials, (AuditLogConfigSpec)spec)).thenComposeAsync(spec -> this.notifyRetentionUpdates((AuditLogConfigSpec)spec, retentionLookup, retentionCallback));
    }

    private static AuditLogConfigSpec currentSpec(AuditLogConfigSpec configuredSpec, TopicRetentionLookup retentionLookup) {
        Map<String, AuditLogConfigDestinationConfig> discrepancies = BaseAuditLogConfigStore.findDiscrepancies(configuredSpec, retentionLookup);
        return discrepancies.isEmpty() ? configuredSpec : BaseAuditLogConfigStore.mergeDiscrepancies(configuredSpec, discrepancies).toBuilder().metadata(AuditLogConfigMetadata.builder().resourceVersion(configuredSpec.calculateChecksum(discrepancies)).modifiedSince(configuredSpec.getMetadata().getUpdatedAt()).build()).build();
    }

    private static Map<String, AuditLogConfigDestinationConfig> findDiscrepancies(AuditLogConfigSpec configuredSpec, TopicRetentionLookup topicRetentionLookup) {
        ImmutableSortedSet topicNames = configuredSpec.getDestinations().getTopics().keySet();
        Map<String, Long> currentRetentionsMs = topicRetentionLookup.retentionMillisOf((Set<String>)topicNames);
        HashMap<String, AuditLogConfigDestinationConfig> result = new HashMap<String, AuditLogConfigDestinationConfig>(topicNames.size());
        configuredSpec.getDestinations().getTopics().forEach((topicName, destinationConfig) -> {
            long configuredRetentionMs = destinationConfig.getRetentionMs();
            Long currentRetentionMs = (Long)currentRetentionsMs.get(topicName);
            if (currentRetentionMs != null && !currentRetentionMs.equals(configuredRetentionMs)) {
                AuditLogConfigDestinationConfig currentConfig = destinationConfig.toBuilder().retentionMs(currentRetentionMs).build();
                result.put((String)topicName, currentConfig);
            }
        });
        return result;
    }

    private static AuditLogConfigSpec mergeDiscrepancies(AuditLogConfigSpec spec, Map<String, AuditLogConfigDestinationConfig> discrepancies) {
        HashMap<String, AuditLogConfigDestinationConfig> topics = new HashMap<String, AuditLogConfigDestinationConfig>((Map<String, AuditLogConfigDestinationConfig>)spec.getDestinations().getTopics());
        topics.putAll(discrepancies);
        return spec.toBuilder().destinations(spec.getDestinations().toBuilder().topics(topics).build()).build();
    }

    private CompletionStage<AuditLogConfigSpec> notifyRetentionUpdates(AuditLogConfigSpec newSpec, TopicRetentionLookup retentionLookup, TopicRetentionUpdateCallback retentionUpdateCallback) {
        HashMap retentionUpdates = new HashMap();
        ImmutableSortedSet topicNames = newSpec.getDestinations().getTopics().keySet();
        Map<String, Long> currentRetentionsMs = retentionLookup.retentionMillisOf((Set<String>)topicNames);
        newSpec.getDestinations().getTopics().forEach((topicName, destinationConfig) -> {
            long configuredRetention = destinationConfig.getRetentionMs();
            Long currentRetention = (Long)currentRetentionsMs.get(topicName);
            if (currentRetention == null || !currentRetention.equals(configuredRetention)) {
                retentionUpdates.put(topicName, configuredRetention);
            }
        });
        if (!retentionUpdates.isEmpty()) {
            return retentionUpdateCallback.handleTopicRetentionTimeUpdate(newSpec);
        }
        return CompletableFuture.completedFuture(newSpec);
    }
}

