/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.auditlogapi.credentials.ExtractedCredentials;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.entities.Conversions;
import io.confluent.auditlogapi.store.AuditLogConfigStorePartialSuccessException;
import io.confluent.auditlogapi.store.BaseAuditLogConfigStore;
import io.confluent.auditlogapi.store.FutureUtil;
import io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler;
import io.confluent.mds.DynamicConfigurator;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.utils.ConfluentAdminClientFactory;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class DynamicConfigAuditLogConfigStore
extends BaseAuditLogConfigStore
implements Reconfigurable {
    private static final String SSL_PREFIX = "ssl.";
    private static final int CLIENT_TIMEOUT_MS = 60000;
    private static final ConfigResource CLUSTER_CONFIG_RESOURCE = new ConfigResource(ConfigResource.Type.BROKER, "");
    private static final AlterConfigsOptions MANAGED_CLUSTERS_OPS = new AlterConfigsOptions().timeoutMs(Integer.valueOf(5000));
    private AuditLogConfigSpec spec = null;
    private final DynamicConfigurator dynamicConfigurator;
    private final ClusterRegistryService clusterRegistryService;
    private Map<String, Object> sslConfigs;

    public DynamicConfigAuditLogConfigStore(ClusterRegistryService clusterRegistryService, DynamicConfigurator dynamicConfigurator) {
        this.clusterRegistryService = Objects.requireNonNull(clusterRegistryService);
        this.dynamicConfigurator = Objects.requireNonNull(dynamicConfigurator);
        this.sslConfigs = new HashMap<String, Object>();
    }

    @Override
    protected synchronized AuditLogConfigSpec get() {
        return this.spec;
    }

    @Override
    protected synchronized CompletionStage<AuditLogConfigSpec> asyncCompareAndSet(AuditLogConfigSpec configuredSpec, AuditLogConfigSpec newSpec) {
        try {
            String json = Conversions.toJson(Conversions.convert(newSpec));
            ConfigEntry configEntry = new ConfigEntry("confluent.security.event.router.config", json);
            AlterConfigsResult alterConfigsResult = this.dynamicConfigurator.setClusterConfig(Collections.singleton(configEntry));
            CompletableFuture<AuditLogConfigSpec> result = new CompletableFuture<AuditLogConfigSpec>();
            alterConfigsResult.all().whenComplete((unused, throwable) -> {
                if (throwable == null) {
                    result.complete(newSpec);
                } else {
                    result.completeExceptionally((Throwable)throwable);
                }
            });
            return result;
        }
        catch (JsonProcessingException | RuntimeException e) {
            return FutureUtil.exceptionalFuture(e);
        }
    }

    @Override
    protected CompletionStage<AuditLogConfigSpec> asyncBroadcast(ExtractedCredentials extractedCredentials, AuditLogConfigSpec spec) {
        String json;
        Map<String, Map<String, String>> targets = this.getManagedClustersInfo(extractedCredentials).join();
        HashMap adminClients = new HashMap();
        try {
            json = Conversions.toJson(Conversions.convert(spec));
        }
        catch (JsonProcessingException e) {
            return FutureUtil.exceptionalFuture(e);
        }
        ArrayList futures = new ArrayList(targets.size());
        ConcurrentHashMap.KeySetView successes = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap failures = new ConcurrentHashMap();
        targets.forEach((name, baseConfig) -> {
            HashMap<String, Object> clientProps = new HashMap<String, Object>((Map<String, Object>)baseConfig);
            clientProps.putAll(extractedCredentials.toClientCredentialProperties());
            if (baseConfig.containsKey("security.protocol") && (((String)baseConfig.get("security.protocol")).equalsIgnoreCase(SecurityProtocol.SSL.name) || ((String)baseConfig.get("security.protocol")).equalsIgnoreCase(SecurityProtocol.SASL_SSL.name))) {
                clientProps.putAll(this.sslConfigs);
            }
            ConfluentAdmin client = ConfluentAdminClientFactory.createAdmin(clientProps);
            adminClients.put(name, client);
            AlterConfigsResult result = client.incrementalAlterConfigs((Map)ImmutableMap.of((Object)CLUSTER_CONFIG_RESOURCE, (Object)ImmutableList.of((Object)new AlterConfigOp(new ConfigEntry("confluent.security.event.router.config", json), AlterConfigOp.OpType.SET))), MANAGED_CLUSTERS_OPS);
            futures.add(((KafkaFuture)result.values().get(CLUSTER_CONFIG_RESOURCE)).whenComplete((ignored, error) -> {
                if (error != null) {
                    failures.put(name, error);
                } else {
                    successes.add(name);
                }
            }));
        });
        CompletableFuture<AuditLogConfigSpec> result = new CompletableFuture<AuditLogConfigSpec>();
        KafkaFuture.allOf((KafkaFuture[])futures.toArray(new KafkaFuture[0])).whenComplete((ignored, error) -> {
            if (failures.isEmpty()) {
                result.complete(spec);
            } else {
                result.completeExceptionally((Throwable)((Object)new AuditLogConfigStorePartialSuccessException(spec, successes, failures)));
            }
            adminClients.forEach((name, client) -> ConfluentAdminClientFactory.closeAdminClientWithTimeout(client));
        });
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.singleton("confluent.security.event.router.config");
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        String json = (String)configs.get("confluent.security.event.router.config");
        if (json != null && !json.trim().isEmpty()) {
            try {
                Conversions.convert(AuditLogRouterJsonConfig.load((String)json));
            }
            catch (IOException e) {
                throw new ConfigException("confluent.security.event.router.config", (Object)json);
            }
            catch (Exception e) {
                throw new ConfigException("confluent.security.event.router.config", (Object)e.getMessage());
            }
        }
    }

    public void reconfigure(Map<String, ?> configs) {
        String json = (String)configs.get("confluent.security.event.router.config");
        if (json == null || json.isEmpty()) {
            this.spec = DEFAULT_SPEC;
        } else {
            try {
                this.spec = Conversions.convert(AuditLogRouterJsonConfig.load((String)json));
            }
            catch (IOException e) {
                throw new ConfigException("confluent.security.event.router.config", (Object)json);
            }
            catch (Exception e) {
                throw new ConfigException("confluent.security.event.router.config", (Object)e.getMessage());
            }
        }
    }

    public void configure(Map<String, ?> configs) {
        this.sslConfigs.putAll(configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(SSL_PREFIX)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue())));
        this.reconfigure(configs);
    }

    private CompletableFuture<Map<String, Map<String, String>>> getManagedClustersInfo(ExtractedCredentials extractedCredentials) {
        CompletableFuture<Map<String, Map<String, String>>> result = CompletableFuture.supplyAsync(() -> {
            List<ClusterInfo> clusterInfos = this.clusterRegistryService.getClusters(extractedCredentials.kafkaPrincipal(), ClusterType.KAFKA_CLUSTER);
            HashMap map = new HashMap();
            clusterInfos.forEach(clsInfo -> {
                List hosts = clsInfo.getHosts();
                hosts.forEach(host -> {
                    Map subMap = map.computeIfAbsent(clsInfo.getClusterName(), prop -> new HashMap());
                    subMap.put("bootstrap.servers", host.getHost() + ":" + host.getPort());
                    subMap.put("security.protocol", clsInfo.getProtocol().value());
                    subMap.put("sasl.mechanism", "OAUTHBEARER");
                    subMap.put("sasl.login.callback.handler.class", TokenBearerLoginCallbackHandler.class.getSimpleName());
                });
            });
            return map;
        });
        return result;
    }
}

