/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metadataapi.errormappers;

import io.confluent.metadataapi.entities.ErrorMessage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataApiExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(MetadataApiExceptionMapper.class);
    @Context
    private UriInfo uriInfo;

    public Response toResponse(Exception exception) {
        int statusCode;
        log.debug("Uncaught exception in REST call to /{}", (Object)this.uriInfo.getPath(), (Object)exception);
        if (exception instanceof WebApplicationException) {
            Response.StatusType statusInfo = ((WebApplicationException)exception).getResponse().getStatusInfo();
            statusCode = statusInfo.getStatusCode();
        } else {
            statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        }
        return Response.status((int)statusCode).entity((Object)new ErrorMessage(statusCode, exception.getMessage())).build();
    }
}

