/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.confluent.auditlog.emitter.auditlogger.AuditLogger;
import io.confluent.auditlog.emitter.auditlogger.InitParams;
import io.confluent.auditlog.emitter.telemetry.NoOpTelemetry;
import io.confluent.auditlog.emitter.telemetry.Telemetry;
import io.confluent.auditlog.emitter.transport.NoOpTransport;
import io.confluent.auditlog.emitter.transport.Transport;
import io.confluent.auditlog.emitter.utils.IdentityParams;
import io.confluent.auditlogapi.authorizer.AuditLogConfigAuthorizer;
import io.confluent.auditlogapi.credentials.CredentialExtractor;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.kafka.DestinationTopicManager;
import io.confluent.auditlogapi.store.DynamicConfigAuditLogConfigStore;
import io.confluent.auditlogapi.store.TopicRetentionUpdateCallback;
import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MultiJwtLoginService;
import io.confluent.common.security.jetty.MultiJwtWithFallbackLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.crn.ConfluentServerCrnAuthority;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticatorConfig;
import io.confluent.mds.DefaultDynamicConfigurator;
import io.confluent.mds.DynamicConfigurator;
import io.confluent.oidc.config.OidcConfig;
import io.confluent.oidc.encryption.EncryptionHandler;
import io.confluent.oidc.errormappers.EncryptionFailedExceptionMapper;
import io.confluent.oidc.errormappers.IdpAuthExceptionMapper;
import io.confluent.oidc.errormappers.InvalidCodeExceptionMapper;
import io.confluent.oidc.errormappers.InvalidDeviceKeyExceptionMapper;
import io.confluent.oidc.errormappers.InvalidStateExceptionMapper;
import io.confluent.oidc.services.OidcTokenService;
import io.confluent.rbacapi.app.CPRbacApiAppConfig;
import io.confluent.rbacapi.app.MdsBasicAuthenticator;
import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.errorhandlers.NoJettyDefaultStackTraceErrorHandler;
import io.confluent.rbacapi.errormappers.ClusterRegistryConflictExceptionMapper;
import io.confluent.rbacapi.errormappers.ClusterRegistryGenericClientErrorExceptionMapper;
import io.confluent.rbacapi.errormappers.ClusterRegistryNoAccessExceptionMapper;
import io.confluent.rbacapi.errormappers.ClusterRegistryNotFoundExceptionMapper;
import io.confluent.rbacapi.errormappers.ClusterRegistryUpdateExceptionMapper;
import io.confluent.rbacapi.errormappers.ClusterRegistryVerifyExceptionMapper;
import io.confluent.rbacapi.errormappers.ConstraintViolationExceptionMapper;
import io.confluent.rbacapi.errormappers.CrnSyntaxExceptionMapper;
import io.confluent.rbacapi.errormappers.DeletedNonexistentResourceExceptionMapper;
import io.confluent.rbacapi.errormappers.KafkaApiExceptionMapper;
import io.confluent.rbacapi.errormappers.KafkaExecutionExceptionMapper;
import io.confluent.rbacapi.errormappers.Mds400ExceptionMapper;
import io.confluent.rbacapi.errormappers.MdsJacksonBindingErrorMapper;
import io.confluent.rbacapi.errormappers.MdsJacksonParseErrorMapper;
import io.confluent.rbacapi.errormappers.MdsJacksonProcessingErrorMapper;
import io.confluent.rbacapi.errormappers.MdsJerseyExceptionMapper;
import io.confluent.rbacapi.errormappers.MdsUncaughtExceptionMapper;
import io.confluent.rbacapi.errormappers.MdsValidationExceptionMapper;
import io.confluent.rbacapi.errormappers.TimeoutExceptionMapper;
import io.confluent.rbacapi.jackson.MdsJacksonMessageBodyProvider;
import io.confluent.rbacapi.jackson.MdsJacksonModule;
import io.confluent.rbacapi.jackson.MdsObjectMapperProvider;
import io.confluent.rbacapi.login.MdsLoginService;
import io.confluent.rbacapi.resources.v1.V1AclResource;
import io.confluent.rbacapi.resources.v1.V1AuditLogConfigResource;
import io.confluent.rbacapi.resources.v1.V1AuthorizeResource;
import io.confluent.rbacapi.resources.v1.V1ClusterRegistryResource;
import io.confluent.rbacapi.resources.v1.V1FeaturesResource;
import io.confluent.rbacapi.resources.v1.V1LookupResource;
import io.confluent.rbacapi.resources.v1.V1MetadataServiceResource;
import io.confluent.rbacapi.resources.v1.V1OidcDeviceAuthResource;
import io.confluent.rbacapi.resources.v1.V1OidcResource;
import io.confluent.rbacapi.resources.v1.V1OperationsResource;
import io.confluent.rbacapi.resources.v1.V1PrincipalsResource;
import io.confluent.rbacapi.resources.v1.V1RolesResource;
import io.confluent.rbacapi.resources.v1.V1UserGroupResource;
import io.confluent.rbacapi.rest.LeaderAwareApplication;
import io.confluent.rbacapi.rest.MdsWriterProxyServlet;
import io.confluent.rbacapi.rest.MdsWritesFilter;
import io.confluent.rbacapi.services.CPFeatureConfigurationService;
import io.confluent.rbacapi.services.ClusterRegistryGatekeeper;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.services.FeatureConfigurationService;
import io.confluent.rbacapi.services.MdsFeatures;
import io.confluent.rbacapi.services.RoleBindingProcessing;
import io.confluent.rbacapi.swagger.SwaggerFilesResource;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.validation.common.ValidOperation;
import io.confluent.rbacapi.validation.common.ValidOptionalResourceType;
import io.confluent.rbacapi.validation.common.ValidResourceType;
import io.confluent.rbacapi.validation.common.ValidRole;
import io.confluent.rbacapi.validation.v1.MDSValidationConfigurationContextResolver;
import io.confluent.rbacapi.validation.v1.V1ValidRoleResourceType;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactory;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.jackson.KafkaModule;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.tokenapi.errormappers.AuthenticationTokenExceptionMapper;
import io.confluent.tokenapi.jwt.JwtProvider;
import io.confluent.tokenapi.resources.v1.V1TokenResource;
import io.confluent.tokenapi.services.TokenService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.ssl.HostSslSocketFactory;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.logging.MDSLoggingFilter;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class RbacApiApplication
extends Application<RestConfig>
implements Reconfigurable,
LeaderAwareApplication {
    private static final Logger log = LoggerFactory.getLogger(RbacApiApplication.class);
    protected final ClusterRegistryService clusterRegistryService;
    private final ObjectMapper objectMapper = MdsObjectMapperProvider.getObjectMapper();
    private final CPRbacApiAppConfig config;
    private final Authorizer authorizer;
    private final AuthStore authStore;
    private final JwtProvider jwtProvider;
    private final AuthenticateCallbackHandler authenticateCallbackHandler;
    private final MdsWriterProxyServlet proxyWriter;
    private final DestinationTopicManager auditLogDestinationTopicManager;
    private final DynamicConfigAuditLogConfigStore auditLogConfigStore;
    private final String metadataClusterId;
    private final Scope metadataClusterScope;
    private final ClusterRegistryGatekeeper clusterRegistryGatekeeper;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final Map<String, Reconfigurable> reconfigurables;
    private final DynamicConfigurator dynamicConfigurator;
    private final MdsFeatures mdsFeatures;
    private FeatureConfigurationService featureConfigurationService;
    private final ConfluentServerCrnAuthority v1CrnAuthority = new ConfluentServerCrnAuthority();
    private final AuditLogger auditLogger;

    public RbacApiApplication(CPRbacApiAppConfig config, Authorizer authorizer, AuthStore authStore, JwtProvider jwtProvider, AuthenticateCallbackHandler authenticateCallbackHandler, String metadataClusterId, ConfluentAdmin internalAdminClient, AuditLogger auditLogger) {
        this(config, authorizer, authStore, jwtProvider, authenticateCallbackHandler, metadataClusterId, internalAdminClient, new CPFeatureConfigurationService(), auditLogger);
    }

    public RbacApiApplication(CPRbacApiAppConfig config, Authorizer authorizer, AuthStore authStore, JwtProvider jwtProvider, AuthenticateCallbackHandler authenticateCallbackHandler, String metadataClusterId, ConfluentAdmin internalAdminClient, FeatureConfigurationService featureService, AuditLogger auditLogger) {
        super((RestConfig)config, "/security");
        this.objectMapper.registerModule((Module)new MdsJacksonModule());
        this.objectMapper.registerModule((Module)new KafkaModule());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.config = config;
        this.authorizer = authorizer;
        this.authStore = authStore;
        this.jwtProvider = jwtProvider;
        this.authenticateCallbackHandler = authenticateCallbackHandler;
        this.dynamicConfigurator = new DefaultDynamicConfigurator(internalAdminClient);
        if (metadataClusterId == null || metadataClusterId.isEmpty()) {
            throw new IllegalArgumentException("Metadata cluster id must be non-empty");
        }
        this.metadataClusterId = metadataClusterId;
        this.metadataClusterScope = Scope.kafkaClusterScope((String)metadataClusterId);
        this.proxyWriter = new MdsWriterProxyServlet(this);
        this.metadataAuthorizer = new SecurityMetadataAuthorizer(authorizer, this.metadataClusterScope);
        this.clusterRegistryGatekeeper = new ClusterRegistryGatekeeper(authorizer, authStore.authCache(), metadataClusterId);
        this.clusterRegistryService = new ClusterRegistryService(this.objectMapper, this.clusterRegistryGatekeeper, this.dynamicConfigurator);
        this.auditLogDestinationTopicManager = new DestinationTopicManager(internalAdminClient);
        this.auditLogDestinationTopicManager.configure(config.originals());
        this.reconfigurables = new ConcurrentHashMap<String, Reconfigurable>();
        this.reconfigurables.put("auditLogDestinationTopicManager", this.auditLogDestinationTopicManager);
        this.reconfigurables.put("clusterRegistryService", this.clusterRegistryService);
        this.auditLogConfigStore = new DynamicConfigAuditLogConfigStore(this.clusterRegistryService, this.dynamicConfigurator);
        this.auditLogConfigStore.configure(config.originals());
        this.reconfigurables.put("auditLogConfigStore", this.auditLogConfigStore);
        this.mdsFeatures = MdsFeatures.loadBaselineFeatures((ObjectMapper)this.objectMapper);
        this.featureConfigurationService = featureService;
        if (auditLogger != null) {
            this.auditLogger = auditLogger;
        } else {
            IdentityParams identityParams = IdentityParams.builder().serviceName("metadata-service").build();
            this.auditLogger = new AuditLogger(new InitParams(identityParams, (Transport)new NoOpTransport(), (Telemetry)new NoOpTelemetry()));
        }
    }

    @VisibleForTesting
    public int getActualMdsPort() {
        return ((NetworkTrafficServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    @VisibleForTesting
    public boolean isServerStarted() {
        return this.server.isStarted();
    }

    @VisibleForTesting
    public ApplicationServer getServer() {
        return this.server;
    }

    @Override
    public boolean isLeader() {
        return this.authStore.isMasterWriter();
    }

    @Override
    public URL getLeader(String protocol) {
        return this.authStore.masterWriterUrl(protocol);
    }

    @Override
    public Collection<URL> getNodes(String protocol) {
        return this.authStore.activeNodeUrls(protocol);
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
        context.setErrorHandler((ErrorHandler)new NoJettyDefaultStackTraceErrorHandler());
        context.addFilter(new FilterHolder((Filter)new MdsWritesFilter(this)), "/*", null);
        context.addServlet(new ServletHolder((Servlet)this.proxyWriter), "/leader/*");
        this.proxyWriter.setSslContextFactory(SslFactory.createSslContextFactory((SslConfig)this.config.getBaseSslConfig()));
    }

    public void setupResources(Configurable<?> context, RestConfig appConfig) {
        Boolean swaggerEnabled;
        ValidRole.RoleValidator.loadRoles((RbacRoles)this.authStore.authCache().rbacRoles());
        ValidOperation.OperationValidator.loadOperations((RbacRoles)this.authStore.authCache().rbacRoles());
        ValidResourceType.ResourceTypeValidator.loadResourceType((RbacRoles)this.authStore.authCache().rbacRoles());
        ValidOptionalResourceType.OptionalResourceTypeValidator.loadResourceType((RbacRoles)this.authStore.authCache().rbacRoles());
        V1ValidRoleResourceType.RoleResourceTypeValidator.loadRoleResourceType((RbacRoles)this.authStore.authCache().rbacRoles());
        MDSValidationConfigurationContextResolver validatorFix = new MDSValidationConfigurationContextResolver();
        context.register((Object)validatorFix);
        String authMethod = this.config.getString("authentication.method");
        String userStore = this.config.getString("user.store");
        boolean isOidcEnabled = "oidc".equalsIgnoreCase(this.config.getString("sso.mode"));
        if ("BEARER".equals(authMethod) && !"NONE".equals(userStore)) {
            this.jwtProvider.configure(this.config.originals());
            this.mdsFeatures.markTokenGenerationEnabled();
            TokenService tokenService = new TokenService(this.jwtProvider);
            context.register((Object)new V1TokenResource(tokenService));
            if (isOidcEnabled) {
                this.mdsFeatures.markOidcEnabled();
                EncryptionHandler encryptionHandler = new EncryptionHandler();
                encryptionHandler.configure(this.config.originals());
                OidcTokenService oidcTokenService = new OidcTokenService(tokenService, this.authStore, encryptionHandler);
                oidcTokenService.configure(this.config.originals());
                context.register((Object)new V1OidcResource(oidcTokenService));
                this.registerOidcSsoIfConfigured(context, tokenService);
            }
        }
        if ((swaggerEnabled = this.config.getBoolean("openapi.enable")).booleanValue()) {
            context.register((Object)new SwaggerFilesResource());
        }
        RoleBindingProcessing roleBindingProcessing = new RoleBindingProcessing(this.authorizer, this.authStore.authCache());
        context.register((Object)new V1FeaturesResource(this.mdsFeatures));
        context.register((Object)new V1AuthorizeResource(this.authorizer, this.metadataAuthorizer));
        context.register((Object)new V1RolesResource(this.authStore.authCache().rbacRoles()));
        context.register((Object)new V1LookupResource(this.authStore.authCache(), this.metadataAuthorizer, this.clusterRegistryService));
        Long configuredTimeoutNanos = this.getConfiguredTimeoutNanos(this.config);
        this.clusterRegistryService.configure(this.config.values());
        context.register((Object)new V1PrincipalsResource(this.authStore, this.metadataAuthorizer, configuredTimeoutNanos, this.clusterRegistryService, this.objectMapper));
        context.register((Object)new V1MetadataServiceResource(this.authStore, this.metadataClusterId));
        context.register((Object)new V1AclResource(this.authStore, this.metadataAuthorizer, configuredTimeoutNanos));
        context.register((Object)new V1OperationsResource(roleBindingProcessing, this.metadataAuthorizer, this.clusterRegistryService));
        context.register((Object)new V1UserGroupResource(this.authStore.authCache(), this.clusterRegistryService, this.metadataAuthorizer));
        context.register((Object)new V1ClusterRegistryResource(this.clusterRegistryService, this.metadataAuthorizer));
        AuditLogConfigAuthorizer auditLogConfigAuthorizer = new AuditLogConfigAuthorizer(this.authorizer, this.metadataClusterId, this::getAllRegisteredKafkaClusterIds);
        Object advertisedListeners = this.config.originals().get("advertised.listeners");
        CredentialExtractor credentialExtractor = advertisedListeners instanceof String ? new CredentialExtractor((String)advertisedListeners) : null;
        TopicRetentionUpdateCallback retentionUpdateCallback = update -> {
            if (log.isInfoEnabled()) {
                log.info("Received an audit log destination topic retention time policy update. {}", (Object)StringUtils.join((Object[])new AuditLogConfigSpec[]{update}));
            }
            return this.auditLogDestinationTopicManager.update(update);
        };
        context.register((Object)new V1AuditLogConfigResource(auditLogConfigAuthorizer, this.auditLogConfigStore, credentialExtractor, this.auditLogDestinationTopicManager::getTopicRetentionMillis, retentionUpdateCallback, configuredTimeoutNanos));
        context.register((Object)new V1AuditLogConfigResource(auditLogConfigAuthorizer, this.auditLogConfigStore, credentialExtractor, this.auditLogDestinationTopicManager::getTopicRetentionMillis, retentionUpdateCallback, configuredTimeoutNanos));
        context.register((Object)new MDSLoggingFilter(java.util.logging.Logger.getLogger("io.confluent.mds.request.logger"), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_TEXT, 8192));
    }

    private void registerOidcSsoIfConfigured(Configurable<?> context, TokenService tokenService) {
        boolean isOidcEnabled = "oidc".equalsIgnoreCase(this.config.getString("sso.mode"));
        if (!isOidcEnabled) {
            return;
        }
        this.mdsFeatures.markOidcEnabled();
        EncryptionHandler encryptionHandler = new EncryptionHandler();
        encryptionHandler.configure(this.config.originals());
        OidcTokenService oidcTokenService = new OidcTokenService(tokenService, this.authStore, encryptionHandler);
        oidcTokenService.configure(this.config.originals());
        context.register((Object)new V1OidcResource(oidcTokenService));
        OidcConfig oidcConfig = new OidcConfig(this.config.originals());
        String deviceAuthEndpointUri = oidcConfig.getString("confluent.oidc.idp.device.authorization.endpoint.uri");
        if (Objects.isNull(deviceAuthEndpointUri) || deviceAuthEndpointUri.isEmpty()) {
            return;
        }
        this.mdsFeatures.markOidcDeviceAuthEnabled();
        context.register((Object)new V1OidcDeviceAuthResource(oidcTokenService));
    }

    @VisibleForTesting
    protected Long getConfiguredTimeoutNanos(CPRbacApiAppConfig appConfig) {
        return appConfig.getLong("idle.timeout.ms") * 1000000L;
    }

    public void stop() throws Exception {
        this.server.stop();
        this.join();
        super.stop();
    }

    public void onShutdown() {
        log.info("Jetty server has processed the shutdown request, now running onShutdown hook...");
        try {
            this.authorizer.close();
        }
        catch (IOException e) {
            log.error("Failed to close authorizer onShutdown.");
        }
        try {
            this.authStore.close();
        }
        catch (IOException e) {
            log.error("Failed to close authStore onShutdown.");
        }
        try {
            this.dynamicConfigurator.close();
        }
        catch (IOException e) {
            log.error("Failed to close dynamicConfigurator onShutdown.");
        }
    }

    protected void registerJsonProvider(Configurable<?> context, RestConfig restConfig, boolean registerExceptionMapper) {
        context.register((Object)new MdsJacksonMessageBodyProvider(this.objectMapper));
    }

    protected void registerExceptionMappers(Configurable<?> context, RestConfig restConfig) {
        MdsUncaughtExceptionMapper fallbackMapper = new MdsUncaughtExceptionMapper();
        context.register((Object)fallbackMapper);
        context.register((Object)new MdsJacksonProcessingErrorMapper());
        context.register((Object)new MdsJacksonParseErrorMapper());
        context.register((Object)new MdsJacksonBindingErrorMapper());
        context.register(JsonParseExceptionMapper.class);
        context.register((Object)new Mds400ExceptionMapper());
        context.register((Object)new MdsValidationExceptionMapper());
        context.register((Object)new ConstraintViolationExceptionMapper());
        context.register((Object)new AuthenticationTokenExceptionMapper((ExceptionMapper)fallbackMapper));
        context.register((Object)new InvalidStateExceptionMapper());
        context.register((Object)new InvalidCodeExceptionMapper());
        context.register((Object)new IdpAuthExceptionMapper());
        context.register((Object)new InvalidDeviceKeyExceptionMapper());
        context.register((Object)new EncryptionFailedExceptionMapper());
        context.register((Object)new TimeoutExceptionMapper());
        context.register((Object)new KafkaApiExceptionMapper((RestConfig)this.config));
        context.register((Object)new KafkaExecutionExceptionMapper((RestConfig)this.config, (ExceptionMapper)fallbackMapper));
        context.register((Object)new ClusterRegistryNoAccessExceptionMapper());
        context.register((Object)new ClusterRegistryNotFoundExceptionMapper());
        context.register((Object)new ClusterRegistryConflictExceptionMapper());
        context.register((Object)new ClusterRegistryGenericClientErrorExceptionMapper());
        context.register((Object)new ClusterRegistryUpdateExceptionMapper());
        context.register((Object)new ClusterRegistryVerifyExceptionMapper());
        context.register((Object)new CrnSyntaxExceptionMapper());
        context.register((Object)new DeletedNonexistentResourceExceptionMapper());
        context.register((Object)new MdsJerseyExceptionMapper());
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        if (context.getContextPath().equals(this.config.getString("websocket.path.prefix"))) {
            return;
        }
        String authMethod = this.config.getString("authentication.method");
        if ("NONE".equals(authMethod)) {
            return;
        }
        LoginService backingLoginService = this.getBackingLoginService();
        ConstraintSecurityHandler securityHandler = this.createSecurityHandler();
        switch (authMethod) {
            case "BASIC": {
                this.configureBasicAuthentication(securityHandler, backingLoginService);
                break;
            }
            case "BEARER": {
                this.configureBearerAuthentication(securityHandler, backingLoginService);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid authentication config of " + authMethod);
            }
        }
        context.setSecurityHandler((SecurityHandler)securityHandler);
    }

    private LoginService getBackingLoginService() {
        String userStore;
        String realm = this.config.getString("authentication.realm");
        switch (userStore = this.config.getString("user.store")) {
            case "FILE": {
                String propPath = this.config.getString("user.store.file.path");
                return new HashLoginService(realm, propPath);
            }
            case "LDAP": 
            case "LDAP_WITH_OAUTH": {
                if (this.authenticateCallbackHandler == null) {
                    throw new IllegalStateException("LDAP authentication requested, but no authenticationCallback provided");
                }
                log.trace("Confluent authenticate callback handler is enabled.");
                return new MdsLoginService(realm, this.authenticateCallbackHandler);
            }
            case "OAUTH": {
                return this.createIdpLoginService(realm);
            }
            case "NONE": {
                log.info("No user store configured. Disabling basic auth.");
                return null;
            }
        }
        throw new IllegalStateException("Invalid user store config of " + userStore);
    }

    private JwtLoginService createIdpLoginService(String realm) {
        SslContextFactory sslContextFactory;
        String idpJwksEndpoint = this.config.getString("oauthbearer.jwks.endpoint.url");
        String idpIssuer = this.config.getString("oauthbearer.expected.issuer");
        String subClaimName = this.config.getString("oauthbearer.sub.claim.name");
        String groupsClaimName = this.config.getString("oauthbearer.groups.claim.name");
        List audience = this.config.getList("oauthbearer.expected.audience");
        String sslEndpointIdentificationAlgorithm = this.config.originals().getOrDefault("confluent.idp.ssl.endpoint.identification.algorithm", null);
        SslContextFactory sslContextFactory2 = sslContextFactory = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.config.getBaseSslConfig().getTrustStorePath()}) ? null : SslFactory.createSslContextFactory((SslConfig)this.config.getBaseSslConfig());
        if (Objects.nonNull(sslContextFactory) && !sslContextFactory.isRunning()) {
            try {
                sslContextFactory.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("SSL Context Factory failed to start. One of the reason could be wrong truststore and keystore password.", e);
            }
        }
        Get get = new Get();
        URL idpJwksUrl = null;
        if (!Strings.isNullOrEmpty((String)idpJwksEndpoint)) {
            try {
                idpJwksUrl = new URL(idpJwksEndpoint);
            }
            catch (MalformedURLException e) {
                log.error("Received invalid URL in: {}, ", (Object)"oauthbearer.jwks.endpoint.url", (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (Objects.nonNull(sslContextFactory) && Objects.nonNull(sslContextFactory.getSslContext())) {
            log.info("Setting up custom SSLContext for OAuth JWT authenticator.");
            String idpJwksHost = Objects.nonNull(idpJwksUrl) ? idpJwksUrl.getHost() : null;
            HostSslSocketFactory sslSocketFactory = new HostSslSocketFactory(sslContextFactory.getSslContext().getSocketFactory(), idpJwksHost, false);
            get.setSslSocketFactory((SSLSocketFactory)sslSocketFactory);
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{sslEndpointIdentificationAlgorithm})) {
                log.info("Provided ssl.endpoint.identification.algorithm={}. Skipping hostname verification in OAuth JWT authenticator.", (Object)sslEndpointIdentificationAlgorithm);
                get.setHostnameVerifier((s, sslSession) -> true);
            }
        } else if (Objects.nonNull(idpJwksUrl) && idpJwksUrl.getProtocol().equals("https")) {
            HostSslSocketFactory sslSocketFactory;
            try {
                sslSocketFactory = new HostSslSocketFactory(SSLContext.getDefault().getSocketFactory(), idpJwksUrl.getHost(), false);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Error while getting default SSLContext: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            get.setSslSocketFactory((SSLSocketFactory)sslSocketFactory);
        }
        HttpsJwks httpsJwks = new HttpsJwks(idpJwksEndpoint);
        httpsJwks.setSimpleHttpGet((SimpleGet)get);
        CloseableVerificationKeyResolver jwksKeyResolver = this.createJwksVerificationKeyResolver(httpsJwks);
        JwtAuthenticator authenticator = new JwtAuthenticator(idpIssuer, jwksKeyResolver, audience, false);
        return new JwtLoginService(realm, authenticator, subClaimName, groupsClaimName);
    }

    private CloseableVerificationKeyResolver createJwksVerificationKeyResolver(HttpsJwks httpsIdpJwks) {
        final HttpsJwksVerificationKeyResolver httpsJwksVerificationKeyResolver = new HttpsJwksVerificationKeyResolver(httpsIdpJwks);
        return new CloseableVerificationKeyResolver(){

            public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
                return httpsJwksVerificationKeyResolver.resolveKey(jws, nestingContext);
            }

            public void close() {
            }
        };
    }

    private void configureBasicAuthentication(ConstraintSecurityHandler securityHandler, LoginService backingLoginService) {
        MdsBasicAuthenticator mdsBasicAuthenticator = new MdsBasicAuthenticator();
        this.mdsFeatures.markBasicAuthEnabled();
        securityHandler.setAuthenticator((Authenticator)mdsBasicAuthenticator);
        securityHandler.setLoginService(backingLoginService);
    }

    private void configureBearerAuthentication(ConstraintSecurityHandler securityHandler, LoginService backingLoginService) {
        this.mdsFeatures.markTokenValidationEnabled();
        MdsBasicAuthenticator mdsBasicAuthenticator = new MdsBasicAuthenticator();
        securityHandler.setAuthenticator((Authenticator)new OAuthOrBasicAuthenticator((BasicAuthenticator)mdsBasicAuthenticator, MdsBasicAuthenticator.MDS_NO_AUTH_ENDPOINTS));
        String realm = this.config.getString("authentication.realm");
        String userStore = this.config.getString("user.store");
        if ("NONE".equals(userStore)) {
            JwtLoginService jwtLoginService = new JwtLoginService(realm, new JwtAuthenticator(new JwtAuthenticatorConfig(this.config.originals())));
            securityHandler.setLoginService((LoginService)jwtLoginService);
            return;
        }
        PublicKey publicKey = this.jwtProvider.getPublicKey();
        JwtLoginService confluentJwtLoginService = new JwtLoginService(realm, this.jwtProvider.issuer, Collections.singletonList(publicKey), "");
        if ("OAUTH".equals(userStore)) {
            securityHandler.setLoginService((LoginService)new MultiJwtLoginService(confluentJwtLoginService, (JwtLoginService)backingLoginService));
            return;
        }
        if ("LDAP_WITH_OAUTH".equals(userStore)) {
            JwtLoginService idpJwtLoginService = this.createIdpLoginService(realm);
            MultiJwtLoginService multiJwtLoginService = new MultiJwtLoginService(confluentJwtLoginService, idpJwtLoginService);
            securityHandler.setLoginService((LoginService)new MultiJwtWithFallbackLoginService(multiJwtLoginService, backingLoginService));
        } else {
            securityHandler.setLoginService((LoginService)new JwtWithFallbackLoginService(confluentJwtLoginService, backingLoginService));
        }
        this.mdsFeatures.markBasicAuthEnabled();
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createSecurePathConstraint("/1.0/*"));
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    private ConstraintMapping createSecurePathConstraint(String pathSpec) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        List<String> roles = this.config.getList("authentication.roles");
        if (roles.equals(RestConfig.AUTHENTICATION_ROLES_DEFAULT)) {
            roles = Collections.singletonList("**");
        }
        constraint.setRoles(roles.toArray(new String[0]));
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("*");
        if (AuthUtil.isCorsEnabled((RestConfig)this.config)) {
            mapping.setMethodOmissions(new String[]{"OPTIONS"});
        }
        mapping.setPathSpec(pathSpec);
        return mapping;
    }

    private Set<String> getAllRegisteredKafkaClusterIds() {
        return this.clusterRegistryService.getUnrestrictedClusters(ClusterType.KAFKA_CLUSTER).stream().map(info -> (String)info.getScope().clusters().get("kafka-cluster")).collect(Collectors.toSet());
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> result = new HashSet<String>();
        this.reconfigurables.values().forEach(r -> result.addAll(r.reconfigurableConfigs()));
        return result;
    }

    public void validateReconfiguration(Map<String, ?> map) throws ConfigException {
        this.reconfigurables.values().forEach(r -> r.validateReconfiguration(map));
    }

    public void reconfigure(Map<String, ?> map) {
        this.reconfigurables.values().forEach(r -> r.reconfigure(map));
    }

    public void configure(Map<String, ?> map) {
        this.reconfigurables.values().forEach(r -> r.configure(map));
    }

    static {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
    }
}

