/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.confluent.auditlogapi.authorizer.AuditLogConfigAuthorizer;
import io.confluent.auditlogapi.credentials.CredentialExtractor;
import io.confluent.auditlogapi.entities.AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigListRoutesResponse;
import io.confluent.auditlogapi.entities.AuditLogConfigResolveResourceRouteResponse;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategories;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategoryTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.entities.Conversions;
import io.confluent.auditlogapi.store.AuditLogConfigConcurrentModificationException;
import io.confluent.auditlogapi.store.AuditLogConfigStore;
import io.confluent.auditlogapi.store.TopicRetentionLookup;
import io.confluent.auditlogapi.store.TopicRetentionUpdateCallback;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogConfigResource {
    private static final Logger log = LoggerFactory.getLogger(AuditLogConfigResource.class);
    @Nonnull
    private final AuditLogConfigAuthorizer authorizer;
    @Nonnull
    private final AuditLogConfigStore store;
    @Nonnull
    private final CredentialExtractor credentialExtractor;
    @Nonnull
    private final TopicRetentionLookup currentRetentionLookup;
    @Nonnull
    private final TopicRetentionUpdateCallback retentionUpdateCallback;
    private final long backendTimeoutNanos;

    public AuditLogConfigResource(AuditLogConfigAuthorizer authorizer, AuditLogConfigStore store, CredentialExtractor credentialExtractor, TopicRetentionLookup currentRetentionLookup, TopicRetentionUpdateCallback retentionUpdateCallback, long backendTimeoutNanos) {
        this.authorizer = Objects.requireNonNull(authorizer);
        this.store = Objects.requireNonNull(store);
        this.credentialExtractor = Objects.requireNonNull(credentialExtractor);
        this.currentRetentionLookup = Objects.requireNonNull(currentRetentionLookup);
        this.retentionUpdateCallback = Objects.requireNonNull(retentionUpdateCallback);
        this.backendTimeoutNanos = backendTimeoutNanos;
    }

    public AuditLogConfigSpec getConfig(SecurityContext context) {
        this.authorizer.authorizeAuditLogConfigAccess(context, AuditLogConfigAuthorizer.DESCRIBE);
        return this.store.getLiveConfig(this.currentRetentionLookup);
    }

    public Response putConfig(HttpServletRequest request, SecurityContext context, AuditLogConfigSpec putSpec) throws InterruptedException, ExecutionException, TimeoutException {
        this.authorizer.authorizeAuditLogConfigAccess(context, AuditLogConfigAuthorizer.ALTER);
        CompletionStage<AuditLogConfigSpec> futureResult = this.store.putConfig(this.credentialExtractor.extractCredentials(request), putSpec, this.currentRetentionLookup, this.retentionUpdateCallback);
        try {
            CompletableFuture<AuditLogConfigSpec> future = futureResult.toCompletableFuture();
            AuditLogConfigSpec result = future.get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
            return Response.ok((Object)result).build();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuditLogConfigConcurrentModificationException) {
                AuditLogConfigSpec spec = ((AuditLogConfigConcurrentModificationException)e.getCause()).getSpec();
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)spec).build();
            }
            log.warn("Error while updating audit log config", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)putSpec).build();
        }
    }

    public AuditLogConfigListRoutesResponse listRoutes(SecurityContext context, String query) {
        ConfluentResourceName crn;
        this.authorizer.authorizeAuditLogConfigAccess(context, AuditLogConfigAuthorizer.DESCRIBE);
        if (query == null || query.isEmpty()) {
            throw new InvalidRequestException("missing query parameter");
        }
        if (query.contains("*")) {
            throw new InvalidRequestException("wild cards are not allowed in the query");
        }
        try {
            crn = ConfluentResourceName.fromString((String)query);
        }
        catch (CrnSyntaxException e) {
            throw new InvalidRequestException("invalid confluent resource name (CRN) format");
        }
        AuditLogConfigSpec spec = this.store.getConfig();
        AuditLogConfigListRoutesResponse.Builder responseBuilder = AuditLogConfigListRoutesResponse.builder();
        responseBuilder.defaultTopics(spec.getDefaultTopics());
        spec.getRoutes().forEach((routeCrnPattern, routeCategories) -> {
            try {
                ConfluentResourceName routeCrn = ConfluentResourceName.fromString((String)routeCrnPattern);
                if (this.couldMatchResourceOrSubResource(routeCrn, crn)) {
                    responseBuilder.route((String)routeCrnPattern, (AuditLogConfigRouteCategories)routeCategories);
                }
            }
            catch (CrnSyntaxException e) {
                log.warn("Ignoring invalid route pattern: " + routeCrnPattern);
            }
        });
        return responseBuilder.build();
    }

    private boolean couldMatchResourceOrSubResource(ConfluentResourceName routeCrn, ConfluentResourceName resourceCrn) {
        if (!Objects.equals(routeCrn.authority(), resourceCrn.authority())) {
            return false;
        }
        Iterator routeElements = routeCrn.elements().iterator();
        Iterator resourceElements = resourceCrn.elements().iterator();
        while (routeElements.hasNext()) {
            if (!resourceElements.hasNext()) {
                return true;
            }
            if (((ConfluentResourceName.Element)routeElements.next()).matches((ConfluentResourceName.Element)resourceElements.next())) continue;
            return false;
        }
        return !resourceElements.hasNext();
    }

    public AuditLogConfigResolveResourceRouteResponse resolveResourceRoute(SecurityContext context, String query) {
        ConfluentResourceName crn;
        this.authorizer.authorizeAuditLogConfigAccess(context, AuditLogConfigAuthorizer.DESCRIBE);
        if (query.contains("*")) {
            throw new InvalidRequestException("wild cards are not allowed in the query");
        }
        try {
            crn = ConfluentResourceName.fromString((String)query);
        }
        catch (CrnSyntaxException e) {
            throw new InvalidRequestException("invalid confluent resource name (CRN) format");
        }
        AuditLogConfigSpec spec = this.store.getConfig();
        Map.Entry match = spec.getCalculatedRoutesMatcher().matchEntry(crn);
        if (match == null) {
            return AuditLogConfigResolveResourceRouteResponse.builder().route("default").categories(AuditLogConfigResource.coalesceWithDefaults(crn, null, spec.getDefaultTopics())).build();
        }
        return AuditLogConfigResolveResourceRouteResponse.builder().route(((ConfluentResourceName)match.getKey()).toString()).categories(AuditLogConfigResource.coalesceWithDefaults(crn, (AuditLogConfigRouteCategories)match.getValue(), spec.getDefaultTopics())).build();
    }

    @VisibleForTesting
    static AuditLogConfigRouteCategories coalesceWithDefaults(ConfluentResourceName routeCrn, AuditLogConfigRouteCategories routeRules, AuditLogConfigDefaultTopics defaultTopics) {
        AuditLogConfigRouteCategories.Canonicalizer canonicalizer = new AuditLogConfigRouteCategories.Canonicalizer();
        routeRules = canonicalizer.convert(routeRules);
        AuditLogConfigRouteCategories.Builder builder = AuditLogConfigRouteCategories.builder();
        Map<String, Map<String, String>> converted = Conversions.convertRouteRules(routeRules);
        Map<String, Map<String, String>> withDefaults = Conversions.withDefaultTopics(routeCrn, converted);
        withDefaults.forEach((category, categoryRules) -> builder.put((String)category, AuditLogConfigRouteCategoryTopics.builder().allowed((String)MoreObjects.firstNonNull(categoryRules.get("allowed"), (Object)defaultTopics.getAllowed())).denied((String)MoreObjects.firstNonNull(categoryRules.get("denied"), (Object)defaultTopics.getDenied())).build()));
        return builder.build();
    }
}

