/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.resources.base.MetadataServiceResource;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.auth.metadata.AuthStore;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/1.0/")
@Produces(value={"application/json"})
public class V1MetadataServiceResource {
    private final MetadataServiceResource delegate;

    public V1MetadataServiceResource(AuthStore authStore, String metadataClusterId) {
        this.delegate = new MetadataServiceResource(authStore, metadataClusterId);
    }

    @GET
    @Path(value="activenodes/{protocol}")
    @PerformanceMetric(value="v1.active.node.with.specified.protocol")
    public List<String> activeNodeWithSpecifiedProtocol(@PathParam(value="protocol") String protocol) {
        return this.delegate.activeNodeWithSpecifiedProtocol(protocol);
    }

    @GET
    @Path(value="metadataClusterId")
    @PerformanceMetric(value="v1.get.backing.kafka.clusterId")
    public String getBackingKafkaClusterId() {
        return this.delegate.getBackingKafkaClusterId();
    }
}

