/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.jackson.V1Role;
import io.confluent.rbacapi.resources.base.RolesResource;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.Role;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/1.0/")
@Produces(value={"application/json"})
public class V1RolesResource {
    private final RolesResource delegate;

    public V1RolesResource(RbacRoles rbacRoles) {
        this.delegate = new RolesResource(rbacRoles);
    }

    @GET
    @Path(value="roles")
    @PerformanceMetric(value="v1.roles.list")
    public List<V1Role> roles() {
        return this.delegate.roles().stream().map(V1Role::new).collect(Collectors.toList());
    }

    @GET
    @Path(value="roles/{roleName}")
    @PerformanceMetric(value="v1.role.get")
    public V1Role role(@PathParam(value="roleName") String roleName) {
        Role role = this.delegate.role(roleName);
        if (role == null) {
            return null;
        }
        return new V1Role(role);
    }

    @GET
    @Path(value="roleNames")
    @PerformanceMetric(value="v1.rolenames.list")
    public List<String> roleNames() {
        return this.delegate.roleNames();
    }
}

