/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.resources.base.UserGroupResource;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.rbacapi.validation.v1.V1ValidMdsScope;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.auth.metadata.AuthCache;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1.0/rbac")
@Produces(value={"application/json"})
public class V1UserGroupResource {
    private final UserGroupResource delegate;

    public V1UserGroupResource(AuthCache authCache, ClusterRegistryService clusterRegistryService, SecurityMetadataAuthorizer metadataAuthorizer) {
        this.delegate = new UserGroupResource(authCache, clusterRegistryService, (ValidationUtil)new V1ValidationUtil(), metadataAuthorizer);
    }

    @POST
    @Path(value="/principals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.get.user.group.list")
    public List<String> getUserGroupList(@Context SecurityContext context, @QueryParam(value="type") @Pattern(regexp="(user)|(group)") @Pattern(regexp="(user)|(group)") String principalType, @V1ValidMdsScope MdsScope mdsScope) {
        return this.delegate.getUserGroupList(context, principalType, mdsScope);
    }
}

