/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import io.confluent.rbacapi.services.ResourceTypePermissions;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import java.util.Map;

public class ClusterPermissions {
    private final Map<ResourceType, ResourceTypePermissions> resourceTypePermisisons;

    public ClusterPermissions(Map<ResourceType, ResourceTypePermissions> resourceTypePermisisons) {
        this.resourceTypePermisisons = resourceTypePermisisons;
    }

    public boolean canDescribeAccess(ResourceType resourceType) {
        return this.hasDescribeAccess(ResourceType.ALL) || this.hasDescribeAccess(resourceType);
    }

    public boolean canDescribeAccess(ResourcePattern resourcePattern) {
        return this.canDescribeAccess(resourcePattern.resourceType()) || this.resourceTypePermisisons.containsKey(resourcePattern.resourceType()) && this.resourceTypePermisisons.get(resourcePattern.resourceType()).canDescribeAccess(resourcePattern.name(), resourcePattern.patternType());
    }

    public boolean canAlterAccess(ResourceType resourceType) {
        return this.hasAlterAccess(ResourceType.ALL) || this.hasAlterAccess(resourceType);
    }

    public boolean canAlterAccess(ResourcePattern resourcePattern) {
        return this.canAlterAccess(resourcePattern.resourceType()) || this.resourceTypePermisisons.containsKey(resourcePattern.resourceType()) && this.resourceTypePermisisons.get(resourcePattern.resourceType()).canAlterAccess(resourcePattern.name(), resourcePattern.patternType());
    }

    private boolean hasDescribeAccess(ResourceType resourceType) {
        return this.resourceTypePermisisons.containsKey(resourceType) && this.resourceTypePermisisons.get(resourceType).canDescribeAccess();
    }

    private boolean hasAlterAccess(ResourceType resourceType) {
        return this.resourceTypePermisisons.containsKey(resourceType) && this.resourceTypePermisisons.get(resourceType).canAlterAccess();
    }
}

