/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import com.google.common.collect.ImmutableSet;
import io.confluent.rbacapi.services.ClusterPermissions;
import io.confluent.rbacapi.services.ResourceTypePermissions;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.utils.RoleAccessUtils;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import io.confluent.security.rbac.RoleBinding;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ClusterPermissionsBuilder {
    private static final String ALL = "All";
    private static final String DESCRIBE_ACCESS = "DescribeAccess";
    private static final String ALTER_ACCESS = "AlterAccess";
    private static final Set<String> FILTER_OPERATIONS = ImmutableSet.of((Object)"All", (Object)"DescribeAccess", (Object)"AlterAccess");
    private static final ResourcePattern KAFKA_CLUSTER_RESOURCE = new ResourcePattern(new ResourceType("Cluster"), "kafka-cluster", PatternType.LITERAL);

    public ClusterPermissions build(Map<String, Role> rolesByName, Collection<KafkaPrincipal> targetPrincipals, Scope scope, ResourceType resourceType, Collection<RoleBinding> roleBindings) {
        HashMap<ResourceType, ResourceTypePermissions.Builder> resourceTypePermisisonsBuilder = new HashMap<ResourceType, ResourceTypePermissions.Builder>();
        for (RoleBinding roleBinding : roleBindings) {
            if (!roleBinding.scope().equals((Object)scope) || !targetPrincipals.contains(roleBinding.principal()) || !rolesByName.containsKey(roleBinding.role())) continue;
            Role role = rolesByName.get(roleBinding.role());
            if (role.bindWithResource()) {
                for (ResourcePattern resourcePattern : roleBinding.resources()) {
                    boolean roleWithDescribeAccess;
                    if (!resourceType.equals((Object)ResourceType.ALL) && !resourcePattern.resourceType().equals((Object)resourceType) || !(roleWithDescribeAccess = RoleAccessUtils.hasDescribeAccess((Role)role, (ResourceType)resourcePattern.resourceType()))) continue;
                    resourceTypePermisisonsBuilder.computeIfAbsent(resourcePattern.resourceType(), rt -> ResourceTypePermissions.builder((ResourceType)rt));
                    boolean roleWithAlterAccess = RoleAccessUtils.hasAlterAccess((Role)role, (ResourceType)resourcePattern.resourceType());
                    HashSet<String> allowedOperations = new HashSet<String>((Collection<String>)ImmutableSet.of((Object)DESCRIBE_ACCESS));
                    if (roleWithAlterAccess) {
                        allowedOperations.add(ALTER_ACCESS);
                    }
                    ((ResourceTypePermissions.Builder)resourceTypePermisisonsBuilder.get(resourcePattern.resourceType())).putResourceOperations(resourcePattern.name(), resourcePattern.patternType(), allowedOperations);
                }
                continue;
            }
            ClusterPermissionsBuilder.addAllRoleOperations(role, resourceTypePermisisonsBuilder);
        }
        return new ClusterPermissions(ClusterPermissionsBuilder.buildResourceTypePermissions(resourceTypePermisisonsBuilder));
    }

    private static void addAllRoleOperations(Role role, Map<ResourceType, ResourceTypePermissions.Builder> resourceTypePermisisonsBuilder) {
        role.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations().stream()).filter(resourceOperations -> FILTER_OPERATIONS.stream().anyMatch(op -> resourceOperations.operations().contains(op))).forEach(allowedOperations -> {
            ResourceType resourceType = new ResourceType(allowedOperations.resourceType());
            resourceTypePermisisonsBuilder.computeIfAbsent(resourceType, v -> ResourceTypePermissions.builder((ResourceType)v));
            ((ResourceTypePermissions.Builder)resourceTypePermisisonsBuilder.get(resourceType)).addClusterOperations(allowedOperations.operations());
        });
    }

    private static boolean isKafkaCluster(Scope scope) {
        return ClusterType.filterScopeBy((ClusterType)ClusterType.KAFKA_CLUSTER).test(scope);
    }

    private static Map<ResourceType, ResourceTypePermissions> buildResourceTypePermissions(Map<ResourceType, ResourceTypePermissions.Builder> resourceTypePermisisonsBuilder) {
        return resourceTypePermisisonsBuilder.values().stream().map(permissionsBuilder -> permissionsBuilder.build()).collect(Collectors.toMap(permissions -> permissions.getResourceType(), permissions -> permissions));
    }
}

