/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;

final class DefaultCookie
implements Cookie {
    private final String name;
    private final String value;
    private final boolean valueQuoted;
    @Nullable
    private final String domain;
    @Nullable
    private final String path;
    private final long maxAge;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean hostOnly;
    @Nullable
    private final String sameSite;

    DefaultCookie(String name, String value, boolean valueQuoted, @Nullable String domain, @Nullable String path, long maxAge, boolean secure, boolean httpOnly, boolean hostOnly, @Nullable String sameSite) {
        this.name = name;
        this.value = value;
        this.valueQuoted = valueQuoted;
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.hostOnly = hostOnly;
        this.sameSite = sameSite;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean isValueQuoted() {
        return this.valueQuoted;
    }

    @Override
    @Nullable
    public String domain() {
        return this.domain;
    }

    @Override
    @Nullable
    public String path() {
        return this.path;
    }

    @Override
    public long maxAge() {
        return this.maxAge;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    @Nullable
    public String sameSite() {
        return this.sameSite;
    }

    @Override
    public boolean isHostOnly() {
        return this.hostOnly;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie that = (Cookie)o;
        if (!(this.name.equals(that.name()) && this.value.equals(that.value()) && Objects.equals(this.path, that.path()))) {
            return false;
        }
        if (this.domain() == null) {
            return that.domain() == null;
        }
        return this.domain().equalsIgnoreCase(that.domain());
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("value", !this.value.isEmpty() ? this.value : "<EMPTY>").add("valueQuoted", this.valueQuoted).add("domain", this.domain).add("path", this.path);
        if (this.maxAge != Long.MIN_VALUE) {
            helper.add("maxAge", this.maxAge);
        }
        if (this.secure) {
            helper.addValue("secure");
        }
        if (this.httpOnly) {
            helper.addValue("httpOnly");
        }
        helper.add("sameSite", this.sameSite);
        return helper.toString();
    }
}

