/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestTimeoutException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class DefaultCancellationScheduler
implements CancellationScheduler {
    static final CancellationScheduler serverFinishedCancellationScheduler = DefaultCancellationScheduler.finished0(true);
    static final CancellationScheduler clientFinishedCancellationScheduler = DefaultCancellationScheduler.finished0(false);
    private CancellationScheduler.State state = CancellationScheduler.State.INIT;
    private long timeoutNanos;
    private long startTimeNanos;
    @Nullable
    private EventExecutor eventLoop;
    private volatile CancellationScheduler.CancellationTask task = noopCancellationTask;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    private long setFromNowStartNanos;
    private TimeoutMode timeoutMode = TimeoutMode.SET_FROM_START;
    @Nullable
    private volatile Throwable cause;
    private final Ticker ticker;
    private final ReentrantShortLock lock = new ReentrantShortLock();
    private final boolean server;
    private final CancellationFuture whenCancelling = new CancellationFuture();
    private final CancellationFuture whenCancelled = new CancellationFuture();

    DefaultCancellationScheduler(long timeoutNanos) {
        this(timeoutNanos, true);
    }

    DefaultCancellationScheduler(long timeoutNanos, boolean server) {
        this(timeoutNanos, server, Ticker.systemTicker());
    }

    DefaultCancellationScheduler(long timeoutNanos, boolean server, Ticker ticker) {
        this.timeoutNanos = timeoutNanos;
        this.server = server;
        this.ticker = ticker;
    }

    @Override
    public void initAndStart(EventExecutor eventLoop, CancellationScheduler.CancellationTask task) {
        this.lock.lock();
        try {
            this.init(eventLoop);
            this.updateTask(task);
            this.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void init(EventExecutor eventLoop) {
        this.lock.lock();
        try {
            Preconditions.checkState(this.eventLoop == null, "Can't init() more than once");
            this.eventLoop = eventLoop;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        this.lock.lock();
        try {
            if (this.state != CancellationScheduler.State.INIT) {
                return;
            }
            this.startTimeNanos = this.ticker.read();
            if (this.timeoutMode == TimeoutMode.SET_FROM_NOW) {
                long elapsedTimeNanos = this.startTimeNanos - this.setFromNowStartNanos;
                this.timeoutNanos = Long.max(LongMath.saturatedSubtract(this.timeoutNanos, elapsedTimeNanos), 0L);
            }
            this.state = CancellationScheduler.State.SCHEDULED;
            if (this.timeoutNanos != Long.MAX_VALUE) {
                this.scheduledFuture = this.eventLoop().schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clearTimeout() {
        this.lock.lock();
        try {
            if (this.timeoutNanos == Long.MAX_VALUE) {
                return;
            }
            this.timeoutNanos = Long.MAX_VALUE;
            if (this.isStarted()) {
                this.cancelScheduled();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancelScheduled() {
        this.lock.lock();
        try {
            if (this.scheduledFuture == null) {
                boolean bl = true;
                return bl;
            }
            boolean cancelled = this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
            boolean bl = cancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isScheduled() {
        return this.scheduledFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void setTimeoutNanos(TimeoutMode mode, long timeoutNanos) {
        this.lock.lock();
        try {
            switch (1.$SwitchMap$com$linecorp$armeria$common$util$TimeoutMode[mode.ordinal()]) {
                case 1: {
                    result = this.setTimeoutNanosFromNow(timeoutNanos);
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: {
                    result = this.setTimeoutNanosFromStart(timeoutNanos);
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 3: {
                    result = this.extendTimeoutNanos(timeoutNanos);
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (result == ScheduleResult.INVOKE_IMMEDIATELY) {
            this.invokeTask(null);
        }
    }

    private ScheduleResult setTimeoutNanosFromStart(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos >= 0L, "timeoutNanos: %s (expected: >= 0)", timeoutNanos);
        if (timeoutNanos == Long.MAX_VALUE) {
            this.clearTimeout();
            return ScheduleResult.INVOKE_LATER;
        }
        if (this.isStarted()) {
            return this.setTimeoutNanosFromStart0(timeoutNanos);
        }
        this.timeoutNanos = timeoutNanos;
        this.timeoutMode = TimeoutMode.SET_FROM_START;
        return ScheduleResult.INVOKE_LATER;
    }

    private ScheduleResult setTimeoutNanosFromStart0(long timeoutNanos) {
        long newTimeoutNanos;
        if (timeoutNanos != Long.MAX_VALUE) {
            long passedTimeNanos = this.ticker.read() - this.startTimeNanos;
            newTimeoutNanos = LongMath.saturatedSubtract(timeoutNanos, passedTimeNanos);
        } else {
            newTimeoutNanos = timeoutNanos;
        }
        this.timeoutMode = TimeoutMode.SET_FROM_START;
        this.timeoutNanos = timeoutNanos;
        if (newTimeoutNanos <= 0L) {
            return ScheduleResult.INVOKE_IMMEDIATELY;
        }
        if (this.cancelScheduled() && !this.isFinished() && newTimeoutNanos != Long.MAX_VALUE) {
            this.scheduledFuture = this.eventLoop().schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
        }
        return ScheduleResult.INVOKE_LATER;
    }

    private ScheduleResult extendTimeoutNanos(long adjustmentNanos) {
        if (this.timeoutNanos == Long.MAX_VALUE || adjustmentNanos == Long.MAX_VALUE) {
            return ScheduleResult.INVOKE_LATER;
        }
        if (this.isStarted()) {
            return this.extendTimeoutNanos0(adjustmentNanos);
        }
        this.timeoutNanos = LongMath.saturatedAdd(this.timeoutNanos, adjustmentNanos);
        return ScheduleResult.INVOKE_LATER;
    }

    private ScheduleResult extendTimeoutNanos0(long adjustmentNanos) {
        long timeoutNanos = this.timeoutNanos;
        this.timeoutNanos = LongMath.saturatedAdd(timeoutNanos, adjustmentNanos);
        if (this.timeoutNanos <= 0L) {
            return ScheduleResult.INVOKE_IMMEDIATELY;
        }
        if (this.cancelScheduled() && !this.isFinished()) {
            this.scheduledFuture = this.eventLoop().schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        return ScheduleResult.INVOKE_LATER;
    }

    private ScheduleResult setTimeoutNanosFromNow(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos > 0L, "timeoutNanos: %s (expected: > 0)", timeoutNanos);
        if (this.isStarted()) {
            return this.setTimeoutNanosFromNow0(timeoutNanos);
        }
        this.setFromNowStartNanos = this.ticker.read();
        this.timeoutMode = TimeoutMode.SET_FROM_NOW;
        this.timeoutNanos = timeoutNanos;
        return ScheduleResult.INVOKE_LATER;
    }

    private ScheduleResult setTimeoutNanosFromNow0(long newTimeoutNanos) {
        assert (newTimeoutNanos > 0L);
        long passedTimeNanos = this.ticker.read() - this.startTimeNanos;
        this.timeoutNanos = LongMath.saturatedAdd(newTimeoutNanos, passedTimeNanos);
        this.timeoutMode = TimeoutMode.SET_FROM_NOW;
        if (this.cancelScheduled() && !this.isFinished() && newTimeoutNanos != Long.MAX_VALUE) {
            this.scheduledFuture = this.eventLoop().schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
        }
        return ScheduleResult.INVOKE_LATER;
    }

    private EventExecutor eventLoop() {
        assert (this.eventLoop != null);
        return this.eventLoop;
    }

    @Override
    public void finishNow(@Nullable Throwable cause) {
        this.invokeTask(cause);
    }

    @Override
    @Nullable
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public long timeoutNanos() {
        return this.timeoutNanos == Long.MAX_VALUE ? 0L : this.timeoutNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long remainingTimeoutNanos() {
        this.lock.lock();
        try {
            if (this.timeoutNanos == Long.MAX_VALUE) {
                long l = 0L;
                return l;
            }
            if (!this.isStarted()) {
                long l = this.timeoutNanos;
                return l;
            }
            long elapsed = this.ticker.read() - this.startTimeNanos;
            long l = Math.max(1L, LongMath.saturatedSubtract(this.timeoutNanos, elapsed));
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    private boolean isStarted() {
        return this.state != CancellationScheduler.State.INIT;
    }

    @Override
    public boolean isFinished() {
        return this.state == CancellationScheduler.State.FINISHED;
    }

    @Override
    public void updateTask(CancellationScheduler.CancellationTask task) {
        this.lock.lock();
        try {
            if (this.state != CancellationScheduler.State.FINISHED) {
                this.task = task;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.whenCancelled().thenAccept(cause -> {
            if (task.canSchedule()) {
                task.run((Throwable)cause);
            }
        });
    }

    private void invokeTask(@Nullable Throwable cause) {
        this.lock.lock();
        try {
            if (this.state == CancellationScheduler.State.FINISHED) {
                return;
            }
            this.state = CancellationScheduler.State.FINISHED;
            this.cancelScheduled();
            this.cause = cause = this.getFinalCause(cause);
        }
        finally {
            this.lock.unlock();
        }
        if (this.task.canSchedule()) {
            ((CancellationFuture)this.whenCancelling()).doComplete(cause);
        }
        if (this.task.canSchedule()) {
            assert (!this.lock.isHeldByCurrentThread()) : "Currently locked by lock: [" + this.lock + "], with count: " + this.lock.getHoldCount();
            this.task.run(cause);
        }
        ((CancellationFuture)this.whenCancelled()).doComplete(cause);
    }

    private Throwable getFinalCause(@Nullable Throwable cause) {
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            cause = cause.getCause();
        }
        if (cause == null) {
            cause = this.server ? RequestTimeoutException.get() : ResponseTimeoutException.get();
        }
        return cause;
    }

    @Override
    public CancellationScheduler.State state() {
        return this.state;
    }

    @Override
    public CompletableFuture<Throwable> whenCancelling() {
        return this.whenCancelling;
    }

    @Override
    public CompletableFuture<Throwable> whenCancelled() {
        return this.whenCancelled;
    }

    private static CancellationScheduler finished0(boolean server) {
        DefaultCancellationScheduler cancellationScheduler = new DefaultCancellationScheduler(Long.MAX_VALUE, server);
        cancellationScheduler.initAndStart((EventExecutor)ImmediateEventExecutor.INSTANCE, noopCancellationTask);
        cancellationScheduler.finishNow();
        return cancellationScheduler;
    }

    static long translateTimeoutNanos(long timeoutNanos) {
        if (timeoutNanos == Long.MAX_VALUE) {
            timeoutNanos = 0x7FFFFFFFFFFFFFFEL;
        }
        if (timeoutNanos == 0L) {
            timeoutNanos = Long.MAX_VALUE;
        }
        return timeoutNanos;
    }

    private static class CancellationFuture
    extends UnmodifiableFuture<Throwable> {
        private CancellationFuture() {
        }

        @Override
        protected void doComplete(@Nullable Throwable cause) {
            super.doComplete(cause);
        }
    }

    private static enum ScheduleResult {
        INVOKE_LATER,
        INVOKE_IMMEDIATELY;

    }
}

