/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.HttpObjectEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;

public abstract class Http1ObjectEncoder
implements HttpObjectEncoder {
    private static final int MAX_TLS_DATA_LENGTH = 16376;
    private static final HttpContent EMPTY_CONTENT = new DefaultHttpContent(Unpooled.EMPTY_BUFFER);
    private final Channel ch;
    private final SessionProtocol protocol;
    private volatile boolean closed;
    private int currentId = 1;
    private int minClosedId = Integer.MAX_VALUE;
    private int maxIdWithPendingWrites = Integer.MIN_VALUE;
    private final IntObjectMap<PendingWrites> pendingWritesMap = new IntObjectHashMap();

    protected Http1ObjectEncoder(Channel ch, SessionProtocol protocol) {
        this.ch = Objects.requireNonNull(ch, "ch");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
    }

    @Override
    public final Channel channel() {
        return this.ch;
    }

    protected final ChannelFuture writeNonInformationalHeaders(int id, HttpObject converted, boolean endStream, ChannelPromise promise) {
        Object f;
        if (converted instanceof LastHttpContent) {
            assert (endStream);
            f = this.write(id, converted, true, promise);
        } else {
            f = this.write(id, converted, false, promise);
            if (endStream) {
                ChannelFuture lastFuture = this.write(id, (HttpObject)LastHttpContent.EMPTY_LAST_CONTENT, true);
                f = Flags.verboseExceptionSampler().isSampled(Http1VerboseWriteException.class) ? this.combine((ChannelFuture)f, lastFuture) : lastFuture;
            }
        }
        this.ch.flush();
        return f;
    }

    private ChannelPromise combine(final ChannelFuture first, final ChannelFuture second) {
        final ChannelPromise promise = this.channel().newPromise();
        FutureListener<Void> listener = new FutureListener<Void>(){
            private int remaining = 2;

            public void operationComplete(Future<Void> ignore) throws Exception {
                --this.remaining;
                if (this.remaining == 0) {
                    Throwable combinedCause;
                    Throwable firstCause = first.cause();
                    Throwable secondCause = second.cause();
                    if (firstCause == null) {
                        combinedCause = secondCause;
                    } else {
                        if (secondCause != null && secondCause != firstCause) {
                            firstCause.addSuppressed(secondCause);
                        }
                        combinedCause = firstCause;
                    }
                    if (combinedCause != null) {
                        promise.setFailure(combinedCause);
                    } else {
                        promise.setSuccess();
                    }
                }
            }
        };
        first.addListener((GenericFutureListener)listener);
        second.addListener((GenericFutureListener)listener);
        return promise;
    }

    @Override
    public final ChannelFuture doWriteData(int id, int streamId, HttpData data, boolean endStream) {
        if (!this.isWritable(id)) {
            data.close();
            return this.newClosedSessionFuture();
        }
        int length = data.length();
        if (length == 0) {
            data.close();
            LastHttpContent content = endStream ? LastHttpContent.EMPTY_LAST_CONTENT : EMPTY_CONTENT;
            ChannelFuture future = this.write(id, (HttpObject)content, endStream);
            this.ch.flush();
            return future;
        }
        try {
            if (!this.protocol.isTls() || length <= 16376) {
                return this.doWriteUnsplitData(id, data, endStream);
            }
            return this.doWriteSplitData(id, data, endStream);
        }
        catch (Throwable t) {
            return this.newFailedFuture(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture doWriteUnsplitData(int id, HttpData data, boolean endStream) {
        ByteBuf buf = this.toByteBuf(data);
        boolean handled = false;
        try {
            Object content = endStream ? new DefaultLastHttpContent(buf) : new DefaultHttpContent(buf);
            ChannelFuture future = this.write(id, (HttpObject)content, endStream);
            handled = true;
            this.ch.flush();
            ChannelFuture channelFuture = future;
            return channelFuture;
        }
        finally {
            if (!handled) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture doWriteSplitData(int id, HttpData data, boolean endStream) {
        try {
            ChannelFuture lastFuture;
            int offset = 0;
            int remaining = data.length();
            while (true) {
                int chunkSize = Math.min(16376, remaining);
                lastFuture = this.write(id, (HttpObject)new DefaultHttpContent(this.toByteBuf(data, offset, chunkSize)), false);
                if ((remaining -= chunkSize) == 0) break;
                offset += chunkSize;
            }
            if (endStream) {
                lastFuture = this.write(id, (HttpObject)LastHttpContent.EMPTY_LAST_CONTENT, true);
            }
            this.ch.flush();
            ChannelFuture channelFuture = lastFuture;
            return channelFuture;
        }
        finally {
            data.close();
        }
    }

    protected final ChannelFuture write(int id, HttpObject obj, boolean endStream) {
        return this.write(id, obj, endStream, this.ch.newPromise());
    }

    final ChannelFuture write(int id, HttpObject obj, boolean endStream, ChannelPromise promise) {
        PendingWrites pendingWrites;
        if (id < this.currentId) {
            ReferenceCountUtil.release((Object)obj);
            promise.setFailure((Throwable)ClosedSessionException.get());
            return promise;
        }
        PendingWrites currentPendingWrites = (PendingWrites)this.pendingWritesMap.get(id);
        if (id == this.currentId) {
            if (currentPendingWrites != null) {
                this.pendingWritesMap.remove(id);
                this.flushPendingWrites(currentPendingWrites);
            }
            ChannelFuture future = this.write(obj, promise);
            if (!this.isPing(id)) {
                this.keepAliveHandler().onReadOrWrite();
            }
            if (endStream) {
                PendingWrites nextPendingWrites;
                ++this.currentId;
                while ((nextPendingWrites = (PendingWrites)this.pendingWritesMap.get(this.currentId)) != null) {
                    this.flushPendingWrites(nextPendingWrites);
                    if (!nextPendingWrites.isEndOfStream()) break;
                    this.pendingWritesMap.remove(this.currentId);
                    ++this.currentId;
                }
            }
            return future;
        }
        AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise> entry = new AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise>(obj, promise);
        if (currentPendingWrites == null) {
            pendingWrites = new PendingWrites();
            this.maxIdWithPendingWrites = Math.max(this.maxIdWithPendingWrites, id);
            this.pendingWritesMap.put(id, (Object)pendingWrites);
        } else {
            pendingWrites = currentPendingWrites;
        }
        pendingWrites.add((Map.Entry<HttpObject, ChannelPromise>)entry);
        if (endStream) {
            pendingWrites.setEndOfStream();
        }
        return promise;
    }

    protected abstract ChannelFuture write(HttpObject var1, ChannelPromise var2);

    protected int currentId() {
        return this.currentId;
    }

    private void flushPendingWrites(PendingWrites pendingWrites) {
        Map.Entry e;
        while ((e = (Map.Entry)pendingWrites.poll()) != null) {
            this.write((HttpObject)e.getKey(), (ChannelPromise)e.getValue());
        }
    }

    @Override
    public final ChannelFuture doWriteTrailers(int id, int streamId, HttpHeaders headers) {
        if (!this.isWritable(id)) {
            return this.newClosedSessionFuture();
        }
        return this.write(id, (HttpObject)this.convertTrailers(headers), true);
    }

    private LastHttpContent convertTrailers(HttpHeaders inputHeaders) {
        if (inputHeaders.isEmpty()) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        DefaultLastHttpContent lastContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
        io.netty.handler.codec.http.HttpHeaders outputHeaders = lastContent.trailingHeaders();
        this.convertTrailers(inputHeaders, outputHeaders);
        return lastContent;
    }

    protected abstract void convertTrailers(HttpHeaders var1, io.netty.handler.codec.http.HttpHeaders var2);

    @Override
    public final ChannelFuture doWriteReset(int id, int streamId, Http2Error error) {
        this.updateClosedId(id);
        if (this.minClosedId <= this.maxIdWithPendingWrites) {
            ClosedSessionException cause = new ClosedSessionException("An HTTP/1 connection has been reset: " + error);
            for (int i = this.minClosedId; i <= this.maxIdWithPendingWrites; ++i) {
                Map.Entry e;
                PendingWrites pendingWrites = (PendingWrites)this.pendingWritesMap.remove(i);
                while ((e = (Map.Entry)pendingWrites.poll()) != null) {
                    ((ChannelPromise)e.getValue()).tryFailure((Throwable)cause);
                }
            }
        }
        ChannelFuture f = this.ch.write((Object)Unpooled.EMPTY_BUFFER);
        if (!this.isWritable(this.currentId)) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return f;
    }

    @Override
    public final boolean isWritable(int id, int streamId) {
        return this.isWritable(id);
    }

    protected final boolean isWritable(int id) {
        return id < this.minClosedId && !this.isClosed();
    }

    protected final void updateClosedId(int id) {
        this.minClosedId = Math.min(this.minClosedId, id);
    }

    protected abstract boolean isPing(int var1);

    @Override
    public final void close(Throwable cause) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.keepAliveHandler().destroy();
        if (this.pendingWritesMap.isEmpty()) {
            return;
        }
        for (Queue queue : this.pendingWritesMap.values()) {
            Map.Entry e;
            while ((e = (Map.Entry)queue.poll()) != null) {
                ((ChannelPromise)e.getValue()).tryFailure(cause);
            }
        }
        this.pendingWritesMap.clear();
    }

    @Override
    public final boolean isClosed() {
        return this.closed || !this.channel().isActive();
    }

    protected final SessionProtocol protocol() {
        return this.protocol;
    }

    private static final class Http1VerboseWriteException
    extends Exception {
        private Http1VerboseWriteException() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class PendingWrites
    extends ArrayDeque<Map.Entry<HttpObject, ChannelPromise>> {
        private static final long serialVersionUID = 4241891747461017445L;
        private boolean endOfStream;

        PendingWrites() {
            super(4);
        }

        @Override
        public boolean add(Map.Entry<HttpObject, ChannelPromise> httpObjectChannelPromiseEntry) {
            return this.isEndOfStream() ? false : super.add(httpObjectChannelPromiseEntry);
        }

        boolean isEndOfStream() {
            return this.endOfStream;
        }

        void setEndOfStream() {
            this.endOfStream = true;
        }
    }
}

