/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMessage;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.HeadersFuture;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitHttpMessageSubscriber
implements Subscriber<HttpObject>,
Subscription {
    private static final Logger logger = LoggerFactory.getLogger(SplitHttpMessageSubscriber.class);
    private static final AtomicReferenceFieldUpdater<SplitHttpMessageSubscriber, HeadersFuture> trailersFutureUpdater = AtomicReferenceFieldUpdater.newUpdater(SplitHttpMessageSubscriber.class, HeadersFuture.class, "trailersFuture");
    private static final HeadersFuture<HttpHeaders> EMPTY_TRAILERS_FUTURE = new HeadersFuture();
    private final HttpMessage upstreamMessage;
    private final EventExecutor upstreamExecutor;
    private long pendingRequests;
    private boolean completing;
    private volatile boolean notifyCancellation;
    private boolean usePooledObject;
    @Nullable
    private volatile HeadersFuture<HttpHeaders> trailersFuture;
    private volatile boolean wroteAny;
    @Nullable
    private volatile Subscriber<? super HttpData> downstream;
    @Nullable
    private volatile Subscription upstream;
    @Nullable
    private volatile EventExecutor downstreamExecutor;
    @Nullable
    private volatile Throwable cause;
    private volatile boolean cancelCalled;
    private boolean needsDirectInvocation;

    SplitHttpMessageSubscriber(int prefetch, HttpMessage upstreamMessage, EventExecutor upstreamExecutor) {
        this.pendingRequests = prefetch;
        this.upstreamMessage = Objects.requireNonNull(upstreamMessage, "upstreamMessage");
        this.upstreamExecutor = Objects.requireNonNull(upstreamExecutor, "upstreamExecutor");
    }

    final CompletableFuture<HttpHeaders> trailersFuture() {
        HeadersFuture<HttpHeaders> trailersFuture = this.trailersFuture;
        if (trailersFuture != null) {
            return trailersFuture;
        }
        trailersFuture = new HeadersFuture();
        if (trailersFutureUpdater.compareAndSet(this, null, trailersFuture)) {
            return trailersFuture;
        }
        HeadersFuture<HttpHeaders> oldTrailersFuture = this.trailersFuture;
        assert (oldTrailersFuture != null);
        return oldTrailersFuture;
    }

    final boolean wroteAny() {
        return this.wroteAny;
    }

    @Nullable
    final Subscription upstream() {
        return this.upstream;
    }

    void initDownstream(Subscriber<? super HttpData> downstream, EventExecutor downstreamExecutor, SubscriptionOption ... options) {
        this.downstream = downstream;
        this.downstreamExecutor = downstreamExecutor;
        for (SubscriptionOption option : options) {
            if (option == SubscriptionOption.NOTIFY_CANCELLATION) {
                this.notifyCancellation = true;
                continue;
            }
            if (option != SubscriptionOption.WITH_POOLED_OBJECTS) continue;
            this.usePooledObject = true;
        }
        boolean bl = this.needsDirectInvocation = downstreamExecutor == this.upstreamExecutor;
        if (this.needsDirectInvocation) {
            this.initDownstream(downstream);
        } else {
            downstreamExecutor.execute(() -> this.initDownstream(downstream));
        }
    }

    private void initDownstream(Subscriber<? super HttpData> downstream) {
        try {
            downstream.onSubscribe((Subscription)this);
            Throwable cause = this.cause;
            if (cause != null) {
                this.onError0(cause, downstream);
            } else if (this.completing) {
                downstream.onComplete();
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber should not throw an exception. subscriber: {}", downstream, (Object)t);
        }
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        if (this.upstream != null) {
            subscription.cancel();
            return;
        }
        this.upstream = subscription;
        if (this.cancelCalled) {
            subscription.cancel();
            return;
        }
        if (this.pendingRequests > 0L) {
            subscription.request(this.pendingRequests);
        }
    }

    public void request(long n) {
        if (n <= 0L) {
            this.upstreamMessage.abort(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
            return;
        }
        if (this.upstreamExecutor.inEventLoop()) {
            this.request0(n);
        } else {
            this.upstreamExecutor.execute(() -> this.request0(n));
        }
    }

    private void request0(long n) {
        Subscription upstream = this.upstream;
        if (upstream == null) {
            this.pendingRequests = LongMath.saturatedAdd(n, this.pendingRequests);
        } else {
            upstream.request(n);
        }
    }

    public final void cancel() {
        Subscription upstream;
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        if (!this.notifyCancellation) {
            this.downstream = NoopSubscriber.get();
        }
        if ((upstream = this.upstream) != null) {
            upstream.cancel();
        }
    }

    public void onNext(HttpObject httpObject) {
        if (httpObject instanceof HttpHeaders) {
            HttpHeaders trailers = (HttpHeaders)httpObject;
            this.completeTrailers(trailers);
            return;
        }
        assert (httpObject instanceof HttpData);
        if (this.needsDirectInvocation) {
            this.onNext0((HttpData)httpObject);
        } else {
            EventExecutor downstreamExecutor = this.downstreamExecutor;
            assert (downstreamExecutor != null);
            downstreamExecutor.execute(() -> this.onNext0((HttpData)httpObject));
        }
    }

    private void onNext0(HttpData httpData) {
        this.wroteAny = true;
        if (!this.usePooledObject) {
            httpData = PooledObjects.copyAndClose(httpData);
        }
        Subscriber<? super HttpData> downstream = this.downstream;
        assert (downstream != null);
        downstream.onNext((Object)httpData);
    }

    public void onComplete() {
        this.doOnCompletion(null);
        this.maybeCompleteTrailers();
        EventExecutor downstreamExecutor = this.downstreamExecutor;
        Subscriber<? super HttpData> downstream = this.downstream;
        if (downstreamExecutor == null || downstream == null) {
            this.completing = true;
            return;
        }
        if (this.needsDirectInvocation) {
            downstream.onComplete();
        } else {
            downstreamExecutor.execute(() -> downstream.onComplete());
        }
    }

    public void onError(Throwable cause) {
        this.doOnCompletion(cause);
        this.maybeCompleteTrailers();
        EventExecutor downstreamExecutor = this.downstreamExecutor;
        Subscriber<? super HttpData> downstream = this.downstream;
        if (downstreamExecutor == null || downstream == null) {
            this.cause = cause;
            return;
        }
        if (this.needsDirectInvocation) {
            this.onError0(cause, downstream);
        } else {
            downstreamExecutor.execute(() -> this.onError0(cause, downstream));
        }
    }

    private void onError0(Throwable cause, Subscriber<? super HttpData> downstream) {
        downstream.onError(cause);
        this.downstream = NoopSubscriber.get();
    }

    private void completeTrailers(HttpHeaders trailers) {
        HeadersFuture<HttpHeaders> trailersFuture = this.trailersFuture;
        if (trailersFuture != null) {
            trailersFuture.doComplete(trailers);
            return;
        }
        trailersFuture = new HeadersFuture();
        if (trailersFutureUpdater.compareAndSet(this, null, trailersFuture)) {
            trailersFuture.doComplete(trailers);
        } else {
            HeadersFuture<HttpHeaders> oldTrailersFuture = this.trailersFuture;
            assert (oldTrailersFuture != null);
            oldTrailersFuture.doComplete(trailers);
        }
    }

    private void maybeCompleteTrailers() {
        if (this.trailersFuture == null && trailersFutureUpdater.compareAndSet(this, null, EMPTY_TRAILERS_FUTURE)) {
            return;
        }
        HeadersFuture<HttpHeaders> trailersFuture = this.trailersFuture;
        assert (trailersFuture != null);
        trailersFuture.doComplete(HttpHeaders.of());
    }

    protected void doOnCompletion(@Nullable Throwable cause) {
    }

    static {
        EMPTY_TRAILERS_FUTURE.doComplete(HttpHeaders.of());
    }
}

