/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser;

import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.AutoValue_EnumConstantElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.OptionElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class EnumConstantElement {
    public static Builder builder() {
        return new Builder();
    }

    EnumConstantElement() {
    }

    public abstract String name();

    public abstract int tag();

    public abstract String documentation();

    public abstract List<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append(this.name()).append(" = ").append(this.tag());
        if (!this.options().isEmpty()) {
            builder.append(" [\n");
            OptionElement.formatOptionList(builder, this.options());
            builder.append(']');
        }
        return builder.append(";\n").toString();
    }

    public static final class Builder {
        private String name;
        private Integer tag;
        private String documentation = "";
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            return this;
        }

        public Builder tag(int tag) {
            this.tag = tag;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public EnumConstantElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.tag, "tag");
            return new AutoValue_EnumConstantElement(this.name, this.tag, this.documentation, Utils.immutableCopyOf(this.options));
        }
    }
}

