/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.replication.push.ReplicationState;
import io.confluent.kafka.replication.push.ReplicationStateMetadata;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaState$;
import kafka.log.MergedLog$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedReplicationSessionIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\n\u0014\u0001aA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003.\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b\t\u0003A\u0011A\"\t\u000f%\u0003!\u0019!C\u0005\u0015\"1!\f\u0001Q\u0001\n-CQa\u0017\u0001\u0005\u0002qCQ!\u0018\u0001\u0005\u0002yCQa\u001f\u0001\u0005\u0002qDq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA7\u0001\u0011\u0005\u0013q\u000e\u0002\b%\u0016\u0004H.[2b\u0015\t!R#A\u0004dYV\u001cH/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0016\u0003\u0015)H/\u001b7t\u0013\t!\u0013EA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\n\t\u00035!J!!K\u000e\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#A\u0017\u0011\u000592T\"A\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u0017e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9tF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005y*\u0012AB:feZ,'/\u0003\u0002A{\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u001a;\u0005\n\u0005\u0002F\u00015\t1\u0003C\u0003&\u000f\u0001\u0007q\u0005C\u0003,\u000f\u0001\u0007Q\u0006C\u0003:\u000f\u0001\u00071(\u0001\u0007sKBd\u0017nY1Ti\u0006$X-F\u0001L!\raUkV\u0007\u0002\u001b*\u0011ajT\u0001\u0007CR|W.[2\u000b\u0005A\u000b\u0016AC2p]\u000e,(O]3oi*\u0011!kU\u0001\u0005kRLGNC\u0001U\u0003\u0011Q\u0017M^1\n\u0005Yk%aD!u_6L7MU3gKJ,gnY3\u0011\u0005\u0015C\u0016BA-\u0014\u00051\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u00035\u0011X\r\u001d7jG\u0006\u001cF/\u0019;fA\u0005i1\u000f^1uKNs\u0017\r]:i_R,\u0012aV\u0001\u0018kB$\u0017\r^3GKR\u001c\u0007n\u0015;bi\u0016|%\u000f\u00165s_^$ra\u00182ogV<\u0018\u0010\u0005\u0002\u001bA&\u0011\u0011m\u0007\u0002\u0005+:LG\u000fC\u0003d\u0017\u0001\u0007A-A\u000eg_2dwn^3s\r\u0016$8\r[(gMN,G/T3uC\u0012\fG/\u0019\t\u0003K2l\u0011A\u001a\u0006\u0003O\"\f1\u0001\\8h\u0015\tI'.A\u0005j]R,'O\\1mg*\u00111.M\u0001\bgR|'/Y4f\u0013\tigMA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006DQa\\\u0006A\u0002A\f1CZ8mY><XM]*uCJ$xJ\u001a4tKR\u0004\"AG9\n\u0005I\\\"\u0001\u0002'p]\u001eDQ\u0001^\u0006A\u0002A\f1CZ8mY><XM\u001d$fi\u000eDG+[7f\u001bNDQA^\u0006A\u0002A\fq\u0002\\3bI\u0016\u0014XI\u001c3PM\u001a\u001cX\r\u001e\u0005\u0006q.\u0001\r\u0001]\u0001\fEJ|7.\u001a:Fa>\u001c\u0007\u000eC\u0003{\u0017\u0001\u0007\u0001/\u0001\u000bsKBd\u0017nY1uS>t7+Z:tS>t\u0017\nZ\u0001\u001ekB$\u0017\r^3SKBd\u0017nY1uS>t7+Z:tS>t7\u000b^1uKR!q, @\u0000\u0011\u0015AH\u00021\u0001q\u0011\u0015QH\u00021\u0001q\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007\tqB]3qY&\u001c\u0017\r^5p]6{G-\u001a\t\u0005\u0003\u000b\tyB\u0004\u0003\u0002\b\u0005mQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\tA,8\u000f\u001b\u0006\u0005\u0003\u001f\t\t\"A\u0006sKBd\u0017nY1uS>t'b\u0001\f\u0002\u0014)!\u0011QCA\f\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\u001a\u0005\u0011\u0011n\\\u0005\u0005\u0003;\tI!\u0001\tSKBd\u0017nY1uS>t7\u000b^1uK&!\u0011\u0011EA\u0012\u0005\u0011iu\u000eZ3\u000b\t\u0005u\u0011\u0011B\u0001\u0012e\u0016\u001cX\r\u001e*fa2L7-Y*uCR,G#C0\u0002*\u00055\u0012qFA\u001d\u0011\u0019\tY#\u0004a\u0001a\u0006i1-\u001e:sK:$H+[7f\u001bNDQA^\u0007A\u0002ADq!!\r\u000e\u0001\u0004\t\u0019$A\u0006jg:+w\u000fT3bI\u0016\u0014\bc\u0001\u000e\u00026%\u0019\u0011qG\u000e\u0003\u000f\t{w\u000e\\3b]\"9\u00111H\u0007A\u0002\u0005M\u0012\u0001E5t\r>dGn\\<fe&s7+\u001f8d\u0003ii\u0017-\u001f2f%\u0016\u001cX\r\u001e'bgR\u001c\u0015-^4iiV\u0003H+[7f)\u0015y\u0016\u0011IA\"\u0011\u0019\tYC\u0004a\u0001a\")aO\u0004a\u0001a\u0006AAo\\*ue&tw\r\u0006\u0002\u0002JA!\u00111JA-\u001d\u0011\ti%!\u0016\u0011\u0007\u0005=3$\u0004\u0002\u0002R)\u0019\u00111K\f\u0002\rq\u0012xn\u001c;?\u0013\r\t9fG\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]3$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\t\u0019\u0007C\u0004\u0002fA\u0001\r!a\u001a\u0002\tQD\u0017\r\u001e\t\u00045\u0005%\u0014bAA67\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\n")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final MetadataCache metadataCache;
    private final AtomicReference<ReplicaState> replicaState;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private AtomicReference<ReplicaState> replicaState() {
        return this.replicaState;
    }

    public ReplicaState stateSnapshot() {
        return this.replicaState().get();
    }

    public void updateFetchStateOrThrow(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset, long brokerEpoch, long replicationSessionId) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            if (currentReplicaState.replicationSessionState().replicationSessionId() > replicationSessionId) {
                throw new FencedReplicationSessionIdException(new StringBuilder(73).append("Received stale fetch state update with ").append(brokerEpoch).append(" and ").append(replicationSessionId).append(". ").append("With current replica state ").append(currentReplicaState).toString());
            }
            MetadataCache metadataCache = this.metadataCache();
            if (metadataCache instanceof KRaftMetadataCache) {
                Option<Object> cachedBrokerEpoch = ((KRaftMetadataCache)metadataCache).getAliveBrokerEpoch(this.brokerId());
                if (brokerEpoch != -1L && cachedBrokerEpoch.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 > brokerEpoch)) {
                    throw new NotLeaderOrFollowerException(new StringBuilder(61).append("Received stale fetch state update. broker epoch=").append(brokerEpoch).append(" ").append("vs expected=").append(cachedBrokerEpoch.get()).toString());
                }
            }
            long lastCaughtUpTime = followerFetchOffsetMetadata$1.messageOffset >= leaderEndOffset ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), followerFetchTimeMs) : (followerFetchOffsetMetadata$1.messageOffset >= currentReplicaState.lastFetchLeaderLogEndOffset() ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), currentReplicaState.lastFetchTimeMs()) : currentReplicaState.lastCaughtUpTimeMs());
            return new ReplicaState(followerStartOffset, followerFetchOffsetMetadata, package$.MODULE$.max(leaderEndOffset, currentReplicaState.lastFetchLeaderLogEndOffset()), followerFetchTimeMs, lastCaughtUpTime, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)brokerEpoch)), currentReplicaState.replicationSessionState());
        });
    }

    public void updateReplicationSessionState(long brokerEpoch, long replicationSessionId, ReplicationState.Mode replicationMode) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            ReplicationState.Mode mode = replicationMode;
            ReplicationState.Mode mode2 = ReplicationState.Mode.PUSH;
            if (!(!(mode != null ? !mode.equals(mode2) : mode2 != null) ? currentReplicaState.canTransitionToPush(brokerEpoch, replicationSessionId) : currentReplicaState.canUpdateBrokerEpochOrReplicationSession(brokerEpoch, replicationSessionId))) {
                throw new IllegalStateException(new StringBuilder(132).append("Illegal state transition attempted from current replica state ").append(currentReplicaState).append(" to ").append("new replica state with [brokerEpoch=").append(brokerEpoch).append(", replicationSessionId=").append(replicationSessionId).append(", mode=").append(replicationMode).toString());
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), currentReplicaState.lastFetchLeaderLogEndOffset(), currentReplicaState.lastFetchTimeMs(), currentReplicaState.lastCaughtUpTimeMs(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)brokerEpoch)), new ReplicationStateMetadata(replicationMode, replicationSessionId));
        });
    }

    public void resetReplicaState(long currentTimeMs, long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTimeMs;
            long l = lastCaughtUpTimeMs = isFollowerInSync ? currentTimeMs : 0L;
            if (isNewLeader) {
                return new ReplicaState(MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, MergedLog$.MODULE$.UnknownOffset(), 0L, lastCaughtUpTimeMs, (Option<Object>)Option$.MODULE$.empty(), ReplicationStateMetadata.INITIAL);
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, isFollowerInSync ? currentTimeMs : 0L, lastCaughtUpTimeMs, currentReplicaState.brokerEpoch(), ReplicationStateMetadata.INITIAL);
        });
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Reset state of replica to ").append(this).toString());
    }

    public void maybeResetLastCaughtUpTime(long currentTimeMs, long leaderEndOffset) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            if (currentReplicaState.logEndOffset() == currentReplicaState.lastFetchLeaderLogEndOffset() && currentReplicaState.logEndOffset() < leaderEndOffset && currentReplicaState.lastCaughtUpTimeMs() > 0L) {
                return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, package$.MODULE$.max(currentTimeMs, currentReplicaState.lastFetchTimeMs()), package$.MODULE$.max(currentTimeMs, currentReplicaState.lastCaughtUpTimeMs()), currentReplicaState.brokerEpoch(), currentReplicaState.replicationSessionState());
            }
            return currentReplicaState;
        });
    }

    public String toString() {
        ReplicaState replicaState = this.replicaState().get();
        scala.collection.mutable.StringBuilder replicaString = new scala.collection.mutable.StringBuilder();
        replicaString.append(new StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new StringBuilder(21).append(", lastCaughtUpTimeMs=").append(replicaState.lastCaughtUpTimeMs()).toString());
        replicaString.append(new StringBuilder(17).append(", logStartOffset=").append(replicaState.logStartOffset()).toString());
        replicaString.append(new StringBuilder(15).append(", logEndOffset=").append(replicaState.logEndOffsetMetadata().messageOffset).toString());
        replicaString.append(new StringBuilder(23).append(", logEndOffsetMetadata=").append(replicaState.logEndOffsetMetadata()).toString());
        replicaString.append(new StringBuilder(30).append(", lastFetchLeaderLogEndOffset=").append(replicaState.lastFetchLeaderLogEndOffset()).toString());
        replicaString.append(new StringBuilder(14).append(", brokerEpoch=").append(replicaState.brokerEpoch().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -2L)).toString());
        replicaString.append(new StringBuilder(26).append(", replicationSessionState=").append(replicaState.replicationSessionState()).toString());
        replicaString.append(new StringBuilder(18).append(", lastFetchTimeMs=").append(replicaState.lastFetchTimeMs()).toString());
        replicaString.append(")");
        return replicaString.toString();
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica replica = (Replica)that;
            if (this.brokerId() == replica.brokerId()) {
                TopicPartition topicPartition = this.topicPartition();
                TopicPartition topicPartition2 = replica.topicPartition();
                if (!(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition, MetadataCache metadataCache) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.metadataCache = metadataCache;
        this.replicaState = new AtomicReference<ReplicaState>(ReplicaState$.MODULE$.Empty());
    }
}

