/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0013&\u00011B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006}\u0001!Ia\u0010\u0005\b\u0007\u0002\u0001\r\u0011\"\u0003E\u0011\u001dA\u0005\u00011A\u0005\n%Caa\u0014\u0001!B\u0013)\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007Q\u0002\u0001\u000b\u0011\u0002*\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-DQa\u001c\u0001\u0005\u0002ECQ\u0001\u001d\u0001\u0005\u0002EDQ\u0001\u001e\u0001\u0005\u0002UD\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004\"CA<\u0001E\u0005I\u0011AA=\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u001e\u0002!\t!a#\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003K<q!a;&\u0011\u0003\tiO\u0002\u0004%K!\u0005\u0011q\u001e\u0005\u0007}\u0005\"\t!!=\t\u000f\u0005M\u0018\u0005\"\u0001\u0002v\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJT!AJ\u0014\u0002\u000b\u0005,H-\u001b;\u000b\u0005!J\u0013A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001i3\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\t\u0003i]j\u0011!\u000e\u0006\u0003m%\nQ!\u001e;jYNL!\u0001O\u001b\u0003\u000f1{wmZ5oO\u0006iQ.\u001a;sS\u000el\u0015M\\1hKJ\u0004\"a\u000f\u001f\u000e\u0003\u001dJ!!P\u0014\u00031\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0003\u0001\n\u0003\"!\u0011\u0001\u000e\u0003\u0015BQ!\u000f\u0002A\u0002i\nQA[8c\u0013\u0012,\u0012!\u0012\t\u0003]\u0019K!aR\u0018\u0003\u0007%sG/A\u0005k_\nLEm\u0018\u0013fcR\u0011!*\u0014\t\u0003]-K!\u0001T\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u0012\t\t\u00111\u0001F\u0003\rAH%M\u0001\u0007U>\u0014\u0017\n\u001a\u0011\u0002\u0015M\u001cwN]5oO6\u000b\u0007/F\u0001S!\u0011\u0019\u0006LW3\u000e\u0003QS!!\u0016,\u0002\u000f5,H/\u00192mK*\u0011qkL\u0001\u000bG>dG.Z2uS>t\u0017BA-U\u0005\u001dA\u0015m\u001d5NCB\u0004\"aW2\u000e\u0003qS!!\u00180\u0002\r\r|W.\\8o\u0015\tQsL\u0003\u0002aC\u00061\u0011\r]1dQ\u0016T\u0011AY\u0001\u0004_J<\u0017B\u00013]\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!\u00114\n\u0005\u001d,#aC(gMN,GoQ8v]R\f1b]2pe&tw-T1qA\u0005\u00012/Z4nK:$xJ\u001a4tKRl\u0015\r]\u000b\u0002WB\u0011\u0011\t\\\u0005\u0003[\u0016\u0012\u0001cU3h[\u0016tGo\u00144gg\u0016$X*\u00199\u0002#M,w-\\3oi>3gm]3u\u001b\u0006\u0004\b%A\u0007hKR\u001c6m\u001c:j]\u001el\u0015\r]\u0001\u0016O\u0016$H)\u001e:bE&d\u0017\u000e^=D_VtG/\u001a:t)\t)'\u000fC\u0003t\u0017\u0001\u0007!,\u0001\u0002jI\u0006)\"/\u001a9peR$UO]1cS2LG/\u001f'baN,Gc\u0003&wqv|\u0018qEA\u001e\u0003\u000bBQa\u001e\u0007A\u0002i\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003z\u0019\u0001\u0007!0A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bC\u0001\u0018|\u0013\taxF\u0001\u0003M_:<\u0007\"\u0002@\r\u0001\u0004Q\u0018!\u00037pgN\u001cu.\u001e8u\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007\t\u0011\u0002\\1qg\u0016$\u0016\u0010]3\u0011\t\u0005\u0015\u0011\u0011\u0005\b\u0005\u0003\u000f\tYB\u0004\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003+qA!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#Y\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\tA\u0013&C\u0002\u0002\u001a\u001d\nq\"\\1uKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0003;\ty\"A\nEkJ\f'-\u001b7jifd\u0015\r]:f)f\u0004XMC\u0002\u0002\u001a\u001dJA!a\t\u0002&\t\u0019B)\u001e:bE&d\u0017\u000e^=MCB\u001cX\rV=qK*!\u0011QDA\u0010\u0011\u001d\tI\u0003\u0004a\u0001\u0003W\t1!\\:h!\u0011\ti#!\u000e\u000f\t\u0005=\u0012\u0011\u0007\t\u0004\u0003\u001by\u0013bAA\u001a_\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\r0\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u007f\tQa]2pe\u0016\u00042ALA!\u0013\r\t\u0019e\f\u0002\b\u0005>|G.Z1o\u0011%\t9\u0005\u0004I\u0001\u0002\u0004\ty$A\bjg>sG)Z7b]\u0012\fU\u000fZ5u\u0003}\u0011X\r]8si\u0012+(/\u00192jY&$\u0018\u0010T1qg\u0016$C-\u001a4bk2$HeN\u000b\u0003\u0003\u001bRC!a\u0010\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\=\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nsKN,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u0002K\u0003KBQa\u001e\bA\u0002i\u000bQC]3q_J$H)\u001e:bE&d\u0017\u000e^=Bk\u0012LG\u000fF\u0005K\u0003W\ni'a\u001c\u0002t!)1i\u0004a\u0001\u000b\")qo\u0004a\u00015\"1\u0011\u0011O\bA\u0002i\f\u0001\u0002^8uC2l5o\u001a\u0005\t\u0003kz\u0001\u0013!a\u0001u\u0006QAo\u001c;bY2\u000b\u0007o]3\u0002?I,\u0007o\u001c:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u0012\"WMZ1vYR$C'\u0006\u0002\u0002|)\u001a!0a\u0014\u0002#U\u0004H-\u0019;f\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eF\u0003K\u0003\u0003\u000b)\tC\u0004\u0002\u0004F\u0001\r!a\u000b\u0002\u0013\t\u0014xn[3s'J\u001c\u0007BBAD#\u0001\u0007!0A\u0005uS6,7\u000b^1na\u0006i1\u000f^1si\u0006+H-\u001b;K_\n$\"!!$\u0011\t\u0005=\u0015\u0011T\u0007\u0003\u0003#SA!a%\u0002\u0016\u0006!A/[7f\u0015\t\t9*\u0001\u0003kCZ\f\u0017\u0002BAN\u0003#\u0013q!\u00138ti\u0006tG/A\fti\u0006\u0014H/Q;eSR\u001cu.\u001c9bGRLwN\u001c&pE\u0006\u0011\u0012\r\u001a3US\u0016\u0014\u0018)\u001e3ji\u0016\u0013(o\u001c:t)\rQ\u00151\u0015\u0005\u0007\u0003K#\u0002\u0019\u0001>\u0002\u000b\r|WO\u001c;\u0002;\u0005$G\rV5fe\u0006+H-\u001b;V].twn\u001e8Fq\u000e,\u0007\u000f^5p]N$2ASAV\u0011\u0019\t)+\u0006a\u0001u\u0006Y\u0012\r\u001a3US\u0016\u0014\u0018)\u001e3jiJ+GO]=Fq\u000e,\u0007\u000f^5p]N$2ASAY\u0011\u0019\t)K\u0006a\u0001u\u0006a\u0012\r\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7k[5qa\u0016$Gc\u0001&\u00028\"1\u0011QU\fA\u0002i\f!&\u00193e\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|g\u000eR1uCZ\u000bG.\u001b3bi&|gnU6jaB,G\rF\u0002K\u0003{Ca!!*\u0019\u0001\u0004Q\u0018AI1eI\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c#bi\u00064\u0016\r\\5eCR,G\rF\u0002K\u0003\u0007Da!!*\u001a\u0001\u0004Q\u0018AF1eIRKWM]*fO6,g\u000e^:Bk\u0012LG/\u001a3\u0015\u0007)\u000bI\r\u0003\u0004\u0002&j\u0001\rA_\u0001\u001aC\u0012$7i\\7qC\u000e$X\r\u001a)beRLG/[8o\u0013\u0012dW\rF\u0002K\u0003\u001fDa!!*\u001c\u0001\u0004Q\u0018\u0001H1eI\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\!vI&$X\r\u001a\u000b\u0004\u0015\u0006U\u0007BBAS9\u0001\u0007!0A\tva\u0012\fG/Z!vI&$HIY*ju\u0016$2ASAn\u0011\u0019\ti.\ba\u0001u\u0006!1/\u001b>f\u0003E\u0011Xm]3u\u0003V$\u0017\u000e^'fiJL7m\u001d\u000b\u0002\u0015\u0006A!/Z:fi*{'\rF\u0002F\u0003ODa!!; \u0001\u0004)\u0015\u0001\u00038fo*{'-\u00133\u0002\u001b\u0005+H-\u001b;SKB|'\u000f^3s!\t\t\u0015e\u0005\u0002\"[Q\u0011\u0011Q^\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0001\u0006]\b\"B\u001d$\u0001\u0004Q\u0004")
public class AuditReporter
implements Logging {
    private final DurabilityMetricsManager metricManager;
    private int jobId;
    private final HashMap<TopicPartition, OffsetCount> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static AuditReporter apply(DurabilityMetricsManager metricManager) {
        return new AuditReporter(metricManager);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, OffsetCount> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    public HashMap<TopicPartition, OffsetCount> getScoringMap() {
        return this.scoringMap();
    }

    public OffsetCount getDurabilityCounters(TopicPartition id) {
        return (OffsetCount)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable)() -> new OffsetCount(0L, 0L));
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapseType, String msg, boolean score, boolean isOnDemandAudit) {
        void var15_13;
        void var14_12;
        String customerFacing = score ? "Customer impacting" : "Non Customer impacting";
        String lapseMsg = new StringBuilder(13).append(customerFacing).append(" ").append(msg).append("\n").append("lapseType: ").append(lapseType).toString();
        Enumeration.Value value = lapseType;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            }
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var14_12 != false) {
            if (score) {
                this.error((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            }
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            }
        }
        if (var15_13 != false) {
            if (var14_12 == false) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Duplicate ").append(lapseMsg).toString());
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
                    this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(offsetCount.total(), offsetCount.loss() + lossCount));
                    return;
                }
                this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(0L, lossCount));
                return;
            }
            return;
        }
    }

    public boolean reportDurabilityLapse$default$7() {
        return false;
    }

    public void resetTopicPartition(TopicPartition topicPartition) {
        if (this.scoringMap().contains((Object)topicPartition)) {
            this.scoringMap().remove((Object)topicPartition);
        }
        this.segmentOffsetMap().remove(topicPartition);
    }

    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, offsetCount.loss() + totalLapse));
            l = offsetCount.loss() + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Instant startAuditJob() {
        return this.metricManager.startAuditJob();
    }

    public Instant startAuditCompactionJob() {
        return this.metricManager.startAuditCompactionJob();
    }

    public void addTierAuditErrors(long count) {
        this.metricManager.addTierAuditError(count);
    }

    public void addTierAuditUnknownExceptions(long count) {
        this.metricManager.addTierAuditUnknownExceptions(count);
    }

    public void addTierAuditRetryExceptions(long count) {
        this.metricManager.addTierAuditRetryExceptions(count);
    }

    public void addCompactedPartitionSkipped(long count) {
        this.metricManager.addCompactedPartitionSkipped(count);
    }

    public void addCompactedPartitionDataValidationSkipped(long count) {
        this.metricManager.addCompactedPartitionDataValidationSkipped(count);
    }

    public void addCompactedPartitionDataValidated(long count) {
        this.metricManager.addCompactedPartitionDataValidated(count);
    }

    public void addTierSegmentsAudited(long count) {
        this.metricManager.addTierSegmentsAudited(count);
    }

    public void addCompactedPartitionIdle(long count) {
        this.metricManager.addCompactedPartitionIdle(count);
    }

    public void addCompactedPartitionAudited(long count) {
        this.metricManager.addCompactedPartitionAudited(count);
    }

    public void updateAuditDbSize(long size) {
        this.metricManager.updateDurabilityAuditDbSize(size);
    }

    public void resetAuditMetrics() {
        this.metricManager.resetAuditMetrics();
    }

    public int resetJob(int newJobId) {
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return old;
    }

    public AuditReporter(DurabilityMetricsManager metricManager) {
        this.metricManager = metricManager;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

