/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.KafkaConfig;
import kafka.server.PerNodeQueue;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t]c!B\u0014)\u0003\u0003i\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011\u0015i\u0007\u0001\"\u0001o\u0011%\t)\u0001\u0001b\u0001\n\u0003\t9\u0001\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0005\u0011%\tI\u0003\u0001b\u0001\n\u0003\tY\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0017\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%\t!a\u000e\t\u0017\u0005%\u0003\u00011AA\u0002\u0013\u0005\u00111\n\u0005\f\u0003/\u0002\u0001\u0019!A!B\u0013\tI\u0004C\u0005\u0002b\u0001\u0001\r\u0011\"\u0001\u0002d!I\u00111\u000e\u0001A\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003c\u0002\u0001\u0015)\u0003\u0002f!I\u0011Q\u000f\u0001C\u0002\u0013\u0005\u0011q\u000f\u0005\b\u0003s\u0002\u0001\u0015!\u0003a\u0011%\tY\b\u0001b\u0001\n\u0003\t9\bC\u0004\u0002~\u0001\u0001\u000b\u0011\u00021\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\u0005\u0005\u0002CAE\u0001\u0001\u0006I!a!\t\u0013\u0005-\u0005A1A\u0005\u0002\u0005\u0005\u0005\u0002CAG\u0001\u0001\u0006I!a!\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005\u0005\u0005\u0002CAI\u0001\u0001\u0006I!a!\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!5\u0001\t\u0003\tI\u000eC\u0004\u0002h\u0002!I!!;\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!1\u0002\u0001\u0007\u0002\t5\u0001b\u0002B\u001c\u0001\u0019\u0005!\u0011\b\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003\u0012Q#\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e+ie\u0016\fGM\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001+\tq#oE\u0002\u0001_m\u0002\"\u0001M\u001d\u000e\u0003ER!AM\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0003SQR!aK\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uE\u0012Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\r\u0005\u0002=\u007f5\tQH\u0003\u0002?U\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u00111\tR\u0007\u0002Q%\u0011Q\t\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004nKR\u0014\u0018nY:\u0011\u0005!cU\"A%\u000b\u0005\u0019S%BA&5\u0003\u0019\u0019w.\\7p]&\u0011Q*\u0013\u0002\b\u001b\u0016$(/[2t\u00039yf.\u001a;x_J\\7\t\\5f]R\u0004\"\u0001U*\u000e\u0003ES!A\u0015\u001b\u0002\u000f\rd\u0017.\u001a8ug&\u0011A+\u0015\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002\u001d-\fgm[1TG\",G-\u001e7feB\u0011\u0001gV\u0005\u00031F\u0012abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0003uS6,\u0007CA.^\u001b\u0005a&B\u0001 K\u0013\tqFL\u0001\u0003US6,\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016\u0004\"!\u00196\u000f\u0005\tD\u0007CA2g\u001b\u0005!'BA3-\u0003\u0019a$o\\8u})\tq-A\u0003tG\u0006d\u0017-\u0003\u0002jM\u00061\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIg-\u0001\u0004=S:LGO\u0010\u000b\n_rlhp`A\u0001\u0003\u0007\u00012a\u0011\u0001q!\t\t(\u000f\u0004\u0001\u0005\u000bM\u0004!\u0019\u0001;\u0003\u0003Q\u000b\"!^=\u0011\u0005Y<X\"\u00014\n\u0005a4'a\u0002(pi\"Lgn\u001a\t\u0003mjL!a\u001f4\u0003\u0007\u0005s\u0017\u0010C\u0003B\u000f\u0001\u0007!\tC\u0003G\u000f\u0001\u0007q\tC\u0003O\u000f\u0001\u0007q\nC\u0003V\u000f\u0001\u0007a\u000bC\u0003Z\u000f\u0001\u0007!\fC\u0003`\u000f\u0001\u0007\u0001-\u0001\u0007rk\u0016,X\rU3s\u001d>$W-\u0006\u0002\u0002\nAA\u00111BA\u000b\u00033\t\t#\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003'1\u0017AC2pY2,7\r^5p]&!\u0011qCA\u0007\u0005\ri\u0015\r\u001d\t\u0005\u00037\ti\"D\u0001K\u0013\r\tyB\u0013\u0002\u0005\u001d>$W\r\u0005\u0003D\u0003G\u0001\u0018bAA\u0013Q\ta\u0001+\u001a:O_\u0012,\u0017+^3vK\u0006i\u0011/^3vKB+'OT8eK\u0002\n\u0001C]3rk\u0016\u001cH\u000fV5nK>,H/T:\u0016\u0005\u00055\u0002c\u0001<\u00020%\u0019\u0011\u0011\u00074\u0003\u0007%sG/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\n\u0001#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0006cV|G/\u0019\u0006\u0004\u0003\u0007R\u0013aC2p_J$\u0017N\\1u_JLA!a\u0012\u0002>\t\u0001\u0012+^8uC\u000e{wN\u001d3j]\u0006$xN]\u0001\u0015cV|G/Y\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u00055\u00131\u000b\t\u0004m\u0006=\u0013bAA)M\n!QK\\5u\u0011%\t)&DA\u0001\u0002\u0004\tI$A\u0002yIE\n\u0011#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:!Q\rq\u00111\f\t\u0004m\u0006u\u0013bAA0M\nAao\u001c7bi&dW-A\u0004ti\u0006\u0014H/\u001a3\u0016\u0005\u0005\u0015\u0004c\u0001<\u0002h%\u0019\u0011\u0011\u000e4\u0003\u000f\t{w\u000e\\3b]\u0006Y1\u000f^1si\u0016$w\fJ3r)\u0011\ti%a\u001c\t\u0013\u0005U\u0003#!AA\u0002\u0005\u0015\u0014\u0001C:uCJ$X\r\u001a\u0011)\u0007E\tY&\u0001\nsKF,Xm\u001d;OC6,gj\\*qC\u000e,W#\u00011\u0002'I,\u0017/^3ti:\u000bW.\u001a(p'B\f7-\u001a\u0011\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003Eqw\u000eZ3M_>\\W\u000f\u001d$bS2,(/Z\u000b\u0003\u0003\u0007\u00032\u0001SAC\u0013\r\t9)\u0013\u0002\u0007'\u0016t7o\u001c:\u0002%9|G-\u001a'p_.,\bOR1jYV\u0014X\rI\u0001\u000beB\u001cg)Y5mkJ,\u0017a\u0003:qG\u001a\u000b\u0017\u000e\\;sK\u0002\n\u0001B\u001d9d%\u0016$(/_\u0001\neB\u001c'+\u001a;ss\u0002\nQa\u001d;beR$B!!\u0014\u0002\u0018\"9\u00111\t\u000fA\u0002\u0005e\u0012\u0001C:ikR$wn\u001e8\u0015\u0005\u00055\u0013\u0001C:dQ\u0016$W\u000f\\3\u0015\u0011\u00055\u0013\u0011UAS\u0003_Ca!a)\u001f\u0001\u0004\u0001\u0017\u0001\u00028b[\u0016Dq!a*\u001f\u0001\u0004\tI+A\u0002gk:\u0004RA^AV\u0003\u001bJ1!!,g\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u00022z\u0001\r!a-\u0002\u0011A,'/[8e\u001bN\u00042A^A[\u0013\r\t9L\u001a\u0002\u0005\u0019>tw-\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011Q\u0018\t\u0007\u0003\u007f\u000b9-a3\u000e\u0005\u0005\u0005'b\u0001\u001a\u0002D*\u0011\u0011QY\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0006\u0005'AC\"pY2,7\r^5p]B\u0019\u0001'!4\n\u0007\u0005=\u0017GA\u000eSKF,Xm\u001d;B]\u0012\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM]\u0001\u0010C\u0012$WI\u001c;ss\u001a{'OT8eKR!\u0011QJAk\u0011\u0019\t9\u000e\ta\u0001a\u0006)QM\u001c;ssR1\u0011QJAn\u0003;Da!a6\"\u0001\u0004\u0001\bbBApC\u0001\u0007\u0011\u0011]\u0001\u0005]>$W\rE\u0003w\u0003G\fI\"C\u0002\u0002f\u001a\u0014aa\u00149uS>t\u0017A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0007\u0003W\f90!?\u0015\t\u00055\u0013Q\u001e\u0005\b\u0003_\u0014\u0003\u0019AAy\u0003!\u0011Xm\u001d9p]N,\u0007c\u0001)\u0002t&\u0019\u0011Q_)\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\"9\u00111\t\u0012A\u0002\u0005e\u0001bBA~E\u0001\u0007\u0011Q`\u0001\bK:$(/[3t!\u0015\ty,a@q\u0013\u0011\u0011\t!!1\u0003\u0013\u0005\u0013(/Y=MSN$\u0018!\u0004:fiJLhi\u001c:F]R\u0014\u0018\u0010\u0006\u0004\u0002N\t\u001d!\u0011\u0002\u0005\b\u0003w\u001c\u0003\u0019AA\u007f\u0011\u001d\tyn\ta\u0001\u0003C\fQb\u0019:fCR,'+Z9vKN$HC\u0002B\b\u0005g\u0011)\u0004\r\u0003\u0003\u0012\t\u001d\u0002C\u0002B\n\u0005?\u0011)C\u0004\u0003\u0003\u0016\tmQB\u0001B\f\u0015\r\u0011IBS\u0001\te\u0016\fX/Z:ug&!!Q\u0004B\f\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002\u0002B\u0011\u0005G\u0011qAQ;jY\u0012,'O\u0003\u0003\u0003\u001e\t]\u0001cA9\u0003(\u0011Y!\u0011\u0006\u0013\u0002\u0002\u0003\u0005)\u0011\u0001B\u0016\u0005\ryF%M\t\u0004k\n5\u0002\u0003\u0002B\u000b\u0005_IAA!\r\u0003\u0018\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002`\u0012\u0002\r!!\u0007\t\u000f\u0005mH\u00051\u0001\u0002~\u00069q-\u001a;O_\u0012,GCBAq\u0005w\u0011i\u0004\u0003\u0004\u0002X\u0016\u0002\r\u0001\u001d\u0005\n\u0003?,\u0003\u0013!a\u0001\u0003C\f\u0011cZ3u\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019E\u000b\u0003\u0002b\n\u00153F\u0001B$!\u0011\u0011IEa\u0015\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEc-\u0001\u0006b]:|G/\u0019;j_:LAA!\u0016\u0003L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class AbstractRequestThread<T>
extends InterBrokerSendThread
implements Logging {
    private final Metrics metrics;
    private final KafkaScheduler kafkaScheduler;
    private final Time time;
    private final String requestName;
    private final Map<Node, PerNodeQueue<T>> queuePerNode;
    private final int requestTimeoutMs;
    private volatile QuotaCoordinator quotaCoordinator;
    private volatile boolean started;
    private final String requestNameNoSpace;
    private final String metricsGroup;
    private final Sensor nodeLookupFailure;
    private final Sensor rpcFailure;
    private final Sensor rpcRetry;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<Node, PerNodeQueue<T>> queuePerNode() {
        return this.queuePerNode;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public boolean started() {
        return this.started;
    }

    public void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public String requestNameNoSpace() {
        return this.requestNameNoSpace;
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public Sensor nodeLookupFailure() {
        return this.nodeLookupFailure;
    }

    public Sensor rpcFailure() {
        return this.rpcFailure;
    }

    public Sensor rpcRetry() {
        return this.rpcRetry;
    }

    public void start(QuotaCoordinator coordinator) {
        super.start();
        this.quotaCoordinator_$eq(coordinator);
        this.started_$eq(true);
    }

    public void shutdown() {
        super.shutdown();
        this.queuePerNode().clear();
        this.metrics.removeSensor(this.nodeLookupFailure().name());
        this.metrics.removeSensor(this.rpcFailure().name());
        this.metrics.removeSensor(this.rpcRetry().name());
        this.quotaCoordinator_$eq(null);
        this.started_$eq(false);
    }

    public void schedule(String name, Function0<BoxedUnit> fun, long periodMs) {
        this.kafkaScheduler.schedule(name, () -> fun.apply$mcV$sp(), 0L, periodMs);
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)this.queuePerNode().values().map((Function1 & Serializable)queue -> {
            ArrayList entryData = new ArrayList();
            queue.queue().drainTo(entryData);
            return new Tuple2((Object)queue.destination(), entryData);
        })).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractRequestThread.$anonfun$generateRequests$2(x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Node node = (Node)x0$2._1();
                ArrayList entries = (ArrayList)x0$2._2();
                return new RequestAndCompletionHandler(currentTimeMs, node, this.createRequest(node, entries), request -> this.handleResponse(node, entries, request));
            }
            throw new MatchError(null);
        })).asJavaCollection();
    }

    public void addEntryForNode(T entry) {
        this.addEntryForNode(entry, (Option<Node>)None$.MODULE$);
    }

    public void addEntryForNode(T entry, Option<Node> node) {
        if (this.started()) {
            Option<Node> option = this.getNode(entry, node);
            if (option instanceof Some) {
                Object object;
                Node node2 = (Node)((Some)option).value();
                Map<Node, PerNodeQueue<T>> atomicGetOrUpdate_map = this.queuePerNode();
                Option option2 = atomicGetOrUpdate_map.get((Object)node2);
                if (option2 instanceof Some) {
                    object = ((Some)option2).value();
                } else if (None$.MODULE$.equals(option2)) {
                    PerNodeQueue atomicGetOrUpdate_value = new PerNodeQueue(node2);
                    object = atomicGetOrUpdate_map.putIfAbsent((Object)node2, atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option2);
                }
                Object var5_5 = null;
                option2 = null;
                Object var7_7 = null;
                ((PerNodeQueue)object).addEntry(entry);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append($this.requestName).append(" Request's destination node is unavailable, skipping ").append($this.requestName).append(" for entry ").append(entry).append(".").toString());
                this.nodeLookupFailure().record();
                return;
            }
            throw new MatchError(option);
        }
    }

    private void handleResponse(Node coordinator, ArrayList<T> entries, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append($this.requestName).append(" Request ").append(entries).append(" failed due to authentication error with coordinator").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> response.authenticationException());
            this.rpcFailure().record();
            return;
        }
        if (response.wasDisconnected()) {
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_COORDINATOR)) {
            this.networkClient.disconnect(coordinator.idString());
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        BooleanRef rpcFailed = BooleanRef.create((boolean)false);
        response.responseBody().errorCounts().keySet().forEach(error -> {
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                rpcFailed$1.elem = true;
                return;
            }
        });
        if (rpcFailed.elem) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append($this.requestName).append(" Request failed with Response ").append(response).toString());
            this.rpcFailure().record();
            return;
        }
    }

    private void retryForEntry(ArrayList<T> entries, Option<Node> node) {
        entries.forEach(entry -> this.addEntryForNode(entry, node));
        this.rpcRetry().record();
    }

    public abstract AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node var1, ArrayList<T> var2);

    public abstract Option<Node> getNode(T var1, Option<Node> var2);

    public Option<Node> getNode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            Node node = (Node)x0$1._1();
            return !((ArrayList)x0$1._2()).isEmpty() && !node.isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ PerNodeQueue $anonfun$addEntryForNode$1(Node node$2) {
        return new PerNodeQueue(node$2);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractRequestThread(KafkaConfig config, Metrics metrics, NetworkClient _networkClient, KafkaScheduler kafkaScheduler, Time time, String requestName) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        void add_stat3;
        void add_metricName3;
        this.metrics = metrics;
        this.kafkaScheduler = kafkaScheduler;
        this.time = time;
        this.requestName = requestName;
        super(new StringBuilder(25).append("DynamicQuotaSenderThread-").append(config.brokerId()).toString(), (KafkaClient)_networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time);
        this.logIdent_$eq(new StringBuilder(34).append("[Dynamic Quota Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.queuePerNode = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.requestTimeoutMs = 30000;
        this.started = false;
        this.requestNameNoSpace = requestName.replace(" ", "-");
        this.metricsGroup = new StringBuilder(8).append(this.requestNameNoSpace().toLowerCase()).append("-metrics").toString();
        this.nodeLookupFailure = metrics.sensor(new StringBuilder(17).append(this.requestNameNoSpace()).append("NodeLookupFailure").toString());
        Sensor sensor = this.nodeLookupFailure();
        Rate rate = new Rate();
        MetricName metricName = metrics.metricName("node-lookup-failure", this.metricsGroup(), "The rate of node lookup failure");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName3, (MeasurableStat)add_stat3, null);
        metricName = null;
        rate = null;
        this.rpcFailure = metrics.sensor(new StringBuilder(10).append(this.requestNameNoSpace()).append("RPCFailure").toString());
        Sensor sensor2 = this.rpcFailure();
        Rate rate2 = new Rate();
        MetricName metricName2 = metrics.metricName("rpc-failure", this.metricsGroup(), new StringBuilder(24).append("The rate of ").append(requestName).append(" RPC failure").toString());
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName2 = null;
        rate2 = null;
        this.rpcRetry = metrics.sensor(new StringBuilder(8).append(this.requestNameNoSpace()).append("RPCRetry").toString());
        Sensor sensor3 = this.rpcRetry();
        Rate rate3 = new Rate();
        MetricName metricName3 = metrics.metricName("rpc-retry", this.metricsGroup(), new StringBuilder(22).append("The rate of ").append(requestName).append(" RPC retry").toString());
        if (sensor3 == null) {
            throw null;
        }
        sensor3.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

