/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import kafka.cluster.Partition;
import kafka.log.MergedLog$;
import kafka.server.DelayedOperation;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchPartitionStats;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0007\u000f\u0001MA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\u0006a\u0002!\t!\u001d\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t)\u0001\u0001C!\u0003\u0007\u0011!\u0003R3mCf,GMU3n_R,g)\u001a;dQ*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fqB]3n_R,g)\u001a;dQR\u000b7o\u001b\t\u00045\u0005\u001aS\"A\u000e\u000b\u0005qi\u0012AC2p]\u000e,(O]3oi*\u0011adH\u0001\u0005kRLGNC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tZ\"A\u0002$viV\u0014X\r\u0005\u0002%O5\tQE\u0003\u0002'?\u0005!A.\u00198h\u0013\tASE\u0001\u0003W_&$\u0017!\u0005:f[>$XMR3uG\"\u0014Vm];miB\u0019!dK\u0017\n\u00051Z\"!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0011aFO\u0007\u0002_)\u0011\u0001'M\u0001\u0004Y><'B\u0001\u001a4\u0003%Ig\u000e^3s]\u0006d7O\u0003\u00025k\u000591\u000f^8sC\u001e,'BA\t7\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\n\u0005mz#a\u0005*f[>$X\rT8h%\u0016\fGMU3tk2$\u0018a\u0004:f[>$XMR3uG\"LeNZ8\u0011\u00059r\u0014BA 0\u0005Y\u0011V-\\8uKN#xN]1hK\u001a+Go\u00195J]\u001a|\u0017\u0001\u00064fi\u000eD\u0007+\u0019:uSRLwN\\*uCR,8\u000fE\u0002C\u000f&k\u0011a\u0011\u0006\u0003\t\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%D\u0005\r\u0019V-\u001d\t\u0005\u0015.k5+D\u0001F\u0013\taUI\u0001\u0004UkBdWM\r\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!V\naaY8n[>t\u0017B\u0001*P\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0016)&\u0011QK\u0004\u0002\u0015\r\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0002\u0017\u0019,Go\u00195QCJ\fWn\u001d\t\u0003]aK!!W\u0018\u0003\u0017\u0019+Go\u00195QCJ\fWn]\u0001\u0011Y>\u001c\u0017\r\u001c*fC\u0012\u0014Vm];miN\u00042AQ$]!\u0011Q5*T/\u0011\u0005Uq\u0016BA0\u000f\u00055aun\u001a*fC\u0012\u0014Vm];mi\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\u000bc\u0013\t\u0019gB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002&gQ6L!aZ#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001\"HSB!!jS'k!\tq3.\u0003\u0002m_\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\tQe.\u0003\u0002p\u000b\n!QK\\5u\u0003\u0019a\u0014N\\5u}QI!o\u001d;vm^D\u0018P\u001f\t\u0003+\u0001AQ\u0001G\u0005A\u0002eAQ!K\u0005A\u0002)BQ\u0001P\u0005A\u0002uBQ\u0001Q\u0005A\u0002\u0005CQAV\u0005A\u0002]CQAW\u0005A\u0002mCQ\u0001Y\u0005A\u0002\u0005DQ\u0001Z\u0005A\u0002\u0015\f1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\tQ\u0010\u0005\u0002K}&\u0011q0\u0012\u0002\b\u0005>|G.Z1o\u00031yg.\u0012=qSJ\fG/[8o)\u0005i\u0017AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedRemoteFetch
extends DelayedOperation {
    private final Future<Void> remoteFetchTask;
    private final CompletableFuture<RemoteLogReadResult> remoteFetchResult;
    private final RemoteStorageFetchInfo remoteFetchInfo;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final FetchParams fetchParams;
    private final Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults;
    private final ReplicaManager replicaManager;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            this.fetchPartitionStatus.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Partition partition;
                    TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
                    LogOffsetMetadata logOffsetMetadata = ((FetchPartitionStatus)x0$1._2()).startOffsetMetadata();
                    try {
                        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                        if (!(logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2))) {
                            return BoxedUnit.UNIT;
                        }
                        partition = $this.replicaManager.getPartitionOrException(topicPartition.topicPartition());
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Partition ").append(topicPartition).append(" is in an offline log directory, satisfy ").append($this.fetchParams).append(" immediately").toString());
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicPartition).append(", satisfy ").append($this.fetchParams).append(" immediately").toString());
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Broker is no longer the leader or follower of %s, satisfy %s immediately"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchParams})));
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    return partition;
                }
                throw new MatchError(null);
            });
            if (!this.remoteFetchResult.isDone()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (!this.remoteFetchTask.cancel(true)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(98).append("Remote fetch task for for RemoteStorageFetchInfo: ").append($this.remoteFetchInfo).append(" could not be cancelled and its isDone value is ").append($this.remoteFetchTask.isDone()).toString());
            return;
        }
    }

    @Override
    public void onComplete() {
        Seq fetchPartitionData = (Seq)this.localReadResults.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                LogReadResult result = (LogReadResult)x0$1._2();
                if (tp.topicPartition().equals((Object)$this.remoteFetchInfo.topicPartition) && $this.remoteFetchResult.isDone()) {
                    Errors errors = result.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && result.info().delayedRemoteStorageFetch.isPresent()) {
                        if ($this.remoteFetchResult.get().error.isPresent()) {
                            FetchDataInfo x$1 = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
                            None$ x$2 = None$.MODULE$;
                            long x$3 = MergedLog$.MODULE$.UnknownOffset();
                            long x$4 = MergedLog$.MODULE$.UnknownOffset();
                            long x$5 = MergedLog$.MODULE$.UnknownOffset();
                            long x$6 = MergedLog$.MODULE$.UnknownOffset();
                            None$ x$8 = None$.MODULE$;
                            Some x$11 = new Some($this.remoteFetchResult.get().error.get());
                            None$ x$12 = None$.MODULE$;
                            long x$13 = 0L;
                            LogReadResult qual$1 = new LogReadResult(x$1, (Option<FetchResponseData.EpochEndOffset>)x$2, x$3, x$4, x$5, x$6, -1L, (Option<Object>)x$8, false, false, (Option<Object>)x$12, (Option<Throwable>)x$11, x$13);
                            long x$15 = qual$1.toFetchPartitionData$default$2();
                            long x$16 = qual$1.toFetchPartitionData$default$3();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)qual$1.toFetchPartitionData(false, x$15, x$16));
                        }
                        FetchDataInfo info = (FetchDataInfo)$this.remoteFetchResult.get().fetchDataInfo.get();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), info.records, Optional.empty(), result.lastStableOffset().isDefined() ? OptionalLong.of(BoxesRunTime.unboxToLong((Object)result.lastStableOffset().get())) : OptionalLong.empty(), info.abortedTransactions, result.preferredReadReplica().isDefined() ? OptionalInt.of(BoxesRunTime.unboxToInt((Object)result.preferredReadReplica().get())) : OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L)));
                    }
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(false, result.toFetchPartitionData$default$2(), result.toFetchPartitionData$default$3()));
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public DelayedRemoteFetch(Future<Void> remoteFetchTask, CompletableFuture<RemoteLogReadResult> remoteFetchResult, RemoteStorageFetchInfo remoteFetchInfo, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, FetchParams fetchParams, Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults, ReplicaManager replicaManager, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.remoteFetchTask = remoteFetchTask;
        this.remoteFetchResult = remoteFetchResult;
        this.remoteFetchInfo = remoteFetchInfo;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.fetchParams = fetchParams;
        this.localReadResults = localReadResults;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(fetchParams.maxWaitMs, (Option<Lock>)None$.MODULE$);
    }
}

