/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerChannelManager;
import kafka.server.NodeToControllerQueueItem;
import kafka.server.NodeToControllerRequestThread;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\f\u0018\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011U\u0003!\u0011!Q\u0001\nYCQ!\u0017\u0001\u0005\u0002iCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\t\b\u0001)A\u0005W\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB<\u0001A\u0003%A\u000fC\u0004y\u0001\t\u0007I\u0011B=\t\ru\u0004\u0001\u0015!\u0003{\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u0019\t9\u0001\u0001C\u0001\u007f\"9\u0011\u0011\u0002\u0001\u0005\u0002]I\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0013\u0002A\u0011AA&\u0005\tru\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/S7qY*\u0011\u0001$G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001;\r:\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%K5\tq#\u0003\u0002'/\tqbj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003Ue\tQ!\u001e;jYNL!\u0001L\u0015\u0003\u000f1{wmZ5oO\u000612m\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'\u000f\u0005\u0002%_%\u0011\u0001g\u0006\u0002\u0017\u0007>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3fe\u0006!A/[7f!\t\u0019D(D\u00015\u0015\tQSG\u0003\u00027o\u000511m\\7n_:T!A\u0007\u001d\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0005\u0003{Q\u0012A\u0001V5nK\u00069Q.\u001a;sS\u000e\u001c\bC\u0001!C\u001b\u0005\t%B\u0001 6\u0013\t\u0019\u0015IA\u0004NKR\u0014\u0018nY:\u0002\r\r|gNZ5h!\t!c)\u0003\u0002H/\tY1*\u00194lC\u000e{gNZ5h\u0003-\u0019\u0007.\u00198oK2t\u0015-\\3\u0011\u0005)\u000bfBA&P!\tau$D\u0001N\u0015\tq5$\u0001\u0004=e>|GOP\u0005\u0003!~\ta\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001kH\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\faB]3uef$\u0016.\\3pkRl5\u000f\u0005\u0002\u001f/&\u0011\u0001l\b\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\t7rkfl\u00181bEB\u0011A\u0005\u0001\u0005\u0006[!\u0001\rA\f\u0005\u0006c!\u0001\rA\r\u0005\u0006}!\u0001\ra\u0010\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006)\"\u0001\r!\u0013\u0005\u0006+\"\u0001\rAV\u0001\u000bY><7i\u001c8uKb$X#A3\u0011\u0005M2\u0017BA45\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%A\u000bnC:,\u0018\r\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\\\u001c\u0002\u000f\rd\u0017.\u001a8ug&\u0011\u0001/\u001c\u0002\u0016\u001b\u0006tW/\u00197NKR\fG-\u0019;b+B$\u0017\r^3s\u0003Yi\u0017M\\;bY6+G/\u00193bi\u0006,\u0006\u000fZ1uKJ\u0004\u0013aC1qSZ+'o]5p]N,\u0012\u0001\u001e\t\u0003YVL!A^7\u0003\u0017\u0005\u0003\u0018NV3sg&|gn]\u0001\rCBLg+\u001a:tS>t7\u000fI\u0001\u000ee\u0016\fX/Z:u)\"\u0014X-\u00193\u0016\u0003i\u0004\"\u0001J>\n\u0005q<\"!\b(pI\u0016$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u)\"\u0014X-\u00193\u0002\u001dI,\u0017/^3tiRC'/Z1eA\u0005)1\u000f^1siR\u0011\u0011\u0011\u0001\t\u0004=\u0005\r\u0011bAA\u0003?\t!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017\u0001\u00058foJ+\u0017/^3tiRC'/Z1e\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\r\u0005\u0005\u0011qBA \u0011\u001d\t\t\u0002\u0006a\u0001\u0003'\tqA]3rk\u0016\u001cH\u000f\r\u0003\u0002\u0016\u00055\u0002CBA\f\u0003G\tIC\u0004\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\"N\u0001\te\u0016\fX/Z:ug&!\u0011\u0011EA\u000e\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002BA\u0013\u0003O\u0011qAQ;jY\u0012,'O\u0003\u0003\u0002\"\u0005m\u0001\u0003BA\u0016\u0003[a\u0001\u0001\u0002\u0007\u00020\u0005=\u0011\u0011!A\u0001\u0006\u0003\t\tDA\u0002`II\nB!a\r\u0002:A\u0019a$!\u000e\n\u0007\u0005]rDA\u0004O_RD\u0017N\\4\u0011\t\u0005e\u00111H\u0005\u0005\u0003{\tYBA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001d\t\t\u0005\u0006a\u0001\u0003\u0007\n\u0001bY1mY\n\f7m\u001b\t\u0004I\u0005\u0015\u0013bAA$/\t\u00113i\u001c8ue>dG.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\fQcY8oiJ|G\u000e\\3s\u0003BLg+\u001a:tS>t7\u000f\u0006\u0002\u0002NA)a$a\u0014\u0002T%\u0019\u0011\u0011K\u0010\u0003\r=\u0003H/[8o!\ra\u0017QK\u0005\u0004\u0003/j'a\u0004(pI\u0016\f\u0005/\u001b,feNLwN\\:")
public class NodeToControllerChannelManagerImpl
implements NodeToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final String threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final NodeToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private NodeToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    @Override
    public void start() {
        this.requestThread().start();
    }

    @Override
    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Node to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public NodeToControllerRequestThread newRequestThread() {
        String threadName = new StringBuilder(30).append(this.threadNamePrefix).append("to-controller-").append(this.channelName).append("-channel-manager").toString();
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new NodeToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), controllerInformation.isZkController(), (Function1<ControllerInformation, KafkaClient>)(Function1 & Serializable)controllerInfo -> this.buildNetworkClient$1((ControllerInformation)controllerInfo), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, threadName, this.retryTimeoutMs);
    }

    @Override
    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())));
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext(), null, null);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext());
    }

    public NodeToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, String threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        this.logContext = new LogContext(new StringBuilder(43).append("[NodeToControllerChannelManager id=").append(config.nodeId()).append(" name=").append(channelName).append("] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

