/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kafka.server.KRaftCachedControllerId;
import kafka.server.MetadataCache;
import kafka.server.ZkCachedControllerId;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.MirrorTopicRequestHelperKraft$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rug\u0001\u0002!B\t!C\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011)\t\u0019\u0001\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!a\n\t\u0015\u00055\u0002A!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003{Aq!!\u0013\u0001\t\u0003\tY\u0005C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002r!A\u00111\u0010\u0001!\u0002\u0013\t\u0019\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011q\u001f\u0001\u0005\n\u0005e\bb\u0002B\u000e\u0001\u0011%!Q\u0004\u0004\u0007\u0005W\u0001AA!\f\t\u0015\u0005%EC!A!\u0002\u0013\u0011y\u0003C\u0004\u0002JQ!\tA!\u000f\t\u0017\t%C\u00031AA\u0002\u0013%!1\n\u0005\f\u0005'\"\u0002\u0019!a\u0001\n\u0013\u0011)\u0006C\u0006\u0003bQ\u0001\r\u0011!Q!\n\t5\u0003b\u0002B2)\u0011\u0005#Q\r\u0005\b\u0005O\"B\u0011\tB5\u0011\u001d\u0011Y\b\u0006C!\u0005{2aA!$\u0001\t\t=\u0005BCAE;\t\u0005\t\u0015!\u0003\u0003\u0012\"9\u0011\u0011J\u000f\u0005\u0002\tm\u0005\"\u0003BU;\t\u0007I\u0011\u0002BV\u0011!\u0011\u0019,\bQ\u0001\n\t5\u0006\"\u0003B[;\t\u0007I\u0011\u0002B\\\u0011!\u00119.\bQ\u0001\n\te\u0006\"\u0003Bm;\t\u0007I\u0011\u0002Bn\u0011!\u0011)/\bQ\u0001\n\tu\u0007\"\u0003Bt;\t\u0007I\u0011\u0002Bu\u0011!\u00199\"\bQ\u0001\n\t-\bbCB\r;\u0001\u0007\t\u0019!C\u0005\u00077A1ba\t\u001e\u0001\u0004\u0005\r\u0011\"\u0003\u0004&!Y1\u0011F\u000fA\u0002\u0003\u0005\u000b\u0015BB\u000f\u0011\u001d\u0011\u0019'\bC!\u0005KBqAa\u001a\u001e\t\u0003\u001aY\u0003C\u0004\u0003|u!\tE! \t\u000f\rmR\u0004\"\u0011\u0004>!911I\u000f\u0005\n\r\u0015cABB$\u0001\u0011\u0019I\u0005\u0003\u0006\u0002\nB\u0012\t\u0011)A\u0005\u0007\u0017Bq!!\u00131\t\u0003\u0019)\u0006C\u0005\u0004dA\u0012\r\u0011\"\u0003\u0004f!A1Q\u000e\u0019!\u0002\u0013\u00199\u0007C\u0004\u0003hA\"\tea\u001c\u0007\r\r}\u0004\u0001BBA\u0011)\tII\u000eB\u0001B\u0003%11\u0011\u0005\b\u0003\u00132D\u0011ABG\u0011-\u0019YJ\u000ea\u0001\u0002\u0004%Ia!(\t\u0017\r\u0015f\u00071AA\u0002\u0013%1q\u0015\u0005\f\u0007W3\u0004\u0019!A!B\u0013\u0019y\nC\u0004\u0003dY\"\tE!\u001a\t\u000f\t\u001dd\u0007\"\u0011\u0004.\"9!1\u0010\u001c\u0005B\tu\u0004bBB_m\u0011%1q\u0018\u0002*\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:GC\u000e$xN]=\u000b\u0005\t\u001b\u0015\u0001\u00027j].T!\u0001R#\u0002\rM,'O^3s\u0015\u00051\u0015!B6bM.\f7\u0001A\n\u0005\u0001%\u000bF\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\r=\u0013'.Z2u!\t\u0011\u0016M\u0004\u0002T?6\tAK\u0003\u0002V-\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003/b\u000bQ!\u00193nS:T!!\u0017.\u0002\u000f\rd\u0017.\u001a8ug*\u0011ai\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a)\u00069\u0012\tZ7j]J+\u0017/^3ti&sG/\u001a:dKB$xN]\u0005\u0003E\u000e\u0014qAR1di>\u0014\u0018P\u0003\u0002a)B\u0011Q\r[\u0007\u0002M*\u0011q-R\u0001\u0006kRLGn]\u0005\u0003S\u001a\u0014q\u0001T8hO&tw-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0003Y6l\u0011\u0001W\u0005\u0003]b\u0013QBT3uo>\u00148n\u00117jK:$\u0018a\u00057j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\bCA9s\u001b\u0005\t\u0015BA:B\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0011\u0005E4\u0018BA<B\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002!\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u00159'o\\;q\u0015\tq(,A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018bAA\u0001w\n\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN]\u0001\ng\u000eDW\rZ;mKJ\u00042!]A\u0004\u0013\r\tI!\u0011\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0017\u0005$W.\u001b8D_:4\u0017n\u001a\t\u0005\u0003\u001f\t\t\"D\u0001W\u0013\r\t\u0019B\u0016\u0002\u0012\u0003\u0012l\u0017N\\\"mS\u0016tGoQ8oM&<\u0017A\u00037pO\u000e{g\u000e^3yiB!\u0011\u0011DA\u0011\u001b\t\tYBC\u0002h\u0003;Q1!a\b[\u0003\u0019\u0019w.\\7p]&!\u00111EA\u000e\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fCBLg+\u001a:tS>t7\u000fE\u0002m\u0003SI1!a\u000bY\u0005-\t\u0005/\u001b,feNLwN\\:\u0002/%tG/\u001a:Ce>\\WM\u001d'jgR,g.\u001a:OC6,\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\t\u0005U\u0012QD\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI$a\r\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002-%\u001c8JU1gi\u000e{g\u000e\u001e:pY2,'/\u00113nS:\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0003\u0003\u0007\nQa]2bY\u0006LA!a\u0012\u0002B\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\f\u0002N\u0005=\u0013\u0011KA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1!\t\t\b\u0001C\u0003k\u0017\u0001\u00071\u000eC\u0003p\u0017\u0001\u0007\u0001\u000fC\u0003u\u0017\u0001\u0007Q\u000fC\u0003y\u0017\u0001\u0007\u0011\u0010C\u0004\u0002\u0004-\u0001\r!!\u0002\t\u000f\u0005-1\u00021\u0001\u0002\u000e!9\u0011QC\u0006A\u0002\u0005]\u0001bBA\u0013\u0017\u0001\u0007\u0011q\u0005\u0005\b\u0003[Y\u0001\u0019AA\u0018\u0011\u001d\tYd\u0003a\u0001\u0003{\t\u0001C]3rk\u0016\u001cH\u000fV5nK>,H/T:\u0016\u0005\u0005\u001d\u0004c\u0001&\u0002j%\u0019\u00111N&\u0003\u000f%sG/Z4fe\u0006\t\"/Z9vKN$H+[7f_V$Xj\u001d\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\t\u0019\b\u0005\u0003\u0002v\u0005]T\"A\"\n\u0007\u0005e4IA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003E\u0019'/Z1uK&sG/\u001a:dKB$xN\u001d\u000b\u0005\u0003\u0003\u000b9\tE\u0002T\u0003\u0007K1!!\"U\u0005]\tE-\\5o%\u0016\fX/Z:u\u0013:$XM]2faR|'\u000fC\u0004\u0002\nB\u0001\r!a#\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feBA\u0011QRAL\u0003O\nY*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003!1WO\\2uS>t'bAAK\u001b\u0006!Q\u000f^5m\u0013\u0011\tI*a$\u0003\u0011\u0019+hn\u0019;j_:\u0004D!!(\u00026B1\u0011qTAV\u0003csA!!)\u0002(6\u0011\u00111\u0015\u0006\u0005\u0003K\u000bi\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tI+a)\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!!,\u00020\n9!)^5mI\u0016\u0014(\u0002BAU\u0003G\u0003B!a-\u000262\u0001A\u0001DA\\\u0003\u000f\u000b\t\u0011!A\u0003\u0002\u0005e&aA0%eE!\u00111XAa!\u0011\ty$!0\n\t\u0005}\u0016\u0011\t\u0002\b\u001d>$\b.\u001b8h!\u0011\ty$a1\n\t\u0005\u0015\u0017\u0011\t\u0002\u0004\u0003:L\u0018AC1qSZ+'o]5p]R1\u00111ZAi\u0003W\u0004B!a\u0010\u0002N&!\u0011qZA!\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t\u0019.\u0005a\u0001\u0003+\faA\\8eK&#\u0007\u0003BAl\u0003KtA!!7\u0002bB!\u00111\\A!\u001b\t\tiNC\u0002\u0002`\u001e\u000ba\u0001\u0010:p_Rt\u0014\u0002BAr\u0003\u0003\na\u0001\u0015:fI\u00164\u0017\u0002BAt\u0003S\u0014aa\u0015;sS:<'\u0002BAr\u0003\u0003Bq!!#\u0012\u0001\u0004\ti\u000f\r\u0003\u0002p\u0006M\bCBAP\u0003W\u000b\t\u0010\u0005\u0003\u00024\u0006MH\u0001DA{\u0003W\f\t\u0011!A\u0003\u0002\u0005e&aA0%g\u0005A\u0011\r]5FeJ|'\u000f\u0006\u0004\u0002|\n\u0005!q\u0003\t\u0005\u0003C\u000bi0\u0003\u0003\u0002\u0000\u0006\r&\u0001C!qS\u0016\u0013(o\u001c:\t\u000f\t\r!\u00031\u0001\u0003\u0006\u0005\tA\u000f\u0005\u0003\u0003\b\tEa\u0002\u0002B\u0005\u0005\u001bqA!a7\u0003\f%\u0011\u00111I\u0005\u0005\u0005\u001f\t\t%A\u0004qC\u000e\\\u0017mZ3\n\t\tM!Q\u0003\u0002\n)\"\u0014xn^1cY\u0016TAAa\u0004\u0002B!9!\u0011\u0004\nA\u0002\u0005U\u0017\u0001D3se>\u0014X*Z:tC\u001e,\u0017\u0001D2p]R\u0014x\u000e\u001c7fe&#WC\u0001B\u0010!\u0019\tyD!\t\u0003&%!!1EA!\u0005\u0019y\u0005\u000f^5p]B!\u0011q\bB\u0014\u0013\u0011\u0011I#!\u0011\u0003\u0007%sGO\u0001\u000eNKR\fG-\u0019;b%\u0016\fX/Z:u\u0013:$XM]2faR|'o\u0005\u0003\u0015\u0013\u0006\u0005\u0005\u0007\u0002B\u0019\u0005k\u0001b!a(\u0002,\nM\u0002\u0003BAZ\u0005k!1Ba\u000e\u0016\u0003\u0003\u0005\tQ!\u0001\u0002:\n\u0019q\f\n\u001b\u0015\t\tm\"q\b\t\u0004\u0005{!R\"\u0001\u0001\t\u000f\u0005%e\u00031\u0001\u0003BA\"!1\tB$!\u0019\ty*a+\u0003FA!\u00111\u0017B$\t1\u00119Da\u0010\u0002\u0002\u0003\u0005)\u0011AA]\u0003AiW\r^1eCR\f'+Z:q_:\u001cX-\u0006\u0002\u0003NA!\u0011\u0011\u0015B(\u0013\u0011\u0011\t&a)\u0003!5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0017\u0001F7fi\u0006$\u0017\r^1SKN\u0004xN\\:f?\u0012*\u0017\u000f\u0006\u0003\u0003X\tu\u0003\u0003BA \u00053JAAa\u0017\u0002B\t!QK\\5u\u0011%\u0011y\u0006GA\u0001\u0002\u0004\u0011i%A\u0002yIE\n\u0011#\\3uC\u0012\fG/\u0019*fgB|gn]3!\u0003\u001dI7OU3bIf$\"!!\u0010\u0002\u001b\r\u0014X-\u0019;f%\u0016\fX/Z:u)\u0019\u0011YG!\u001e\u0003xA\"!Q\u000eB9!\u0019\ty*a+\u0003pA!\u00111\u0017B9\t-\u0011\u0019hGA\u0001\u0002\u0003\u0015\t!!/\u0003\u0007}#S\u0007C\u0004\u0002Tn\u0001\r!!6\t\u000f\te4\u00041\u0001\u0003&\u0005IA/[7f_V$Xj]\u0001\u0014S:$XM]2faR,GMU3ta>t7/\u001a\u000b\u0003\u0005\u007f\u0002bA!!\u0003\u0004\n\u001dUBAAJ\u0013\u0011\u0011))a%\u0003\u0011=\u0003H/[8oC2\u0004B!!)\u0003\n&!!1RAR\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cXM\u0001\u0010De\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN!Q$SAAa\u0011\u0011\u0019Ja&\u0011\r\u0005}\u00151\u0016BK!\u0011\t\u0019La&\u0005\u0017\tee$!A\u0001\u0002\u000b\u0005\u0011\u0011\u0018\u0002\u0004?\u00122D\u0003\u0002BO\u0005?\u00032A!\u0010\u001e\u0011\u001d\tIi\ba\u0001\u0005C\u0003DAa)\u0003(B1\u0011qTAV\u0005K\u0003B!a-\u0003(\u0012a!\u0011\u0014BP\u0003\u0003\u0005\tQ!\u0001\u0002:\u0006\u00192M]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiV\u0011!Q\u0016\t\u0005\u0003C\u0013y+\u0003\u0003\u00032\u0006\r&aE\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$\u0018\u0001F2sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$\b%A\u0004gkR,(/Z:\u0016\u0005\te\u0006\u0003\u0003B^\u0005\u0003\f)N!2\u000e\u0005\tu&\u0002\u0002B`\u0003\u0003\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019M!0\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0003H\n5'\u0011[\u0007\u0003\u0005\u0013TAAa3\u0002\u0014\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t='\u0011\u001a\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA9\u0003T&\u0019!Q[!\u0003)\rcWo\u001d;fe2Kgn\u001b+pa&\u001c\u0017J\u001c4p\u0003!1W\u000f^;sKN\u0004\u0013!C1mY\u001a+H/\u001e:f+\t\u0011i\u000e\u0005\u0004\u0003H\n5'q\u001c\t\u0004\u0015\n\u0005\u0018b\u0001Br\u0017\n!ak\\5e\u0003)\tG\u000e\u001c$viV\u0014X\rI\u0001\u000fKJ\u0014xN\u001d*fgB|gn]3t+\t\u0011Y\u000f\u0005\u0004\u0003\u0002\n5(\u0011_\u0005\u0005\u0005_\f\u0019JA\u0005BeJ\f\u0017\u0010T5tiB!!1_B\t\u001d\u0011\u0011)pa\u0003\u000f\t\t]8q\u0001\b\u0005\u0005s\u001c)A\u0004\u0003\u0003|\u000e\ra\u0002\u0002B\u007f\u0007\u0003qA!a7\u0003\u0000&\ta,\u0003\u0002];&\u0011aiW\u0005\u0004\u0003?Q\u0016\u0002BB\u0005\u0003;\tq!\\3tg\u0006<W-\u0003\u0003\u0004\u000e\r=\u0011\u0001G\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rR1uC*!1\u0011BA\u000f\u0013\u0011\u0019\u0019b!\u0006\u0003)\r\u0013X-\u0019;bE2,Gk\u001c9jGJ+7/\u001e7u\u0015\u0011\u0019iaa\u0004\u0002\u001f\u0015\u0014(o\u001c:SKN\u0004xN\\:fg\u0002\nAc\u0019:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,WCAB\u000f!\u0011\t\tka\b\n\t\r\u0005\u00121\u0015\u0002\u0015\u0007J,\u0017\r^3U_BL7m\u001d*fgB|gn]3\u00021\r\u0014X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f?\u0012*\u0017\u000f\u0006\u0003\u0003X\r\u001d\u0002\"\u0003B0S\u0005\u0005\t\u0019AB\u000f\u0003U\u0019'/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK\u0002\"ba!\f\u00048\re\u0002\u0007BB\u0018\u0007g\u0001b!a(\u0002,\u000eE\u0002\u0003BAZ\u0007g!1b!\u000e-\u0003\u0003\u0005\tQ!\u0001\u0002:\n\u0019q\fJ\u001c\t\u000f\u0005MG\u00061\u0001\u0002V\"9!\u0011\u0010\u0017A\u0002\t\u0015\u0012AC8o%\u0016\u001c\bo\u001c8tKR!!qQB \u0011\u001d\u0019\tE\fa\u0001\u0005\u000f\u000b\u0001B]3ta>t7/Z\u0001\u0014CNLhn\u0019$fi\u000eDGk\u001c9jG&sgm\u001c\u000b\u0003\u0005s\u0013\u0011&\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;J]R,'oY3qi>\u00148\u0003\u0002\u0019J\u0003\u0003\u0003Da!\u0014\u0004RA1\u0011qTAV\u0007\u001f\u0002B!a-\u0004R\u0011Y11K\u0019\u0002\u0002\u0003\u0005)\u0011AA]\u0005\ryF\u0005\u000f\u000b\u0005\u0007/\u001aI\u0006E\u0002\u0003>ABq!!#3\u0001\u0004\u0019Y\u0006\r\u0003\u0004^\r\u0005\u0004CBAP\u0003W\u001by\u0006\u0005\u0003\u00024\u000e\u0005D\u0001DB*\u00073\n\t\u0011!A\u0003\u0002\u0005e\u0016aE1mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$XCAB4!\u0011\t\tk!\u001b\n\t\r-\u00141\u0015\u0002\u001f\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR\fA#\u00197uKJ\u001cuN\u001c4jON\u0014V-];fgR\u0004CCBB9\u0007w\u001ai\b\r\u0003\u0004t\r]\u0004CBAP\u0003W\u001b)\b\u0005\u0003\u00024\u000e]DaCB=k\u0005\u0005\t\u0011!B\u0001\u0003s\u00131a\u0018\u0013:\u0011\u001d\t\u0019.\u000ea\u0001\u0003+DqA!\u001f6\u0001\u0004\u0011)CA\u0011GS:$7i\\8sI&t\u0017\r^8s%\u0016\fX/Z:u\u0013:$XM]2faR|'o\u0005\u00037\u0013\u0006\u0005\u0005\u0007BBC\u0007\u0013\u0003b!a(\u0002,\u000e\u001d\u0005\u0003BAZ\u0007\u0013#1ba#8\u0003\u0003\u0005\tQ!\u0001\u0002:\n!q\fJ\u00191)\u0011\u0019yi!%\u0011\u0007\tub\u0007C\u0004\u0002\nb\u0002\raa%1\t\rU5\u0011\u0014\t\u0007\u0003?\u000bYka&\u0011\t\u0005M6\u0011\u0014\u0003\r\u0007\u0017\u001b\t*!A\u0001\u0002\u000b\u0005\u0011\u0011X\u0001\u0018M&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016,\"aa(\u0011\t\u0005\u00056\u0011U\u0005\u0005\u0007G\u000b\u0019KA\fGS:$7i\\8sI&t\u0017\r^8s%\u0016\u001c\bo\u001c8tK\u0006Yb-\u001b8e\u0007>|'\u000fZ5oCR|'OU3ta>t7/Z0%KF$BAa\u0016\u0004*\"I!q\f\u001e\u0002\u0002\u0003\u00071qT\u0001\u0019M&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016\u0004CCBBX\u0007s\u001bY\f\r\u0003\u00042\u000eU\u0006CBAP\u0003W\u001b\u0019\f\u0005\u0003\u00024\u000eUFaCB\\{\u0005\u0005\t\u0011!B\u0001\u0003s\u0013Aa\u0018\u00132c!9\u00111[\u001fA\u0002\u0005U\u0007b\u0002B={\u0001\u0007!QE\u0001\u0015M&tGm\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0015\t\r\u000571\u001c\t\t\u0003\u007f\u0019\u0019ma2\u0004T&!1QYA!\u0005\u0019!V\u000f\u001d7feA!1\u0011ZBh\u001b\t\u0019YM\u0003\u0003\u0004N\u0006u\u0011\u0001\u00039s_R|7m\u001c7\n\t\rE71\u001a\u0002\u0007\u000bJ\u0014xN]:\u0011\t\rU7q[\u0007\u0003\u0003;IAa!7\u0002\u001e\t!aj\u001c3f\u0011\u0019ax\b1\u0001\u0002V\u0002")
public class ClusterLinkAdminRequestInterceptorFactory
implements AdminRequestInterceptor.Factory,
Logging {
    public final ClusterLinkManager kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$clusterLinkManager;
    public final GroupCoordinator kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$groupCoordinator;
    private final ApiVersions apiVersions;
    public final ListenerName kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName;
    private final boolean isKRaftControllerAdmin;
    private final Integer kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs;
    private final MetadataCache kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Integer kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs() {
        return this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs;
    }

    public MetadataCache kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache() {
        return this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache;
    }

    public AdminRequestInterceptor createInterceptor(Function<Integer, AbstractRequest.Builder<?>> requestBuilder) {
        AbstractRequest.Builder<?> request = requestBuilder.apply(this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs());
        ApiKeys apiKeys = request.apiKey();
        if (ApiKeys.METADATA.equals(apiKeys)) {
            return new MetadataRequestInterceptor(this, request);
        }
        if (ApiKeys.CREATE_TOPICS.equals(apiKeys) && this.isKRaftControllerAdmin) {
            return new CreateTopicsRequestInterceptor(this, request);
        }
        if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
            return new IncrementalAlterConfigsRequestInterceptor(request);
        }
        if (ApiKeys.FIND_COORDINATOR.equals(apiKeys)) {
            return new FindCoordinatorRequestInterceptor(this, request);
        }
        return AdminRequestInterceptor.Factory.DEFAULT_INTERCEPTOR_FACTORY.createInterceptor(requestBuilder);
    }

    public short kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$apiVersion(String nodeId, AbstractRequest.Builder<?> requestBuilder) {
        NodeApiVersions versionInfo = this.apiVersions.get(nodeId);
        if (versionInfo != null) {
            return versionInfo.latestUsableVersion(requestBuilder.apiKey(), requestBuilder.oldestAllowedVersion(), requestBuilder.latestAllowedVersion());
        }
        return requestBuilder.latestAllowedVersion();
    }

    public ApiError kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$apiError(Throwable t, String errorMessage) {
        if (t instanceof ConfigException) {
            ConfigException configException = (ConfigException)t;
            this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> configException);
            return ApiError.fromThrowable((Throwable)new InvalidConfigurationException(configException.getMessage(), configException.getCause()));
        }
        if (t != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return ApiError.fromThrowable((Throwable)t);
        }
        throw new MatchError(null);
    }

    public Option<Object> kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$controllerId() {
        return this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getControllerId().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof ZkCachedControllerId) {
                int id = ((ZkCachedControllerId)x0$1).id();
                return new Some((Object)BoxesRunTime.boxToInteger((int)id));
            }
            if (x0$1 instanceof KRaftCachedControllerId) {
                return this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getRandomAliveBrokerId();
            }
            throw new MatchError(x0$1);
        });
    }

    public ClusterLinkAdminRequestInterceptorFactory(NetworkClient networkClient, ClusterLinkMetadataManager linkMetadataManager, ClusterLinkManager clusterLinkManager, GroupCoordinator groupCoordinator, ClusterLinkScheduler scheduler, AdminClientConfig adminConfig, LogContext logContext, ApiVersions apiVersions, ListenerName interBrokerListenerName, boolean isKRaftControllerAdmin) {
        this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$clusterLinkManager = clusterLinkManager;
        this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$groupCoordinator = groupCoordinator;
        this.apiVersions = apiVersions;
        this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName = interBrokerListenerName;
        this.isKRaftControllerAdmin = isKRaftControllerAdmin;
        this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs = adminConfig.getInt("request.timeout.ms");
        this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache = linkMetadataManager.metadataCache();
        this.logIdent_$eq(logContext.logPrefix());
    }

    private class CreateTopicsRequestInterceptor
    implements AdminRequestInterceptor {
        private final AbstractRequest.Builder<?> requestBuilder;
        private final CreateTopicsRequest createTopicsRequest;
        private final Map<String, CompletableFuture<ClusterLinkTopicInfo>> futures;
        private final CompletableFuture<Void> allFuture;
        private final ArrayList<CreateTopicsResponseData.CreatableTopicResult> errorResponses;
        private CreateTopicsResponse createTopicsResponse;
        public final /* synthetic */ ClusterLinkAdminRequestInterceptorFactory $outer;

        private CreateTopicsRequest createTopicsRequest() {
            return this.createTopicsRequest;
        }

        private Map<String, CompletableFuture<ClusterLinkTopicInfo>> futures() {
            return this.futures;
        }

        private CompletableFuture<Void> allFuture() {
            return this.allFuture;
        }

        private ArrayList<CreateTopicsResponseData.CreatableTopicResult> errorResponses() {
            return this.errorResponses;
        }

        private CreateTopicsResponse createTopicsResponse() {
            return this.createTopicsResponse;
        }

        private void createTopicsResponse_$eq(CreateTopicsResponse x$1) {
            this.createTopicsResponse = x$1;
        }

        public boolean isReady() {
            return this.allFuture().isDone();
        }

        public AbstractRequest.Builder<?> createRequest(String nodeId, int timeoutMs) {
            CreateTopicsRequestData newRequestData = this.createTopicsRequest().data().duplicate();
            short version = this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$apiVersion(nodeId, this.requestBuilder);
            Iterator iterator = newRequestData.topics().iterator();
            while (iterator.hasNext()) {
                CreateTopicsRequestData.CreatableTopic topic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
                try {
                    if (topic.linkName() == null) continue;
                    MirrorTopicRequestHelperKraft$.MODULE$.transformCreatableTopic(this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$clusterLinkManager, topic, (Option<CompletableFuture<ClusterLinkTopicInfo>>)this.futures().get((Object)topic.name()), newRequestData.validateOnly(), version);
                }
                catch (Throwable t) {
                    ApiError err = this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$apiError(t, new StringBuilder(38).append("Error processing create topic request ").append(topic).toString());
                    CreateTopicsResponseData.CreatableTopicResult response = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(err.error().code()).setErrorMessage(err.error().message());
                    this.errorResponses().add(response);
                    iterator.remove();
                }
            }
            CreateTopicsRequest.Builder newRequest = new CreateTopicsRequest.Builder(newRequestData);
            if (newRequestData.topics().isEmpty()) {
                CreateTopicsResponseData.CreatableTopicResultCollection topics = new CreateTopicsResponseData.CreatableTopicResultCollection();
                topics.addAll(this.errorResponses());
                CreateTopicsResponseData responseData = new CreateTopicsResponseData().setTopics(topics);
                this.createTopicsResponse_$eq(new CreateTopicsResponse(responseData));
            }
            return newRequest;
        }

        public Optional<AbstractResponse> interceptedResponse() {
            return Optional.ofNullable(this.createTopicsResponse());
        }

        public AbstractResponse onResponse(AbstractResponse response) {
            if (this.errorResponses().isEmpty()) {
                return response;
            }
            CreateTopicsResponseData allResponses = ((CreateTopicsResponse)response).data().duplicate();
            allResponses.topics().addAll(this.errorResponses());
            return new CreateTopicsResponse(allResponses);
        }

        private Map<String, CompletableFuture<ClusterLinkTopicInfo>> asyncFetchTopicInfo() {
            CreateTopicsRequestData.CreatableTopicCollection topics = this.createTopicsRequest().data().topics();
            Iterable mirrorTopics = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)topics).asScala().filter((Function1 & Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestInterceptor.$anonfun$asyncFetchTopicInfo$1(x$59)));
            if (mirrorTopics.nonEmpty()) {
                scala.collection.immutable.Map startSpec = ((IterableOnceOps)mirrorTopics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.name()), (Object)BoxesRunTime.boxToLong((long)topic.mirrorStartOffsetSpec())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                scala.collection.immutable.Map mirrorTopicLinks = ((IterableOnceOps)mirrorTopics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.name()), $this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$clusterLinkManager.resolveLinkId(topic.linkName())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$clusterLinkManager.fetchSourceTopicInfoForMirrors((Map<String, Option<Uuid>>)mirrorTopicLinks, (Map<String, ApiError>)((Map)Map$.MODULE$.empty()), (Function2 & Serializable)(topic, client) -> client.fetchTopicInfo((String)topic, Predef$.MODULE$.Integer2int(this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$requestTimeoutMs()), BoxesRunTime.unboxToLong((Object)startSpec.apply(topic))));
            }
            return (Map)Map$.MODULE$.empty();
        }

        public /* synthetic */ ClusterLinkAdminRequestInterceptorFactory kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$CreateTopicsRequestInterceptor$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$asyncFetchTopicInfo$1(CreateTopicsRequestData.CreatableTopic x$59) {
            return x$59.linkName() != null;
        }

        public CreateTopicsRequestInterceptor(ClusterLinkAdminRequestInterceptorFactory $outer, AbstractRequest.Builder<?> requestBuilder) {
            this.requestBuilder = requestBuilder;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.createTopicsRequest = (CreateTopicsRequest)requestBuilder.build();
            this.futures = this.asyncFetchTopicInfo();
            this.allFuture = this.futures().isEmpty() ? CompletableFuture.completedFuture(null) : CompletableFuture.allOf((CompletableFuture[])this.futures().values().toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class)));
            this.errorResponses = new ArrayList();
        }
    }

    private class FindCoordinatorRequestInterceptor
    implements AdminRequestInterceptor {
        private final AbstractRequest.Builder<?> requestBuilder;
        private FindCoordinatorResponse findCoordinatorResponse;
        public final /* synthetic */ ClusterLinkAdminRequestInterceptorFactory $outer;

        public AbstractResponse onResponse(AbstractResponse x$1) {
            return super.onResponse(x$1);
        }

        private FindCoordinatorResponse findCoordinatorResponse() {
            return this.findCoordinatorResponse;
        }

        private void findCoordinatorResponse_$eq(FindCoordinatorResponse x$1) {
            this.findCoordinatorResponse = x$1;
        }

        public boolean isReady() {
            return true;
        }

        public AbstractRequest.Builder<?> createRequest(String nodeId, int timeoutMs) {
            FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)this.requestBuilder.build();
            if (this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$apiVersion(nodeId, this.requestBuilder) >= 4 && findCoordinatorRequest.data().keyType() == FindCoordinatorRequest.CoordinatorType.GROUP.id() && this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().contains("__consumer_offsets")) {
                Buffer coordinators = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(findCoordinatorRequest.data().coordinatorKeys()).asScala().map((Function1 & Serializable)key -> {
                    void var4_4;
                    void var3_3;
                    Tuple2<Errors, Node> tuple2 = this.findGroupCoordinator((String)key);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    Errors error = (Errors)tuple2._1();
                    Node node = (Node)tuple2._2();
                    return new FindCoordinatorResponseData.Coordinator().setKey(key).setErrorCode(var3_3.code()).setHost(var4_4.host()).setNodeId(var4_4.id()).setPort(var4_4.port());
                });
                FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setCoordinators(CollectionConverters$.MODULE$.BufferHasAsJava(coordinators).asJava());
                this.findCoordinatorResponse_$eq(new FindCoordinatorResponse(responseData));
            }
            return this.requestBuilder;
        }

        public Optional<AbstractResponse> interceptedResponse() {
            return Optional.ofNullable(this.findCoordinatorResponse());
        }

        private Tuple2<Errors, Node> findGroupCoordinator(String group) {
            int partition = this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$groupCoordinator.partitionFor(group);
            Option topicMetadata = this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__consumer_offsets"}))), this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName, this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata$default$3(), this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata$default$4()).headOption().filter((Function1 & Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)FindCoordinatorRequestInterceptor.$anonfun$findGroupCoordinator$1(x$62)));
            if (topicMetadata instanceof Some) {
                MetadataResponseData.MetadataResponseTopic metadata2 = (MetadataResponseData.MetadataResponseTopic)((Some)topicMetadata).value();
                Option coordinatorEndpoint = CollectionConverters$.MODULE$.ListHasAsScala(metadata2.partitions()).asScala().find((Function1 & Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)FindCoordinatorRequestInterceptor.$anonfun$findGroupCoordinator$2(partition, x$63))).filter((Function1 & Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)FindCoordinatorRequestInterceptor.$anonfun$findGroupCoordinator$3(x$64))).flatMap((Function1 & Serializable)metadata -> this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getAliveBrokerNode(metadata.leaderId(), $this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName));
                if (coordinatorEndpoint instanceof Some) {
                    Node endpoint = (Node)((Some)coordinatorEndpoint).value();
                    return new Tuple2((Object)Errors.NONE, (Object)endpoint);
                }
                return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)Node.noNode());
            }
            if (None$.MODULE$.equals(topicMetadata)) {
                return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)Node.noNode());
            }
            throw new MatchError((Object)topicMetadata);
        }

        public /* synthetic */ ClusterLinkAdminRequestInterceptorFactory kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$FindCoordinatorRequestInterceptor$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$findGroupCoordinator$1(MetadataResponseData.MetadataResponseTopic x$62) {
            return x$62.errorCode() == Errors.NONE.code();
        }

        public static final /* synthetic */ boolean $anonfun$findGroupCoordinator$2(int partition$1, MetadataResponseData.MetadataResponsePartition x$63) {
            return x$63.partitionIndex() == partition$1;
        }

        public static final /* synthetic */ boolean $anonfun$findGroupCoordinator$3(MetadataResponseData.MetadataResponsePartition x$64) {
            return x$64.leaderId() != -1;
        }

        public FindCoordinatorRequestInterceptor(ClusterLinkAdminRequestInterceptorFactory $outer, AbstractRequest.Builder<?> requestBuilder) {
            this.requestBuilder = requestBuilder;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class IncrementalAlterConfigsRequestInterceptor
    implements AdminRequestInterceptor {
        private final IncrementalAlterConfigsRequest alterConfigsRequest;

        public boolean isReady() {
            return super.isReady();
        }

        public AbstractResponse onResponse(AbstractResponse x$1) {
            return super.onResponse(x$1);
        }

        public Optional<AbstractResponse> interceptedResponse() {
            return super.interceptedResponse();
        }

        private IncrementalAlterConfigsRequest alterConfigsRequest() {
            return this.alterConfigsRequest;
        }

        public AbstractRequest.Builder<?> createRequest(String nodeId, int timeoutMs) {
            IncrementalAlterConfigsRequestData newRequest = this.alterConfigsRequest().data().duplicate();
            newRequest.setSkipMirrorTopicConfigValidation(true);
            return new IncrementalAlterConfigsRequest.Builder(newRequest);
        }

        public /* synthetic */ ClusterLinkAdminRequestInterceptorFactory kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$IncrementalAlterConfigsRequestInterceptor$$$outer() {
            return ClusterLinkAdminRequestInterceptorFactory.this;
        }

        public IncrementalAlterConfigsRequestInterceptor(AbstractRequest.Builder<?> requestBuilder) {
            if (ClusterLinkAdminRequestInterceptorFactory.this == null) {
                throw null;
            }
            this.alterConfigsRequest = (IncrementalAlterConfigsRequest)requestBuilder.build();
        }
    }

    private class MetadataRequestInterceptor
    implements AdminRequestInterceptor {
        private final AbstractRequest.Builder<?> requestBuilder;
        private MetadataResponse metadataResponse;
        public final /* synthetic */ ClusterLinkAdminRequestInterceptorFactory $outer;

        public AbstractResponse onResponse(AbstractResponse x$1) {
            return super.onResponse(x$1);
        }

        private MetadataResponse metadataResponse() {
            return this.metadataResponse;
        }

        private void metadataResponse_$eq(MetadataResponse x$1) {
            this.metadataResponse = x$1;
        }

        public boolean isReady() {
            return true;
        }

        public AbstractRequest.Builder<?> createRequest(String nodeId, int timeoutMs) {
            Seq seq;
            MetadataRequest metadataRequest = (MetadataRequest)this.requestBuilder.build();
            scala.collection.immutable.Set topics = metadataRequest.isAllTopics() ? this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getAllTopics((Option<String>)None$.MODULE$) : CollectionConverters$.MODULE$.ListHasAsScala(metadataRequest.topics()).asScala().toSet();
            Seq topicResponses = this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata((Set<String>)topics, this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName, this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata$default$3(), this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getTopicMetadata$default$4());
            if (!metadataRequest.isAllTopics()) {
                Set nonExistingTopics = (Set)topics.diff((Set)((IterableOnceOps)topicResponses.map((Function1 & Serializable)x$57 -> x$57.name())).toSet()).map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic));
                seq = (Seq)topicResponses.$plus$plus((IterableOnce)nonExistingTopics);
            } else {
                seq = topicResponses;
            }
            Seq topicMetadata = seq;
            this.metadataResponse_$eq(MetadataResponse.prepareResponse((short)ApiKeys.METADATA.latestVersion(), (int)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$metadataCache().getAliveBrokerNodes(this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$interBrokerListenerName).toList()).asJava(), null, (int)BoxesRunTime.unboxToInt((Object)this.kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer().kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$$controllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), (List)CollectionConverters$.MODULE$.SeqHasAsJava(topicMetadata).asJava(), (int)Integer.MIN_VALUE, null));
            return this.requestBuilder;
        }

        public Optional<AbstractResponse> interceptedResponse() {
            return Optional.ofNullable(this.metadataResponse());
        }

        public /* synthetic */ ClusterLinkAdminRequestInterceptorFactory kafka$server$link$ClusterLinkAdminRequestInterceptorFactory$MetadataRequestInterceptor$$$outer() {
            return this.$outer;
        }

        public MetadataRequestInterceptor(ClusterLinkAdminRequestInterceptorFactory $outer, AbstractRequest.Builder<?> requestBuilder) {
            this.requestBuilder = requestBuilder;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

