/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.cluster.BrokerEndPoint;
import kafka.server.BrokerBlockingSender;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkReplicaQuotaAdapter;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$InSync$;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkAsyncSender;
import kafka.server.link.ClusterLinkClientType$Fetcher$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.FetchResponseSize;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkFetcherThread$ {
    public static final ClusterLinkFetcherThread$ MODULE$ = new ClusterLinkFetcherThread$();
    private static final String mirrorTopicMessageRateMetricName = "mirror-topic-message-rate-per-second";
    private static final String mirrorTopicMessageRateMetricDescription = "Rate of messages being written to the mirror topic per second";
    private static final String mirrorTopicRpoMetricName = "mirror-topic-rpo-seconds";
    private static final String mirrorTopicRpoMetricDescription = "RPO for mirror topic in seconds";

    public Option<LogContext> $lessinit$greater$default$17() {
        return None$.MODULE$;
    }

    public String mirrorTopicMessageRateMetricName() {
        return mirrorTopicMessageRateMetricName;
    }

    public String mirrorTopicMessageRateMetricDescription() {
        return mirrorTopicMessageRateMetricDescription;
    }

    public String mirrorTopicRpoMetricName() {
        return mirrorTopicRpoMetricName;
    }

    public String mirrorTopicRpoMetricDescription() {
        return mirrorTopicRpoMetricDescription;
    }

    public ClusterLinkFetcherThread apply(String name, int fetcherId, FetcherPool fetcherPool, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkConnectionManager connectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> tenant, Function0<FetchResponseSize> dynamicFetchSize) {
        int brokerId = brokerConfig.brokerId();
        LogContext logContext = new LogContext(new StringBuilder(80).append("[ClusterLinkFetcher brokerId=").append(brokerId).append(" ").append("fetcherId=").append(fetcherId).append(" fetcherPool=").append(fetcherPool.name()).append(" source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(sourceBroker.id()).append(")] ").toString(), connectionManager.maxLogLevel());
        scala.collection.mutable.Map extraMetricTags = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))}));
        if (fetcherPool.equals(FetcherPool$InSync$.MODULE$)) {
            extraMetricTags.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-pool"), (Object)fetcherPool.name()));
        }
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), (Map<String, String>)((Map)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus((IterableOnce)extraMetricTags)), time, new StringBuilder(28).append("link-").append(clusterLinkMetadata.linkName()).append("-broker-").append(brokerId).append("-fetcher-").append(fetcherId).append("-pool-").append(fetcherPool.name()).toString(), ClusterLinkClientType$Fetcher$.MODULE$, logContext);
        connectionManager.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        BrokerBlockingSender blockingSender = new BrokerBlockingSender(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, fetcherId, clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        ClusterLinkLeaderEndPoint leader = ClusterLinkLeaderEndPoint$.MODULE$.apply(logContext, time, blockingSender, clusterLinkClient, brokerConfig, clusterLinkConfig, replicaMgr, quota, clusterLinkMetrics);
        return new ClusterLinkFetcherThread(name, fetcherId, leader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, clusterLinkConfig.replicaFetchBackoff(), replicaMgr, quota, clusterLinkMetrics, time, dynamicFetchSize, clusterLinkClient, (Option<LogContext>)new Some((Object)logContext), tenant);
    }

    public ClusterLinkFetcherWithSharedThread createFetcherWithSharedThread(String name, int fetcherId, FetcherPool fetcherPool, Uuid linkId, ClusterLinkSharedFetcherThread sharedThread, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkConnectionManager connectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ReplicaManager replicaMgr, ClusterLinkQuotas quotas, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> tenant, Function0<FetchResponseSize> dynamicFetchSize) {
        int brokerId = brokerConfig.brokerId();
        LogContext logContext = new LogContext(new StringBuilder(80).append("[ClusterLinkFetcher brokerId=").append(brokerId).append(" fetcherId=").append(fetcherId).append(" fetcherPool=").append(fetcherPool.name()).append(" source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(sourceBroker.id()).append(")] ").toString(), connectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = sharedThread.clusterLinkClient();
        ClusterLinkAsyncSender sender = new ClusterLinkAsyncSender(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), Predef$.MODULE$.Integer2int(clusterLinkConfig.requestTimeoutMs()), time, quotas.requestQuotaAdapter(clusterLinkMetadata.linkName(), tenant), fetcherId, fetcherPool, clusterLinkClient.networkClient());
        ClusterLinkReplicaQuotaAdapter quota = new ClusterLinkReplicaQuotaAdapter(quotas, tenant, clusterLinkMetadata.linkName());
        ClusterLinkAsyncLeaderEndPoint leader = ClusterLinkLeaderEndPoint$.MODULE$.createAsyncLeaderEndpoint(logContext, time, sender, clusterLinkClient, brokerConfig, clusterLinkConfig, replicaMgr, quota, clusterLinkMetrics);
        ClusterLinkFetcherWithSharedThread fetcher = new ClusterLinkFetcherWithSharedThread(name, linkId, fetcherId, fetcherPool, name, sourceBroker, sharedThread, sender, leader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, clusterLinkConfig.replicaFetchBackoff(), replicaMgr, quota, clusterLinkMetrics, time, dynamicFetchSize, clusterLinkClient, logContext, tenant);
        sharedThread.addFetcher(sourceBroker.id(), fetcher);
        return fetcher;
    }

    private ClusterLinkFetcherThread$() {
    }
}

