/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.controller.StateChangeLogger;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rmg\u0001B\u001d;\u0001\u0005C\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00051\")A\f\u0001C\u0001;\"9\u0001\r\u0001a\u0001\n\u0013\t\u0007bB7\u0001\u0001\u0004%IA\u001c\u0005\u0007i\u0002\u0001\u000b\u0015\u00022\t\u000fe\u0004!\u0019!C\u0005u\"9\u00111\u0001\u0001!\u0002\u0013Y\bbBA\u0003\u0001\u0011%\u0011q\u0001\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!a/\u0001\t\u0013\ti\fC\u0004\u0002R\u0002!I!a5\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"I!Q\u0002\u0001\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005K\u0001\u0011\u0013!C\u0001\u0005\u001fAqAa\n\u0001\t\u0003\u0012I\u0003C\u0004\u00032\u0001!\tEa\r\t\u000f\t}\u0002\u0001\"\u0011\u0003B!9!1\n\u0001\u0005B\t5\u0003b\u0002B*\u0001\u0011\u0005#Q\u000b\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005CBqA!\u001a\u0001\t\u0003\u00129\u0007C\u0004\u0003f\u0001!IAa\u001f\t\u000f\t}\u0004\u0001\"\u0011\u0003\u0002\"9!q\u0011\u0001\u0005B\t%\u0005b\u0002BJ\u0001\u0011\u0005#Q\u0013\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011\t\u000b\u0001C!\u0005GCqAa/\u0001\t\u0003\u0011i\fC\u0004\u0003B\u0002!\tEa1\t\u000f\t%\u0007\u0001\"\u0011\u0003L\"9!\u0011\u001b\u0001\u0005B\tM\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005C\u0004A\u0011\tBr\u0011\u001d\u0011Y\u000f\u0001C!\u0005[DqAa>\u0001\t\u0003\u0012I\u0010C\u0004\u0004\u0004\u0001!\te!\u0002\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n!91Q\u0002\u0001\u0005\u0002\r=\u0001bBB\u000e\u0001\u0011\u00053Q\u0004\u0005\b\u0007W\u0001A\u0011AB\u0017\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cAqaa\u000e\u0001\t\u0003\u001aI\u0004C\u0004\u00048\u0001!\te!\u0010\t\u000f\r\u0005\u0003\u0001\"\u0001\u0004D!91\u0011\n\u0001\u0005B\r-\u0003bBB1\u0001\u0011\u000511\r\u0005\b\u0007o\u0002A\u0011AB=\u0011\u001d\u0019I\t\u0001C!\u0007\u0017Cqa!'\u0001\t\u0003\u001aY\nC\u0004\u0004$\u0002!\te!*\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"91\u0011\u0019\u0001\u0005B\r\r\u0007bBBl\u0001\u0011\u00053\u0011\u001c\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002<y\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002>}\u000511/\u001a:wKJT\u0011aP\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001!\t\u0013'S!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u0011\u0011JS\u0007\u0002y%\u00111\n\u0010\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u00055\u0003V\"\u0001(\u000b\u0005=s\u0014!B;uS2\u001c\u0018BA)O\u0005\u001daunZ4j]\u001e\u0004\"a\u0015+\u000e\u0003iJ!!\u0016\u001e\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003a\u0003\"aQ-\n\u0005i#%aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005y{\u0006CA*\u0001\u0011\u001516\u00011\u0001Y\u00035y6-\u001e:sK:$\u0018*\\1hKV\t!\r\u0005\u0002dW6\tAM\u0003\u0002fM\u0006)\u0011.\\1hK*\u0011qh\u001a\u0006\u0003Q&\fa!\u00199bG\",'\"\u00016\u0002\u0007=\u0014x-\u0003\u0002mI\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011cX2veJ,g\u000e^%nC\u001e,w\fJ3r)\ty'\u000f\u0005\u0002Da&\u0011\u0011\u000f\u0012\u0002\u0005+:LG\u000fC\u0004t\u000b\u0005\u0005\t\u0019\u00012\u0002\u0007a$\u0013'\u0001\b`GV\u0014(/\u001a8u\u00136\fw-\u001a\u0011)\u0005\u00191\bCA\"x\u0013\tAHI\u0001\u0005w_2\fG/\u001b7f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011aPP\u0001\u000bG>tGO]8mY\u0016\u0014\u0018bAA\u0001{\n\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cHCCA\u0005\u0003K\t9#!\r\u0002FA1\u00111BA\u000b\u00033i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005kRLGN\u0003\u0002\u0002\u0014\u0005!!.\u0019<b\u0013\u0011\t9\"!\u0004\u0003\t1K7\u000f\u001e\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)!\u0011qDA\t\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0012Q\u0004\u0002\b\u0013:$XmZ3s\u0011\u0015)\u0017\u00021\u0001c\u0011\u001d\tI#\u0003a\u0001\u0003W\tqA\u0019:pW\u0016\u00148\u000f\u0005\u0003D\u0003[A\u0016bAA\u0018\t\n)\u0011I\u001d:bs\"9\u00111G\u0005A\u0002\u0005U\u0012\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\b]\u0016$xo\u001c:l\u0015\r\tyDZ\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003\u000fJ\u0001\u0019AA%\u0003i1\u0017\u000e\u001c;feVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t!\r\u0019\u00151J\u0005\u0004\u0003\u001b\"%a\u0002\"p_2,\u0017M\\\u0001\rGV\u0014(/\u001a8u\u00136\fw-\u001a\u000b\u0002E\u0006!r-\u001a;QCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006$B\"a\u0016\u0002\u001c\u0006u\u0015\u0011WAZ\u0003o\u0003RaQA-\u0003;J1!a\u0017E\u0005\u0019y\u0005\u000f^5p]B1\u0011qLA8\u0003krA!!\u0019\u0002l9!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0001\u000ba\u0001\u0010:p_Rt\u0014\"A#\n\u0007\u00055D)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00141\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011Q\u000e#\u0011\t\u0005]\u0014Q\u0013\b\u0005\u0003s\nyI\u0004\u0003\u0002|\u0005-e\u0002BA?\u0003\u0013sA!a \u0002\b:!\u0011\u0011QAC\u001d\u0011\t\u0019'a!\n\u0003)L!\u0001[5\n\u0005}:\u0017bAA M&!\u0011QRA\u001f\u0003\u001diWm]:bO\u0016LA!!%\u0002\u0014\u0006!R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a#bi\u0006TA!!$\u0002>%!\u0011qSAM\u0005eiU\r^1eCR\f'+Z:q_:\u001cX\rU1si&$\u0018n\u001c8\u000b\t\u0005E\u00151\u0013\u0005\u0006K.\u0001\rA\u0019\u0005\b\u0003?[\u0001\u0019AAQ\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0002$\u0006-f\u0002BAS\u0003O\u00032!a\u0019E\u0013\r\tI\u000bR\u0001\u0007!J,G-\u001a4\n\t\u00055\u0016q\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%F\tC\u0004\u00024-\u0001\r!!\u000e\t\u000f\u0005U6\u00021\u0001\u0002J\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t\u0011\u001d\tIl\u0003a\u0001\u0003\u0013\n\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sg\u0006\u0011r-\u001a;PM\u001ad\u0017N\\3SKBd\u0017nY1t)!\tI!a0\u0002B\u0006=\u0007\"B3\r\u0001\u0004\u0011\u0007bBAb\u0019\u0001\u0007\u0011QY\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!a2\u0002L6\u0011\u0011\u0011\u001a\u0006\u0003w\u0019LA!!4\u0002J\n)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007bBA\u001a\u0019\u0001\u0007\u0011QG\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$\u0002\"!6\u0002`\u0006\u0005\u0018Q\u001d\t\u0006\u0007\u0006e\u0013q\u001b\t\u0005\u00033\fY.\u0004\u0002\u0002>%!\u0011Q\\A\u001f\u0005\u0011qu\u000eZ3\t\u000b\u0015l\u0001\u0019\u00012\t\r\u0005\rX\u00021\u0001Y\u0003\tIG\rC\u0004\u000245\u0001\r!!\u000e\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fGCCAv\u0003{\u00149A!\u0003\u0003\fA1\u0011Q^Az\u0003ol!!a<\u000b\u0007\u0005EH)\u0001\u0006d_2dWm\u0019;j_:LA!!>\u0002p\n\u00191+Z9\u0011\t\u0005]\u0014\u0011`\u0005\u0005\u0003w\fIJA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\t\u000f\u0005}h\u00021\u0001\u0003\u0002\u00051Ao\u001c9jGN\u0004b!!<\u0003\u0004\u0005\u0005\u0016\u0002\u0002B\u0003\u0003_\u00141aU3u\u0011\u001d\t\u0019D\u0004a\u0001\u0003kA\u0011\"!.\u000f!\u0003\u0005\r!!\u0013\t\u0013\u0005ef\u0002%AA\u0002\u0005%\u0013AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTC\u0001B\tU\u0011\tIEa\u0005,\u0005\tU\u0001\u0003\u0002B\f\u0005Ci!A!\u0007\u000b\t\tm!QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\bE\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0011IBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nAbZ3u\u00032dGk\u001c9jGN$BA!\u0001\u0003,!9!QF\tA\u0002\t=\u0012a\u0004;f]\u0006tG\u000f\u0015:fM&Dx\n\u001d;\u0011\u000b\r\u000bI&!)\u0002%\u001d,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005k\u0011i\u0004\u0005\u0004\u0002n\n\r!q\u0007\t\u0005\u00033\u0014I$\u0003\u0003\u0003<\u0005u\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003?\u0013\u0002\u0019AAQ\u0003)9W\r\u001e+pa&\u001c\u0017\n\u001a\u000b\u0005\u0005\u0007\u0012I\u0005\u0005\u0003\u0002Z\n\u0015\u0013\u0002\u0002B$\u0003{\u0011A!V;jI\"9\u0011qT\nA\u0002\u0005\u0005\u0016\u0001D4fiR{\u0007/[2OC6,G\u0003\u0002B\u0018\u0005\u001fBqA!\u0015\u0015\u0001\u0004\u0011\u0019%A\u0004u_BL7-\u00133\u0002\u001d!\f7/\u00117jm\u0016\u0014%o\\6feR!\u0011\u0011\nB,\u0011\u00151V\u00031\u0001Y\u00039I7O\u0011:pW\u0016\u0014h)\u001a8dK\u0012$B!!\u0013\u0003^!)aK\u0006a\u00011\u0006!\u0012n\u001d\"s_.,'o\u00155viRLgn\u001a#po:$B!!\u0013\u0003d!)ak\u0006a\u00011\u0006yq-\u001a;BY&4XM\u0011:pW\u0016\u00148\u000f\u0006\u0002\u0003jA1\u0011q\fB6\u0005_JAA!\u001c\u0002t\tA\u0011\n^3sC\ndW\r\u0005\u0003\u0003r\t]TB\u0001B:\u0015\r\u0011)HZ\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0005s\u0012\u0019H\u0001\bCe>\\WM]'fi\u0006$\u0017\r^1\u0015\t\t%$Q\u0010\u0005\u0006Kf\u0001\rAY\u0001\u0013O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$W\r\u0006\u0004\u0002V\n\r%Q\u0011\u0005\u0006-j\u0001\r\u0001\u0017\u0005\b\u0003gQ\u0002\u0019AA\u001b\u000359W\r\u001e\"s_.,'\u000fV1hgR!!1\u0012BI!!\t\u0019K!$\u0002\"\u0006\u0005\u0016\u0002\u0002BH\u0003_\u00131!T1q\u0011\u001516\u00041\u0001Y\u0003=9W\r\u001e\"s_.,'oQ3mY&#Gc\u0001-\u0003\u0018\")a\u000b\ba\u00011\u0006\u0019r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3fgR!!Q\u0014BP!\u0019\ti/a=\u0002X\"9\u00111G\u000fA\u0002\u0005U\u0012\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0011)K!.\u00038B)1)!\u0017\u0003(B!!\u0011\u0016BX\u001d\u0011\tIHa+\n\t\t5\u00161S\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u00032\nM&\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0005[\u000b\u0019\nC\u0004\u0002 z\u0001\r!!)\t\r\tef\u00041\u0001Y\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002#\u001d,G\u000fU1si&$\u0018n\u001c8J]\u001a|7\u000f\u0006\u0002\u0003@B1\u0011Q^Az\u0005O\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002Bc\u0005\u000f\u0004BaQA-1\"9\u0011q\u0014\u0011A\u0002\u0005\u0005\u0016a\u0004;pa&\u001cg*Y7fgR{\u0017\nZ:\u0015\u0005\t5\u0007\u0003CA\u0006\u0005\u001f\f\tKa\u0011\n\t\t=\u0015QB\u0001\u0010i>\u0004\u0018nY%egR{g*Y7fgR\u0011!Q\u001b\t\t\u0003\u0017\u0011yMa\u0011\u0002\"\u0006YAo\u001c9jG&#\u0017J\u001c4p)\t\u0011Y\u000eE\u0004D\u0005;\u0014iM!6\n\u0007\t}GI\u0001\u0004UkBdWMM\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0003+\u0014)Oa:\u0003j\"9\u0011q\u0014\u0013A\u0002\u0005\u0005\u0006B\u0002B]I\u0001\u0007\u0001\fC\u0004\u00024\u0011\u0002\r!!\u000e\u00029\u001d,G\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1F]\u0012\u0004x.\u001b8ugR1!q\u001eBy\u0005k\u0004r!a)\u0003\u000eb\u000b9\u000eC\u0004\u0003t\u0016\u0002\rAa\u000e\u0002\u0005Q\u0004\bbBA\u001aK\u0001\u0007\u0011QG\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u0011!1 \t\u0006\u0007\u0006e#Q \t\u0004\u0013\n}\u0018bAB\u0001y\t\u00112)Y2iK\u0012\u001cuN\u001c;s_2dWM]%e\u0003Y9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6fe&#WC\u0001Bc\u0003Q9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6feR!!QYB\u0006\u0011\u0015)\u0007\u00061\u0001c\u0003M9W\r^!mSZ,'I]8lKJ,\u0005o\\2i)\u0011\u0019\tb!\u0007\u0011\u000b\r\u000bIfa\u0005\u0011\u0007\r\u001b)\"C\u0002\u0004\u0018\u0011\u0013A\u0001T8oO\")a+\u000ba\u00011\u0006\u0011r-\u001a;DYV\u001cH/\u001a:NKR\fG-\u0019;b)\u0019\u0019yb!\n\u0004*A!\u0011\u0011\\B\u0011\u0013\u0011\u0019\u0019#!\u0010\u0003\u000f\rcWo\u001d;fe\"91q\u0005\u0016A\u0002\u0005\u0005\u0016!C2mkN$XM]%e\u0011\u001d\t\u0019D\u000ba\u0001\u0003k\tqc\u001d;bi\u0016\u001c\u0005.\u00198hKR\u0013\u0018mY3F]\u0006\u0014G.\u001a3\u0015\u0005\u0005%\u0013a\u00057pON#\u0018\r^3DQ\u0006tw-\u001a+sC\u000e,GcA8\u00044!91Q\u0007\u0017A\u0002\u0005\u0005\u0016aA:ue\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0002J\rm\u0002bBAP[\u0001\u0007\u0011\u0011\u0015\u000b\u0005\u0003\u0013\u001ay\u0004C\u0004\u0003t:\u0002\rAa\u000e\u0002\u0011M,G/S7bO\u0016$2a\\B#\u0011\u0019\u00199e\fa\u0001E\u0006Aa.Z<J[\u0006<W-\u0001\u0004d_:4\u0017n\u001a\u000b\u0005\u0007\u001b\u001a\u0019\u0006\u0005\u0003\u0002\f\r=\u0013\u0002BB)\u0003\u001b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0019)\u0006\ra\u0001\u0007/\nabY8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u0004Z\ruSBAB.\u0015\u0011\u0019I%!\u0010\n\t\r}31\f\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0003Q!Wm]2sS\n,7\t\\5f]R\fVo\u001c;bgR!1QMB7!\u0011\u00199g!\u001b\u000e\u0005\u0005M\u0015\u0002BB6\u0003'\u0013\u0001\u0005R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rR1uC\"91qN\u0019A\u0002\rE\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0007O\u001a\u0019(\u0003\u0003\u0004v\u0005M%a\b#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fR1uC\u0006AB-Z:de&\u0014WmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\rm4\u0011\u0011\t\u0005\u0007O\u001ai(\u0003\u0003\u0004\u0000\u0005M%\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0007bBB8e\u0001\u000711\u0011\t\u0005\u0007O\u001a))\u0003\u0003\u0004\b\u0006M%a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e#bi\u0006\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u000b\u0003\u0007\u001b\u0003Baa$\u0004\u00166\u00111\u0011\u0013\u0006\u0005\u0003\u007f\u0019\u0019J\u0003\u0002>M&!1qSBI\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001\u00034fCR,(/Z:\u0015\u0005\ru\u0005\u0003BBH\u0007?KAa!)\u0004\u0012\nAa)Z1ukJ,7/\u0001\tjg\n\u0013xn[3s\t\u0016<'/\u00193fIR!\u0011\u0011JBT\u0011\u00151V\u00071\u0001Y\u0003eI7O\u0011:pW\u0016\u00148i\\7q_:,g\u000e\u001e#fOJ\fG-\u001a3\u0015\r\u0005%3QVBX\u0011\u00151f\u00071\u0001Y\u0011\u001d\u0019\tL\u000ea\u0001\u0007g\u000b\u0011bY8na>tWM\u001c;\u0011\t\rU6QX\u0007\u0003\u0007oSAA!\u001e\u0004:*\u001911\u00184\u0002\u000f\rd\u0017.\u001a8ug&!1qXB\\\u0005=\u0011%o\\6fe\u000e{W\u000e]8oK:$\u0018\u0001E7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;f)\u0011\u0019)ma5\u0011\u000b\r\u000bIfa2\u0011\t\r%7qZ\u0007\u0003\u0007\u0017T1a!4=\u0003\u0011a\u0017N\\6\n\t\rE71\u001a\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0011\u001d\u0019)n\u000ea\u0001\u0003C\u000bQ\u0001^8qS\u000e\fa\u0003\\5oW\u000e{wN\u001d3j]\u0006$xN]#oC\ndW\rZ\u000b\u0003\u0003\u0013\u0002")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (None$.MODULE$.equals(tenantPrefixOpt)) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (tenantPrefixOpt instanceof Some) {
            String tenantName = (String)((Some)tenantPrefixOpt).value();
            return CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(tenantPrefixOpt);
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala((Map)this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala((Map)this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced())).flatMap((Function1 & Serializable)x$10 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$10.node(listenerName.value()))));
    }

    @Override
    public scala.collection.immutable.Map<String, String> getBrokerTags(int brokerId) {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.fenced()))).flatMap((Function1 & Serializable)x$12 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$12.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas)).setObservers(Replicas.toList((int[])partition.observers))));
    }

    @Override
    public Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfos() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().topics().topicsByName().values()).asScala().flatMap((Function1 & Serializable)img -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(img.partitions().keySet()).asScala().map((Function1 & Serializable)partitionId -> (UpdateMetadataRequestData.UpdateMetadataPartitionState)this.getPartitionInfo(img.name(), Predef$.MODULE$.Integer2int(partitionId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getPartitionInfos$3(p)))).toSeq();
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<Map<String, Uuid>, Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public Features features() {
        MetadataImage image = this._currentImage();
        return new Features(image.features().metadataVersion(), image.features().finalizedVersions(), image.highestOffsetAndEpoch().offset(), true);
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        TopicImage topicImage = this._currentImage().topics().getTopic(topic);
        if (topicImage == null) {
            return None$.MODULE$;
        }
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())).map((Function1 & Serializable)state -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)state));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if (broker.fenced() || !broker.listeners().containsKey(listenerName$3.value())) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionInfos$3(UpdateMetadataRequestData.UpdateMetadataPartitionState p) {
        return p != null;
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int replicaId) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)replicaId);
        boolean bl = false;
        Some some = null;
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(replicaId));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
            return result$1.put((Object)n, (Object)node);
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((BrokerRegistration)some.value()).fenced()) {
                node = Node.noNode();
                return result$1.put((Object)n, (Object)node);
            }
        }
        if (!bl) throw new MatchError((Object)option);
        BrokerRegistration broker = (BrokerRegistration)some.value();
        node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable)() -> Node.noNode());
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)tp$1.partition()))).foreach((Function1 & Serializable)partition -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replicaId -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)replicaId)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            return !(brokerComponent != null ? !brokerComponent.equals(component$1) : component$1 != null);
        });
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

