/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.serdes.CompactionCommitAndSwap;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.utils.CoreUtils;

public class TierCompactionCommitAndSwap
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 128;
    private final TopicIdPartition topicIdPartition;
    private final CompactionCommitAndSwap compactionMetadata;

    public TierCompactionCommitAndSwap(TopicIdPartition topicIdPartition, int tierEpoch, OffsetAndEpoch stateOffset, UUID messageId, Set<UUID> sourceObjectIds, Set<UUID> destinationObjectIds, long lastCleanOffset, CompactStats compactStats) {
        if (sourceObjectIds.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one source object for any TierCompactionCommitAndSwap operation. TopicIdPartition: " + topicIdPartition + " destinationObjectIds: " + destinationObjectIds);
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(128).forceDefaults(false);
        CompactionCommitAndSwap.startSourceObjectIdsVector(builder, sourceObjectIds.size());
        for (UUID uUID : sourceObjectIds) {
            kafka.tier.serdes.UUID.createUUID(builder, uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        }
        int sourceObjectIdsOffset = builder.endVector();
        CompactionCommitAndSwap.startDestinationObjectIdsVector(builder, destinationObjectIds.size());
        for (UUID destId : destinationObjectIds) {
            kafka.tier.serdes.UUID.createUUID(builder, destId.getMostSignificantBits(), destId.getLeastSignificantBits());
        }
        int n = builder.endVector();
        CompactionCommitAndSwap.startCompactionCommitAndSwap(builder);
        int messageIdOffset = kafka.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        CompactionCommitAndSwap.addMessageId(builder, messageIdOffset);
        CompactionCommitAndSwap.addSourceObjectIds(builder, sourceObjectIdsOffset);
        CompactionCommitAndSwap.addDestinationObjectIds(builder, n);
        CompactionCommitAndSwap.addVersion(builder, (byte)0);
        CompactionCommitAndSwap.addTierEpoch(builder, tierEpoch);
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        CompactionCommitAndSwap.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        CompactionCommitAndSwap.addLastCleanOffset(builder, lastCleanOffset);
        if (compactStats != CompactStats.EMPTY) {
            int compactStatsOffset = kafka.tier.serdes.CompactStats.createCompactStats(builder, compactStats.bytesRead(), compactStats.bytesWritten(), compactStats.dirtyBytesRead());
            CompactionCommitAndSwap.addCompactStats(builder, compactStatsOffset);
        }
        int entryId = CompactionCommitAndSwap.endCompactionCommitAndSwap(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.compactionMetadata = CompactionCommitAndSwap.getRootAsCompactionCommitAndSwap(builder.dataBuffer());
    }

    public TierCompactionCommitAndSwap(TopicIdPartition topicIdPartition, int tierEpoch, UUID messageId, UUID destinationObjectId, OffsetAndEpoch stateOffset, Set<UUID> sourceObjectIds, long lastCleanOffset, CompactStats stats) {
        this(topicIdPartition, tierEpoch, stateOffset, messageId, sourceObjectIds, new HashSet<UUID>(Collections.singletonList(destinationObjectId)), lastCleanOffset, stats);
    }

    public TierCompactionCommitAndSwap(TierSegmentUploadInitiate uploadInitiate, UUID messageId, Set<UUID> sourceObjectIds, long lastCleanOffset, CompactStats compactStats) {
        this(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), messageId, uploadInitiate.objectId(), uploadInitiate.stateOffsetAndEpoch(), sourceObjectIds, lastCleanOffset, compactStats);
    }

    public TierCompactionCommitAndSwap(TopicIdPartition topicIdPartition, CompactionCommitAndSwap metadata) {
        this.topicIdPartition = topicIdPartition;
        this.compactionMetadata = metadata;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.CompactionCommitAndSwap;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.compactionMetadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return new OffsetAndEpoch(this.compactionMetadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.compactionMetadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID uuid = this.compactionMetadata.messageId();
        return new UUID(uuid.mostSignificantBits(), uuid.leastSignificantBits());
    }

    public int sourceObjectIdsLength() {
        return this.compactionMetadata.sourceObjectIdsLength();
    }

    public UUID sourceObjectIdsGet(int i) {
        kafka.tier.serdes.UUID uuid = this.compactionMetadata.sourceObjectIds(i);
        return new UUID(uuid.mostSignificantBits(), uuid.leastSignificantBits());
    }

    public UUID destinationObjectIdsGet(int i) {
        kafka.tier.serdes.UUID uuid = this.compactionMetadata.destinationObjectIds(i);
        return new UUID(uuid.mostSignificantBits(), uuid.leastSignificantBits());
    }

    public int destinationObjectIdsLength() {
        return this.compactionMetadata.destinationObjectIdsLength();
    }

    public long lastCleanOffset() {
        return this.compactionMetadata.lastCleanOffset();
    }

    public CompactStats compactStats() {
        kafka.tier.serdes.CompactStats stats = this.compactionMetadata.compactStats();
        return stats == null ? CompactStats.EMPTY : new CompactStats(stats);
    }

    public String toString() {
        return "TierCompactionCommitAndSwap(version=" + this.compactionMetadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", sourceObjectIds=" + this.sourceObjectIdsToString() + ", destinationObjectIds=" + this.destinationObjectIdsToString() + ", lastCleanOffset=" + this.lastCleanOffset() + ", compactStats=" + this.compactStats() + ")";
    }

    private String destinationObjectIdsToString() {
        int destinationObjectIdsLength = this.destinationObjectIdsLength();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < destinationObjectIdsLength; ++i) {
            builder.append(CoreUtils.uuidToBase64(this.destinationObjectIdsGet(i)));
            if (i == destinationObjectIdsLength - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    private String sourceObjectIdsToString() {
        int sourceObjectIdsLength = this.sourceObjectIdsLength();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < sourceObjectIdsLength; ++i) {
            builder.append(CoreUtils.uuidToBase64(this.sourceObjectIdsGet(i)));
            if (i == sourceObjectIdsLength - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

