/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

public class KRaftSnapshotMetrics
implements AutoCloseable {
    static final String METRIC_GROUP_NAME = "raft-backup-metrics";
    private final Metrics metrics;
    static final String METRIC_UPLOAD_LAG_NAME = "metadata-upload-lag-ms";
    private volatile long lastUploadMs = -1L;
    private final MetricName uploadLag;
    static final String METRIC_ERROR_NAME = "metadata-error";
    private volatile boolean hasError;
    private final MetricName error;
    static final String METRIC_PUT_LATENCY_PREFIX = "put-latency-ms";
    private final Sensor putLatency;
    static final String METRIC_DELETE_LATENCY_PREFIX = "delete-latency-ms";
    private final Sensor deleteLatency;
    static final String METRIC_50_PERCENTILE_SUFFIX = "-50-percentile";
    static final String METRIC_90_PERCENTILE_SUFFIX = "-90-percentile";
    static final String METRIC_99_PERCENTILE_SUFFIX = "-99-percentile";

    public KRaftSnapshotMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.uploadLag = metrics.metricName(METRIC_UPLOAD_LAG_NAME, METRIC_GROUP_NAME, "The amount of time in milliseconds, since last upload");
        metrics.addMetric(this.uploadLag, (mConfig, currentTimeMs) -> this.lastUploadMs == -1L ? -1.0 : (double)(currentTimeMs - this.lastUploadMs));
        this.error = metrics.metricName(METRIC_ERROR_NAME, METRIC_GROUP_NAME, "The health of KRaft snapshot manager");
        metrics.addMetric(this.error, (mConfig, currentTimeMs) -> this.hasError ? 1.0 : 0.0);
        double maxLatencyMs = 30000.0;
        int totalBucketSizeInBytes = (int)maxLatencyMs * 4;
        this.putLatency = metrics.sensor(METRIC_PUT_LATENCY_PREFIX);
        MetricName put50PercentileLatency = metrics.metricName("put-latency-ms-50-percentile", METRIC_GROUP_NAME, "The 50-Percentile latency for PUT calls in ms", Collections.emptyMap());
        MetricName put90PercentileLatency = metrics.metricName("put-latency-ms-90-percentile", METRIC_GROUP_NAME, "The 90-Percentile latency for PUT calls in ms", Collections.emptyMap());
        MetricName put99PercentileLatency = metrics.metricName("put-latency-ms-99-percentile", METRIC_GROUP_NAME, "The 99-Percentile latency for PUT calls in ms", Collections.emptyMap());
        Percentile putLatency50Percentile = new Percentile(put50PercentileLatency, 50.0);
        Percentile putLatency90Percentile = new Percentile(put90PercentileLatency, 90.0);
        Percentile putLatency99Percentile = new Percentile(put99PercentileLatency, 99.0);
        Percentiles putLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{putLatency50Percentile, putLatency90Percentile, putLatency99Percentile});
        this.putLatency.add((CompoundStat)putLatencyPercentiles);
        this.deleteLatency = metrics.sensor(METRIC_DELETE_LATENCY_PREFIX);
        MetricName delete50PercentileLatency = metrics.metricName("delete-latency-ms-50-percentile", METRIC_GROUP_NAME, "The 50-Percentile latency for DELETE calls in ms", Collections.emptyMap());
        MetricName delete90PercentileLatency = metrics.metricName("delete-latency-ms-90-percentile", METRIC_GROUP_NAME, "The 90-Percentile latency for DELETE calls in ms", Collections.emptyMap());
        MetricName delete99PercentileLatency = metrics.metricName("delete-latency-ms-99-percentile", METRIC_GROUP_NAME, "The 99-Percentile latency for DELETE calls in ms", Collections.emptyMap());
        Percentile deleteLatency50Percentile = new Percentile(delete50PercentileLatency, 50.0);
        Percentile deleteLatency90Percentile = new Percentile(delete90PercentileLatency, 90.0);
        Percentile deleteLatency99Percentile = new Percentile(delete99PercentileLatency, 99.0);
        Percentiles deleteLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{deleteLatency50Percentile, deleteLatency90Percentile, deleteLatency99Percentile});
        this.deleteLatency.add((CompoundStat)deleteLatencyPercentiles);
    }

    public void updateLastUploadMs(long timeMs) {
        this.lastUploadMs = timeMs;
    }

    public Sensor putLatencySensor() {
        return this.putLatency;
    }

    public Sensor deleteLatencySensor() {
        return this.deleteLatency;
    }

    public void updateError(boolean errorValue) {
        this.hasError = errorValue;
    }

    @Override
    public void close() throws Exception {
        Arrays.asList(this.uploadLag, this.error).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        Arrays.asList(this.putLatency.name(), this.deleteLatency.name()).forEach(arg_0 -> ((Metrics)this.metrics).removeSensor(arg_0));
    }
}

