/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ua\u0001\u0002'N\u0001IC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")a\u000e\u0001C\u0001_\")1\u000f\u0001C\u0001i\"I\u0011Q\f\u0001\u0012\u0002\u0013\u0005\u0011q\f\u0005\n\u0003k\u0002\u0011\u0013!C\u0001\u0003oB\u0011\"a\u001f\u0001#\u0003%\t!! \t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005u\u0004\"CAB\u0001E\u0005I\u0011AAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017C\u0011\"a.\u0001#\u0003%\t!a\u001e\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005m\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003{B\u0011\"a;\u0001#\u0003%\t!! \t\u0013\u00055\b!%A\u0005\u0002\u0005u\u0004\"CAx\u0001E\u0005I\u0011AAC\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDq!!?\u0001\t\u0003\tY\u0010C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0003\u001a!9!Q\u0004\u0001\u0005\u0002\t}\u0001\"\u0003B\u0019\u0001E\u0005I\u0011AA?\u0011%\u0011\u0019\u0004AI\u0001\n\u0003\ti\bC\u0005\u00036\u0001\t\n\u0011\"\u0001\u0002\u0006\"9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\n\u0005_\u0002\u0011\u0013!C\u0001\u0005cB\u0011B!\u001e\u0001#\u0003%\tAa\u001e\t\u0013\tm\u0004!%A\u0005\u0002\u0005u\u0004\"\u0003B?\u0001E\u0005I\u0011\u0001B@\u0011%\u0011\u0019\tAI\u0001\n\u0003\t)\tC\u0004\u0003\u0006\u0002!\tAa\"\t\u0013\t]\u0005!%A\u0005\u0002\tE\u0004b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005S\u0003A\u0011\u0001BV\u0011%\u00119\fAI\u0001\n\u0003\t)\tC\u0004\u0003:\u0002!IAa/\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!Q\u001b\u0001\u0005\u0002\t]\u0007\"\u0003Bu\u0001E\u0005I\u0011AA?\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[DqA!>\u0001\t\u0003\u00119\u0010C\u0004\u0003\u0000\u0002!\ta!\u0001\t\u0013\r-\u0001!%A\u0005\u0002\u0005u\u0004bBB\u0007\u0001\u0011\u00051q\u0002\u0005\b\u0007/\u0001A\u0011AB\r\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007GAqa!\u000b\u0001\t\u0003\u0019Y\u0003C\u0004\u00042\u0001!\taa\r\t\u000f\re\u0002\u0001\"\u0001\u0004<!91\u0011\t\u0001\u0005\u0002\r\r\u0003bBB!\u0001\u0011\u000511\n\u0005\b\u0007#\u0002A\u0011AB*\u0011\u001d\u00199\u0006\u0001C\u0001\u00073Bqaa\u001c\u0001\t\u0003\u0019\t\bC\u0004\u0004v\u0001!\taa\u001e\t\u000f\rm\u0004\u0001\"\u0003\u0004~!I11\u0012\u0001\u0012\u0002\u0013%\u0011Q\u0010\u0005\b\u0007\u001b\u0003A\u0011ABH\u0011\u001d\u0019)\n\u0001C\u0001\u0007/Cqaa'\u0001\t\u0003\u0019i\nC\u0004\u0004\"\u0002!\taa)\t\u000f\t5\u0003\u0001\"\u0001\u0004,\"9!Q\n\u0001\u0005\u0002\rU\u0006bBB]\u0001\u0011\u000511\u0018\u0005\b\u0007\u0017\u0004A\u0011ABg\u0011\u001d\u0019\u0019\u000e\u0001C\u0001\u0007+Dqaa8\u0001\t\u0003\u0019\t\u000fC\u0004\u0004f\u0002!\taa:\t\u000f\r=\b\u0001\"\u0001\u0004r\"91q\u001f\u0001\u0005\u0002\rex!\u0003C\u0004\u001b\u0006\u0005\t\u0012\u0001C\u0005\r!aU*!A\t\u0002\u0011-\u0001B\u00028J\t\u0003!i\u0001C\u0005\u0005\u0010%\u000b\n\u0011\"\u0001\u0005\u0012\ti\u0011\tZ7j]j[7\t\\5f]RT!AT(\u0002\u0005i\\'\"\u0001)\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aU-\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g!\tQV,D\u0001\\\u0015\tav*A\u0003vi&d7/\u0003\u0002_7\n9Aj\\4hS:<\u0017\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u0005\u0014W\"A'\n\u0005\rl%!D&bM.\f'l[\"mS\u0016tG/A\u0006lC\u001a\\\u0017mQ8oM&<\u0007c\u0001+gQ&\u0011q-\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%dW\"\u00016\u000b\u0005-|\u0015AB:feZ,'/\u0003\u0002nU\nY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0019\u0001/\u001d:\u0011\u0005\u0005\u0004\u0001\"B0\u0004\u0001\u0004\u0001\u0007b\u00023\u0004!\u0003\u0005\r!Z\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\tvq\u0006-\u0011QCA\r\u0003[\ti$a\u0012\u0002LA\u0011AK^\u0005\u0003oV\u0013A!\u00168ji\")\u0011\u0010\u0002a\u0001u\u0006)Ao\u001c9jGB\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~+6\taP\u0003\u0002\u0000#\u00061AH]8pizJ1!a\u0001V\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111A+\t\u000f\u00055A\u00011\u0001\u0002\u0010\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0007Q\u000b\t\"C\u0002\u0002\u0014U\u00131!\u00138u\u0011\u001d\t9\u0002\u0002a\u0001\u0003\u001f\t\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011%\tY\u0002\u0002I\u0001\u0002\u0004\ti\"A\u0006u_BL7mQ8oM&<\u0007\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0005kRLGN\u0003\u0002\u0002(\u0005!!.\u0019<b\u0013\u0011\tY#!\t\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0005\u00020\u0011\u0001\n\u00111\u0001\u00022\u0005i!/Y2l\u0003^\f'/Z'pI\u0016\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oy\u0015!B1e[&t\u0017\u0002BA\u001e\u0003k\u0011QBU1dW\u0006;\u0018M]3N_\u0012,\u0007\"CA \tA\u0005\t\u0019AA!\u0003E)8/Z:N_\u0012,'O\u001c+pa&\u001c\u0017\n\u001a\t\u0004)\u0006\r\u0013bAA#+\n9!i\\8mK\u0006t\u0007\"CA%\tA\u0005\t\u0019AA!\u0003E)8/Z:MK\u001e\f7-\u001f+pa&\u001c\u0017\n\u001a\u0005\n\u0003\u001b\"\u0001\u0013!a\u0001\u0003\u001f\n1b\u00197vgR,'\u000fT5oWB!AKZA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,U\u0006!A.\u001b8l\u0013\u0011\tY&!\u0016\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\"TCAA1U\u0011\ti\"a\u0019,\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001cV\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\nIGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'\u0006\u0002\u0002z)\"\u0011\u0011GA2\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIY*\"!a +\t\u0005\u0005\u00131M\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00138\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIa*\"!a\"+\t\u0005=\u00131M\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002\u000e\u00065\u0016q\u0016\t\u0007\u0003\u001f\u000b)*!'\u000e\u0005\u0005E%bAAJ+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0015\u0011\u0013\u0002\u0004'\u0016\f\b\u0003BAN\u0003Sk!!!(\u000b\t\u0005]\u0012q\u0014\u0006\u0004!\u0006\u0005&\u0002BAR\u0003K\u000ba!\u00199bG\",'BAAT\u0003\ry'oZ\u0005\u0005\u0003W\u000biJ\u0001\bCe>\\WM]'fi\u0006$\u0017\r^1\t\u0013\u0005=\"\u0002%AA\u0002\u0005E\u0002\"CAY\u0015A\u0005\t\u0019AAZ\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0005)\u001a\f)\f\u0005\u0004\u0002\u0010\u0006U\u0015qB\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003q9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:%I\u00164\u0017-\u001e7uII*\"!!0+\t\u0005M\u00161M\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000fF\bv\u0003\u0007\f)-!3\u0002`\u0006\r\u0018Q]At\u0011\u0015IX\u00021\u0001{\u0011\u001d\t9-\u0004a\u0001\u0003;\taaY8oM&<\u0007bBAf\u001b\u0001\u0007\u0011QZ\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\t\u0003\u001f\u000by-a\u0004\u0002T&!\u0011\u0011[AI\u0005\ri\u0015\r\u001d\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\(\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002^\u0006]'!\u0005*fa2L7-Y!tg&<g.\\3oi\"I\u0011\u0011]\u0007\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\tm\u0006d\u0017\u000eZ1uK\"I\u0011qH\u0007\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003\u0013j\u0001\u0013!a\u0001\u0003\u0003B\u0011\"!\u0014\u000e!\u0003\u0005\r!a\u0014\u0002G\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012*\u0014aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$HEN\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003-!x\u000e]5d\u000bbL7\u000f^:\u0015\t\u0005\u0005\u0013Q\u001f\u0005\u0007\u0003o\u0014\u0002\u0019\u0001>\u0002\u0013Q|\u0007/[2OC6,\u0017a\u0005<bY&$\u0017\r^3U_BL7m\u0011:fCR,GcC;\u0002~\u0006}(\u0011\u0001B\u0002\u0005'AQ!_\nA\u0002iDq!a3\u0014\u0001\u0004\ti\rC\u0004\u0002HN\u0001\r!!\b\t\u000f\t\u00151\u00031\u0001\u0003\b\u0005qAo\u001c9jGN\u001cV\u000f\u001d9mS\u0016\u0014\b#\u0002+\u0003\n\t5\u0011b\u0001B\u0006+\nIa)\u001e8di&|g\u000e\r\t\u0006\u0003\u001f\u0013yA_\u0005\u0005\u0005#\t\tJA\u0002TKRD\u0011B!\u0006\u0014!\u0003\u0005\rA!\u0004\u0002\u001b\r\u0014X-\u0019;fIR{\u0007/[2t\u0003u1\u0018\r\\5eCR,Gk\u001c9jG\u000e\u0013X-\u0019;fI\u0011,g-Y;mi\u0012*TC\u0001B\u000eU\u0011\u0011i!a\u0019\u0002;]\u0014\u0018\u000e^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$R\"\u001eB\u0011\u0005G\u00119Ca\u000b\u0003.\t=\u0002\"B=\u0016\u0001\u0004Q\bb\u0002B\u0013+\u0001\u0007\u0011QZ\u0001\u0012e\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bb\u0002B\u0015+\u0001\u0007\u0011\u0011I\u0001\tSN,\u0006\u000fZ1uK\"I\u0011qH\u000b\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003\u0013*\u0002\u0013!a\u0001\u0003\u0003B\u0011\"!\u0014\u0016!\u0003\u0005\r!a\u0014\u0002O]\u0014\u0018\u000e^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001(oJLG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\!tg&<g.\\3oi\u0012\"WMZ1vYR$S'A\u0014xe&$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u00122\u0014a\u00033fY\u0016$X\rV8qS\u000e$2!\u001eB\u001e\u0011\u0015I\u0018\u00041\u0001{\u00035\tG\r\u001a)beRLG/[8ogR!\u0012Q\u001aB!\u0005\u0007\u00129Ea\u0013\u0003P\tM#q\u000bB5\u0005WBQ!\u001f\u000eA\u0002iDqA!\u0012\u001b\u0001\u0004\ti-\u0001\nfq&\u001cH/\u001b8h\u0003N\u001c\u0018n\u001a8nK:$\bb\u0002B%5\u0001\u0007\u0011QR\u0001\u000bC2d'I]8lKJ\u001c\b\"\u0003B'5A\u0005\t\u0019AA\b\u00035qW/\u001c)beRLG/[8og\"I!Q\u0005\u000e\u0011\u0002\u0003\u0007!\u0011\u000b\t\u0005)\u001a\fi\rC\u0005\u0003Vi\u0001\n\u00111\u0001\u0002B\u0005aa/\u00197jI\u0006$Xm\u00148ms\"I!\u0011\f\u000e\u0011\u0002\u0003\u0007!1L\u0001\u000fi>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u!\u0011!fM!\u0018\u0011\t\t}#QM\u0007\u0003\u0005CRAAa\u0019\u0002 \u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0003h\t\u0005$A\u0004+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u0005\n\u0003\u001bR\u0002\u0013!a\u0001\u0003\u001fBqA!\u001c\u001b\u0001\u0004\t\t%\u0001\rsC\u000e\\W*\u001b=j]\u001e\u001cV\u000f\u001d9peR,e.\u00192mK\u0012\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM$\u0006BA\b\u0003G\nq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\te$\u0006\u0002B)\u0003G\nq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012:TC\u0001BAU\u0011\u0011Y&a\u0019\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012B\u0014!H2sK\u0006$XMT3x!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:lWM\u001c;\u0015!\u00055'\u0011\u0012BF\u0005\u001b\u0013yI!%\u0003\u0014\nU\u0005\"B=!\u0001\u0004Q\bb\u0002B#A\u0001\u0007\u0011Q\u001a\u0005\b\u0005\u0013\u0002\u0003\u0019AAG\u0011%\u0011i\u0005\tI\u0001\u0002\u0004\ty\u0001C\u0004\u0003&\u0001\u0002\rA!\u0015\t\u000f\te\u0003\u00051\u0001\u0003\\!9!Q\u000e\u0011A\u0002\u0005\u0005\u0013aJ2sK\u0006$XMT3x!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\nQC^1mS\u0012\fG/\u001a(foB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0003\u001e\n\r&Q\u0015BT!\u001d!&qTA[\u0003\u001fI1A!)V\u0005\u0019!V\u000f\u001d7fe!)\u0011P\ta\u0001u\"9!Q\t\u0012A\u0002\u00055\u0007b\u0002B'E\u0001\u0007\u0011qB\u0001\u001fGJ,\u0017\r^3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5BgNLwM\\7f]R$\"\"!4\u0003.\n=&\u0011\u0017B[\u0011\u0015I8\u00051\u0001{\u0011\u001d\u0011)e\ta\u0001\u0003\u001bDqAa-$\u0001\u0004\ti-\u0001\foK^\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u\u0011%\tie\tI\u0001\u0002\u0004\ty%\u0001\u0015de\u0016\fG/\u001a)beRLG/[8og^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\rwC2LG-\u0019;f%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$HcB;\u0003>\n}&1\u0019\u0005\b\u0005K)\u0003\u0019AAg\u0011\u001d\u0011\t-\na\u0001\u0003\u001f\t\u0011$\u001a=qK\u000e$X\r\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"9!QY\u0013A\u0002\t\u001d\u0017AE1wC&d\u0017M\u00197f\u0005J|7.\u001a:JIN\u0004Ra\u001fBe\u0003\u001fIAA!\u0005\u0002\n\u0005Y\u0001/\u0019:tK\n\u0013xn[3s)\u0011\u0011yM!5\u0011\tQ3\u0017q\u0002\u0005\u0007\u0005'4\u0003\u0019\u0001>\u0002\r\t\u0014xn[3s\u00035\u0019\u0007.\u00198hK\u000e{gNZ5hgRIQO!7\u0003^\n\u0005(Q\u001d\u0005\u0007\u00057<\u0003\u0019\u0001>\u0002\u0015\u0015tG/\u001b;z)f\u0004X\r\u0003\u0004\u0003`\u001e\u0002\rA_\u0001\u000bK:$\u0018\u000e^=OC6,\u0007b\u0002BrO\u0001\u0007\u0011QD\u0001\bG>tg-[4t\u0011%\u00119o\nI\u0001\u0002\u0004\t\t%\u0001\bjgV\u001bXM]\"mS\u0016tG/\u00133\u0002/\rD\u0017M\\4f\u0007>tg-[4tI\u0011,g-Y;mi\u0012\"\u0014A\u0005;ss\u000ecW-\u00198Rk>$\u0018MT8eKN$\u0002\"!\u0011\u0003p\nE(1\u001f\u0005\u0007\u00057L\u0003\u0019\u0001>\t\r\t}\u0017\u00061\u0001{\u0011\u001d\u00119/\u000ba\u0001\u0003\u0003\nAc\u00195b]\u001e,7\t\\5f]RLEmQ8oM&<G#B;\u0003z\nu\bB\u0002B~U\u0001\u0007!0A\ttC:LG/\u001b>fI\u000ec\u0017.\u001a8u\u0013\u0012DqAa9+\u0001\u0004\ti\"\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR9Qoa\u0001\u0004\b\r%\u0001BBB\u0003W\u0001\u0007!0A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\rC\u0004\u0003d.\u0002\r!!\b\t\u0013\t\u001d8\u0006%AA\u0002\u0005\u0005\u0013\u0001K2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0005<bY&$\u0017\r^3Ja\u000e{gNZ5h)\u0015)8\u0011CB\u000b\u0011\u0019\u0019\u0019\"\fa\u0001u\u0006\u0011\u0011\u000e\u001d\u0005\b\u0005Gl\u0003\u0019AA\u000f\u0003Q1\u0018\r\\5eCR,G+\u001a8b]R\u001cuN\u001c4jOR)Qoa\u0007\u0004 !11Q\u0004\u0018A\u0002i\fa\u0001^3oC:$\bb\u0002Br]\u0001\u0007\u0011QD\u0001\u000fG\"\fgnZ3Ja\u000e{gNZ5h)\u0015)8QEB\u0014\u0011\u0019\u0019\u0019b\fa\u0001u\"9!1]\u0018A\u0002\u0005u\u0011AE2iC:<W\rV3oC:$8i\u001c8gS\u001e$R!^B\u0017\u0007_Aaa!\b1\u0001\u0004Q\bb\u0002Bra\u0001\u0007\u0011QD\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006k\u000eU2q\u0007\u0005\u0006sF\u0002\rA\u001f\u0005\b\u0005G\f\u0004\u0019AA\u000f\u0003E\u0019\u0007.\u00198hKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006k\u000eu2q\b\u0005\u0006sJ\u0002\rA\u001f\u0005\b\u0005G\u0014\u0004\u0019AA\u000f\u0003I\u0019\u0007.\u00198hK\n\u0013xn[3s\u0007>tg-[4\u0015\u000bU\u001c)e!\u0013\t\u000f\r\u001d3\u00071\u0001\u00026\u00069!M]8lKJ\u001c\bb\u0002Brg\u0001\u0007\u0011Q\u0004\u000b\u0006k\u000e53q\n\u0005\b\u0005'$\u0004\u0019\u0001Bh\u0011\u001d\u0011\u0019\u000f\u000ea\u0001\u0003;\tAC^1mS\u0012\fG/\u001a\"s_.,'oQ8oM&<GcA;\u0004V!9!1]\u001bA\u0002\u0005u\u0011aF2iC:<Wm\u00117vgR,'\u000fT5oW\u000e{gNZ5h)\u0015)81LB6\u0011\u001d\u0019iF\u000ea\u0001\u0007?\na\u0001\\5oW&#\u0007\u0003BB1\u0007Oj!aa\u0019\u000b\t\r\u0015\u0014qT\u0001\u0007G>lWn\u001c8\n\t\r%41\r\u0002\u0005+VLG\rC\u0004\u0004nY\u0002\r!!\b\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paN\faCZ3uG\"\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u000b\u0005\u0003;\u0019\u0019\bC\u0004\u0004^]\u0002\raa\u0018\u0002/\u0015t7/\u001e:f\u00072,8\u000f^3s\u0019&t7.\u0012=jgR\u001cHcA;\u0004z!91Q\f\u001dA\u0002\r}\u0013AE2iC:<W-\u00128uSRL8i\u001c8gS\u001e$\u0012\"^B@\u0007\u0007\u001b9i!#\t\r\r\u0005\u0015\b1\u0001{\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016Daa!\":\u0001\u0004Q\u0018a\u00064vY2\u001c\u0016M\\5uSj,G-\u00128uSRLh*Y7f\u0011\u001d\u0011\u0019/\u000fa\u0001\u0003;A\u0011Ba::!\u0003\u0005\r!!\u0011\u00029\rD\u0017M\\4f\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\tb-\u001a;dQ\u0016sG/\u001b;z\u0007>tg-[4\u0015\r\u0005u1\u0011SBJ\u0011\u0019\u0019\ti\u000fa\u0001u\"11QA\u001eA\u0002i\f!cZ3u\u00032dGk\u001c9jG\u000e{gNZ5hgR\u00111\u0011\u0014\t\b\u0003\u001f\u000byM_A\u000f\u0003U1W\r^2i\u00032dWI\u001c;jif\u001cuN\u001c4jON$Ba!'\u0004 \"1!1\\\u001fA\u0002i\f!DZ3uG\"\fE\u000e\\\"iS2$WI\u001c;jif\u001cuN\u001c4jON$ba!'\u0004&\u000e\u001d\u0006BBBA}\u0001\u0007!\u0010\u0003\u0004\u0004*z\u0002\rA_\u0001\u0010G\"LG\u000eZ#oi&$\u0018\u0010V=qKR!1QVBX!\u001d\ty)a4{\u0003\u001fAqa!-@\u0001\u0004\u0019\u0019,\u0001\u0004u_BL7m\u001d\t\u0005w\n%'\u0010\u0006\u0003\u0003P\u000e]\u0006\"B=A\u0001\u0004Q\u0018!E2sK\u0006$Xm\u00117vgR,'\u000fT5oWR)Qo!0\u0004H\"91qX!A\u0002\r\u0005\u0017aD2mkN$XM\u001d'j].$\u0015\r^1\u0011\u0007\u0005\u001c\u0019-C\u0002\u0004F6\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u0005\b\u0007\u0013\f\u0005\u0019AA\u000f\u0003E\u0001XM]:jgR,g\u000e^\"p]\u001aLwm]\u0001\u000fO\u0016$8\t\\;ti\u0016\u0014H*\u001b8l)\u0011\u0019ym!5\u0011\tQ37\u0011\u0019\u0005\b\u0007;\u0012\u0005\u0019AB0\u0003=9W\r^\"mkN$XM\u001d'j].\u001cH\u0003BBl\u00073\u0004\u0002\"a$\u0002P\u000e}3\u0011\u0019\u0005\b\u00077\u001c\u0005\u0019ABo\u0003\u001da\u0017N\\6JIN\u0004Ra\u001fBe\u0007?\n!cZ3u\u00032d7\t\\;ti\u0016\u0014H*\u001b8lgR\u001111\u001d\t\u0007\u0003\u001f\u000b)j!1\u0002\u001dM,Go\u00117vgR,'\u000fT5oWR)Qo!;\u0004l\"91qX#A\u0002\r\u0005\u0007bBBw\u000b\u0002\u0007\u0011qB\u0001!Kb\u0004Xm\u0019;fI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"T6NV3sg&|g.A\teK2,G/Z\"mkN$XM\u001d'j].$R!^Bz\u0007kDqa!\u0018G\u0001\u0004\u0019y\u0006C\u0004\u0004n\u001a\u0003\r!a\u0004\u0002A5\f\u0017PY3SK\u0016t7M]=qi\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwm\u001d\u000b\u0004k\u000em\bbBB\u007f\u000f\u0002\u00071q`\u0001\u0012G>tg-[4Ue\u0006t7OZ8s[\u0016\u0014\bc\u0002+\u0005\u0002\u0005uAQA\u0005\u0004\t\u0007)&!\u0003$v]\u000e$\u0018n\u001c82!\u0011!f-!\b\u0002\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u!\t\t\u0017j\u0005\u0002J'R\u0011A\u0011B\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0011M!fA3\u0002d\u0001")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Option<KafkaConfig> kafkaConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<KafkaConfig> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        java.util.List brokerMetadatas = CollectionConverters$.MODULE$.SeqHasAsJava(this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2())).asJava();
        Map replicaAssignment = (Map)CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)partitions, (int)replicationFactor, (int)-1, (int)-1)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            }
            throw new MatchError(null);
        });
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.ofNullable(broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config, (Function0<Set<String>>)(Function0 & Serializable)() -> $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1()), this.validateTopicCreate$default$5());
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config, Function0<Set<String>> topicsSupplier, Set<String> createdTopics) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set topics = (Set)topicsSupplier.apply();
            if (topics.contains((Object)topic) || createdTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)((SetOps)topics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)))).$plus$plus((IterableOnce)createdTopics.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$2(topic, x$4))));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$4(x$6)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$5(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable)x$8 -> x$8.extractLogConfigMap()).getOrElse((Function0 & Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$9.isRemoteLogStorageSystemEnabled()))));
    }

    public Set<String> validateTopicCreate$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
                topicIdOpt.orElse(() -> AdminZkClient.$anonfun$writeTopicPartitionAssignment$2((Option)legacyTopicIdOpt)).foreach((Function1 & Serializable)topicId -> {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Assigned topicId ").append(topicId).append(" to topic ").append(topic$3).toString());
                    return BoxedUnit.UNIT;
                });
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink, boolean rackMixingSupportEnabled) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement, rackMixingSupportEnabled);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement, boolean rackMixingSupportEnabled) {
        void var9_9;
        Tuple2<Seq<Object>, Object> tuple2 = this.validateNewPartitions(topic, existingAssignment, numPartitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq existingAssignmentPartition0 = (Seq)tuple2._1();
        int n = tuple2._2$mcI$sp();
        replicaAssignment.foreach(arg_0 -> AdminZkClient.$anonfun$createNewPartitionsAssignment$1$adapted(this, (Seq)var9_9, allBrokers, arg_0));
        return (Map)((Map)replicaAssignment.getOrElse(() -> AdminZkClient.$anonfun$createNewPartitionsAssignment$3(allBrokers, (Seq)var9_9, topicPlacement, n, rackMixingSupportEnabled, existingAssignment))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Tuple2<Seq<Object>, Object> validateNewPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, int numPartitions) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        return new Tuple2(existingAssignmentPartition0, (Object)BoxesRunTime.boxToInteger((int)partitionsToAdd));
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                return x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        String string6 = ConfigType$.MODULE$.ConfluentTenant();
        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
            this.changeTenantConfig(entityName, configs);
            return;
        }
        String string7 = ConfigType$.MODULE$.ClusterLink();
        if (!(string7 != null ? !string7.equals(entityType) : entityType != null)) {
            throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), new StringBuilder(1).append(user).append("/").append(ConfigType$.MODULE$.Client()).toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig(ConfigType$.MODULE$.User(), user);
                    String userPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs, false);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void validateTenantConfig(String tenant, Properties configs) {
        DynamicConfig$Tenant$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs, false);
    }

    public void changeTenantConfig(String tenant, Properties configs) {
        this.validateTenantConfig(tenant, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.ConfluentTenant(), tenant, configs, false);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs, false);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs, false));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$13 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$13))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs, false);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(Uuid linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(linkId).toString(), persistentProps, false);
    }

    public Properties fetchClusterLinkConfig(Uuid linkId) {
        return this.fetchEntityConfig(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(linkId).toString());
    }

    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if ((ConfigType$.MODULE$.Client().equals(rootEntityType) || ConfigType$.MODULE$.User().equals(rootEntityType) || ConfigType$.MODULE$.Ip().equals(rootEntityType) || ConfigType$.MODULE$.ConfluentTenant().equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> numPartitions(scala.collection.immutable.Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                Seq partitions = (Seq)x0$1._2();
                return new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            }
            throw new MatchError(null);
        });
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        Uuid linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(clusterLinkData.linkId()).toString();
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId, persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(Uuid linkId) {
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).get((Object)javaLinkId);
    }

    public Map<Uuid, ClusterLinkData> getClusterLinks(scala.collection.immutable.Set<Uuid> linkIds) {
        scala.collection.immutable.Set javaLinkIds = (scala.collection.immutable.Set)linkIds.map((Function1 & Serializable)uuid -> CoreUtils$.MODULE$.toJavaUUID((Uuid)uuid));
        return (Map)this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)javaLinkIds).map((Function1 & Serializable)entry -> new Tuple2((Object)CoreUtils$.MODULE$.toKafkaUUID((UUID)entry._1()), entry._2()));
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((IterableOnceOps)this.zkClient.getChildren("/cluster_links").map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData, int expectedControllerEpochZkVersion) {
        Uuid linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData, expectedControllerEpochZkVersion);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public void deleteClusterLink(Uuid linkId, int expectedControllerEpochZkVersion) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId, expectedControllerEpochZkVersion);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.deleteEntityConfig(ConfigType$.MODULE$.ClusterLink(), javaLinkId, this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.getAllClusterLinks().foreach((Function1 & Serializable)link -> {
            AdminZkClient.$anonfun$maybeReencryptClusterLinkConfigs$1(this, configTransformer, link);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$2(String topic$2, String x$4) {
        return Topic.hasCollision((String)topic$2, (String)x$4);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$4(ReplicaAssignment x$6) {
        return x$6.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$5(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ Option $anonfun$writeTopicPartitionAssignment$2(Option legacyTopicIdOpt$1) {
        return legacyTopicIdOpt$1;
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$4(Seq existingAssignmentPartition0$1, BrokerMetadata x$12) {
        return x$12.id >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$3(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, boolean rackMixingSupportEnabled$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$4(existingAssignmentPartition0$1, x$12))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), rackMixingSupportEnabled$1, startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!assignment.replicas().toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$13) {
        return Integer.toString(x$13);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public static final /* synthetic */ void $anonfun$maybeReencryptClusterLinkConfigs$1(AdminZkClient $this, Function1 configTransformer$1, ClusterLinkData link) {
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(link.linkId()).toString();
        $this.zkClient.transformEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId, (Function1<Properties, Option<Properties>>)configTransformer$1);
    }

    public AdminZkClient(KafkaZkClient zkClient, Option<KafkaConfig> kafkaConfig) {
        this.zkClient = zkClient;
        this.kafkaConfig = kafkaConfig;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$1$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id))).toSet());
        return BoxedUnit.UNIT;
    }
}

