/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSchemaProvider
implements SchemaProvider {
    private SchemaVersionFetcher schemaVersionFetcher;

    @Override
    public void configure(Map<String, ?> configs) {
        this.schemaVersionFetcher = (SchemaVersionFetcher)configs.get("schemaVersionFetcher");
    }

    public SchemaVersionFetcher schemaVersionFetcher() {
        return this.schemaVersionFetcher;
    }

    protected Map<String, String> resolveReferences(Schema schema) {
        return this.resolveReferences(schema, false);
    }

    protected Map<String, String> resolveReferences(Schema schema, boolean isNew) {
        List<SchemaReference> references = schema.getReferences();
        if (references == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashSet<String> visited = new HashSet<String>();
        this.resolveReferences(schema, result, visited, isNew);
        return result;
    }

    private void resolveReferences(Schema schema, Map<String, String> schemas, Set<String> visited, boolean isNew) {
        boolean lookupDeletedSchema = !isNew;
        List<SchemaReference> references = schema.getReferences();
        for (SchemaReference reference : references) {
            if (reference.getName() == null || reference.getSubject() == null || reference.getVersion() == null) {
                throw new IllegalStateException("Invalid reference: " + reference);
            }
            if (visited.contains(reference.getName())) continue;
            visited.add(reference.getName());
            if (schemas.containsKey(reference.getName())) continue;
            QualifiedSubject refSubject = QualifiedSubject.qualifySubjectWithParent(this.schemaVersionFetcher().tenant(), schema.getSubject(), reference.getSubject());
            Schema s = this.schemaVersionFetcher().getByVersion(refSubject.toQualifiedSubject(), reference.getVersion(), lookupDeletedSchema);
            if (s == null) {
                throw new IllegalStateException("No schema reference found for subject \"" + refSubject + "\" and version " + reference.getVersion());
            }
            if (reference.getVersion() == -1) {
                reference.setVersion(s.getVersion());
            }
            this.resolveReferences(s, schemas, visited, isNew);
            schemas.put(reference.getName(), s.getSchema());
        }
    }

    protected static boolean canLookupIgnoringVersion(ParsedSchema current, ParsedSchema prev) {
        Integer schemaVer = AbstractSchemaProvider.getConfluentVersionNumber(current.metadata());
        Integer prevVer = AbstractSchemaProvider.getConfluentVersionNumber(prev.metadata());
        if (schemaVer == null && prevVer != null) {
            ParsedSchema newSchema = current.metadata() != null ? current : current.copy(new Metadata(null, null, null), current.ruleSet());
            ParsedSchema newPrev = prev.copy(Metadata.removeConfluentVersion(prev.metadata()), prev.ruleSet());
            return newSchema.equivalent(newPrev);
        }
        if (schemaVer != null && prevVer == null) {
            if (!schemaVer.equals(prev.version())) {
                return false;
            }
            ParsedSchema newPrev = prev.metadata() != null ? prev : prev.copy(new Metadata(null, null, null), prev.ruleSet());
            ParsedSchema newSchema = current.copy(Metadata.removeConfluentVersion(current.metadata()), current.ruleSet());
            return newSchema.equivalent(newPrev);
        }
        return current.equivalent(prev);
    }

    protected static boolean hasLatestVersion(List<SchemaReference> refs) {
        return refs.stream().anyMatch(e -> e.getVersion() == -1);
    }

    protected static List<SchemaReference> replaceLatestVersion(List<SchemaReference> refs, SchemaVersionFetcher fetcher) {
        ArrayList<SchemaReference> result = new ArrayList<SchemaReference>();
        for (SchemaReference ref : refs) {
            if (ref.getVersion() == -1) {
                Schema s = fetcher.getByVersion(ref.getSubject(), -1, false);
                result.add(new SchemaReference(ref.getName(), ref.getSubject(), s.getVersion()));
                continue;
            }
            result.add(ref);
        }
        return result;
    }

    protected static Integer getConfluentVersionNumber(Metadata metadata) {
        return metadata != null ? metadata.getConfluentVersionNumber() : null;
    }

    protected static String getConfluentVersion(Metadata metadata) {
        return metadata != null ? metadata.getConfluentVersion() : null;
    }
}

