/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.rbac;

import io.confluent.connect.security.rbac.ActionBuilder;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.connect.security.rbac.CreateConnectorActionBuilder;
import io.confluent.connect.security.rbac.PutConnectorConfigActionBuilder;
import io.confluent.connect.security.rbac.SimpleConnectorActionBuilder;
import io.confluent.connect.security.util.ConnectRestApiMethods;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.kafka.connect.health.ConnectClusterState;

public class ConnectActions {
    private static final ActionBuilder EMPTY_ACTION_BUILDER = requestContext -> Collections.emptyList();
    public static final ResourceType CONNECTOR_RESOURCE = new ResourceType("Connector");
    private final Map<Method, ActionBuilder> actionBuilders;

    public static ConnectActions build(Scope scope, ConnectClusterState clusterState) {
        HashMap<Method, ActionBuilder> actionBuilders = new HashMap<Method, ActionBuilder>();
        actionBuilders.put(ConnectRestApiMethods.CREATE_CONNECTOR, new CreateConnectorActionBuilder(scope));
        actionBuilders.put(ConnectRestApiMethods.PUT_CONNECTOR_CONFIG, new PutConnectorConfigActionBuilder(scope, clusterState));
        List<Method> connectorReadConfigMethods = Arrays.asList(ConnectRestApiMethods.GET_CONNECTOR, ConnectRestApiMethods.GET_CONNECTOR_CONFIG, ConnectRestApiMethods.GET_TASK_CONFIGS);
        for (Method method : connectorReadConfigMethods) {
            actionBuilders.put(method, new SimpleConnectorActionBuilder(scope, ConnectorOperations.READ_CONFIG));
        }
        List<Method> connectorReadStatusMethods = Arrays.asList(ConnectRestApiMethods.GET_CONNECTOR_STATUS, ConnectRestApiMethods.GET_TASK_STATUS);
        for (Method connectorReadStatusMethod : connectorReadStatusMethods) {
            actionBuilders.put(connectorReadStatusMethod, new SimpleConnectorActionBuilder(scope, ConnectorOperations.READ_STATUS));
        }
        actionBuilders.put(ConnectRestApiMethods.PAUSE_CONNECTOR, new SimpleConnectorActionBuilder(scope, ConnectorOperations.PAUSE));
        actionBuilders.put(ConnectRestApiMethods.RESUME_CONNECTOR, new SimpleConnectorActionBuilder(scope, ConnectorOperations.RESUME));
        List<Method> list = Arrays.asList(ConnectRestApiMethods.RESTART_CONNECTOR, ConnectRestApiMethods.RESTART_TASK);
        for (Method connectorRestartMethod : list) {
            actionBuilders.put(connectorRestartMethod, new SimpleConnectorActionBuilder(scope, ConnectorOperations.PAUSE, ConnectorOperations.RESUME));
        }
        actionBuilders.put(ConnectRestApiMethods.DELETE_CONNECTOR, new SimpleConnectorActionBuilder(scope, ConnectorOperations.DELETE));
        actionBuilders.put(ConnectRestApiMethods.GET_CONNECTOR_ACTIVE_TOPICS, new SimpleConnectorActionBuilder(scope, ConnectorOperations.READ_ACTIVE_TOPICS));
        actionBuilders.put(ConnectRestApiMethods.RESET_CONNECTOR_ACTIVE_TOPICS, new SimpleConnectorActionBuilder(scope, ConnectorOperations.RESET_ACTIVE_TOPICS));
        return new ConnectActions(actionBuilders);
    }

    ConnectActions(Map<Method, ActionBuilder> actionBuilders) {
        this.actionBuilders = actionBuilders;
    }

    public List<Action> actions(Method resourceMethod, ContainerRequestContext requestContext) throws IOException {
        return this.actionBuilders.getOrDefault(resourceMethod, EMPTY_ACTION_BUILDER).computeActions(requestContext);
    }
}

