/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.command.SingleCommandParser;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.factories.RestrictionRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;

public class SingleCommand<C> {
    private final ParserMetadata<C> parserConfig;
    private final CommandMetadata commandMetadata;
    private final List<GlobalRestriction> restrictions;

    public static <C> SingleCommand<C> singleCommand(Class<C> command) {
        return new SingleCommand<C>(command, null, null);
    }

    public static <C> SingleCommand<C> singleCommand(Class<C> command, ParserMetadata<C> parserConfig) {
        return new SingleCommand<C>(command, null, parserConfig);
    }

    private SingleCommand(Class<C> command, Iterable<GlobalRestriction> restrictions, ParserMetadata<C> parserConfig) {
        if (command == null) {
            throw new NullPointerException("command is null");
        }
        this.parserConfig = parserConfig != null ? parserConfig : MetadataLoader.loadParser(command);
        this.restrictions = this.createRestrictions(command, restrictions);
        this.commandMetadata = MetadataLoader.loadCommand(command, this.parserConfig);
    }

    private List<GlobalRestriction> createRestrictions(Class<C> commandClass, Iterable<GlobalRestriction> restrictions) {
        ArrayList<GlobalRestriction> foundRestrictions = new ArrayList<GlobalRestriction>();
        if (restrictions != null && restrictions.iterator().hasNext()) {
            foundRestrictions.addAll(IteratorUtils.toList(restrictions.iterator()));
        }
        for (Class<? extends Annotation> annotationClass : RestrictionRegistry.getGlobalRestrictionAnnotationClasses()) {
            GlobalRestriction restriction;
            Annotation annotation = commandClass.getAnnotation(annotationClass);
            if (annotation == null || (restriction = RestrictionRegistry.getGlobalRestriction(annotationClass, annotation)) == null) continue;
            foundRestrictions.add(restriction);
        }
        if (foundRestrictions.isEmpty()) {
            foundRestrictions.addAll(Arrays.asList(GlobalRestriction.DEFAULTS));
        }
        return foundRestrictions;
    }

    public CommandMetadata getCommandMetadata() {
        return this.commandMetadata;
    }

    public ParserMetadata<C> getParserConfiguration() {
        return this.parserConfig;
    }

    public C parse(String ... args) {
        return this.parse(Arrays.asList(args));
    }

    public C parse(Iterable<String> args) {
        SingleCommandParser<C> parser = new SingleCommandParser<C>();
        return (C)parser.parse(this.parserConfig, this.commandMetadata, this.restrictions, args);
    }

    public ParseResult<C> parseWithResult(String ... args) {
        return this.parseWithResult(Arrays.asList(args));
    }

    public ParseResult<C> parseWithResult(Iterable<String> args) {
        SingleCommandParser<C> parser = new SingleCommandParser<C>();
        return parser.parseWithResult(this.parserConfig, this.commandMetadata, this.restrictions, args);
    }
}

