/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNameValueOptionParser<T>
extends AbstractOptionParser<T> {
    private static final char DEFAULT_SEPARATOR = '=';
    private final char separator;

    public AbstractNameValueOptionParser() {
        this('=');
    }

    public AbstractNameValueOptionParser(char sep) {
        this.separator = sep;
        if (Character.isWhitespace(this.separator)) {
            throw new IllegalArgumentException("AbstractNameValueOptionParser may only be instantiated with a non-whitespace separator");
        }
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        List<String> parts = AirlineUtils.unmodifiableListCopy(StringUtils.split((String)((String)tokens.peek()), (String)new String(new char[]{this.separator}), (int)2));
        if (parts.size() != 2) {
            return null;
        }
        OptionMetadata option = this.findOption(state, allowedOptions, parts.get(0));
        if (option == null || option.getArity() != 1) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        state = state.withOptionValue(option, parts.get(1)).popContext();
        return state;
    }
}

