/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CheckDeviceAuthResponse {
    private final String userCode;
    private final Boolean complete;
    private final String error;
    private final String status;
    private final String description;
    private final String authToken;
    private final Long expiresIn;

    @JsonCreator
    public CheckDeviceAuthResponse(@JsonProperty(value="user_code") String userCode, @JsonProperty(value="complete") Boolean complete, @JsonProperty(value="error") String error, @JsonProperty(value="status") String status, @JsonProperty(value="description") String description, @JsonProperty(value="auth_token") String authToken, @JsonProperty(value="expires_in") Long expiresIn) {
        this.userCode = userCode;
        this.complete = complete;
        this.error = error;
        this.status = status;
        this.description = description;
        this.authToken = authToken;
        this.expiresIn = expiresIn;
    }

    public static CheckDeviceAuthResponse createPendingAuthResponse(String userCode, String status, String description) {
        return new CheckDeviceAuthResponse(userCode, false, null, status, description, null, null);
    }

    public static CheckDeviceAuthResponse createErrorResponse(String userCode, String error, String description) {
        return new CheckDeviceAuthResponse(userCode, true, error, null, description, null, null);
    }

    public static CheckDeviceAuthResponse createCompleteAuthResponse(String userCode, String authToken, Long expiresIn) {
        return new CheckDeviceAuthResponse(userCode, true, null, "success", "Authentication successful.", authToken, expiresIn);
    }

    @JsonProperty(value="user_code")
    public String userCode() {
        return this.userCode;
    }

    @JsonProperty(value="complete")
    public Boolean complete() {
        return this.complete;
    }

    @JsonProperty(value="error")
    public String error() {
        return this.error;
    }

    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @JsonProperty(value="auth_token")
    public String authToken() {
        return this.authToken;
    }

    @JsonProperty(value="expires_in")
    public Long expiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }
}

