/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import io.spiffe.bundle.jwtbundle.JwtBundleSet;
import io.spiffe.bundle.x509bundle.X509BundleSet;
import io.spiffe.exception.JwtBundleException;
import io.spiffe.exception.JwtSvidException;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.exception.X509BundleException;
import io.spiffe.exception.X509ContextException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.svid.jwtsvid.JwtSvid;
import io.spiffe.workloadapi.Address;
import io.spiffe.workloadapi.GrpcConversionUtils;
import io.spiffe.workloadapi.StreamObservers;
import io.spiffe.workloadapi.Watcher;
import io.spiffe.workloadapi.WorkloadApiClient;
import io.spiffe.workloadapi.X509Context;
import io.spiffe.workloadapi.grpc.SpiffeWorkloadAPIGrpc;
import io.spiffe.workloadapi.grpc.Workload;
import io.spiffe.workloadapi.internal.GrpcManagedChannelFactory;
import io.spiffe.workloadapi.internal.ManagedChannelWrapper;
import io.spiffe.workloadapi.internal.SecurityHeaderInterceptor;
import io.spiffe.workloadapi.retry.ExponentialBackoffPolicy;
import io.spiffe.workloadapi.retry.RetryHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class DefaultWorkloadApiClient
implements WorkloadApiClient {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultWorkloadApiClient.class.getName());
    private final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub;
    private final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub;
    private final ManagedChannelWrapper managedChannel;
    private final List<Context.CancellableContext> cancellableContexts;
    private final ExponentialBackoffPolicy exponentialBackoffPolicy;
    private final ScheduledExecutorService retryExecutor;
    private final ExecutorService executorService;
    private volatile boolean closed;

    private DefaultWorkloadApiClient(SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub, SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub, ManagedChannelWrapper managedChannel, ExponentialBackoffPolicy exponentialBackoffPolicy, ScheduledExecutorService retryExecutor, ExecutorService executorService) {
        this.workloadApiAsyncStub = workloadApiAsyncStub;
        this.workloadApiBlockingStub = workloadApiBlockingStub;
        this.managedChannel = managedChannel;
        this.cancellableContexts = Collections.synchronizedList(new ArrayList());
        this.exponentialBackoffPolicy = exponentialBackoffPolicy;
        this.retryExecutor = retryExecutor;
        this.executorService = executorService;
    }

    DefaultWorkloadApiClient(SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub, SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub, ManagedChannelWrapper managedChannel, ExponentialBackoffPolicy backoffPolicy) {
        this.workloadApiAsyncStub = workloadApiAsyncStub;
        this.workloadApiBlockingStub = workloadApiBlockingStub;
        this.exponentialBackoffPolicy = backoffPolicy;
        this.executorService = Executors.newCachedThreadPool();
        this.retryExecutor = Executors.newSingleThreadScheduledExecutor();
        this.cancellableContexts = Collections.synchronizedList(new ArrayList());
        this.managedChannel = managedChannel;
    }

    public static WorkloadApiClient newClient() throws SocketEndpointAddressException {
        ClientOptions options = ClientOptions.builder().build();
        return DefaultWorkloadApiClient.newClient(options);
    }

    public static WorkloadApiClient newClient(@NonNull ClientOptions options) throws SocketEndpointAddressException {
        String spiffeSocketPath;
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String string = spiffeSocketPath = StringUtils.isNotBlank((CharSequence)options.spiffeSocketPath) ? options.spiffeSocketPath : Address.getDefaultAddress();
        if (options.exponentialBackoffPolicy == null) {
            options.exponentialBackoffPolicy = ExponentialBackoffPolicy.DEFAULT;
        }
        if (options.executorService == null) {
            options.executorService = Executors.newCachedThreadPool();
        }
        URI socketEndpointAddress = Address.parseAddress(spiffeSocketPath);
        ManagedChannelWrapper managedChannel = GrpcManagedChannelFactory.newChannel((URI)socketEndpointAddress, (ExecutorService)options.executorService);
        SecurityHeaderInterceptor securityHeaderInterceptor = new SecurityHeaderInterceptor();
        SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadAPIAsyncStub = (SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub)((SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub)SpiffeWorkloadAPIGrpc.newStub((Channel)managedChannel.getChannel()).withExecutor(options.executorService)).withInterceptors(new ClientInterceptor[]{securityHeaderInterceptor});
        SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadAPIBlockingStub = (SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub)((SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub)SpiffeWorkloadAPIGrpc.newBlockingStub((Channel)managedChannel.getChannel()).withExecutor(options.executorService)).withInterceptors(new ClientInterceptor[]{securityHeaderInterceptor});
        ScheduledExecutorService retryExecutor = Executors.newSingleThreadScheduledExecutor();
        return new DefaultWorkloadApiClient(workloadAPIAsyncStub, workloadAPIBlockingStub, managedChannel, options.exponentialBackoffPolicy, retryExecutor, options.executorService);
    }

    @Override
    public X509Context fetchX509Context() throws X509ContextException {
        X509Context x509Context;
        block8: {
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                x509Context = (X509Context)cancellableContext.call(this::callFetchX509Context);
                if (cancellableContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new X509ContextException("Error fetching X509Context", e);
                }
            }
            cancellableContext.close();
        }
        return x509Context;
    }

    @Override
    public void watchX509Context(@NonNull Watcher<X509Context> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.X509SVIDResponse> streamObserver = StreamObservers.getX509ContextStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchX509SVID(this.newX509SvidRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    @Override
    public X509BundleSet fetchX509Bundles() throws X509BundleException {
        X509BundleSet x509BundleSet;
        block8: {
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                x509BundleSet = (X509BundleSet)cancellableContext.call(this::callFetchX509Bundles);
                if (cancellableContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new X509BundleException("Error fetching X.509 bundles", e);
                }
            }
            cancellableContext.close();
        }
        return x509BundleSet;
    }

    @Override
    public void watchX509Bundles(@NonNull Watcher<X509BundleSet> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.X509BundlesResponse> streamObserver = StreamObservers.getX509BundlesStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchX509Bundles(this.newX509BundlesRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    @Override
    public JwtSvid fetchJwtSvid(@NonNull String audience, String ... extraAudience) throws JwtSvidException {
        JwtSvid jwtSvid;
        block9: {
            if (audience == null) {
                throw new NullPointerException("audience is marked non-null but is null");
            }
            Set<String> audParam = this.createAudienceSet(audience, extraAudience);
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                jwtSvid = (JwtSvid)cancellableContext.call(() -> this.callFetchJwtSvid(audParam));
                if (cancellableContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JwtSvidException("Error fetching JWT SVID", e);
                }
            }
            cancellableContext.close();
        }
        return jwtSvid;
    }

    @Override
    public JwtSvid fetchJwtSvid(@NonNull SpiffeId subject, @NonNull String audience, String ... extraAudience) throws JwtSvidException {
        JwtSvid jwtSvid;
        block10: {
            if (subject == null) {
                throw new NullPointerException("subject is marked non-null but is null");
            }
            if (audience == null) {
                throw new NullPointerException("audience is marked non-null but is null");
            }
            Set<String> audParam = this.createAudienceSet(audience, extraAudience);
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                jwtSvid = (JwtSvid)cancellableContext.call(() -> this.callFetchJwtSvid(subject, audParam));
                if (cancellableContext == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JwtSvidException("Error fetching JWT SVID", e);
                }
            }
            cancellableContext.close();
        }
        return jwtSvid;
    }

    @Override
    public List<JwtSvid> fetchJwtSvids(@NonNull String audience, String ... extraAudience) throws JwtSvidException {
        List list;
        block9: {
            if (audience == null) {
                throw new NullPointerException("audience is marked non-null but is null");
            }
            Set<String> audParam = this.createAudienceSet(audience, extraAudience);
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                list = (List)cancellableContext.call(() -> this.callFetchJwtSvids(audParam));
                if (cancellableContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JwtSvidException("Error fetching JWT SVID", e);
                }
            }
            cancellableContext.close();
        }
        return list;
    }

    @Override
    public List<JwtSvid> fetchJwtSvids(@NonNull SpiffeId subject, @NonNull String audience, String ... extraAudience) throws JwtSvidException {
        List list;
        block10: {
            if (subject == null) {
                throw new NullPointerException("subject is marked non-null but is null");
            }
            if (audience == null) {
                throw new NullPointerException("audience is marked non-null but is null");
            }
            Set<String> audParam = this.createAudienceSet(audience, extraAudience);
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                list = (List)cancellableContext.call(() -> this.callFetchJwtSvids(subject, audParam));
                if (cancellableContext == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JwtSvidException("Error fetching JWT SVID", e);
                }
            }
            cancellableContext.close();
        }
        return list;
    }

    @Override
    public JwtBundleSet fetchJwtBundles() throws JwtBundleException {
        JwtBundleSet jwtBundleSet;
        block8: {
            Context.CancellableContext cancellableContext = Context.current().withCancellation();
            try {
                jwtBundleSet = (JwtBundleSet)cancellableContext.call(this::callFetchBundles);
                if (cancellableContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cancellableContext != null) {
                        try {
                            cancellableContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JwtBundleException("Error fetching JWT Bundles", e);
                }
            }
            cancellableContext.close();
        }
        return jwtBundleSet;
    }

    @Override
    public JwtSvid validateJwtSvid(@NonNull String token, @NonNull String audience) throws JwtSvidException {
        Workload.ValidateJWTSVIDResponse response;
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        Workload.ValidateJWTSVIDRequest request = this.createJwtSvidRequest(token, audience);
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            response = (Workload.ValidateJWTSVIDResponse)cancellableContext.call(() -> this.workloadApiBlockingStub.validateJWTSVID(request));
        }
        catch (Exception e) {
            throw new JwtSvidException("Error validating JWT SVID", e);
        }
        if (response == null || StringUtils.isBlank((CharSequence)response.getSpiffeId())) {
            throw new JwtSvidException("Error validating JWT SVID. Empty response from Workload API");
        }
        return JwtSvid.parseInsecure(token, Collections.singleton(audience), "");
    }

    @Override
    public void watchJwtBundles(@NonNull Watcher<JwtBundleSet> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.JWTBundlesResponse> streamObserver = StreamObservers.getJwtBundleStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchJWTBundles(this.newJwtBundlesRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.log(Level.FINE, "Closing WorkloadAPI client");
        DefaultWorkloadApiClient defaultWorkloadApiClient = this;
        synchronized (defaultWorkloadApiClient) {
            if (!this.closed) {
                for (Context.CancellableContext context : this.cancellableContexts) {
                    context.close();
                }
                if (this.managedChannel != null) {
                    this.managedChannel.close();
                }
                this.retryExecutor.shutdown();
                this.executorService.shutdown();
                this.closed = true;
            }
        }
        log.log(Level.INFO, "WorkloadAPI client is closed");
    }

    private X509Context callFetchX509Context() throws X509ContextException {
        Iterator<Workload.X509SVIDResponse> x509SvidResponse = this.workloadApiBlockingStub.fetchX509SVID(this.newX509SvidRequest());
        return GrpcConversionUtils.toX509Context(x509SvidResponse);
    }

    private X509BundleSet callFetchX509Bundles() throws X509BundleException {
        Iterator<Workload.X509BundlesResponse> x509BundlesResponse = this.workloadApiBlockingStub.fetchX509Bundles(this.newX509BundlesRequest());
        return GrpcConversionUtils.toX509BundleSet(x509BundlesResponse);
    }

    private JwtSvid callFetchJwtSvid(SpiffeId subject, Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().setSpiffeId(subject.toString()).addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience, true).get(0);
    }

    private JwtSvid callFetchJwtSvid(Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience, true).get(0);
    }

    private List<JwtSvid> callFetchJwtSvids(SpiffeId subject, Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().setSpiffeId(subject.toString()).addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience, false);
    }

    private List<JwtSvid> callFetchJwtSvids(Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience, false);
    }

    private List<JwtSvid> processJwtSvidResponse(Workload.JWTSVIDResponse response, Set<String> audience, boolean firstOnly) throws JwtSvidException {
        if (response.getSvidsList() == null || response.getSvidsList().isEmpty()) {
            throw new JwtSvidException("JWT SVID response from the Workload API is empty");
        }
        int n = response.getSvidsCount();
        if (firstOnly) {
            n = 1;
        }
        ArrayList<JwtSvid> svids = new ArrayList<JwtSvid>(n);
        HashSet<String> hints = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            if (hints.contains(response.getSvids(i).getHint())) continue;
            JwtSvid svid = JwtSvid.parseInsecure(response.getSvids(i).getSvid(), audience, response.getSvids(i).getHint());
            hints.add(svid.getHint());
            svids.add(svid);
        }
        return svids;
    }

    private JwtBundleSet callFetchBundles() throws JwtBundleException {
        Workload.JWTBundlesRequest request = Workload.JWTBundlesRequest.newBuilder().build();
        Iterator<Workload.JWTBundlesResponse> bundlesResponse = this.workloadApiBlockingStub.fetchJWTBundles(request);
        return GrpcConversionUtils.toJwtBundleSet(bundlesResponse);
    }

    private Set<String> createAudienceSet(String audience, String[] extraAudience) {
        HashSet<String> audParam = new HashSet<String>();
        audParam.add(audience);
        Collections.addAll(audParam, extraAudience);
        return audParam;
    }

    private Workload.X509SVIDRequest newX509SvidRequest() {
        return Workload.X509SVIDRequest.newBuilder().build();
    }

    private Workload.X509BundlesRequest newX509BundlesRequest() {
        return Workload.X509BundlesRequest.newBuilder().build();
    }

    private Workload.JWTBundlesRequest newJwtBundlesRequest() {
        return Workload.JWTBundlesRequest.newBuilder().build();
    }

    private Workload.ValidateJWTSVIDRequest createJwtSvidRequest(String token, String audience) {
        return Workload.ValidateJWTSVIDRequest.newBuilder().setSvid(token).setAudience(audience).build();
    }

    public static class ClientOptions {
        private String spiffeSocketPath;
        private ExponentialBackoffPolicy exponentialBackoffPolicy;
        private ExecutorService executorService;

        public ClientOptions(String spiffeSocketPath, ExponentialBackoffPolicy exponentialBackoffPolicy, ExecutorService executorService) {
            this.spiffeSocketPath = spiffeSocketPath;
            this.exponentialBackoffPolicy = exponentialBackoffPolicy;
            this.executorService = executorService;
        }

        @Generated
        public static ClientOptionsBuilder builder() {
            return new ClientOptionsBuilder();
        }

        @Generated
        public String getSpiffeSocketPath() {
            return this.spiffeSocketPath;
        }

        @Generated
        public ExponentialBackoffPolicy getExponentialBackoffPolicy() {
            return this.exponentialBackoffPolicy;
        }

        @Generated
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientOptions)) {
                return false;
            }
            ClientOptions other = (ClientOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spiffeSocketPath = this.getSpiffeSocketPath();
            String other$spiffeSocketPath = other.getSpiffeSocketPath();
            if (this$spiffeSocketPath == null ? other$spiffeSocketPath != null : !this$spiffeSocketPath.equals(other$spiffeSocketPath)) {
                return false;
            }
            ExponentialBackoffPolicy this$exponentialBackoffPolicy = this.getExponentialBackoffPolicy();
            ExponentialBackoffPolicy other$exponentialBackoffPolicy = other.getExponentialBackoffPolicy();
            if (this$exponentialBackoffPolicy == null ? other$exponentialBackoffPolicy != null : !((Object)this$exponentialBackoffPolicy).equals(other$exponentialBackoffPolicy)) {
                return false;
            }
            ExecutorService this$executorService = this.getExecutorService();
            ExecutorService other$executorService = other.getExecutorService();
            return !(this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spiffeSocketPath = this.getSpiffeSocketPath();
            result = result * 59 + ($spiffeSocketPath == null ? 43 : $spiffeSocketPath.hashCode());
            ExponentialBackoffPolicy $exponentialBackoffPolicy = this.getExponentialBackoffPolicy();
            result = result * 59 + ($exponentialBackoffPolicy == null ? 43 : ((Object)$exponentialBackoffPolicy).hashCode());
            ExecutorService $executorService = this.getExecutorService();
            result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultWorkloadApiClient.ClientOptions(spiffeSocketPath=" + this.getSpiffeSocketPath() + ", exponentialBackoffPolicy=" + this.getExponentialBackoffPolicy() + ", executorService=" + this.getExecutorService() + ")";
        }

        @Generated
        public static class ClientOptionsBuilder {
            @Generated
            private String spiffeSocketPath;
            @Generated
            private ExponentialBackoffPolicy exponentialBackoffPolicy;
            @Generated
            private ExecutorService executorService;

            @Generated
            ClientOptionsBuilder() {
            }

            @Generated
            public ClientOptionsBuilder spiffeSocketPath(String spiffeSocketPath) {
                this.spiffeSocketPath = spiffeSocketPath;
                return this;
            }

            @Generated
            public ClientOptionsBuilder exponentialBackoffPolicy(ExponentialBackoffPolicy exponentialBackoffPolicy) {
                this.exponentialBackoffPolicy = exponentialBackoffPolicy;
                return this;
            }

            @Generated
            public ClientOptionsBuilder executorService(ExecutorService executorService) {
                this.executorService = executorService;
                return this;
            }

            @Generated
            public ClientOptions build() {
                return new ClientOptions(this.spiffeSocketPath, this.exponentialBackoffPolicy, this.executorService);
            }

            @Generated
            public String toString() {
                return "DefaultWorkloadApiClient.ClientOptions.ClientOptionsBuilder(spiffeSocketPath=" + this.spiffeSocketPath + ", exponentialBackoffPolicy=" + this.exponentialBackoffPolicy + ", executorService=" + this.executorService + ")";
            }
        }
    }
}

