/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi;

import io.spiffe.bundle.x509bundle.X509BundleSet;
import io.spiffe.svid.x509svid.X509Svid;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public final class X509Context {
    private final List<X509Svid> x509Svids;
    private final X509BundleSet x509BundleSet;

    X509Context(List<X509Svid> x509Svids, X509BundleSet x509BundleSet) {
        this.x509Svids = x509Svids;
        this.x509BundleSet = x509BundleSet;
    }

    public static X509Context of(@NonNull List<X509Svid> x509Svids, @NonNull X509BundleSet x509BundleSet) {
        if (x509Svids == null) {
            throw new NullPointerException("x509Svids is marked non-null but is null");
        }
        if (x509BundleSet == null) {
            throw new NullPointerException("x509BundleSet is marked non-null but is null");
        }
        if (x509Svids.size() == 0) {
            throw new IllegalArgumentException("The X.509 Context must have a least one X.509 SVID");
        }
        return new X509Context(x509Svids, x509BundleSet);
    }

    public X509Svid getDefaultSvid() {
        return this.x509Svids.get(0);
    }

    @Generated
    public List<X509Svid> getX509Svids() {
        return this.x509Svids;
    }

    @Generated
    public X509BundleSet getX509BundleSet() {
        return this.x509BundleSet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509Context)) {
            return false;
        }
        X509Context other = (X509Context)o;
        List<X509Svid> this$x509Svids = this.getX509Svids();
        List<X509Svid> other$x509Svids = other.getX509Svids();
        if (this$x509Svids == null ? other$x509Svids != null : !((Object)this$x509Svids).equals(other$x509Svids)) {
            return false;
        }
        X509BundleSet this$x509BundleSet = this.getX509BundleSet();
        X509BundleSet other$x509BundleSet = other.getX509BundleSet();
        return !(this$x509BundleSet == null ? other$x509BundleSet != null : !((Object)this$x509BundleSet).equals(other$x509BundleSet));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<X509Svid> $x509Svids = this.getX509Svids();
        result = result * 59 + ($x509Svids == null ? 43 : ((Object)$x509Svids).hashCode());
        X509BundleSet $x509BundleSet = this.getX509BundleSet();
        result = result * 59 + ($x509BundleSet == null ? 43 : ((Object)$x509BundleSet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "X509Context(x509Svids=" + this.getX509Svids() + ", x509BundleSet=" + this.getX509BundleSet() + ")";
    }
}

