/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class TimeBuckets<T> {
    private final long bucketSizeMs;
    private NavigableMap<Long, Bucket<T>> buckets;

    public TimeBuckets(long bucketSizeMs) {
        this.bucketSizeMs = bucketSizeMs;
        this.buckets = new TreeMap<Long, Bucket<T>>();
    }

    public Bucket<T> get(long timeMs) {
        if (timeMs < 0L) {
            throw new IllegalArgumentException("Invalid timestamp " + timeMs);
        }
        long timestamp = this.getTimestamp(timeMs);
        Bucket bucket = (Bucket)this.buckets.get(timestamp);
        if (bucket == null) {
            bucket = new Bucket(timestamp);
            this.buckets.put(timestamp, bucket);
        }
        return bucket;
    }

    public Bucket<T> removeOldestBucket() {
        Map.Entry<Long, Bucket<T>> entry = this.buckets.pollFirstEntry();
        return entry != null ? entry.getValue() : null;
    }

    public long getTimestamp(long timeMs) {
        return timeMs - timeMs % this.bucketSizeMs;
    }

    public long getNumberOfBuckets() {
        return this.buckets.size();
    }

    public long getBucketSizeMs() {
        return this.bucketSizeMs;
    }

    public class Bucket<T> {
        public long timestamp;
        public T data;

        public Bucket(long timestamp) {
            this.timestamp = timestamp;
            this.data = null;
        }

        public boolean corresponds(long timestamp) {
            return timestamp == this.timestamp;
        }
    }
}

