/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.ForeignKeyJoinParams;
import io.confluent.ksql.execution.streams.ForeignKeyJoinParamsFactory;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class ForeignKeyTableTableJoinBuilder {
    private ForeignKeyTableTableJoinBuilder() {
    }

    public static <KLeftT, KRightT> KTableHolder<KLeftT> build(KTableHolder<KLeftT> left, KTableHolder<KRightT> right, ForeignKeyTableTableJoin<KLeftT, KRightT> join, RuntimeBuildContext buildContext) {
        KTable result;
        CompiledExpression expressionEvaluator;
        LogicalSchema leftSchema = left.getSchema();
        LogicalSchema rightSchema = right.getSchema();
        ProcessingLogger logger = buildContext.getProcessingLogger(join.getProperties().getQueryContext());
        CodeGenRunner codeGenRunner = new CodeGenRunner(leftSchema, buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        Optional leftColumnName = join.getLeftJoinColumnName();
        Optional leftJoinExpression = join.getLeftJoinExpression();
        if (leftColumnName.isPresent()) {
            expressionEvaluator = codeGenRunner.buildCodeGenFromParseTree((Expression)new UnqualifiedColumnReferenceExp((ColumnName)leftColumnName.get()), "Left Join Expression");
        } else if (leftJoinExpression.isPresent()) {
            expressionEvaluator = codeGenRunner.buildCodeGenFromParseTree((Expression)leftJoinExpression.get(), "Left Join Expression");
        } else {
            throw new IllegalStateException("Both leftColumnName and leftJoinExpression are empty.");
        }
        ForeignKeyJoinParams joinParams = ForeignKeyJoinParamsFactory.create((ExpressionEvaluator)expressionEvaluator, leftSchema, rightSchema, logger);
        Formats formats = join.getFormats();
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)joinParams.getSchema(), (SerdeFeatures)formats.getKeyFeatures(), (SerdeFeatures)formats.getValueFeatures());
        Serde keySerde = left.getExecutionKeyFactory().buildKeySerde(formats.getKeyFormat(), physicalSchema, join.getProperties().getQueryContext());
        Serde valSerde = buildContext.buildValueSerde(formats.getValueFormat(), physicalSchema, join.getProperties().getQueryContext());
        switch (join.getJoinType()) {
            case INNER: {
                result = left.getTable().join(right.getTable(), joinParams.getKeyExtractor(), (ValueJoiner)joinParams.getJoiner(), buildContext.getMaterializedFactory().create(keySerde, valSerde));
                break;
            }
            case LEFT: {
                result = left.getTable().leftJoin(right.getTable(), joinParams.getKeyExtractor(), (ValueJoiner)joinParams.getJoiner(), buildContext.getMaterializedFactory().create(keySerde, valSerde));
                break;
            }
            default: {
                throw new IllegalStateException("invalid join type: " + join.getJoinType());
            }
        }
        return KTableHolder.unmaterialized((KTable)result, (LogicalSchema)joinParams.getSchema(), (ExecutionKeyFactory)left.getExecutionKeyFactory());
    }
}

