/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class KsqlKeyExtractor<KRightT>
implements Function<GenericRow, KRightT> {
    private final ExpressionEvaluator expressionEvaluator;
    private final ProcessingLogger processingLogger;
    private final Supplier<String> errorMessage;

    KsqlKeyExtractor(ExpressionEvaluator expressionEvaluator, ProcessingLogger processingLogger) {
        this.expressionEvaluator = Objects.requireNonNull(expressionEvaluator);
        this.processingLogger = processingLogger;
        this.errorMessage = () -> String.format("Error calculating left join expression: `%s`.", expressionEvaluator.getExpression());
    }

    @Override
    public KRightT apply(GenericRow left) {
        return (KRightT)GenericKey.genericKey((Object[])new Object[]{this.expressionEvaluator.evaluate(left, null, this.processingLogger, this.errorMessage)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlKeyExtractor that = (KsqlKeyExtractor)o;
        return Objects.equals(this.expressionEvaluator, that.expressionEvaluator) && Objects.equals(this.processingLogger, that.processingLogger) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.expressionEvaluator, this.processingLogger, this.errorMessage);
    }

    public String toString() {
        return "KsqlKeyExtractor{expressionEvaluator=" + this.expressionEvaluator + "processingLogger=" + this.processingLogger + "errorMessage=" + this.errorMessage + '}';
    }
}

