/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.SchemaNotSupportedException;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;

final class MaterializationUtil {
    private static final String MATERIALIZE_OP = "Materialize";

    private MaterializationUtil() {
    }

    static QueryContext materializeContext(ExecutionStep<?> step) {
        return QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext()).push(new String[]{MATERIALIZE_OP}).getQueryContext();
    }

    static <K> Materialized<K, GenericRow, KeyValueStore<Bytes, byte[]>> buildMaterialized(ExecutionStep<?> step, LogicalSchema aggregateSchema, Formats formats, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, ExecutionKeyFactory<K> executionKeyFactory) {
        PhysicalSchema physicalAggregationSchema = PhysicalSchema.from((LogicalSchema)aggregateSchema, (SerdeFeatures)formats.getKeyFeatures(), (SerdeFeatures)formats.getValueFeatures());
        QueryContext queryContext = MaterializationUtil.materializeContext(step);
        Serde<K> keySerde = MaterializationUtil.buildKeySerde(formats, physicalAggregationSchema, queryContext, executionKeyFactory);
        Serde<GenericRow> valueSerde = MaterializationUtil.buildValueSerde(formats, buildContext, physicalAggregationSchema, queryContext);
        return materializedFactory.create(keySerde, valueSerde, StreamsUtil.buildOpName(queryContext));
    }

    private static <K> Serde<K> buildKeySerde(Formats formats, PhysicalSchema physicalAggregationSchema, QueryContext queryContext, ExecutionKeyFactory<K> executionKeyFactory) {
        try {
            return executionKeyFactory.buildKeySerde(formats.getKeyFormat(), physicalAggregationSchema, queryContext);
        }
        catch (SchemaNotSupportedException e) {
            throw MaterializationUtil.schemaNotSupportedException(e, "key");
        }
    }

    private static Serde<GenericRow> buildValueSerde(Formats formats, RuntimeBuildContext buildContext, PhysicalSchema physicalAggregationSchema, QueryContext queryContext) {
        try {
            return buildContext.buildValueSerde(formats.getValueFormat(), physicalAggregationSchema, queryContext);
        }
        catch (SchemaNotSupportedException e) {
            throw MaterializationUtil.schemaNotSupportedException(e, "value");
        }
    }

    private static SchemaNotSupportedException schemaNotSupportedException(SchemaNotSupportedException e, String type) {
        return new SchemaNotSupportedException("One of the functions used in the statement has an intermediate type that the " + type + " format can not handle. Please remove the function or change the format." + System.lineSeparator() + "Consider up-voting https://github.com/confluentinc/ksql/issues/3950, which will resolve this limitation", (Throwable)e);
    }
}

