/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.ConsumedFactory;
import io.confluent.ksql.execution.streams.SourceBuilderBase;
import io.confluent.ksql.execution.streams.SourceBuilderUtils;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.StaticTopicSerde;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueStore;

final class SourceBuilderV1
extends SourceBuilderBase {
    private static final SourceBuilderV1 instance = new SourceBuilderV1();

    private SourceBuilderV1() {
    }

    public static SourceBuilderV1 instance() {
        return instance;
    }

    public KStreamHolder<GenericKey> buildStream(RuntimeBuildContext buildContext, StreamSource source, ConsumedFactory consumedFactory) {
        PhysicalSchema physicalSchema = SourceBuilderUtils.getPhysicalSchema(source);
        Serde<GenericRow> valueSerde = SourceBuilderUtils.getValueSerde(buildContext, source, physicalSchema);
        Serde<GenericKey> keySerde = SourceBuilderUtils.getKeySerde(source, physicalSchema, buildContext);
        Consumed<GenericKey, GenericRow> consumed = SourceBuilderUtils.buildSourceConsumed(source, keySerde, valueSerde, Topology.AutoOffsetReset.LATEST, buildContext, consumedFactory);
        KStream<GenericKey, GenericRow> kstream = this.buildKStream((SourceStep<?>)source, buildContext, (Consumed)consumed, (Function)SourceBuilderV1.nonWindowedKeyGenerator(source.getSourceSchema()));
        return new KStreamHolder(kstream, SourceBuilderUtils.buildSchema(source, false), ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext));
    }

    public KStreamHolder<Windowed<GenericKey>> buildWindowedStream(RuntimeBuildContext buildContext, WindowedStreamSource source, ConsumedFactory consumedFactory) {
        PhysicalSchema physicalSchema = SourceBuilderUtils.getPhysicalSchema(source);
        Serde<GenericRow> valueSerde = SourceBuilderUtils.getValueSerde(buildContext, source, physicalSchema);
        WindowInfo windowInfo = source.getWindowInfo();
        Serde<Windowed<GenericKey>> keySerde = SourceBuilderUtils.getWindowedKeySerde(source, physicalSchema, buildContext, windowInfo);
        Consumed<Windowed<GenericKey>, GenericRow> consumed = SourceBuilderUtils.buildSourceConsumed(source, keySerde, valueSerde, Topology.AutoOffsetReset.LATEST, buildContext, consumedFactory);
        KStream<Windowed<GenericKey>, GenericRow> kstream = this.buildKStream((SourceStep<?>)source, buildContext, (Consumed)consumed, (Function)SourceBuilderUtils.windowedKeyGenerator(source.getSourceSchema()));
        return new KStreamHolder(kstream, SourceBuilderUtils.buildSchema(source, true), ExecutionKeyFactory.windowed((RuntimeBuildContext)buildContext, (WindowInfo)windowInfo));
    }

    KTableHolder<Windowed<GenericKey>> buildWindowedTable(RuntimeBuildContext buildContext, SourceStep<KTableHolder<Windowed<GenericKey>>> source, ConsumedFactory consumedFactory, MaterializedFactory materializedFactory, PlanInfo planInfo) {
        PhysicalSchema physicalSchema = SourceBuilderUtils.getPhysicalSchema(source);
        Serde<GenericRow> valueSerde = SourceBuilderUtils.getValueSerde(buildContext, source, physicalSchema);
        if (!(source instanceof WindowedTableSource)) {
            throw new IllegalArgumentException("Expected a version of WindowedTableSource");
        }
        WindowInfo windowInfo = ((WindowedTableSource)source).getWindowInfo();
        Serde<Windowed<GenericKey>> keySerde = SourceBuilderUtils.getWindowedKeySerde(source, physicalSchema, buildContext, windowInfo);
        Consumed<Windowed<GenericKey>, GenericRow> consumed = SourceBuilderUtils.buildSourceConsumed(source, keySerde, valueSerde, Topology.AutoOffsetReset.EARLIEST, buildContext, consumedFactory);
        String stateStoreName = SourceBuilderUtils.tableChangeLogOpName(source.getProperties());
        Materialized materialized = materializedFactory.create(keySerde, valueSerde, stateStoreName);
        KTable<Windowed<GenericKey>, GenericRow> ktable = this.buildKTable(source, buildContext, consumed, SourceBuilderUtils.windowedKeyGenerator(source.getSourceSchema()), materialized, valueSerde, stateStoreName, planInfo);
        return KTableHolder.materialized(ktable, (LogicalSchema)SourceBuilderUtils.buildSchema(source, true), (ExecutionKeyFactory)ExecutionKeyFactory.windowed((RuntimeBuildContext)buildContext, (WindowInfo)windowInfo), (MaterializationInfo.Builder)MaterializationInfo.builder((String)stateStoreName, (LogicalSchema)physicalSchema.logicalSchema()));
    }

    @Override
    public Materialized<GenericKey, GenericRow, KeyValueStore<Bytes, byte[]>> buildTableMaterialized(SourceStep<KTableHolder<GenericKey>> source, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, Serde<GenericKey> keySerde, Serde<GenericRow> valueSerde, String stateStoreName) {
        return materializedFactory.create(keySerde, valueSerde, stateStoreName);
    }

    @Override
    <K> KTable<K, GenericRow> buildKTable(SourceStep<?> streamSource, RuntimeBuildContext buildContext, Consumed<K, GenericRow> consumed, Function<K, Collection<?>> keyGenerator, Materialized<K, GenericRow, KeyValueStore<Bytes, byte[]>> materialized, Serde<GenericRow> valueSerde, String stateStoreName, PlanInfo planInfo) {
        KTable table;
        boolean forceChangelog;
        SourceBuilderV1.validateNotUsingOldExecutionStepWithNewQueries(streamSource);
        boolean bl = forceChangelog = streamSource instanceof TableSourceV1 && ((TableSourceV1)streamSource).isForceChangelog() != false;
        if (!forceChangelog) {
            String changelogTopic = SourceBuilderUtils.changelogTopic(buildContext, stateStoreName);
            StaticTopicSerde.Callback onFailure = SourceBuilderUtils.getRegisterCallback(buildContext, streamSource.getFormats().getValueFormat());
            table = buildContext.getStreamsBuilder().table(streamSource.getTopicName(), consumed.withValueSerde(StaticTopicSerde.wrap((String)changelogTopic, valueSerde, (StaticTopicSerde.Callback)onFailure)), materialized);
        } else {
            KTable source = buildContext.getStreamsBuilder().table(streamSource.getTopicName(), consumed);
            boolean forceMaterialization = !planInfo.isRepartitionedInPlan(streamSource);
            table = forceMaterialization ? source.mapValues(row -> row, materialized) : source.mapValues(row -> row);
        }
        return table.transformValues(new SourceBuilderUtils.AddKeyAndPseudoColumns<K>(keyGenerator, streamSource.getPseudoColumnVersion(), streamSource.getSourceSchema().headers()), new String[0]);
    }

    private <K> KStream<K, GenericRow> buildKStream(SourceStep<?> streamSource, RuntimeBuildContext buildContext, Consumed<K, GenericRow> consumed, Function<K, Collection<?>> keyGenerator) {
        KStream stream = buildContext.getStreamsBuilder().stream(streamSource.getTopicName(), consumed);
        int pseudoColumnVersion = streamSource.getPseudoColumnVersion();
        return stream.transformValues(new SourceBuilderUtils.AddKeyAndPseudoColumns<K>(keyGenerator, pseudoColumnVersion, streamSource.getSourceSchema().headers()), new String[0]);
    }

    private static Function<GenericKey, Collection<?>> nonWindowedKeyGenerator(LogicalSchema schema) {
        GenericKey nullKey = GenericKey.builder((LogicalSchema)schema).appendNulls().build();
        return key -> key == null ? nullKey.values() : key.values();
    }

    private static void validateNotUsingOldExecutionStepWithNewQueries(SourceStep<?> streamSource) {
        if (streamSource instanceof TableSourceV1 && streamSource.getPseudoColumnVersion() != 0) {
            throw new KsqlException("Should not be using old execution step version with new queries");
        }
    }
}

