/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.JoinParams;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.execution.streams.JoinedFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class StreamTableJoinBuilder {
    private static final String SERDE_CTX = "Left";

    private StreamTableJoinBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> left, KTableHolder<K> right, StreamTableJoin<K> join, RuntimeBuildContext buildContext, JoinedFactory joinedFactory) {
        KStream result;
        Formats leftFormats = join.getInternalFormats();
        QueryContext queryContext = join.getProperties().getQueryContext();
        QueryContext.Stacker stacker = QueryContext.Stacker.of((QueryContext)queryContext);
        LogicalSchema leftSchema = left.getSchema();
        PhysicalSchema leftPhysicalSchema = PhysicalSchema.from((LogicalSchema)leftSchema, (SerdeFeatures)leftFormats.getKeyFeatures(), (SerdeFeatures)leftFormats.getValueFeatures());
        Serde leftSerde = buildContext.buildValueSerde(leftFormats.getValueFormat(), leftPhysicalSchema, stacker.push(new String[]{SERDE_CTX}).getQueryContext());
        Serde keySerde = left.getExecutionKeyFactory().buildKeySerde(leftFormats.getKeyFormat(), leftPhysicalSchema, queryContext);
        Joined joined = joinedFactory.create(keySerde, leftSerde, null, StreamsUtil.buildOpName(queryContext));
        LogicalSchema rightSchema = right.getSchema();
        JoinParams joinParams = JoinParamsFactory.create(join.getKeyColName(), leftSchema, rightSchema);
        switch (join.getJoinType()) {
            case LEFT: {
                result = left.getStream().leftJoin(right.getTable(), (ValueJoiner)joinParams.getJoiner(), joined);
                break;
            }
            case INNER: {
                result = left.getStream().join(right.getTable(), (ValueJoiner)joinParams.getJoiner(), joined);
                break;
            }
            default: {
                throw new IllegalStateException("invalid join type");
            }
        }
        return left.withStream(result, joinParams.getSchema());
    }
}

