/*
 * Decompiled with CFR 0.152.
 */
package kafka.backupRestore.objectLifecycle.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.LongVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.backupRestore.objectLifecycle.serdes.DatedList;
import kafka.backupRestore.objectLifecycle.serdes.Header;
import kafka.backupRestore.objectLifecycle.serdes.TopicRetentionData;

public final class LifecycleManagerState
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static LifecycleManagerState getRootAsLifecycleManagerState(ByteBuffer _bb) {
        return LifecycleManagerState.getRootAsLifecycleManagerState(_bb, new LifecycleManagerState());
    }

    public static LifecycleManagerState getRootAsLifecycleManagerState(ByteBuffer _bb, LifecycleManagerState obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public LifecycleManagerState __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public Header header() {
        return this.header(new Header());
    }

    public Header header(Header obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public long lastRunTimestamp() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long tierOffsets(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(this.__vector(o) + j * 8) : 0L;
    }

    public int tierOffsetsLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public LongVector tierOffsetsVector() {
        return this.tierOffsetsVector(new LongVector());
    }

    public LongVector tierOffsetsVector(LongVector obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer tierOffsetsAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 8);
    }

    public ByteBuffer tierOffsetsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 8);
    }

    public TopicRetentionData retentionData(int j) {
        return this.retentionData(new TopicRetentionData(), j);
    }

    public TopicRetentionData retentionData(TopicRetentionData obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int retentionDataLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public TopicRetentionData.Vector retentionDataVector() {
        return this.retentionDataVector(new TopicRetentionData.Vector());
    }

    public TopicRetentionData.Vector retentionDataVector(TopicRetentionData.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public DatedList latestDataFiles(int j) {
        return this.latestDataFiles(new DatedList(), j);
    }

    public DatedList latestDataFiles(DatedList obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int latestDataFilesLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public DatedList.Vector latestDataFilesVector() {
        return this.latestDataFilesVector(new DatedList.Vector());
    }

    public DatedList.Vector latestDataFilesVector(DatedList.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createLifecycleManagerState(FlatBufferBuilder builder, int headerOffset, long last_run_timestamp, int tier_offsetsOffset, int retention_dataOffset, int latest_data_filesOffset) {
        builder.startTable(5);
        LifecycleManagerState.addLastRunTimestamp(builder, last_run_timestamp);
        LifecycleManagerState.addLatestDataFiles(builder, latest_data_filesOffset);
        LifecycleManagerState.addRetentionData(builder, retention_dataOffset);
        LifecycleManagerState.addTierOffsets(builder, tier_offsetsOffset);
        LifecycleManagerState.addHeader(builder, headerOffset);
        return LifecycleManagerState.endLifecycleManagerState(builder);
    }

    public static void startLifecycleManagerState(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addHeader(FlatBufferBuilder builder, int headerOffset) {
        builder.addOffset(0, headerOffset, 0);
    }

    public static void addLastRunTimestamp(FlatBufferBuilder builder, long lastRunTimestamp) {
        builder.addLong(1, lastRunTimestamp, 0L);
    }

    public static void addTierOffsets(FlatBufferBuilder builder, int tierOffsetsOffset) {
        builder.addOffset(2, tierOffsetsOffset, 0);
    }

    public static int createTierOffsetsVector(FlatBufferBuilder builder, long[] data) {
        builder.startVector(8, data.length, 8);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addLong(data[i]);
        }
        return builder.endVector();
    }

    public static void startTierOffsetsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(8, numElems, 8);
    }

    public static void addRetentionData(FlatBufferBuilder builder, int retentionDataOffset) {
        builder.addOffset(3, retentionDataOffset, 0);
    }

    public static int createRetentionDataVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startRetentionDataVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addLatestDataFiles(FlatBufferBuilder builder, int latestDataFilesOffset) {
        builder.addOffset(4, latestDataFilesOffset, 0);
    }

    public static int createLatestDataFilesVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startLatestDataFilesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endLifecycleManagerState(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishLifecycleManagerStateBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedLifecycleManagerStateBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public LifecycleManagerState get(int j) {
            return this.get(new LifecycleManagerState(), j);
        }

        public LifecycleManagerState get(LifecycleManagerState obj, int j) {
            return obj.__assign(LifecycleManagerState.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

