/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005t!\u0002\u0012$\u0011\u0003Qc!\u0002\u0017$\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039d!\u0002\u0017$\u0001\rJ\u0004\u0002\u0003\u0014\u0005\u0005\u000b\u0007I\u0011B'\t\u0011A#!\u0011!Q\u0001\n9C\u0001\"\u0015\u0003\u0003\u0006\u0004%IA\u0015\u0005\t7\u0012\u0011\t\u0011)A\u0005'\")A\u0007\u0002C\u00019\")q\f\u0002C!A\")A\u0010\u0002C!{\"9\u0011\u0011\u0004\u0003\u0005B\u0005m\u0001bBA\u0019\t\u0011\u0005\u00131\u0007\u0005\b\u0003\u000f\"A\u0011IA%\u0011\u001d\ti\u0006\u0002C!\u0003?Bq!a\u001d\u0005\t\u0003\n)\bC\u0004\u0002.\u0012!\t%a,\t\u000f\u0005\u001dG\u0001\"\u0011\u0002J\"9\u0011q\u001f\u0003\u0005B\u0005e\bb\u0002B\u0001\t\u0011%!1\u0001\u0005\b\u0005_!A\u0011\tB\u0019\u0011\u001d\u00119\u0005\u0002C!\u0005\u0013BqAa\u0018\u0005\t\u0013\u0011\t\u0007C\u0004\u0003\u0014\u0012!\tE!&\t\u000f\t-F\u0001\"\u0011\u0003.\"9!\u0011\u0017\u0003\u0005B\tM\u0006b\u0002Bi\t\u0011\u0005#1\u001b\u0005\b\u0005;$A\u0011\tBp\u0011\u001d\u0011I\u000f\u0002C!\u0005WDqAa>\u0005\t\u0003\u0012I\u0010C\u0004\u0004\u0016\u0011!\tea\u0006\t\u000f\r}A\u0001\"\u0011\u0004\"!911\u0007\u0003\u0005B\rU\u0012aF$s_V\u00048i\\8sI&t\u0017\r^8s\u0003\u0012\f\u0007\u000f^3s\u0015\t!S%A\u0003he>,\bO\u0003\u0002'O\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005A\u0013!B6bM.\f7\u0001\u0001\t\u0003W\u0005i\u0011a\t\u0002\u0018\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fE-\u00199uKJ\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!&A\u0003baBd\u0017\u0010F\u00059\u0007o\u00199e!\u0015\u0004TA\u00111\u0006B\n\u0004\ti\u0012\u0005CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\r[U\"\u0001#\u000b\u0005\u0011*%B\u0001\u0014G\u0015\tAsI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'E\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/F\u0001O!\tYs*\u0003\u0002MG\u0005a1m\\8sI&t\u0017\r^8sA\u0005!A/[7f+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0015)H/\u001b7t\u0015\tAf)\u0001\u0004d_6lwN\\\u0005\u00035V\u0013A\u0001V5nK\u0006)A/[7fAQ\u0019\u0001(\u00180\t\u000b\u0019J\u0001\u0019\u0001(\t\u000bEK\u0001\u0019A*\u0002-\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$2!Y8x!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\u000bG>t7-\u001e:sK:$(B\u00014?\u0003\u0011)H/\u001b7\n\u0005!\u001c'!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0011!.\\\u0007\u0002W*\u0011AnV\u0001\b[\u0016\u001c8/Y4f\u0013\tq7N\u0001\u0012D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006a*\u0001\r!]\u0001\bG>tG/\u001a=u!\t\u0011X/D\u0001t\u0015\t!x+\u0001\u0005sKF,Xm\u001d;t\u0013\t18O\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000baT\u0001\u0019A=\u0002\u000fI,\u0017/^3tiB\u0011!N_\u0005\u0003w.\u0014\u0011eQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fcV,7\u000f\u001e#bi\u0006\f\u0011B[8j]\u001e\u0013x.\u001e9\u0015\u000fy\f)!a\u0002\u0002\u0010A\u0019!mZ@\u0011\u0007)\f\t!C\u0002\u0002\u0004-\u0014QCS8j]\u001e\u0013x.\u001e9SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003q\u0017\u0001\u0007\u0011\u000f\u0003\u0004y\u0017\u0001\u0007\u0011\u0011\u0002\t\u0004U\u0006-\u0011bAA\u0007W\n!\"j\\5o\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e#bi\u0006Dq!!\u0005\f\u0001\u0004\t\u0019\"\u0001\bck\u001a4WM]*vaBd\u0017.\u001a:\u0011\u0007Q\u000b)\"C\u0002\u0002\u0018U\u0013aBQ;gM\u0016\u00148+\u001e9qY&,'/A\u0005ts:\u001cwI]8vaRA\u0011QDA\u0013\u0003O\ty\u0003\u0005\u0003cO\u0006}\u0001c\u00016\u0002\"%\u0019\u00111E6\u0003+MKhnY$s_V\u0004(+Z:q_:\u001cX\rR1uC\")\u0001\u000f\u0004a\u0001c\"1\u0001\u0010\u0004a\u0001\u0003S\u00012A[A\u0016\u0013\r\tic\u001b\u0002\u0015'ft7m\u0012:pkB\u0014V-];fgR$\u0015\r^1\t\u000f\u0005EA\u00021\u0001\u0002\u0014\u0005I\u0001.Z1si\n,\u0017\r\u001e\u000b\u0007\u0003k\ti$a\u0010\u0011\t\t<\u0017q\u0007\t\u0004U\u0006e\u0012bAA\u001eW\n)\u0002*Z1si\n,\u0017\r\u001e*fgB|gn]3ECR\f\u0007\"\u00029\u000e\u0001\u0004\t\bB\u0002=\u000e\u0001\u0004\t\t\u0005E\u0002k\u0003\u0007J1!!\u0012l\u0005QAU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000fR1uC\u0006QA.Z1wK\u001e\u0013x.\u001e9\u0015\r\u0005-\u00131KA+!\u0011\u0011w-!\u0014\u0011\u0007)\fy%C\u0002\u0002R-\u0014a\u0003T3bm\u0016<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006a:\u0001\r!\u001d\u0005\u0007q:\u0001\r!a\u0016\u0011\u0007)\fI&C\u0002\u0002\\-\u0014Q\u0003T3bm\u0016<%o\\;q%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\u0006mSN$xI]8vaN$b!!\u0019\u0002j\u0005-\u0004\u0003\u00022h\u0003G\u00022A[A3\u0013\r\t9g\u001b\u0002\u0017\u0019&\u001cHo\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC\")\u0001o\u0004a\u0001c\"1\u0001p\u0004a\u0001\u0003[\u00022A[A8\u0013\r\t\th\u001b\u0002\u0016\u0019&\u001cHo\u0012:pkB\u001c(+Z9vKN$H)\u0019;b\u00039!Wm]2sS\n,wI]8vaN$b!a\u001e\u0002\u0010\u0006E\u0005\u0003\u00022h\u0003s\u0002b!a\u001f\u0002~\u0005\u0005U\"A3\n\u0007\u0005}TM\u0001\u0003MSN$\b\u0003BAB\u0003\u0013s1A[AC\u0013\r\t9i[\u0001\u001b\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003\u0017\u000biI\u0001\bEKN\u001c'/\u001b2fI\u001e\u0013x.\u001e9\u000b\u0007\u0005\u001d5\u000eC\u0003q!\u0001\u0007\u0011\u000fC\u0004\u0002\u0014B\u0001\r!!&\u0002\u0011\u001d\u0014x.\u001e9JIN\u0004b!a\u001f\u0002~\u0005]\u0005\u0003BAM\u0003OsA!a'\u0002$B\u0019\u0011Q\u0014\u0019\u000e\u0005\u0005}%bAAQS\u00051AH]8pizJ1!!*1\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011VAV\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0015\u0019\u0002\u0019\u0011,G.\u001a;f\u000fJ|W\u000f]:\u0015\u0011\u0005E\u0016\u0011YAb\u0003\u000b\u0004BAY4\u00024B!\u0011QWA^\u001d\rQ\u0017qW\u0005\u0004\u0003s[\u0017\u0001\u0007#fY\u0016$Xm\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC&!\u0011QXA`\u0005y!U\r\\3uC\ndWm\u0012:pkB\u0014Vm];mi\u000e{G\u000e\\3di&|gNC\u0002\u0002:.DQ\u0001]\tA\u0002EDq!a%\u0012\u0001\u0004\t)\nC\u0004\u0002\u0012E\u0001\r!a\u0005\u0002\u001f\u0019,Go\u00195BY2|eMZ:fiN$\u0002\"a3\u0002\\\u0006u\u0017Q\u001e\t\u0005E\u001e\fi\r\u0005\u0003\u0002P\u0006Ugb\u00016\u0002R&\u0019\u00111[6\u0002/=3gm]3u\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BAl\u00033\u0014\u0001d\u00144gg\u0016$h)\u001a;dQJ+7\u000f]8og\u0016<%o\\;q\u0015\r\t\u0019n\u001b\u0005\u0006aJ\u0001\r!\u001d\u0005\u0007qJ\u0001\r!a8\u0011\t\u0005\u0005\u0018q\u001d\b\u0004U\u0006\r\u0018bAAsW\u00061rJ\u001a4tKR4U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002j\u0006-(aF(gMN,GOR3uG\"\u0014V-];fgR<%o\\;q\u0015\r\t)o\u001b\u0005\b\u0003_\u0014\u0002\u0019AAy\u00035\u0011X-];je\u0016\u001cF/\u00192mKB\u0019q&a=\n\u0007\u0005U\bGA\u0004C_>dW-\u00198\u0002\u0019\u0019,Go\u00195PM\u001a\u001cX\r^:\u0015\u0011\u0005-\u00171`A\u007f\u0003\u007fDQ\u0001]\nA\u0002EDa\u0001_\nA\u0002\u0005}\u0007bBAx'\u0001\u0007\u0011\u0011_\u0001\u0012Q\u0006tG\r\\3GKR\u001c\u0007n\u00144gg\u0016$H\u0003CAf\u0005\u000b\u0011IAa\u0003\t\u000f\t\u001dA\u00031\u0001\u0002\u0018\u00069qM]8va&#\u0007bBAx)\u0001\u0007\u0011\u0011\u001f\u0005\b\u0005\u001b!\u0002\u0019\u0001B\b\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006_\tE!QC\u0005\u0004\u0005'\u0001$AB(qi&|g\u000e\u0005\u0004\u0003\u0018\t\u0005\"q\u0005\b\u0005\u00053\u0011iB\u0004\u0003\u0002\u001e\nm\u0011\"A\u0019\n\u0007\t}\u0001'A\u0004qC\u000e\\\u0017mZ3\n\t\t\r\"Q\u0005\u0002\u0004'\u0016\f(b\u0001B\u0010aA!!\u0011\u0006B\u0016\u001b\u00059\u0016b\u0001B\u0017/\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!D2p[6LGo\u00144gg\u0016$8\u000f\u0006\u0005\u00034\tm\"Q\bB#!\u0011\u0011wM!\u000e\u0011\u0007)\u00149$C\u0002\u0003:-\u0014\u0001d\u00144gg\u0016$8i\\7nSR\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015\u0001X\u00031\u0001r\u0011\u0019AX\u00031\u0001\u0003@A\u0019!N!\u0011\n\u0007\t\r3NA\fPM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cH\u000fR1uC\"9\u0011\u0011C\u000bA\u0002\u0005M\u0011AG2p[6LG\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cH\u0003\u0003B&\u0005'\u0012)F!\u0018\u0011\t\t<'Q\n\t\u0004U\n=\u0013b\u0001B)W\nYB\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGOU3ta>t7/\u001a#bi\u0006DQ\u0001\u001d\fA\u0002EDa\u0001\u001f\fA\u0002\t]\u0003c\u00016\u0003Z%\u0019!1L6\u00035QChn\u00144gg\u0016$8i\\7nSR\u0014V-];fgR$\u0015\r^1\t\u000f\u0005Ea\u00031\u0001\u0002\u0014\u000592M]3bi\u0016|eMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u000b\u000f\u0005G\u0012iGa\u001e\u0003|\t\u0015%\u0011\u0012BG!\u0011\u0011)G!\u001b\u000e\u0005\t\u001d$B\u0001-(\u0013\u0011\u0011YGa\u001a\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003p]\u0001\rA!\u001d\u0002\u001b\r,(O]3oiRKW.Z't!\ry#1O\u0005\u0004\u0005k\u0002$\u0001\u0002'p]\u001eDqA!\u001f\u0018\u0001\u0004\u0011\t(\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005{:\u0002\u0019\u0001B@\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0007=\u0012\t)C\u0002\u0003\u0004B\u00121!\u00138u\u0011\u001d\u00119i\u0006a\u0001\u0003/\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0005\b\u0005\u0017;\u0002\u0019\u0001B9\u0003=\u0019w.\\7jiRKW.Z:uC6\u0004\bb\u0002BH/\u0001\u0007!\u0011S\u0001\u0010Kb\u0004\u0018N]3US6,7\u000f^1naB)qF!\u0005\u0003r\u0005iA-\u001a7fi\u0016|eMZ:fiN$\u0002Ba&\u0003 \n\u0005&\u0011\u0016\t\u0005E\u001e\u0014I\nE\u0002k\u00057K1A!(l\u0005ayeMZ:fi\u0012+G.\u001a;f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006ab\u0001\r!\u001d\u0005\u0007qb\u0001\rAa)\u0011\u0007)\u0014)+C\u0002\u0003(.\u0014qc\u00144gg\u0016$H)\u001a7fi\u0016\u0014V-];fgR$\u0015\r^1\t\u000f\u0005E\u0001\u00041\u0001\u0002\u0014\u0005a\u0001/\u0019:uSRLwN\u001c$peR!!q\u0010BX\u0011\u001d\u00119!\u0007a\u0001\u0003/\u000bac\u001c8Ue\u0006t7/Y2uS>t7i\\7qY\u0016$X\r\u001a\u000b\t\u0005k\u0013YLa0\u0003HB\u0019qFa.\n\u0007\te\u0006G\u0001\u0003V]&$\bb\u0002B_5\u0001\u0007!\u0011O\u0001\u000baJ|G-^2fe&#\u0007b\u0002B\u00075\u0001\u0007!\u0011\u0019\t\u0006w\t\r'qE\u0005\u0004\u0005\u000bd$\u0001C%uKJ\f'\r\\3\t\u000f\t%'\u00041\u0001\u0003L\u0006\tBO]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u0007I\u0014i-C\u0002\u0003PN\u0014\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0003Myg\u000eU1si&$\u0018n\u001c8t\t\u0016dW\r^3e)\u0019\u0011)L!6\u0003\\\"9!q[\u000eA\u0002\te\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\u0005m\u0014Q\u0010B\u0014\u0011\u001d\t\tb\u0007a\u0001\u0003'\t!b\u001c8FY\u0016\u001cG/[8o)\u0019\u0011)L!9\u0003f\"9!1\u001d\u000fA\u0002\t}\u0014aG4s_V\u0004X*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8J]\u0012,\u0007\u0010C\u0004\u0003hr\u0001\rAa \u0002C\u001d\u0014x.\u001e9NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\u0011)L!<\u0003p\"9!1]\u000fA\u0002\t}\u0004b\u0002Bt;\u0001\u0007!\u0011\u001f\t\u0005\u0003w\u0012\u00190C\u0002\u0003v\u0016\u00141b\u00149uS>t\u0017\r\\%oi\u0006\u0011rN\u001c(fo6+G/\u00193bi\u0006LU.Y4f)\u0019\u0011)La?\u0004\f!9!Q \u0010A\u0002\t}\u0018\u0001\u00038fo&k\u0017mZ3\u0011\t\r\u00051qA\u0007\u0003\u0007\u0007Q1a!\u0002G\u0003\u0015IW.Y4f\u0013\u0011\u0019Iaa\u0001\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u001d\u0019iA\ba\u0001\u0007\u001f\tQ\u0001Z3mi\u0006\u0004Ba!\u0001\u0004\u0012%!11CB\u0002\u00055iU\r^1eCR\fG)\u001a7uC\u0006IrM]8va6+G/\u00193bi\u0006$v\u000e]5d\u0007>tg-[4t)\t\u0019I\u0002\u0005\u0003\u0002|\rm\u0011bAB\u000fK\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u000fM$\u0018M\u001d;vaR!!QWB\u0012\u0011\u001d\u0019)\u0003\ta\u0001\u0007O\t\u0001e\u001a:pkBlU\r^1eCR\fGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiB!1\u0011FB\u0018\u001b\t\u0019YCC\u0002\u0004.\u0015\f\u0001BZ;oGRLwN\\\u0005\u0005\u0007c\u0019YCA\u0006J]R\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001C:ikR$wn\u001e8\u0015\u0005\tU\u0006bBB\u001d\u0007\u0001\u000711H\u0001\u0007G>tg-[4\u0011\t\ru21I\u0007\u0003\u0007\u007fQ1a!\u0011(\u0003\u0019\u0019XM\u001d<fe&!1QIB \u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\r%3\u00011\u0001\u0004L\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BB\u001f\u0007\u001bJAaa\u0014\u0004@\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"B)\u0004\u0001\u0004\u0019\u0006bBB+\u0007\u0001\u00071qK\u0001\b[\u0016$(/[2t!\u0011\u0019If!\u0018\u000e\u0005\rm#bAB+/&!1qLB.\u0005\u001diU\r\u001e:jGN\u0004")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig config, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(config, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(request.protocols().valuesList()).asScala().map((Function1 & Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()))).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)CollectionConverters$.MODULE$.ListHasAsScala(request.members()).asScala().toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(var4_4.code());
        var5_5.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$3(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().map((Function1 & Serializable)groupId -> this.describeGroup$1((String)groupId))).asJava());
    }

    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        this.coordinator().handleDeleteGroups((Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().toSet(), new RequestLocal(bufferSupplier)).foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()))), arg_0, arg_1));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        request.topics().forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> handleFetchOffset(String groupId, boolean requireStable, Option<scala.collection.immutable.Seq<TopicPartition>> partitions) {
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> future = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        void v0 = var5_5;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)var5_5.exception());
        } else {
            void var6_6;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset));
            var6_6.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(topicsList));
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationIdOrMemberEpoch(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), -1L, (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, long commitTimestamp, Option<Object> expireTimestamp) {
        String string;
        Optional<Integer> optional;
        switch (leaderEpoch) {
            case -1: {
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            }
        }
        switch (metadata == null ? 0 : metadata.hashCode()) {
            case 0: {
                if (metadata == null) {
                    string = OffsetAndMetadata$.MODULE$.NoMetadata();
                    break;
                }
            }
            default: {
                string = metadata;
            }
        }
        return new OffsetAndMetadata(offset, optional, string, -1L == commitTimestamp ? currentTimeMs : commitTimestamp, expireTimestamp);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void v0 = var7_7;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)var7_7.exception());
        } else {
            void var8_8;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error));
            var8_8.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(response);
        }
        return future;
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public void onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)CollectionConverters$.MODULE$.IterableHasAsScala(partitions).asScala(), transactionResult);
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(topicPartitions).asScala(), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)joinResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)syncGroupResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$3(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId) {
        void var4_4;
        void var3_3;
        Tuple2<Errors, GroupSummary> tuple2 = this.coordinator().handleDescribeGroup(groupId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        GroupSummary summary = (GroupSummary)tuple2._2();
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(var3_3.code()).setGroupId(groupId).setGroupState(var4_4.state()).setProtocolType(var4_4.protocolType()).setProtocolData(var4_4.protocol()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)var4_4.members().map((Function1 & Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()))).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error));
        commitStatus.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), partition.commitTimestamp(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error));
        results.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

