/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import kafka.Kafka$;
import kafka.cluster.Partition;
import kafka.durability.Utils;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.events.DurabilityEventType$;
import kafka.log.AbstractLog;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.state.SegmentState;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();

    public Option<Tuple4<Object, Object, Object, Set<Object>>> getLiveOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> log = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (log instanceof Some) {
            AbstractLog l = (AbstractLog)((Some)log).value();
            Option<Set<Object>> option = this.getIsrIfLeaderPartition(replicaManager, topicPartition);
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)l.highWatermark()), (Object)BoxesRunTime.boxToLong((long)l.logStartOffset()), l.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1), (Object)isr));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(log)) {
            return None$.MODULE$;
        }
        throw new MatchError(log);
    }

    public Option<Set<Object>> getIsrIfLeaderPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            if (partition.leaderLogIfLocal() instanceof Some) {
                return Option$.MODULE$.apply(partition.inSyncReplicaIds());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Set<Object>> getIsrPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            return Option$.MODULE$.apply(partition.inSyncReplicaIds());
        }
        return None$.MODULE$;
    }

    public int getLocalReplicaEpochIfLeader(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            if (partition.leaderLogIfLocal() instanceof Some) {
                return partition.getLeaderEpoch();
            }
            return -1;
        }
        return -1;
    }

    public boolean getMirrorState(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            return ((HostedPartition.Online)hostedPartition).partition().isActiveLinkDestinationLeader();
        }
        return false;
    }

    public Option<Object> getLogEndOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset()));
    }

    public Option<Object> getLatestEpoch(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            return ((AbstractLog)((Some)option).value()).latestEpoch();
        }
        return None$.MODULE$;
    }

    public boolean isTieredLog(AbstractLog log) {
        return log.config().confluentLogConfig().tierEnable() && !log.config().compact() && !Topic.isInternal((String)log.topicPartition().topic());
    }

    public Option<Utils.MaxTimestampWithSize> getPreviousTierSegmentInfo(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long offset) {
        boolean bl = false;
        Some some = null;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (!this.isTieredLog(log)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            AbstractLog log = (AbstractLog)some.value();
            if (this.isValidTopicId(log.topicId(), topicIdPartition.topicId())) {
                Optional<SegmentState> state = log.tierPartitionState().previousMetadataBeforeOffset(offset);
                if (state.isPresent()) {
                    return new Some((Object)new Utils.MaxTimestampWithSize(state.get().maxTimestamp(), state.get().size()));
                }
                return None$.MODULE$;
            }
            Kafka$ warn_this = Kafka$.MODULE$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = Utils$.$anonfun$getPreviousTierSegmentInfo$1(topicIdPartition, log);
                Object var12_11 = null;
                warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Utils.MaxTimestampWithSize> getTierSegmentInfoForRange(ReplicaManager replicaManager, TopicPartition topicPartition, long start, long end) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && this.isTieredLog(log = (AbstractLog)((Some)option).value())) {
            Buffer states = CollectionConverters$.MODULE$.ListHasAsScala(log.tierPartitionState().segmentInMemoryMetadataRange(start, end)).asScala();
            if (states.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)new Utils.MaxTimestampWithSize(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)states.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()))).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.unboxToInt((Object)((IterableOnceOps)states.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
        }
        return None$.MODULE$;
    }

    public Option<Object> getEstimatedLogRangeSize(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long startOffset) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            if (this.isValidTopicId(log.topicId(), topicIdPartition.topicId())) {
                Option<Utils.MaxTimestampWithSize> option2 = this.getPreviousTierSegmentInfo(replicaManager, topicIdPartition, startOffset);
                if (option2 instanceof Some) {
                    Utils.MaxTimestampWithSize prev = (Utils.MaxTimestampWithSize)((Some)option2).value();
                    if (log.logStartOffset() == startOffset) {
                        return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size())));
                    }
                    if (log.logStartOffset() > startOffset) {
                        Option<Utils.MaxTimestampWithSize> gapSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), startOffset, log.logStartOffset() - 1L);
                        if (gapSize.isDefined()) {
                            return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size() + ((Utils.MaxTimestampWithSize)gapSize.get()).size())));
                        }
                        return None$.MODULE$;
                    }
                    Option<Utils.MaxTimestampWithSize> extraSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), log.logStartOffset(), startOffset - 1L);
                    if (extraSize.isDefined()) {
                        return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() - ((Utils.MaxTimestampWithSize)extraSize.get()).size() + prev.size())));
                    }
                    return None$.MODULE$;
                }
                return None$.MODULE$;
            }
            Kafka$ warn_this = Kafka$.MODULE$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = Utils$.$anonfun$getEstimatedLogRangeSize$1(topicIdPartition, log);
                Object var11_11 = null;
                warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public int getBrokerId(ReplicaManager replicaManager) {
        return replicaManager.config().brokerId();
    }

    public Option<Object> getLocalLogRetentionSize(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null) {
            return new Some((Object)BoxesRunTime.boxToLong((long)log.config().retentionSize));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalLogRetentionMs(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null) {
            return new Some((Object)BoxesRunTime.boxToLong((long)log.config().retentionMs));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalStartOffsetForEpoch(ReplicaManager replicaManager, TopicPartition topicPartition, int epoch) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            Option<LeaderEpochFileCache> option2 = ((AbstractLog)((Some)option).value()).leaderEpochCache();
            if (option2 instanceof Some) {
                LeaderEpochFileCache cache = (LeaderEpochFileCache)((Some)option2).value();
                return new Some((Object)BoxesRunTime.boxToLong((long)cache.offsetForEpoch(epoch)));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean isCompacted(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            return ((AbstractLog)((Some)option).value()).config().compact();
        }
        return false;
    }

    public String consumerRecordMetadata(ConsumerRecord<byte[], byte[]> record) {
        Date timestampFormatted = new Date(record.timestamp());
        return new StringBuilder(34).append("Timestamp: ").append(timestampFormatted).append(", Partition: ").append(record.partition()).append(", Offset: ").append(record.offset()).toString();
    }

    public Set<Enumeration.Value> parseDurabilityEventCsvLists(String events) {
        return ((IterableOnceOps)CoreUtils$.MODULE$.parseCsvList(events).flatMap((Function1 & Serializable)evt -> DurabilityEventType$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    public Set<Enumeration.Value> parseDurabilityAuditsCsvLists(String audits) {
        return ((IterableOnceOps)CoreUtils$.MODULE$.parseCsvList(audits).flatMap((Function1 & Serializable)evt -> DurabilityAuditCheck$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    public int toPartition(TopicPartition topicPartition, int numPartitions) {
        return Math.abs(topicPartition.hashCode()) % numPartitions;
    }

    public int getDayOfYear(Time time) {
        return GregorianCalendar.from(Instant.ofEpochMilli(time.milliseconds()).atZone(ZoneOffset.UTC)).get(6);
    }

    private boolean isValidTopicId(Option<Uuid> currTopicId, Uuid oldTopicId) {
        block3: {
            block2: {
                if (currTopicId.isEmpty()) break block2;
                Object object = currTopicId.getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
                if (object != null ? !object.equals(oldTopicId) : oldTopicId != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$getPreviousTierSegmentInfo$1(TopicIdPartition topicIdPartition$1, AbstractLog log$1) {
        return new StringBuilder(205).append("Not returning prev tier segment info, since the topic has changed from topicId: ").append(topicIdPartition$1.topicId()).append(" ").append("to topicId: ").append(log$1.topicId()).append("This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic").toString();
    }

    public static final /* synthetic */ String $anonfun$getEstimatedLogRangeSize$1(TopicIdPartition topicIdPartition$2, AbstractLog log$2) {
        return new StringBuilder(201).append("Not returning estimated log size, since the topic has changed from topicId: ").append(topicIdPartition$2.topicId()).append(" ").append("to topicId: ").append(log$2.topicId()).append("This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic").toString();
    }

    private Utils$() {
    }
}

