/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kafka.common.TenantHelpers;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001B/_\u0001\rD\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t!\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005e\"Aq\u000f\u0001BC\u0002\u0013\u0005\u0001\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003z\u0011!i\bA!b\u0001\n\u0003q\b\"CA\f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\tI\u0002\u0001BC\u0002\u0013%\u00111\u0004\u0005\u000b\u0003S\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u0016\u0001\t\u0015\r\u0011\"\u0001\u0002.!Q\u0011q\u0010\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005\u0005\u0005A!b\u0001\n\u0003\t\u0019\t\u0003\u0006\u0002\f\u0002\u0011\t\u0011)A\u0005\u0003\u000bC!\"!$\u0001\u0005\u000b\u0007I\u0011AAH\u0011)\t)\u000b\u0001B\u0001B\u0003%\u0011\u0011\u0013\u0005\u000b\u0003O\u0003!Q1A\u0005\u0002\u0005%\u0006BCA\\\u0001\t\u0005\t\u0015!\u0003\u0002,\"Q\u0011\u0011\u0018\u0001\u0003\u0006\u0004%\t!a/\t\u0015\u0005\u0005\u0007A!A!\u0002\u0013\ti\fC\u0004\u0002D\u0002!\t!!2\t\u0013\u0005m\u0007A1A\u0005\n\u0005u\u0007\u0002CAs\u0001\u0001\u0006I!a8\t\u0013\u0005\u001d\b\u00011A\u0005\n\u0005%\b\"CAy\u0001\u0001\u0007I\u0011BAz\u0011!\ty\u0010\u0001Q!\n\u0005-\b\"\u0003B\u0001\u0001\u0001\u0007I\u0011BAu\u0011%\u0011\u0019\u0001\u0001a\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0015BAv\u0011%\u0011Y\u0001\u0001a\u0001\n\u0013\tI\u000fC\u0005\u0003\u000e\u0001\u0001\r\u0011\"\u0003\u0003\u0010!A!1\u0003\u0001!B\u0013\tY\u000f\u0003\u0005\u0003\u0016\u0001\u0011\r\u0011\"\u0001r\u0011\u001d\u00119\u0002\u0001Q\u0001\nID\u0001B!\u0007\u0001\u0001\u0004%\t!\u001d\u0005\n\u00057\u0001\u0001\u0019!C\u0001\u0005;AqA!\t\u0001A\u0003&!\u000fC\u0005\u0003$\u0001\u0011\r\u0011\"\u0001\u0003&!A!Q\u0006\u0001!\u0002\u0013\u00119\u0003C\u0005\u0002$\u0001\u0001\r\u0011\"\u0001\u0002\u001c!I!q\u0006\u0001A\u0002\u0013\u0005!\u0011\u0007\u0005\t\u0005k\u0001\u0001\u0015)\u0003\u0002\u001e!Y!q\b\u0001A\u0002\u0003\u0007I\u0011\u0001B!\u0011-\u00119\u0006\u0001a\u0001\u0002\u0004%\tA!\u0017\t\u0017\tu\u0003\u00011A\u0001B\u0003&!1\t\u0005\f\u0005C\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0019\u0007C\u0006\u0003p\u0001\u0001\r\u00111A\u0005\u0002\tE\u0004b\u0003B;\u0001\u0001\u0007\t\u0011)Q\u0005\u0005KB1B!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003|!Y!1\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001BG\u0011-\u0011\t\n\u0001a\u0001\u0002\u0003\u0006KA! \t\u0017\tU\u0005\u00011AA\u0002\u0013\u0005!q\u0013\u0005\f\u0005O\u0003\u0001\u0019!a\u0001\n\u0003\u0011I\u000bC\u0006\u0003.\u0002\u0001\r\u0011!Q!\n\te\u0005\"\u0003BY\u0001\t\u0007I\u0011\u0001BZ\u0011!\u0011\t\u000e\u0001Q\u0001\n\tU\u0006b\u0003Bj\u0001\u0001\u0007\t\u0019!C\u0001\u0005+D1Ba9\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003f\"Y!\u0011\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002Bl\u0011-\u0011i\u000f\u0001a\u0001\u0002\u0004%\tAa<\t\u0017\t]\b\u00011AA\u0002\u0013\u0005!\u0011 \u0005\f\u0005{\u0004\u0001\u0019!A!B\u0013\u0011\t\u0010C\u0006\u0004\u0002\u0001\u0001\r\u00111A\u0005\u0002\r\r\u0001bCB\b\u0001\u0001\u0007\t\u0019!C\u0001\u0007#A1b!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0004\u0006!Y1\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011AB\u000e\u0011-\u0019\u0019\u0004\u0001a\u0001\u0002\u0004%\ta!\u000e\t\u0017\re\u0002\u00011A\u0001B\u0003&1Q\u0004\u0005\f\u0007w\u0001\u0001\u0019!a\u0001\n\u0003\u0019i\u0004C\u0006\u0004X\u0001\u0001\r\u00111A\u0005\u0002\re\u0003bCB/\u0001\u0001\u0007\t\u0011)Q\u0005\u0007\u007fAqaa\u0018\u0001\t\u0013\u0019\t\u0007C\u0004\u0004h\u0001!\ta!\u001b\t\u000f\r-\u0004\u0001\"\u0001\u0004n!91Q\u0011\u0001\u0005\u0002\r\u001d\u0005bBBE\u0001\u0011\u00051q\u0011\u0005\b\u0007\u0017\u0003A\u0011ABD\u0011\u001d\u0019i\t\u0001C\u0001\u0007\u001fCqa!(\u0001\t\u0003\u0019y\tC\u0004\u0004 \u0002!\taa$\t\u000f\r\u0005\u0006\u0001\"\u0001\u0004\u0010\"911\u0015\u0001\u0005\u0002\r=\u0005bBBS\u0001\u0011\u00051q\u0012\u0005\b\u0007O\u0003A\u0011ABH\u0011\u001d\u0019I\u000b\u0001C\u0005\u0007WCqaa,\u0001\t\u0003\u00199\tC\u0004\u00042\u0002!Iaa\"\t\u000f\rM\u0006\u0001\"\u0001\u0004\b\"91Q\u0017\u0001\u0005\n\r]\u0006bBB^\u0001\u0011\u00051QX\u0004\n\u0007\u0003t\u0016\u0011!E\u0001\u0007\u00074\u0001\"\u00180\u0002\u0002#\u00051Q\u0019\u0005\b\u0003\u0007TF\u0011ABd\u0011%\u0019IMWI\u0001\n\u0003\u0019YM\u0001\u0007TQ\u0006\u0014X\rZ*feZ,'O\u0003\u0002`A\u000611/\u001a:wKJT\u0011!Y\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001AM\u001b\t\u0003K\"l\u0011A\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011N\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-tW\"\u00017\u000b\u00055\u0004\u0017!B;uS2\u001c\u0018BA8m\u0005\u001daunZ4j]\u001e\f!c\u001d5be\u0016$7+\u001a:wKJ\u001cuN\u001c4jOV\t!\u000f\u0005\u0002ti6\ta,\u0003\u0002v=\nY1*\u00194lC\u000e{gNZ5h\u0003M\u0019\b.\u0019:fIN+'O^3s\u0007>tg-[4!\u0003%iW\r^1Qe>\u00048/F\u0001z!\t\u0019(0\u0003\u0002|=\nqQ*\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\u0018AC7fi\u0006\u0004&o\u001c9tA\u0005!A/[7f+\u0005y\b\u0003BA\u0001\u0003'i!!a\u0001\u000b\u00075\f)A\u0003\u0003\u0002\b\u0005%\u0011AB2p[6|gNC\u0002b\u0003\u0017QA!!\u0004\u0002\u0010\u00051\u0011\r]1dQ\u0016T!!!\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0016\u0005\r!\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001bX7fiJL7m]\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)!A\u0004nKR\u0014\u0018nY:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\u001b\u0016$(/[2t\u0003%yV.\u001a;sS\u000e\u001c\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005=\u0002CBA\u0019\u0003\u007f\t\u0019%\u0004\u0002\u00024)!\u0011QGA\u001c\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003s\tY$\u0001\u0003vi&d'BAA\u001f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u00131\u0007\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA#\u0003\u000f\nY%a\u0016\u000e\u0005\u0005]\u0012\u0002BA%\u0003o\u00111!T1q!\u0011\ti%a\u0015\u000e\u0005\u0005=#\u0002BA)\u0003w\tA\u0001\\1oO&!\u0011QKA(\u0005\u001dIe\u000e^3hKJ\u0004B!!\u0017\u0002z9!\u00111LA:\u001d\u0011\ti&a\u001c\u000f\t\u0005}\u0013Q\u000e\b\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005%TBAA3\u0015\r\t9GY\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005E\u0011\u0002BA\u0007\u0003\u001fI1!YA\u0006\u0013\u0011\t\t(!\u0003\u0002\tI\fg\r^\u0005\u0005\u0003k\n9(\u0001\u0006SC\u001a$8i\u001c8gS\u001eTA!!\u001d\u0002\n%!\u00111PA?\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\t\u0005U\u0014qO\u0001\u001eG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:fA\u0005\u0019b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssV\u0011\u0011Q\u0011\t\u0004g\u0006\u001d\u0015bAAE=\n\u0019b)Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0006!b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0002\n1#\\;mi&$VM\\1oi6+G/\u00193bi\u0006,\"!!%\u0011\u000b\u0015\f\u0019*a&\n\u0007\u0005UeM\u0001\u0004PaRLwN\u001c\t\u0005\u00033\u000b\t+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003-iW\u000f\u001c;ji\u0016t\u0017M\u001c;\u000b\u0007}\u000bI!\u0003\u0003\u0002$\u0006m%aE'vYRLG+\u001a8b]RlU\r^1eCR\f\u0017\u0001F7vYRLG+\u001a8b]RlU\r^1eCR\f\u0007%\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u0002,B!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006%\u0011\u0001C7fi\u0006$\u0017\r^1\n\t\u0005U\u0016q\u0016\u0002\u0012\u0017\u000647.Y\"p]\u001aLwmU2iK6\f\u0017!D2p]\u001aLwmU2iK6\f\u0007%A\u000bj]R,'O\u0011:pW\u0016\u0014\bk\u001c:u\rV$XO]3\u0016\u0005\u0005u\u0006#B3\u0002\u0014\u0006}\u0006CBA\u0019\u0003\u007f\tY%\u0001\fj]R,'O\u0011:pW\u0016\u0014\bk\u001c:u\rV$XO]3!\u0003\u0019a\u0014N\\5u}Q!\u0012qYAe\u0003\u0017\fi-a4\u0002R\u0006M\u0017Q[Al\u00033\u0004\"a\u001d\u0001\t\u000bA\u001c\u0002\u0019\u0001:\t\u000b]\u001c\u0002\u0019A=\t\u000bu\u001c\u0002\u0019A@\t\u000f\u0005e1\u00031\u0001\u0002\u001e!9\u00111F\nA\u0002\u0005=\u0002bBAA'\u0001\u0007\u0011Q\u0011\u0005\b\u0003\u001b\u001b\u0002\u0019AAI\u0011\u001d\t9k\u0005a\u0001\u0003WC\u0011\"!/\u0014!\u0003\u0005\r!!0\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0002`B!\u0011\u0011AAq\u0013\u0011\t\u0019/a\u0001\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013aB:uCJ$X\rZ\u000b\u0003\u0003W\u00042!ZAw\u0013\r\tyO\u001a\u0002\b\u0005>|G.Z1o\u0003-\u0019H/\u0019:uK\u0012|F%Z9\u0015\t\u0005U\u00181 \t\u0004K\u0006]\u0018bAA}M\n!QK\\5u\u0011%\tipFA\u0001\u0002\u0004\tY/A\u0002yIE\n\u0001b\u001d;beR,G\rI\u0001\rkN,GMQ=Ce>\\WM]\u0001\u0011kN,GMQ=Ce>\\WM]0%KF$B!!>\u0003\b!I\u0011Q \u000e\u0002\u0002\u0003\u0007\u00111^\u0001\u000ekN,GMQ=Ce>\\WM\u001d\u0011\u0002!U\u001cX\r\u001a\"z\u0007>tGO]8mY\u0016\u0014\u0018\u0001F;tK\u0012\u0014\u0015pQ8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002v\nE\u0001\"CA\u007f;\u0005\u0005\t\u0019AAv\u0003E)8/\u001a3Cs\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002!\r|g\u000e\u001e:pY2,'oQ8oM&<\u0017\u0001F2p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002v\n}\u0001\u0002CA\u007fE\u0005\u0005\t\u0019\u0001:\u0002#\r|g\u000e\u001e:pY2,'oQ8oM&<\u0007%\u0001\rnKR\fG-\u0019;b\u000b:\u001c'/\u001f9u_J4\u0015m\u0019;pef,\"Aa\n\u0011\t\u00055&\u0011F\u0005\u0005\u0005W\tyK\u0001\rNKR\fG-\u0019;b\u000b:\u001c'/\u001f9u_J4\u0015m\u0019;pef\f\u0011$\\3uC\u0012\fG/Y#oGJL\b\u000f^8s\r\u0006\u001cGo\u001c:zA\u0005YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\t)Pa\r\t\u0013\u0005ux%!AA\u0002\u0005u\u0011\u0001C7fiJL7m\u001d\u0011)\u0007!\u0012I\u0004E\u0002f\u0005wI1A!\u0010g\u0005!1x\u000e\\1uS2,\u0017a\u0003:bMRl\u0015M\\1hKJ,\"Aa\u0011\u0011\r\t\u0015#\u0011\nB'\u001b\t\u00119EC\u0002\u0002r\u0001LAAa\u0013\u0003H\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0005\u0005\u001f\u0012\u0019&\u0004\u0002\u0003R)!\u0011qAAP\u0013\u0011\u0011)F!\u0015\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003=\u0011\u0018M\u001a;NC:\fw-\u001a:`I\u0015\fH\u0003BA{\u00057B\u0011\"!@+\u0003\u0003\u0005\rAa\u0011\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011)\u0007-\u0012I$A\u0007ce>\\WM]'fiJL7m]\u000b\u0003\u0005K\u0002BAa\u001a\u0003l5\u0011!\u0011\u000e\u0006\u0004\u0003cs\u0016\u0002\u0002B7\u0005S\u00121C\u0011:pW\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\f\u0011C\u0019:pW\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\t)Pa\u001d\t\u0013\u0005uX&!AA\u0002\t\u0015\u0014A\u00042s_.,'/T3ue&\u001c7\u000f\t\u0015\u0004]\te\u0012aF2p]R\u0014x\u000e\u001c7feN+'O^3s\u001b\u0016$(/[2t+\t\u0011i\b\u0005\u0003\u0003\u0000\t\u001dUB\u0001BA\u0015\u0011\t\u0019Ca!\u000b\t\t\u0015\u0015\u0011B\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002BE\u0005\u0003\u0013\u0011dQ8oiJ|G\u000e\\3s\u001b\u0016$\u0018\rZ1uC6+GO]5dg\u0006Y2m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]0%KF$B!!>\u0003\u0010\"I\u0011Q \u0019\u0002\u0002\u0003\u0007!QP\u0001\u0019G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\u0004\u0003fA\u0019\u0003:\u00051An\\1eKJ,\"A!'\u0011\t\tm%1U\u0007\u0003\u0005;SAA!&\u0003 *!!\u0011UA\u0005\u0003\u0015IW.Y4f\u0013\u0011\u0011)K!(\u0003\u001d5+G/\u00193bi\u0006du.\u00193fe\u0006QAn\\1eKJ|F%Z9\u0015\t\u0005U(1\u0016\u0005\n\u0003{\u001c\u0014\u0011!a\u0001\u00053\u000bq\u0001\\8bI\u0016\u0014\b\u0005K\u00025\u0005s\tqc\u001d8baNDw\u000e^:ESN\f'\r\\3e%\u0016\f7o\u001c8\u0016\u0005\tU\u0006C\u0002B\\\u0005{\u0013\t-\u0004\u0002\u0003:*!!1XA\u001a\u0003\u0019\tGo\\7jG&!!q\u0018B]\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003\u0002Bb\u0005\u0017tAA!2\u0003HB\u0019\u00111\r4\n\u0007\t%g-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001b\u0014yM\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u00134\u0017\u0001G:oCB\u001c\bn\u001c;t\t&\u001c\u0018M\u00197fIJ+\u0017m]8oA\u0005y1O\\1qg\"|G/R7jiR,'/\u0006\u0002\u0003XB!!\u0011\u001cBp\u001b\t\u0011YN\u0003\u0003\u0003^\n}\u0015!\u00039vE2L7\u000f[3s\u0013\u0011\u0011\tOa7\u0003\u001fMs\u0017\r]:i_R,U.\u001b;uKJ\f1c\u001d8baNDw\u000e^#nSR$XM]0%KF$B!!>\u0003h\"I\u0011Q \u001d\u0002\u0002\u0003\u0007!q[\u0001\u0011g:\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;fe\u0002B3!\u000fB\u001d\u0003E\u0019h.\u00199tQ>$x)\u001a8fe\u0006$xN]\u000b\u0003\u0005c\u0004BA!7\u0003t&!!Q\u001fBn\u0005E\u0019f.\u00199tQ>$x)\u001a8fe\u0006$xN]\u0001\u0016g:\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014x\fJ3r)\u0011\t)Pa?\t\u0013\u0005u8(!AA\u0002\tE\u0018AE:oCB\u001c\bn\u001c;HK:,'/\u0019;pe\u0002B3\u0001\u0010B\u001d\u0003UiW\r^1eCR\fGj\\1eKJlU\r\u001e:jGN,\"a!\u0002\u0011\t\r\u001d11B\u0007\u0003\u0007\u0013QA!a\t\u0003\u001e&!1QBB\u0005\u0005UiU\r^1eCR\fGj\\1eKJlU\r\u001e:jGN\f\u0011$\\3uC\u0012\fG/\u0019'pC\u0012,'/T3ue&\u001c7o\u0018\u0013fcR!\u0011Q_B\n\u0011%\tiPPA\u0001\u0002\u0004\u0019)!\u0001\fnKR\fG-\u0019;b\u0019>\fG-\u001a:NKR\u0014\u0018nY:!Q\ry$\u0011H\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H/\u0006\u0002\u0004\u001eA1\u0011QIB\u0010\u0007GIAa!\t\u00028\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0004&\r=RBAB\u0014\u0015\u0011\u0019Ica\u000b\u0002\u000bM$xN]3\u000b\u0007\r5\u0002-\u0001\u0003uS\u0016\u0014\u0018\u0002BB\u0019\u0007O\u0011q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0017i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003Ho\u0018\u0013fcR!\u0011Q_B\u001c\u0011%\ti0QA\u0001\u0002\u0004\u0019i\"A\nuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u001fB$\b%\u0001\tiiR\u00048+\u001a:wKJ\u0014\u0015N\u001c3feV\u00111q\b\t\u0005\u0007\u0003\u001a\u0019&\u0004\u0002\u0004D)\u0019ql!\u0012\u000b\t\r\u001d3\u0011J\u0001\u0005QR$\bOC\u0002b\u0007\u0017RAa!\u0014\u0004P\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0007#\n!![8\n\t\rU31\t\u0002\u0016\u0017\u000647.\u0019%uiB\u001cVM\u001d<fe\nKg\u000eZ3s\u0003QAG\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'o\u0018\u0013fcR!\u0011Q_B.\u0011%\ti\u0010RA\u0001\u0002\u0004\u0019y$A\tiiR\u00048+\u001a:wKJ\u0014\u0015N\u001c3fe\u0002\n!bY8qs\u000e{gNZ5h)\r\u001181\r\u0005\u0007\u0007K2\u0005\u0019\u0001:\u0002\r\r|gNZ5h\u0003\u0019I7/V:fIR\u0011\u00111^\u0001\u000fgR\f'\u000f\u001e$pe\n\u0013xn[3s)\u0011\t)pa\u001c\t\u000f\rE\u0004\n1\u0001\u0004t\u0005\u00012\r[3dWN,Xn\u0015;pe\u0016|\u0005\u000f\u001e\t\u0007\u0003\u000b\u001ayb!\u001e\u0011\t\r]4\u0011Q\u0007\u0003\u0007sRAaa\u001f\u0004~\u0005A1\r[3dWN,XN\u0003\u0003\u0004\u0000\r%\u0013aB:u_J\fw-Z\u0005\u0005\u0007\u0007\u001bIH\u0001\tFe\u0015\u001b\u0005.Z2lgVl7\u000b^8sK\u0006\u00112\u000f^1si\u001a{'oQ8oiJ|G\u000e\\3s)\t\t)0A\u0007ti>\u0004hi\u001c:Ce>\\WM]\u0001\u0012gR|\u0007OR8s\u0007>tGO]8mY\u0016\u0014\u0018a\u0006:bMRl\u0015M\\1hKJ4\u0015-\u001e7u\u0011\u0006tG\r\\3s+\t\u0019\t\n\u0005\u0003\u0004\u0014\u000eeUBABK\u0015\u0011\u00199*a(\u0002\u000b\u0019\fW\u000f\u001c;\n\t\rm5Q\u0013\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001b[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001eG>tGO]8mY\u0016\u00148\u000b^1siV\u0004h)Y;mi\"\u000bg\u000e\u001a7fe\u0006)\u0013N\\5uS\u0006d'I]8lKJlU\r^1eCR\fGj\\1e\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\"M\u0006$\u0018\r\\)v_J,XnQ8oiJ|G\u000e\\3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001%]>tg)\u0019;bYF+xN];n\u0007>tGO]8mY\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003k\u001ci\u000bC\u0004\u0004rM\u0003\raa\u001d\u0002'\u0015t7/\u001e:f\u001d>$(+\u00194u\u0019\u0016\fG-\u001a:\u0002\tM$x\u000e]\u0001\u0015S:LG\u000f\u0013;uaN+'O^3s\u0005&tG-\u001a:\u00023%t\u0017\u000e^5bY&TX\rV5fe>\u0013'.Z2u'R|'/\u001a\u000b\u0005\u0007;\u0019I\fC\u0004\u0004r]\u0003\raa\u001d\u0002/%tG/\u001a:Ce>\\WM]\"mS\u0016tGoQ8oM&<GCAB`!\u001d\t)%a\u0012\u0003B\u0012\fAb\u00155be\u0016$7+\u001a:wKJ\u0004\"a\u001d.\u0014\u0005i#GCABb\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u00111Q\u001a\u0016\u0005\u0003{\u001bym\u000b\u0002\u0004RB!11[Bo\u001b\t\u0019)N\u0003\u0003\u0004X\u000ee\u0017!C;oG\",7m[3e\u0015\r\u0019YNZ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBp\u0007+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final KafkaConfigSchema configSchema;
    private final Option<CompletableFuture<Integer>> interBrokerPortFuture;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private KafkaConfig controllerConfig;
    private final MetadataEncryptorFactory metadataEncryptorFactory;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Optional<TierObjectStore> tierObjectStoreOpt;
    private KafkaHttpServerBinder httpServerBinder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<CompletableFuture<Integer>> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public Option<CompletableFuture<Integer>> interBrokerPortFuture() {
        return this.interBrokerPortFuture;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public void controllerConfig_$eq(KafkaConfig x$1) {
        this.controllerConfig = x$1;
    }

    public MetadataEncryptorFactory metadataEncryptorFactory() {
        return this.metadataEncryptorFactory;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    public void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public Optional<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public void tierObjectStoreOpt_$eq(Optional<TierObjectStore> x$1) {
        this.tierObjectStoreOpt = x$1;
    }

    public KafkaHttpServerBinder httpServerBinder() {
        return this.httpServerBinder;
    }

    public void httpServerBinder_$eq(KafkaHttpServerBinder x$1) {
        this.httpServerBinder = x$1;
    }

    private KafkaConfig copyConfig(KafkaConfig config) {
        return new KafkaConfig(config.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$, (Option<String>)new Some((Object)config.brokerSessionUuid()));
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (!this.isUsed()) {
            this.start(checksumStoreOpt);
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start(Optional.empty());
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$10)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$11 -> {
                    x$11.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$12 -> {
                    x$12.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$13)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$15 -> {
                    x$15.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$16 -> {
                    x$16.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$17)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$18 -> {
                    x$18.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void start(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                void apply_time;
                Time time = this.time();
                Metrics apply_metrics = this.metrics();
                Object var7_3 = null;
                time = null;
                this.brokerMetrics_$eq(new BrokerServerMetrics(apply_metrics, (Time)apply_time));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            this.tierObjectStoreOpt_$eq(this.initializeTierObjectStore(checksumStoreOpt));
            KafkaRaftManager _raftManager = (KafkaRaftManager)Option$.MODULE$.apply(this.raftManager()).getOrElse((Function0 & Serializable)() -> new KafkaRaftManager(this.metaProps(), this.sharedServerConfig(), new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler(), this.tierObjectStoreOpt()));
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            Function<String, String> nameToTenantCallback = this.multiTenantMetadata().isDefined() ? TenantHelpers.NAME_TO_TENANT_CALLBACK : TenantHelpers.NAME_TO_NULL_CALLBACK;
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$19 -> {}, x$20 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics()).setMetadataEncryptorFactory(this.metadataEncryptorFactory()).setNameToTenantCallback(nameToTenantCallback);
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(_raftManager.client()).setConfigSchema(this.configSchema()).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register(this.loader());
            this.initHttpServerBinder();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().close(), this, Level.WARN);
            this.loader_$eq(null);
        }
        if (this.metadataLoaderMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metadataLoaderMetrics().close(), this, Level.WARN);
            this.metadataLoaderMetrics_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().close(), this, Level.WARN);
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        if (this.tierObjectStoreOpt().isPresent()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.tierObjectStoreOpt().get().close(), this, Level.WARN);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerServerMetrics().close(), this, Level.WARN);
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.brokerMetrics().close(), this, Level.WARN);
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metrics().close(), this, Level.WARN);
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.httpServerBinder_$eq(null);
        this.started_$eq(false);
    }

    public synchronized void initHttpServerBinder() {
        if (this.httpServerBinder() == null) {
            this.httpServerBinder_$eq(new KafkaHttpServerBinder());
            return;
        }
    }

    private Optional<TierObjectStore> initializeTierObjectStore(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) || !this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) && Predef$.MODULE$.Boolean2boolean(this.sharedServerConfig().confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return TierObjectStoreUtils.maybeCreateTierObjectStore(this.copyConfig(this.sharedServerConfig()), this.metaProps().clusterId(), this.metrics(), this.time(), checksumStoreOpt);
        }
        return Optional.empty();
    }

    public Map<String, Object> interBrokerClientConfig() {
        Map result = ConfluentConfigs.clientConfigsForEndpoint(this.sharedServerConfig().originals(), this.sharedServerConfig().values(), (ListenerName)this.sharedServerConfig().interBrokerListenerName(), (SecurityProtocol)this.sharedServerConfig().interBrokerSecurityProtocol());
        this.interBrokerPortFuture().foreach((Function1 & Serializable)future -> {
            try {
                Integer port = (Integer)future.get(10L, TimeUnit.MINUTES);
                String hostName = Utils.formatAddress((String)this.sharedServerConfig().interBrokerHostNameFromAdvertisedListeners(), (Integer)port);
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Using %s as %s for inter broker client config."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{hostName, "bootstrap.servers"})));
                return result.put("bootstrap.servers", hostName);
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to determine the inter-broker port used by the co-located broker.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw new RuntimeException("Failed to determine the inter-broker port used by the co-located broker.", e);
            }
        });
        return Collections.unmodifiableMap(result);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$10) {
        return x$10.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$13) {
        return x$13.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$17) {
        return x$17.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory, Option<MultiTenantMetadata> multiTenantMetadata, KafkaConfigSchema configSchema, Option<CompletableFuture<Integer>> interBrokerPortFuture) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        this.multiTenantMetadata = multiTenantMetadata;
        this.configSchema = configSchema;
        this.interBrokerPortFuture = interBrokerPortFuture;
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = this.copyConfig(sharedServerConfig);
        this.controllerConfig = this.copyConfig(sharedServerConfig);
        this.metadataEncryptorFactory = new MetadataEncryptorFactory(sharedServerConfig.originals());
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

