/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import kafka.server.ClusterLinkQuotas;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkCheckAvailability;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.LazyResource;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskType;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=e!\u0002\u001b6\u0003\u0003a\u0004\u0002C)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011Y\u0003!\u0011!Q\u0001\nMC\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00053\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003c\u0011!1\u0007A!b\u0001\n\u00039\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00111\u0004!Q1A\u0005\u00025D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\tq\u0002\u0011\t\u0019!C\u0005s\"A!\u0010\u0001BA\u0002\u0013%1\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0011)Q\u0005c\"Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\tI\u0003C\u0004\u00022\u0001!\t!a\r\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013E\u0011\u0011\n\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n#\t\u0019\u0006C\u0006\u0002X\u0001\u0001\r\u0011!Q!\n\u0005-\u0003\"CA.\u0001\u0001\u0007I\u0011BA/\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0015BA0\u0011%\ty\u0007\u0001b\u0001\n\u0013\t\t\b\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BA:\u0011-\t\u0019\u000b\u0001a\u0001\u0002\u0004%I!!*\t\u0017\u0005\u0015\u0007\u00011AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003\u0007\u0004\u0001\u0019!A!B\u0013\t9\u000bC\u0005\u0002T\u0002\u0011\r\u0011\"\u0005\u0002V\"A\u00111\u001d\u0001!\u0002\u0013\t9\u000eC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011Q\u001e\u0001\u0005\n\u0005-\bbBAx\u0001\u0019E\u00111\u001e\u0005\b\u0003c\u0004a\u0011CAv\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003WDq!!>\u0001\t\u0013\tY\u000fC\u0004\u0002x\u00021\t\"a;\t\u000f\u0005e\bA\"\u0005\u0002l\"A\u00111 \u0001\u0005\u0002U\ni\u0010\u0003\u0005\u0003&\u0001!\t!\u000eB\u0014\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqAa\u000f\u0001\t\u0003\tY\u000fC\u0004\u0003>\u0001!\t!a;\t\u000f\t}\u0002\u0001\"\u0001\u0003B!A!\u0011\n\u0001\u0005BU\u0012Y\u0005\u0003\u0004\u0003R\u0001!\t!\u001f\u0005\b\u0005'\u0002A\u0011\tB+\u0011\u001d\u0011I\u0007\u0001D\t\u0005WBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003|\u0001!\tE! \t\u000f\t5\u0005\u0001\"\u0003\u0002l\n\u0001\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0015\t1t'\u0001\u0003mS:\\'B\u0001\u001d:\u0003\u0019\u0019XM\u001d<fe*\t!(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001i4i\u0013\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011CeBA#G\u001b\u0005)\u0014BA$6\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005%S%!D\"mS\u0016tG/T1oC\u001e,'O\u0003\u0002HkA\u0011AjT\u0007\u0002\u001b*\u0011a*O\u0001\u0006kRLGn]\u0005\u0003!6\u0013q\u0001T8hO&tw-\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#A*\u0011\u0005\u0015#\u0016BA+6\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002\u00111Lgn\u001b#bi\u0006,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039f\n!A_6\n\u0005y[&aD\"mkN$XM\u001d'j].$\u0015\r^1\u0002\u00131Lgn\u001b#bi\u0006\u0004\u0013a\u00037j].lU\r\u001e:jGN,\u0012A\u0019\t\u0003\u000b\u000eL!\u0001Z\u001b\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\rY&t7.T3ue&\u001c7\u000fI\u0001\ng\u000eDW\rZ;mKJ,\u0012\u0001\u001b\t\u0003\u000b&L!A[\u001b\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0011Y&t7.\u00113nS:4\u0015m\u0019;pef,\u0012A\u001c\t\u0005}=\fH/\u0003\u0002q\u007f\tIa)\u001e8di&|g.\r\t\u0003\u000bJL!a]\u001b\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0005\u0002Fk&\u0011a/\u000e\u0002\u0017\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u001cE.[3oi\u0006\tB.\u001b8l\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\u0011\u0002\u00151Lgn[\"p]\u001aLw-F\u0001r\u00039a\u0017N\\6D_:4\u0017nZ0%KF$\"\u0001`@\u0011\u0005yj\u0018B\u0001@@\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005A\"!AA\u0002E\f1\u0001\u001f\u00132\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011)\u00075\t9\u0001E\u0002?\u0003\u0013I1!a\u0003@\u0005!1x\u000e\\1uS2,\u0017\u0001\u0002;j[\u0016\u0004B!!\u0005\u0002$5\u0011\u00111\u0003\u0006\u0004\u001d\u0006U!\u0002BA\f\u00033\taaY8n[>t'b\u0001\u001e\u0002\u001c)!\u0011QDA\u0010\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011E\u0001\u0004_J<\u0017\u0002BA\u0013\u0003'\u0011A\u0001V5nK\u00061\u0011/^8uCN\u0004B!a\u000b\u0002.5\tq'C\u0002\u00020]\u0012\u0011c\u00117vgR,'\u000fT5oWF+x\u000e^1t\u0003\u0019a\u0014N\\5u}Q\u0011\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@\u0005\u0005\u00131IA#!\t)\u0005\u0001C\u0003R!\u0001\u00071\u000bC\u0003X!\u0001\u0007\u0011\fC\u0003a!\u0001\u0007!\rC\u0003g!\u0001\u0007\u0001\u000eC\u0003m!\u0001\u0007a\u000eC\u0003y!\u0001\u0007\u0011\u000fC\u0004\u0002\u000eA\u0001\r!a\u0004\t\u000f\u0005\u001d\u0002\u00031\u0001\u0002*\u0005)\u0011\rZ7j]V\u0011\u00111\n\t\u0005}\u00055C/C\u0002\u0002P}\u0012aa\u00149uS>t\u0017!C1e[&tw\fJ3r)\ra\u0018Q\u000b\u0005\n\u0003\u0003\u0011\u0012\u0011!a\u0001\u0003\u0017\na!\u00193nS:\u0004\u0003fA\n\u0002\b\u0005a2\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRLXCAA0!\u0015q\u0014QJA1!\r)\u00151M\u0005\u0004\u0003K*$\u0001H\"mkN$XM\u001d'j].\u001c\u0005.Z2l\u0003Z\f\u0017\u000e\\1cS2LG/_\u0001!G2,8\u000f^3s\u0019&t7n\u00115fG.\fe/Y5mC\nLG.\u001b;z?\u0012*\u0017\u000fF\u0002}\u0003WB\u0011\"!\u0001\u0016\u0003\u0003\u0005\r!a\u0018\u0002;\rdWo\u001d;fe2Kgn[\"iK\u000e\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u0002\nQ\u0002\\1{sJ+7o\\;sG\u0016\u001cXCAA:!\u0019\t)(a \u0002\u00046\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0004nkR\f'\r\\3\u000b\u0007\u0005ut(\u0001\u0006d_2dWm\u0019;j_:LA!!!\u0002x\t1!)\u001e4gKJ\u0004D!!\"\u0002\u0010B)Q)a\"\u0002\f&\u0019\u0011\u0011R\u001b\u0003\u00191\u000b'0\u001f*fg>,(oY3\u0011\t\u00055\u0015q\u0012\u0007\u0001\t-\t\t\nGA\u0001\u0002\u0003\u0015\t!!&\u0003\u0007}#\u0013'\u0001\bmCjL(+Z:pkJ\u001cWm\u001d\u0011\u0012\t\u0005]\u0015Q\u0014\t\u0004}\u0005e\u0015bAAN\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0002 &\u0019\u0011\u0011U \u0003\u0007\u0005s\u00170\u0001\rmCjL(+Z:pkJ\u001cWMU3ba\u0016\u0014h)\u001e;ve\u0016,\"!a*1\t\u0005%\u0016q\u0018\t\u0007\u0003W\u000bI,!0\u000e\u0005\u00055&\u0002BAX\u0003c\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\u0019,!.\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003o\u000bAA[1wC&!\u00111XAW\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BAG\u0003\u007f#1\"!1\u001c\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\n\u0019q\f\n\u001a\u000231\f'0\u001f*fg>,(oY3SK\u0006\u0004XM\u001d$viV\u0014X\rI\u0001\u001dY\u0006T\u0018PU3t_V\u00148-\u001a*fCB,'OR;ukJ,w\fJ3r)\ra\u0018\u0011\u001a\u0005\n\u0003\u0003Q\u0012\u0011!a\u0001\u0003\u0017\u0004D!!4\u0002RB1\u00111VA]\u0003\u001f\u0004B!!$\u0002R\u0012a\u0011\u0011YAe\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\u0006!An\\2l+\t\t9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\u0011\ti.!.\u0002\t1\fgnZ\u0005\u0005\u0003C\fYN\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0012GJ,\u0017\r^3SK6|G/Z!e[&tG#\u0001;\u0002\u000fM$\u0018M\u001d;vaR\tA0\u0001\nti\u0006\u0014H/\u001e9BGRLg/\u001a+bg.\u001c\u0018\u0001H:uCJ$X\u000f]!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f)\u0006\u001c8n]\u0001'gR\f'\u000f^;q\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017i\u0019;jm\u0016|%/\u00138bGRLg/\u001a+bg.\u001c\u0018\u0001C:ikR$wn\u001e8\u0002'MDW\u000f\u001e3po:\f5\r^5wKR\u000b7o[:\u0002;MDW\u000f\u001e3po:\fE\rZ5uS>t\u0017\r\\!di&4X\rV1tWN\fqe\u001d5vi\u0012|wO\\!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f\u001fJLe.Y2uSZ,G+Y:lg\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0015a\u0018q B\u0002\u0011\u0019\u0011\ta\na\u0001c\u0006Ia.Z<D_:4\u0017n\u001a\u0005\b\u0005\u000b9\u0003\u0019\u0001B\u0004\u0003-)\b\u000fZ1uK\u0012\\U-_:\u0011\r\t%!1\u0002B\b\u001b\t\tY(\u0003\u0003\u0003\u000e\u0005m$aA*fiB!!\u0011\u0003B\u0010\u001d\u0011\u0011\u0019Ba\u0007\u0011\u0007\tUq(\u0004\u0002\u0003\u0018)\u0019!\u0011D\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\u0011ibP\u0001\u0007!J,G-\u001a4\n\t\t\u0005\"1\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tuq(A\nhKR\u001cE.^:uKJd\u0015N\\6BI6Lg.F\u0001u\u0003!9W\r^!e[&tWC\u0001B\u0017!\u0011\u0011yCa\u000e\u000e\u0005\tE\"\u0002BA$\u0005gQAA!\u000e\u0002\u001a\u000591\r\\5f]R\u001c\u0018\u0002\u0002B\u001d\u0005c\u0011abQ8oM2,XM\u001c;BI6Lg.A\tde\u0016\fG/Z!oIN+G/\u00113nS:\f!b\u00197pg\u0016\fE-\\5o\u0003!I7/Q2uSZ,GC\u0001B\"!\rq$QI\u0005\u0004\u0005\u000fz$a\u0002\"p_2,\u0017M\\\u0001\u0015_:\fe/Y5mC\nLG.\u001b;z\u0007\"\fgnZ3\u0015\u0007q\u0014i\u0005C\u0004\u0003P5\u0002\rAa\u0011\u0002\u0017%\u001c\u0018I^1jY\u0006\u0014G.Z\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$BAa\u0016\u0003`A)a(!\u0014\u0003ZA\u0019QIa\u0017\n\u0007\tuSGA\bUCN\\G)Z:de&\u0004H/[8o\u0011\u001d\u0011\tg\fa\u0001\u0005G\n\u0001\u0002^1tWRK\b/\u001a\t\u0004\u000b\n\u0015\u0014b\u0001B4k\tAA+Y:l)f\u0004X-\u0001\u0011uCN\\G)Z:de&\u0004H/[8o\r>\u0014\u0018\t\u001a3ji&|g.\u00197UCN\\G\u0003\u0002B,\u0005[BqA!\u00191\u0001\u0004\u0011\u0019'A\bsK6|G/\u001a'j].\u001cF/\u0019;f+\t\u0011\u0019\bE\u0003?\u0003\u001b\u0012)\bE\u0002F\u0005oJ1A!\u001f6\u0005=\u0011V-\\8uK2Kgn[*uCR,\u0017\u0001\u0006:fO&\u001cH/\u001a:MCjL(+Z:pkJ\u001cW\rF\u0002}\u0005\u007fBqA!!3\u0001\u0004\u0011\u0019)\u0001\u0007mCjL(+Z:pkJ\u001cW\r\r\u0003\u0003\u0006\n%\u0005#B#\u0002\b\n\u001d\u0005\u0003BAG\u0005\u0013#ABa#\u0003\u0000\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00134\u0003U\u0019\b.\u001e;e_^t\u0017\n\u001a7f%\u0016\u001cx.\u001e:dKN\u0004")
public abstract class AbstractClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetrics linkMetrics;
    private final ClusterLinkScheduler scheduler;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory;
    private volatile ClusterLinkConfig linkConfig;
    private final Time time;
    private final ClusterLinkQuotas quotas;
    private volatile Option<ClusterLinkAdminClient> admin;
    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability;
    private final Buffer<LazyResource<?>> lazyResources;
    private ScheduledFuture<?> lazyResourceReaperFuture;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    @Override
    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory() {
        return this.linkAdminFactory;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    public Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    public void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Buffer<LazyResource<?>> lazyResources() {
        return this.lazyResources;
    }

    private ScheduledFuture<?> lazyResourceReaperFuture() {
        return this.lazyResourceReaperFuture;
    }

    private void lazyResourceReaperFuture_$eq(ScheduledFuture<?> x$1) {
        this.lazyResourceReaperFuture = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    public ClusterLinkAdminClient createRemoteAdmin() {
        return (ClusterLinkAdminClient)this.linkAdminFactory().apply((Object)this.linkConfig());
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.startupAdditionalActiveOrInactiveTasks();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Startup of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this.currentConfig(), this.linkMetrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin(), this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
        this.startupAdditionalActiveTasks();
        this.lazyResourceReaperFuture_$eq(this.scheduler().schedule("ShutdownIdleResources", () -> this.shutdownIdleResources(), this.currentConfig().clientsMaxIdleMs(), this.currentConfig().clientsMaxIdleMs()));
    }

    public abstract void startupAdditionalActiveTasks();

    public abstract void startupAdditionalActiveOrInactiveTasks();

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Shutting down ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        this.shutdownAdditionalActiveOrInactiveTasks();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Shutdown of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)None$.MODULE$);
        this.shutdownAdditionalActiveTasks();
        Option$.MODULE$.apply(this.lazyResourceReaperFuture()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.cancel(true)));
        this.lazyResourceReaperFuture_$eq(null);
    }

    public abstract void shutdownAdditionalActiveTasks();

    public abstract void shutdownAdditionalActiveOrInactiveTasks();

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.linkConfig_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Reconfiguring ").append(this.getClass().getSimpleName()).append(". oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Reconfiguring AdminClient and restarting tasks for ").append(this.getClass().getSimpleName()).toString());
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks();
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    public ClusterLinkAdminClient getClusterLinkAdmin() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public ConfluentAdmin getAdmin() {
        return this.getClusterLinkAdmin().admin();
    }

    public void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some((Object)this.createRemoteAdmin()));
    }

    public void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> a.close(), this, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused());
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks();
            if (!Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.linkConfig().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.linkConfig().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this.linkConfig(), this.linkMetrics(), this.clusterLinkManager(), intervalMs, this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin(), this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.linkConfig();
    }

    @Override
    public Option<TaskDescription> taskDescription(TaskType taskType) {
        if (ClusterLinkCheckAvailabilityTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkCheckAvailability().flatMap((Function1 & Serializable)x$5 -> x$5.taskDescription());
        }
        return this.taskDescriptionForAdditionalTask(taskType);
    }

    public abstract Option<TaskDescription> taskDescriptionForAdditionalTask(TaskType var1);

    public Option<RemoteLinkState> remoteLinkState() {
        return this.clusterLinkCheckAvailability().map((Function1 & Serializable)x$6 -> x$6.remoteLinkState());
    }

    @Override
    public void registerLazyResource(LazyResource<?> lazyResource) {
        this.lazyResources().$plus$eq(lazyResource);
    }

    private void shutdownIdleResources() {
        this.lazyResources().foreach((Function1 & Serializable)x$7 -> {
            x$7.closeIdleResource();
            return BoxedUnit.UNIT;
        });
    }

    public AbstractClusterLinkClientManager(ClusterLinkManager clusterLinkManager, ClusterLinkData linkData, ClusterLinkMetrics linkMetrics, ClusterLinkScheduler scheduler, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, ClusterLinkConfig linkConfig, Time time, ClusterLinkQuotas quotas) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.linkMetrics = linkMetrics;
        this.scheduler = scheduler;
        this.linkAdminFactory = linkAdminFactory;
        this.linkConfig = linkConfig;
        this.time = time;
        this.quotas = quotas;
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.lazyResources = (Buffer)Buffer$.MODULE$.empty();
        this.lock = new Object();
    }
}

