/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkFetcherThread$AdjustmentType$;
import kafka.server.link.ClusterLinkFetcherThread$MaxPartitionLagOrder$;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$SourceTopicIdChanged$;
import kafka.server.link.MirrorFailureType$UnexpectedTruncation$;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011=a!B%K\u0003\u0003\t\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015D\u0011\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b8\t\u0011E\u0004!\u0011!Q\u0001\nID\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\ts\u0002\u0011\t\u0011)A\u0005u\"AQ\u0010\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\t\u0019\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005E\u0002BCA\u001c\u0001\t\u0005\t\u0015!\u0003\u0002:!Q\u0011q\b\u0001\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\tI\u0005\u0003\u0006\u0002P\u0001\u0011\t\u0011)A\u0005\u0003#B1\"!\u0018\u0001\u0005\u000b\u0007I\u0011\u0001&\u0002`!Q\u0011q\r\u0001\u0003\u0002\u0003\u0006I!!\u0019\t\u0015\u0005%\u0004A!A!\u0002\u0013\tY\u0007\u0003\u0006\u0002x\u0001\u0011\t\u0011)A\u0005\u0003sBq!a\u001f\u0001\t\u0003\ti\bC\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\"A\u0011\u0011\u0018\u0001!\u0002\u0013\tI\u000bC\u0005\u0002<\u0002\u0011\r\u0011\"\u0003\u0002(\"A\u0011Q\u0018\u0001!\u0002\u0013\tI\u000bC\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002(\"A\u0011\u0011\u0019\u0001!\u0002\u0013\tI\u000bC\u0005\u0002D\u0002\u0011\r\u0011\"\u0003\u0002F\"A\u0011Q\u001a\u0001!\u0002\u0013\t9\rC\u0005\u0002P\u0002\u0011\r\u0011\"\u0003\u0002R\"A\u0011q\u001b\u0001!\u0002\u0013\t\u0019\u000eC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A\u0011q\u001d\u0001!\u0002\u0013\ti\u000eC\u0005\u0002j\u0002\u0011\r\u0011\"\u0003\u0002l\"A!1\u0002\u0001!\u0002\u0013\ti\u000f\u0003\u0006\u0003\u000e\u0001\u0011\r\u0011\"\u0001K\u0005\u001fA\u0001B!\t\u0001A\u0003%!\u0011\u0003\u0005\n\u0005G\u0001!\u0019!C)\u0003\u000bD\u0001B!\n\u0001A\u0003%\u0011q\u0019\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011%\u0011\t\u0004\u0001b\u0001\n\u0003\n)\r\u0003\u0005\u00034\u0001\u0001\u000b\u0011BAd\u0011\u001d\u0011)\u0004\u0001C)\u0005oAqA!\u0016\u0001\t#\u00129\u0006C\u0004\u0003`\u0001!\tF!\u0019\t\u000f\tm\u0004\u0001\"\u0011\u0003~!A!1\u0012\u0001\u0005\u0002)\u0013i\t\u0003\u0005\u0003\u0014\u0002!\tF\u0013BK\u0011\u001d\u0011\u0019\u000b\u0001C)\u0005KCqA!3\u0001\t\u0003\u0012Y\rC\u0004\u0003l\u0002!\tE!\u000b\t\u0011\t5\b\u0001\"\u0001K\u0005_Dqa!\u0001\u0001\t\u0003\u001a\u0019\u0001C\u0004\u0004\u0018\u0001!\te!\u0007\t\u000f\r\u001d\u0002\u0001\"\u0011\u0004*!911\u0006\u0001\u0005\u0002\r5\u0002bBB\u001a\u0001\u0011\u00051Q\u0007\u0005\b\u0007G\u0002A\u0011BB3\u0011\u001d\u0019y\u0007\u0001C\t\u0007cB\u0001ba\u001e\u0001\t\u0003Q%\u0011\u0006\u0005\b\u0007s\u0002A\u0011IB>\u0011\u001d\u0019\u0019\t\u0001C!\u0007\u000bCqa!$\u0001\t\u0013\u0019y\tC\u0004\u0004,\u0002!Ia!,\t\u000f\rE\u0006\u0001\"\u0003\u00044\"91\u0011\u0018\u0001\u0005\n\rm\u0006\u0002CBc\u0001\u0011\u0005!ja2\t\u0011\rU\u0007\u0001\"\u0001K\u0007/DQba8\u0001!\u0003\r\t\u0011!C\u0005\u0007Ctw!CBu\u0015\u0006\u0005\t\u0012ABv\r!I%*!A\t\u0002\r5\bbBA>\r\u0012\u00051Q\u001f\u0005\n\u0007o4\u0015\u0013!C\u0001\u0007s\u0014!c\u00117vgR,'\u000fT5oW\u001a+Go\u00195fe*\u00111\nT\u0001\u0005Y&t7N\u0003\u0002N\u001d\u000611/\u001a:wKJT\u0011aT\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u000b\u0005\u0002T)6\tA*\u0003\u0002V\u0019\n!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0011\u0001,\u0019\b\u00033~\u0003\"AW/\u000e\u0003mS!\u0001\u0018)\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0016!\u00034fi\u000eDWM]%e!\t1w-D\u0001^\u0013\tAWLA\u0002J]R\fa\u0001\\3bI\u0016\u0014\bCA6m\u001b\u0005Q\u0015BA7K\u0005e\u0019E.^:uKJd\u0015N\\6MK\u0006$WM]#oIB{\u0017N\u001c;\n\u0005%|\u0017B\u00019M\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"aU:\n\u0005Qd%aC&bM.\f7i\u001c8gS\u001e\f\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h!\tYw/\u0003\u0002y\u0015\n\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002'\rdWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0011\u0005-\\\u0018B\u0001?K\u0005M\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u000391W\r^2iKJl\u0015M\\1hKJ\u0004\"a[@\n\u0007\u0005\u0005!JA\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\r\u0019\u0016qA\u0005\u0004\u0003\u0013a%\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003A\u0001\u0018-^:fIB\u000b'\u000f^5uS>t7\u000fE\u0002T\u0003\u001fI1!!\u0005M\u0005A\u0001\u0016-^:fIB\u000b'\u000f^5uS>t7/\u0001\nfqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0007\u0003BA\f\u0003Wi!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0006kRLGn\u001d\u0006\u0005\u0003?\t\t#\u0001\u0004d_6lwN\u001c\u0006\u0004\u001f\u0006\r\"\u0002BA\u0013\u0003O\ta!\u00199bG\",'BAA\u0015\u0003\ry'oZ\u0005\u0005\u0003[\tIB\u0001\nFqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0017A\u0003:fa2L7-Y'heB\u00191+a\r\n\u0007\u0005UBJ\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0007M\u000bY$C\u0002\u0002>1\u0013ABU3qY&\u001c\u0017-U;pi\u0006\f!c\u00197vgR,'\u000fT5oW6+GO]5dgB\u00191.a\u0011\n\u0007\u0005\u0015#J\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004B!a\u0006\u0002L%!\u0011QJA\r\u0005\u0011!\u0016.\\3\u0002!\u0011Lh.Y7jG\u001a+Go\u00195TSj,\u0007#\u00024\u0002T\u0005]\u0013bAA+;\nIa)\u001e8di&|g\u000e\r\t\u0004W\u0006e\u0013bAA.\u0015\n\tb)\u001a;dQJ+7\u000f]8og\u0016\u001c\u0016N_3\u0002#\rdWo\u001d;fe2Kgn[\"mS\u0016tG/\u0006\u0002\u0002bA\u00191.a\u0019\n\u0007\u0005\u0015$J\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]R\f!c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8uA\u0005iAn\\4D_:$X\r\u001f;PaR\u0004RAZA7\u0003cJ1!a\u001c^\u0005\u0019y\u0005\u000f^5p]B!\u0011qCA:\u0013\u0011\t)(!\u0007\u0003\u00151{wmQ8oi\u0016DH/\u0001\u0004uK:\fg\u000e\u001e\t\u0005M\u00065t+\u0001\u0004=S:LGO\u0010\u000b'\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM\u00037\u000bi*a(\u0002\"\u0006\r\u0006CA6\u0001\u0011\u00151F\u00031\u0001X\u0011\u0015!G\u00031\u0001f\u0011\u0015IG\u00031\u0001k\u0011\u0015\tH\u00031\u0001s\u0011\u0015)H\u00031\u0001w\u0011\u0015IH\u00031\u0001{\u0011\u0015iH\u00031\u0001\u007f\u0011\u001d\t\u0019\u0001\u0006a\u0001\u0003\u000bAq!a\u0003\u0015\u0001\u0004\ti\u0001C\u0004\u0002\u0014Q\u0001\r!!\u0006\t\u000f\u0005=B\u00031\u0001\u00022!9\u0011q\u0007\u000bA\u0002\u0005e\u0002bBA )\u0001\u0007\u0011\u0011\t\u0005\b\u0003\u000f\"\u0002\u0019AA%\u0011\u001d\ty\u0005\u0006a\u0001\u0003#Bq!!\u0018\u0015\u0001\u0004\t\t\u0007C\u0005\u0002jQ\u0001\n\u00111\u0001\u0002l!9\u0011q\u000f\u000bA\u0002\u0005e\u0014A\u00067j].4U\r^2iKJ4En\\<D_:$(o\u001c7\u0016\u0005\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u0005Y\u0006twM\u0003\u0002\u00024\u0006!!.\u0019<b\u0013\u0011\t9,!,\u0003\u000f%sG/Z4fe\u00069B.\u001b8l\r\u0016$8\r[3s\r2|woQ8oiJ|G\u000eI\u0001 Y&t7NR3uG\",'/T1y\u0019\u0006<w-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001\t7j].4U\r^2iKJl\u0015\r\u001f'bO\u001eLgn\u001a)beRLG/[8og\u0002\nQ\u0004\\5oW\u001a+Go\u00195fe2\u000bwmZ5oOB\u000b'\u000f^5uS>tWj]\u0001\u001fY&t7NR3uG\",'\u000fT1hO&tw\rU1si&$\u0018n\u001c8Ng\u0002\nq#^:f\u0013:$W\r]3oI\u0016tGOU3uK:$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0007c\u00014\u0002J&\u0019\u00111Z/\u0003\u000f\t{w\u000e\\3b]\u0006ARo]3J]\u0012,\u0007/\u001a8eK:$(+\u001a;f]RLwN\u001c\u0011\u0002%Ut\u0007O]3gSb,G\rT5oW:\u000bW.Z\u000b\u0003\u0003'\u0004B!a+\u0002V&\u0019!-!,\u0002'Ut\u0007O]3gSb,G\rT5oW:\u000bW.\u001a\u0011\u0002\u000f5,GO]5dgV\u0011\u0011Q\u001c\t\u0005\u0003?\f\u0019/\u0004\u0002\u0002b*!\u0011\u0011\\A\u000f\u0013\u0011\t)/!9\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u000eqCJ$\u0018\u000e^5p]2\u000b7\u000f^\"bk\u001eDG/\u00169US6,Wj]\u000b\u0003\u0003[\u0004\u0002\"a<\u0002z\u0006u(QA\u0007\u0003\u0003cTA!a=\u0002v\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005]\u0018\u0011W\u0001\u0005kRLG.\u0003\u0003\u0002|\u0006E(!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011q B\u0001\u001b\t\ti\"\u0003\u0003\u0003\u0004\u0005u!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004M\n\u001d\u0011b\u0001B\u0005;\n!Aj\u001c8h\u0003q\u0001\u0018M\u001d;ji&|g\u000eT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Ng\u0002\n\u0001\u0004]1si&$\u0018n\u001c8t/&$\bNT3x%\u0016\u001cwN\u001d3t+\t\u0011\t\u0002\u0005\u0004\u0003\u0014\tu\u0011Q`\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u00059Q.\u001e;bE2,'b\u0001B\u000e;\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}!Q\u0003\u0002\u0007\u0005V4g-\u001a:\u00023A\f'\u000f^5uS>t7oV5uQ:+wOU3d_J$7\u000fI\u0001\u001aiJ\fgn]5uS>tGk\u001c)vg\"\u001cV\u000f\u001d9peR,G-\u0001\u000eue\u0006t7/\u001b;j_:$v\u000eU;tQN+\b\u000f]8si\u0016$\u0007%\u0001\u0004e_^{'o\u001b\u000b\u0003\u0005W\u00012A\u001aB\u0017\u0013\r\u0011y#\u0018\u0002\u0005+:LG/A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0005qqN\\(gMN,G\u000fV5fe\u0016$G\u0003CAd\u0005s\u0011iD!\u0013\t\u000f\tm\"\u00061\u0001\u0002~\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B U\u0001\u0007!\u0011I\u0001\re\u0016\fX/Z:u\u000bB|7\r\u001b\t\u0007\u0005\u0007\u0012)%!+\u000e\u0005\u0005U\u0018\u0002\u0002B$\u0003k\u0014\u0001b\u00149uS>t\u0017\r\u001c\u0005\b\u0005\u0017R\u0003\u0019\u0001B'\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!q\nB)\u001b\u0005\u0001\u0011b\u0001B*_\nIa)\u001a;dQ\u0012\u000bG/Y\u0001\u0012_:\u0004\u0016M\u001d;ji&|gNR3oG\u0016$GCBAd\u00053\u0012i\u0006C\u0004\u0003\\-\u0002\r!!@\u0002\u0005Q\u0004\bb\u0002B W\u0001\u0007!\u0011I\u0001\u0019Q\u0006tG\r\\3QCJ$\u0018\u000e^5p]\u0016C8-\u001a9uS>tGCBAd\u0005G\u0012)\u0007C\u0004\u0003\\1\u0002\r!!@\t\u000f\t\u001dD\u00061\u0001\u0003j\u0005\tQ\r\u0005\u0003\u0003l\tUd\u0002\u0002B7\u0005cr1A\u0017B8\u0013\u0005q\u0016b\u0001B:;\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B<\u0005s\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\tMT,\u0001\u0005ueVt7-\u0019;f)\u0019\t9Ma \u0003\u0002\"9!1L\u0017A\u0002\u0005u\bb\u0002BB[\u0001\u0007!QQ\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\r\u0019&qQ\u0005\u0004\u0005\u0013c%!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0019m\u0006d\u0017\u000eZ1uK6K'O]8s)J,hnY1uS>tGCBAd\u0005\u001f\u0013\t\nC\u0004\u0003\\9\u0002\r!!@\t\u000f\t\re\u00061\u0001\u0003\u0006\u0006yS\u000f\u001d3bi\u00164U\r^2i\u001f\u001a47/\u001a;B]\u0012l\u0015-\u001f2f\u001b\u0006\u00148\u000e\u0016:v]\u000e\fG/[8o\u0007>l\u0007\u000f\\3uKR!!1\u0006BL\u0011\u001d\u0011Ij\fa\u0001\u00057\u000bABZ3uG\"|eMZ:fiN\u0004\u0002B!(\u0003 \u0006u(QQ\u0007\u0003\u00053IAA!)\u0003\u001a\t\u0019Q*\u00199\u0002)A\u0014xnY3tg\u001a+Go\u00195SKN\u0004xN\\:f)\u0019\u0011YCa*\u0003D\"9!\u0011\u0016\u0019A\u0002\t-\u0016!E:fgNLwN\u001c)beRLG/[8ogBA!1\tBW\u0003{\u0014y+\u0003\u0003\u0003\"\u0006U\b\u0003\u0002BY\u0005{sAAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u000bi\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011YL!.\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\t}&\u0011\u0019\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\tm&Q\u0017\u0005\b\u0005\u000b\u0004\u0004\u0019\u0001Bd\u00031\u0011Xm\u001d9p]N,G)\u0019;b!!\u0011iJa(\u0002~\n5\u0013\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0003N\n\r(Q\u001dBu!\u00151\u0017Q\u000eBh!\u0011\u0011\tNa8\u000e\u0005\tM'\u0002\u0002Bk\u0005/\f1\u0001\\8h\u0015\u0011\u0011INa7\u0002\u0013%tG/\u001a:oC2\u001c(\u0002\u0002Bo\u0003C\tqa\u001d;pe\u0006<W-\u0003\u0003\u0003b\nM'!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0003\\E\u0002\r!!@\t\u000f\t\u001d\u0018\u00071\u0001\u0003\u0006\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\u0011Y%\ra\u0001\u0005\u001b\nAdY8na2,G/\u001a#fY\u0006LX\r\u001a$fi\u000eD'+Z9vKN$8/\u0001\rnCf\u0014WMT8uS\u001aL(+Z1es\u001a{'OR3uG\"$BAa\u000b\u0003r\"9!1_\u001aA\u0002\tU\u0018!\u00039beRLG/[8o!\u0011\u00119P!@\u000e\u0005\te(b\u0001B~\u001d\u000691\r\\;ti\u0016\u0014\u0018\u0002\u0002B\u0000\u0005s\u0014\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\u0019)aa\u0003\u0011\r\tu5qAA\u007f\u0013\u0011\u0019IA!\u0007\u0003\u0007M+G\u000fC\u0004\u0004\u000eQ\u0002\raa\u0004\u0002%%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$Xm\u001d\t\t\u0005;\u0013y*!@\u0004\u0012A\u00191ka\u0005\n\u0007\rUAJA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\f\u0001C]3n_Z,\u0007+\u0019:uSRLwN\\:\u0015\t\rm11\u0005\t\t\u0005;\u0013y*!@\u0004\u001eA\u00191ka\b\n\u0007\r\u0005BJA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0004&U\u0002\ra!\u0002\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\f1C]3n_Z,\u0017\t\u001c7QCJ$\u0018\u000e^5p]N$\"aa\u0007\u0002U\u001d,G\u000fT1hO&tw\rU1si&$\u0018n\u001c8t)>l\u0015n\u001a:bi\u0016$v\u000eR3gCVdG\u000fU8pYR!1QAB\u0018\u0011\u001d\u0019\td\u000ea\u0001\u0005\u000b\tQA\\8x\u001bN\fq$\u00193kkN$H*Y4hS:<\u0007+\u0019:uSRLwN\\:SKF,\u0018N]3e)\u0011\u00199d!\u0019\u0011\u000f\u0019\u001cId!\u0010\u0004`%\u001911H/\u0003\rQ+\b\u000f\\33!\u0011\u0019yd!\u0017\u000f\t\r\u000531\u000b\b\u0005\u0007\u0007\u001ayE\u0004\u0003\u0004F\r5c\u0002BB$\u0007\u0017r1AWB%\u0013\u0005y\u0015BA'O\u0013\tYE*C\u0002\u0004R)\u000b\u0001d\u00117vgR,'\u000fT5oW\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0019)fa\u0016\u0002\u001d\u0005#'.^:u[\u0016tG\u000fV=qK*\u00191\u0011\u000b&\n\t\rm3Q\f\u0002\u000f\u0003\u0012TWo\u001d;nK:$H+\u001f9f\u0015\u0011\u0019)fa\u0016\u0011\u000b\u0019\fig!\u0002\t\u000f\rE\u0002\b1\u0001\u0003\u0006\u0005\u0019\u0003/\u0019:uSRLwN\u001c'bO\u001a{'\u000f\u00165s_R$H.Z!oI6KwM]1uS>tG\u0003\u0003B\u0003\u0007O\u001aIga\u001b\t\u000f\tm\u0013\b1\u0001\u0002~\"91\u0011G\u001dA\u0002\t\u0015\u0001bBB7s\u0001\u0007!QA\u0001\u0013Y\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/A\rdY\u0016\f'\u000fU1si&$\u0018n\u001c8MS:\\g)Y5mkJ,GC\u0002B\u0016\u0007g\u001a)\bC\u0004\u0003\\i\u0002\r!!@\t\u000f\t\u001d(\b1\u0001\u0003\u0006\u00051R\u000f\u001d3bi\u0016$\u0015P\\1nS\u000e4U\r^2i'&TX-A\u000bva\u0012\fG/\u001a$fi\u000eDWM\u001d'bON#\u0018\r^:\u0015\r\t-2QPB@\u0011\u001d\u0011Y\u0006\u0010a\u0001\u0003{Dqa!!=\u0001\u0004\u0011)!A\u0002mC\u001e\fQ#\u001e9eCR,g)\u001a;dQ\u0016\u0014()\u001f;f%\u0006$X\r\u0006\u0004\u0003,\r\u001d5\u0011\u0012\u0005\b\u00057j\u0004\u0019AA\u007f\u0011\u001d\u0019Y)\u0010a\u0001\u0005\u000b\tQAY=uKN\facZ3u\u001fJ\u001c%/Z1uKR{\u0007/[2TK:\u001cxN\u001d\u000b\u000b\u0007#\u001b9ja'\u0004\u001e\u000e\u001d\u0006\u0003BAp\u0007'KAa!&\u0002b\n11+\u001a8t_JDaa!'?\u0001\u00049\u0016!\u0002;pa&\u001c\u0007\"\u0002,?\u0001\u00049\u0006bBBP}\u0001\u00071\u0011U\u0001\u0005gR\fG\u000f\u0005\u0003\u0002`\u000e\r\u0016\u0002BBS\u0003C\u0014a\"T3bgV\u0014\u0018M\u00197f'R\fG\u000f\u0003\u0004\u0004*z\u0002\raV\u0001\fI\u0016\u001c8M]5qi&|g.A\nv]B\u0014XMZ5yK\u0012$v\u000e]5d\u001d\u0006lW\rF\u0002X\u0007_Caa!'@\u0001\u00049\u0016!\u0003;pa&\u001cG+Y4t)\u0011\u0019)la.\u0011\r\tu%qT,X\u0011\u0019\u0019I\n\u0011a\u0001/\u0006Ar-\u001a;NKN\u001c\u0018mZ3SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\t\ru61\u0019\t\u0005\u0003\u007f\u001cy,\u0003\u0003\u0004B\u0006u!AC'fiJL7MT1nK\"11\u0011T!A\u0002]\u000bqcY1mGVd\u0017\r^3NSJ\u0014xN\u001d+pa&\u001c'\u000b]8\u0015\r\r%7\u0011[Bj!\u00151\u0017QNBf!\r17QZ\u0005\u0004\u0007\u001fl&A\u0002#pk\ndW\r\u0003\u0004\u0004\u001a\n\u0003\ra\u0016\u0005\b\u0007\u0003\u0013\u0005\u0019\u0001B\u0003\u0003})\b\u000fZ1uKB\u000b'\u000f^5uS>tG*Y:u\u0007\u0006,x\r\u001b;VaRKW.\u001a\u000b\u0007\u0005W\u0019Ina7\t\u000f\tm3\t1\u0001\u0002~\"91Q\\\"A\u0002\t\u0015\u0011AD2bk\u001eDG/\u00169US6,Wj]\u0001\rgV\u0004XM\u001d\u0013mK\u0006$WM]\u000b\u0003\u0007G\u00042aUBs\u0013\r\u00199\u000f\u0014\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0003I\u0019E.^:uKJd\u0015N\\6GKR\u001c\u0007.\u001a:\u0011\u0005-45c\u0001$\u0004pB\u0019am!=\n\u0007\rMXL\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007W\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nt'\u0006\u0002\u0004|*\"\u00111NB\u007fW\t\u0019y\u0010\u0005\u0003\u0005\u0002\u0011-QB\u0001C\u0002\u0015\u0011!)\u0001b\u0002\u0002\u0013Ut7\r[3dW\u0016$'b\u0001C\u0005;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00115A1\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class ClusterLinkFetcher
extends ReplicaFetcherThread {
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final Time time;
    private final Function0<FetchResponseSize> dynamicFetchSize;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Option<String> tenant;
    private final Integer linkFetcherFlowControl;
    private final Integer linkFetcherMaxLaggingPartitions;
    private final Integer linkFetcherLaggingPartitionMs;
    private final boolean useIndependentRetention;
    private final String unprefixedLinkName;
    private final Metrics metrics;
    private final ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs;
    private final Buffer<TopicPartition> partitionsWithNewRecords;
    private final boolean transitionToPushSupported;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$17() {
        return None$.MODULE$;
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer linkFetcherFlowControl() {
        return this.linkFetcherFlowControl;
    }

    private Integer linkFetcherMaxLaggingPartitions() {
        return this.linkFetcherMaxLaggingPartitions;
    }

    private Integer linkFetcherLaggingPartitionMs() {
        return this.linkFetcherLaggingPartitionMs;
    }

    private boolean useIndependentRetention() {
        return this.useIndependentRetention;
    }

    private String unprefixedLinkName() {
        return this.unprefixedLinkName;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs() {
        return this.partitionLastCaughtUpTimeMs;
    }

    public Buffer<TopicPartition> partitionsWithNewRecords() {
        return this.partitionsWithNewRecords;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public void doWork() {
        this.updateDynamicFetchSize();
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString(), this.fetcherManager.onPartitionLinkFailure$default$4());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public boolean handlePartitionException(TopicPartition tp, Throwable e) {
        Option<MirrorFailureType> failure2 = MirrorFailureType$.MODULE$.failureType(e);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Handle mirror partition failure ").append(failure2).append(" for partition ").append(tp).append(" due to exception ").append(e).toString());
        if (failure2.exists((Function1 & Serializable)failure -> BoxesRunTime.boxToBoolean((boolean)this.fetcherManager.onPartitionLinkFailure(tp, failure, e.getMessage(), false)))) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Request metadata update because of errors for partition ").append(tp).toString());
            this.clusterLinkMetadata.requestUpdate();
        }
        return true;
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        if (this.validateMirrorTruncation(tp, offsetTruncationState)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Mirror partition truncation validation completed, proceeding to truncate ").append(tp).append(" to ").append(offsetTruncationState).toString());
            return super.truncate(tp, offsetTruncationState);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validateMirrorTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        Option<Object> sourceEpoch = offsetTruncationState.currentLeaderEpoch();
        BooleanRef partitionFailed = BooleanRef.create((boolean)false);
        try {
            if (offsetTruncationState.offset() < log.highWatermark() && log.latestEpoch().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 >= 0)) {
                Uuid uuid = partition.getLinkedTopicId();
                Uuid uuid2 = Uuid.ZERO_UUID;
                if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                    Uuid topicId;
                    MetadataResponseData.MetadataResponseTopic topicResponse = ((ClusterLinkLeaderEndPoint)super.leader()).fetchTopicMetadata(tp.topic());
                    if (topicResponse == null || topicResponse.errorCode() != Errors.NONE.code()) {
                        throw new StaleMetadataException("Failed to obtain topic id from source leader for validating truncation, will retry after obtaining new metadata.");
                    }
                    Uuid uuid3 = topicId = topicResponse.topicId();
                    Uuid uuid4 = partition.getLinkedTopicId();
                    if (uuid3 == null ? uuid4 != null : !uuid3.equals(uuid4)) {
                        Uuid uuid5 = topicId;
                        Uuid uuid6 = Uuid.ZERO_UUID;
                        if (uuid5 == null ? uuid6 != null : !uuid5.equals(uuid6)) {
                            void failPartition$1_cause;
                            String string = new StringBuilder(66).append("Topic id ").append(topicId).append(" obtained from leader does not match persisted topic id ").append(partition.getLinkedTopicId()).append(".").toString();
                            MirrorFailureType$SourceTopicIdChanged$ failPartition$1_failureType = MirrorFailureType$SourceTopicIdChanged$.MODULE$;
                            String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                            this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                            this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                            this.markPartitionFailed(tp);
                            partitionFailed.elem = true;
                            return false;
                        }
                    }
                }
                if (sourceEpoch.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 <= BoxesRunTime.unboxToInt((Object)log.latestEpoch().get()))) {
                    void failPartition$1_cause;
                    String string = new StringBuilder(78).append("Source leader epoch ").append(sourceEpoch).append(" is not greater than latest epoch in the destination log ").append(log.latestEpoch()).append(".").toString();
                    MirrorFailureType$UnexpectedTruncation$ failPartition$1_failureType = MirrorFailureType$UnexpectedTruncation$.MODULE$;
                    String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                    this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                    this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                    this.markPartitionFailed(tp);
                    partitionFailed.elem = true;
                    Object var19_16 = null;
                    string = null;
                    Object var21_17 = null;
                } else if (sourceEpoch.nonEmpty() && log.latestEpoch().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0)) {
                    int prevLogEpoch = BoxesRunTime.unboxToInt((Object)log.latestEpoch().get()) - 1;
                    OffsetForLeaderEpochRequestData.OffsetForLeaderPartition oldEpochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(BoxesRunTime.unboxToInt((Object)sourceEpoch.get())).setLeaderEpoch(prevLogEpoch);
                    Option epochResponse = ((ClusterLinkLeaderEndPoint)super.leader()).fetchEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)oldEpochData)})))).get((Object)tp);
                    if (epochResponse.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcher.$anonfun$validateMirrorTruncation$5(x$4)))) {
                        throw new StaleMetadataException("Failed to obtain epoch end offsets from source leader for validating truncation, will retry after obtaining new metadata.");
                    }
                    epochResponse.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.endOffset())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)sourceOffsetForPrevEpoch -> {
                        Option<OffsetAndEpoch> destOffsetForPrevEpoch = log.endOffsetForEpoch(prevLogEpoch);
                        if (destOffsetForPrevEpoch.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcher.$anonfun$validateMirrorTruncation$8(sourceOffsetForPrevEpoch, x$6)))) {
                            void failPartition$1_cause;
                            String string = new StringBuilder(253).append("Destination log contains records for previous epoch ").append(prevLogEpoch).append(" up to ").append(destOffsetForPrevEpoch).append(", ").append("but end offset for the same epoch in the source log is ").append(sourceOffsetForPrevEpoch).append(". Source offset for older epochs should not be ").append("greater since new records could not have been appended at older epoch after an epoch bump.").toString();
                            MirrorFailureType$UnexpectedTruncation$ failPartition$1_failureType = MirrorFailureType$UnexpectedTruncation$.MODULE$;
                            String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                            this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                            $this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                            this.markPartitionFailed(tp);
                            partitionFailed$1.elem = true;
                            return;
                        }
                    });
                }
            }
        }
        catch (RetriableException e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(128).append("Failed to validate mirror partition truncation to ").append(offsetTruncationState.offset()).append(" below ").append("destination high watermark ").append(log.highWatermark()).append(", will retry when new metadata is available.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.handlePartitionException(tp, e);
            partitionFailed.elem = true;
        }
        return !partitionFailed.elem;
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkFetcher.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void processFetchResponse(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, Map<TopicPartition, FetchResponseData.PartitionData> responseData) {
        sessionPartitions.keySet().forEach(tp -> {
            if (!responseData.contains(tp)) {
                $this.fetcherManager.updatePartitionFetchState((TopicPartition)tp, ((ClusterLinkLeaderEndPoint)this.super$leader()).lastFetchTimeMs(), (Option<Object>)None$.MODULE$);
                return;
            }
        });
        super.processFetchResponse(sessionPartitions, responseData);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, ((ClusterLinkLeaderEndPoint)super.leader()).lastFetchTimeMs(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)partitionData.highWatermark())));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, tp);
        Optional<Object> sourceLeaderLogStartOffset = !this.useIndependentRetention() ? Optional.of(BoxesRunTime.boxToLong((long)partitionData.logStartOffset())) : Optional.empty();
        Option<LogAppendInfo> appendInfo = this.replicaMgr.appendRecordsToFollowerReplica(tp, fetchOffset, AppendOrigin.CLUSTER_LINK, -1L, Optional.empty(), records, partitionData.highWatermark(), sourceLeaderLogStartOffset, this.quota);
        appendInfo.foreach((Function1 & Serializable)info -> {
            ClusterLinkFetcher.$anonfun$processPartitionData$1(this, tp, info);
            return BoxedUnit.UNIT;
        });
        return appendInfo;
    }

    @Override
    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewRecords().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewRecords().toSeq());
            this.partitionsWithNewRecords().clear();
            return;
        }
    }

    public void maybeNotifyReadyForFetch(Partition partition) {
        if (ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.linkFetcherFlowControl(), false)) {
            this.maybeNotifyReadyForFetch();
            return;
        }
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> addedPartitions = super.addPartitions(initialFetchStates);
        addedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$addPartitions$1(this, p)));
        return addedPartitions;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removePartitions(topicPartitions);
        removedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$removePartitions$1(this, p)));
        return removedPartitions;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removeAllPartitions() {
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removeAllPartitions();
        removedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$removeAllPartitions$1(this, p)));
        return removedPartitions;
    }

    public Set<TopicPartition> getLaggingPartitionsToMigrateToDefaultPool(long nowMs) {
        scala.collection.mutable.Set migratingPartitions = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, lastCaughtUpTimeMs) -> ClusterLinkFetcher.$anonfun$getLaggingPartitionsToMigrateToDefaultPool$1(this, nowMs, migratingPartitions, topicPartition, BoxesRunTime.unboxToLong((Object)lastCaughtUpTimeMs)));
        return migratingPartitions;
    }

    public Tuple2<Enumeration.Value, Option<Set<TopicPartition>>> adjustLaggingPartitionsRequired(long nowMs) {
        PriorityQueue maxHeap = PriorityQueue$.MODULE$.empty((Ordering)ClusterLinkFetcherThread$MaxPartitionLagOrder$.MODULE$);
        scala.collection.mutable.Set partitionsToThrottle = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, lastCaughtUpTimeMs) -> ClusterLinkFetcher.$anonfun$adjustLaggingPartitionsRequired$1(this, nowMs, maxHeap, partitionsToThrottle, topicPartition, BoxesRunTime.unboxToLong((Object)lastCaughtUpTimeMs)));
        if (maxHeap.size() < Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Increase(), (Object)None$.MODULE$);
        }
        if (partitionsToThrottle.isEmpty()) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.NoAdjustment(), (Object)None$.MODULE$);
        }
        return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Decrease(), (Object)new Some((Object)partitionsToThrottle));
    }

    private long partitionLagForThrottleAndMigration(TopicPartition tp, long nowMs, long lastCaughtUpTimeMs) {
        FetcherLagMetrics lagStats = this.fetcherLagStats().stats().get(tp);
        if (lagStats != null && lagStats.lag() > 0L) {
            if (nowMs - lastCaughtUpTimeMs > (long)Predef$.MODULE$.Integer2int(this.linkFetcherLaggingPartitionMs())) {
                return lagStats.lag();
            }
        } else {
            return this.fetcherManager.laggingPartitionsForTest(tp);
        }
        return 0L;
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString(), true);
    }

    public void updateDynamicFetchSize() {
        FetchResponseSize dynamicSize = (FetchResponseSize)this.dynamicFetchSize.apply();
        ((ClusterLinkLeaderEndPoint)super.leader()).setFetchSize(dynamicSize.perPartitionSize());
        ((ClusterLinkLeaderEndPoint)super.leader()).updateFetchResponseSize(dynamicSize.responseSize());
    }

    @Override
    public void updateFetcherLagStats(TopicPartition tp, long lag) {
        super.updateFetcherLagStats(tp, lag);
        long topicLag = this.fetcherManager.getTopicLag(tp.topic());
        if (topicLag >= 0L) {
            Sensor sensor = this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-lag", (MeasurableStat)new Value(), "Mirror topic lag");
            long nowMs = this.time.milliseconds();
            sensor.record((double)topicLag, nowMs);
            if (topicLag == 0L) {
                this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)nowMs));
            }
        }
        Option<Object> rpoInSeconds = this.calculateMirrorTopicRpo(tp.topic(), lag);
        Sensor rpoSensor = this.getOrCreateTopicSensor(tp.topic(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicRpoMetricName(), (MeasurableStat)new Value(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicRpoMetricDescription());
        rpoInSeconds.foreach((Function1)(JFunction1.mcVD.sp & Serializable)x$1 -> rpoSensor.record(x$1));
    }

    @Override
    public void updateFetcherByteRate(TopicPartition tp, long bytes) {
        super.updateFetcherByteRate(tp, bytes);
        String topic = tp.topic();
        this.getOrCreateTopicSensor(topic, "mirror-topic-byte-total", (MeasurableStat)new CumulativeSum(), "Mirror topic throughput").record((double)bytes);
        this.brokerTopicStats().topicStats(topic).mirrorBytesInRate().mark(bytes);
        this.brokerTopicStats().allTopicsStats().mirrorBytesInRate().mark(bytes);
    }

    private Sensor getOrCreateTopicSensor(String topic, String name, MeasurableStat stat, String description) {
        String sensorName = new StringBuilder(3).append(name).append("-").append(this.tenant).append("-").append(this.unprefixedLinkName()).append("-").append(this.unprefixedTopicName(topic)).toString();
        Sensor sensor = this.metrics().sensor(sensorName, this.metrics().config(), TimeUnit.MINUTES.toSeconds(5L), new Sensor[0]);
        MetricName metricName = new MetricName(name, "cluster-link-metrics", description, CollectionConverters$.MODULE$.MapHasAsJava(this.topicTags(topic)).asJava());
        if (sensor == null) {
            throw null;
        }
        sensor.add(metricName, stat, null);
        return sensor;
    }

    private String unprefixedTopicName(String topic) {
        return (String)this.tenant.map((Function1 & Serializable)t -> topic.substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> topic);
    }

    private Map<String, String> topicTags(String topic) {
        String unprefixedTopic = this.unprefixedTopicName(topic);
        return ((IterableOnceOps)new .colon.colon((Object)this.tenant.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)unprefixedTopic)), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private MetricName getMessageRateMetricName(String topic) {
        return new MetricName(ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricName(), "cluster-link-metrics", ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicTags(topic)).asJava());
    }

    public Option<Object> calculateMirrorTopicRpo(String topic, long lag) {
        KafkaMetric mirrorTopicMessageMetric = this.metrics().metric(this.getMessageRateMetricName(topic));
        if (mirrorTopicMessageMetric == null) {
            return None$.MODULE$;
        }
        double mirrorTopicMessageRate = BoxesRunTime.unboxToDouble((Object)mirrorTopicMessageMetric.metricValue());
        if (lag > 0L && mirrorTopicMessageRate == 0.0) {
            return None$.MODULE$;
        }
        if (lag == 0L) {
            return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)lag / mirrorTopicMessageRate)));
    }

    public void updatePartitionLastCaughtUpTime(TopicPartition tp, long caughtUpTimeMs) {
        this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)caughtUpTimeMs));
    }

    private final void failPartition$1(MirrorFailureType failureType, String cause, TopicPartition tp$4, OffsetTruncationState offsetTruncationState$2, AbstractLog log$1, BooleanRef partitionFailed$1) {
        String errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp$4).append(" due to unexpected truncation to offset ").append(offsetTruncationState$2.offset()).append(". ").append("Destination high watermark is ").append(log$1.highWatermark()).append(", destination log end offset is ").append(log$1.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append(cause).toString();
        this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
        this.fetcherManager.onPartitionLinkFailure(tp$4, failureType, errorMessage, false);
        this.markPartitionFailed(tp$4);
        partitionFailed$1.elem = true;
    }

    public static final /* synthetic */ boolean $anonfun$validateMirrorTruncation$5(OffsetForLeaderEpochResponseData.EpochEndOffset x$4) {
        return x$4.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$validateMirrorTruncation$8(long sourceOffsetForPrevEpoch$1, OffsetAndEpoch x$6) {
        return x$6.offset() < sourceOffsetForPrevEpoch$1;
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcher $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable)x$7 -> {
                    x$7.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(ClusterLinkFetcher $this, TopicPartition tp$5, LogAppendInfo info) {
        if (info.numMessages() > 0L) {
            $this.partitionsWithNewRecords().$plus$eq((Object)tp$5);
        }
        $this.getOrCreateTopicSensor(tp$5.topic(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricName(), (MeasurableStat)new Rate(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricDescription()).record((double)info.numMessages(), $this.time.milliseconds());
    }

    public static final /* synthetic */ long $anonfun$addPartitions$1(ClusterLinkFetcher $this, TopicPartition p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().putIfAbsent(p, BoxesRunTime.boxToLong((long)$this.time.milliseconds())));
    }

    public static final /* synthetic */ long $anonfun$removePartitions$1(ClusterLinkFetcher $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ long $anonfun$removeAllPartitions$1(ClusterLinkFetcher $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ void $anonfun$getLaggingPartitionsToMigrateToDefaultPool$1(ClusterLinkFetcher $this, long nowMs$1, scala.collection.mutable.Set migratingPartitions$1, TopicPartition topicPartition, long lastCaughtUpTimeMs) {
        if ($this.partitionLagForThrottleAndMigration(topicPartition, nowMs$1, lastCaughtUpTimeMs) > 0L) {
            migratingPartitions$1.$plus$eq((Object)topicPartition);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$1(ClusterLinkFetcher $this, long nowMs$2, PriorityQueue maxHeap$1, scala.collection.mutable.Set partitionsToThrottle$1, TopicPartition topicPartition, long lastCaughtUpTimeMs) {
        long lag = $this.partitionLagForThrottleAndMigration(topicPartition, nowMs$2, lastCaughtUpTimeMs);
        if (lag > 0L) {
            if (maxHeap$1.size() >= Predef$.MODULE$.Integer2int($this.linkFetcherMaxLaggingPartitions())) {
                long maxPartitionLag = ((ClusterLinkFetcherThread.PartitionAndLag)maxHeap$1.head()).lag();
                if (lag < maxPartitionLag) {
                    partitionsToThrottle$1.$plus$eq((Object)((ClusterLinkFetcherThread.PartitionAndLag)maxHeap$1.dequeue()).partition());
                    maxHeap$1.$plus$eq((Object)new ClusterLinkFetcherThread.PartitionAndLag(topicPartition, lag));
                    return;
                }
                partitionsToThrottle$1.$plus$eq((Object)topicPartition);
                return;
            }
            maxHeap$1.$plus$eq((Object)new ClusterLinkFetcherThread.PartitionAndLag(topicPartition, lag));
            return;
        }
    }

    public ClusterLinkFetcher(String name, int fetcherId, ClusterLinkLeaderEndPoint leader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, Option<LogContext> logContextOpt, Option<String> tenant) {
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.time = time;
        this.dynamicFetchSize = dynamicFetchSize;
        this.clusterLinkClient = clusterLinkClient;
        this.tenant = tenant;
        super(name, fetcherId, leader, brokerConfig, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), (Function0<MetadataVersion>)new Serializable(brokerConfig){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        });
        this.linkFetcherFlowControl = clusterLinkConfig.linkFetcherFlowControl();
        this.linkFetcherMaxLaggingPartitions = clusterLinkConfig.linkFetcherMaxLaggingPartitions();
        this.linkFetcherLaggingPartitionMs = clusterLinkConfig.linkFetcherLaggingPartitionMs();
        this.useIndependentRetention = clusterLinkConfig.useIndependentRetention();
        this.unprefixedLinkName = (String)tenant.map((Function1 & Serializable)t -> $this.clusterLinkMetadata.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> $this.clusterLinkMetadata.linkName());
        this.metrics = clusterLinkMetrics.metrics();
        this.partitionLastCaughtUpTimeMs = new ConcurrentHashMap();
        this.partitionsWithNewRecords = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.transitionToPushSupported = false;
        this.isOffsetForLeaderEpochSupported = true;
    }
}

