/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopicsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0010 \u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\n\u0001B\u0001B\u0003%\u0001\u000bC\u0005X\u0001\t\u0005\t\u0015!\u0003Y7\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011%Q\u0007A!A!\u0002\u0013Y\u0007\u000fC\u0005r\u0001\t\u0005\t\u0015!\u0003sm\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011)y\bA!A!\u0002\u0013a\u0018\u0011\u0001\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nqDq!a\u0002\u0001\t\u0003\tI\u0001C\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(!I\u0011Q\u0007\u0001A\u0002\u0013%\u0011q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002*!9\u0011Q\n\u0001\u0005R\u0005=\u0003bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a0\u0001\t\u0013\t\t\rC\u0004\u0002F\u0002!\t&a2\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\u001eI\u0011q[\u0010\u0002\u0002#\u0005\u0011\u0011\u001c\u0004\t=}\t\t\u0011#\u0001\u0002\\\"9\u0011qA\r\u0005\u0002\u0005\r\b\"CAs3E\u0005I\u0011AAt\u0011%\ti0GI\u0001\n\u0003\t9\u000fC\u0005\u0002\u0000f\t\n\u0011\"\u0001\u0002h\na2\t\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c(B\u0001\u0011\"\u0003\u0011a\u0017N\\6\u000b\u0005\t\u001a\u0013AB:feZ,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00140!\tACF\u0004\u0002*U5\tq$\u0003\u0002,?\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!!\f\u0018\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005-z\u0002C\u0001\u00194\u001b\u0005\t$B\u0001\u001a$\u0003\u0015)H/\u001b7t\u0013\t!\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\r1Lgn[%e!\t9t(D\u00019\u0015\tI$(\u0001\u0004d_6lwN\u001c\u0006\u0003ImR!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sO&\u0011\u0001\t\u000f\u0002\u0005+VLG-\u0001\u0005mS:\\g*Y7f!\t\u0019EJ\u0004\u0002E\u0015B\u0011Q\tS\u0007\u0002\r*\u0011q)J\u0001\u0007yI|w\u000e\u001e \u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017\"\u000bA\u0002\\5oW&\u001b\b+Y;tK\u0012\u00042!\u0015*U\u001b\u0005A\u0015BA*I\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002R+&\u0011a\u000b\u0013\u0002\b\u0005>|G.Z1o\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002*3&\u0011!l\b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005]c\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0011\u0005%r\u0016BA0 \u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003)awnY1m\u0003\u0012l\u0017N\u001c\t\u0004#J\u0013\u0007CA2i\u001b\u0005!'BA3g\u0003\u0015\tG-\\5o\u0015\t9'(A\u0004dY&,g\u000e^:\n\u0005%$'AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0005i&lW\r\u0005\u0002m]6\tQN\u0003\u00023q%\u0011q.\u001c\u0002\u0005)&lW-\u0003\u0002kY\u0005)\u0011/^8uCB\u00111\u000f^\u0007\u0002C%\u0011Q/\t\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006L!!\u001d\u0017\u0002\u000f5,GO]5dgB\u0011\u0011&_\u0005\u0003u~\u0011!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006)R.\u0019=U_BL7m\u001d)fe&#XM]1uS>t\u0007CA)~\u0013\tq\bJA\u0002J]R\f!\"\u001b8uKJ4\u0018\r\\'t\u0013\r\t\u0019\u0001L\u0001\u0012e\u0016\u001c8\r[3ek2,G)\u001a7bs6\u001b\u0018\u0001\u0004:fiJLH)\u001a7bs6\u001b\u0018A\u0002\u001fj]&$h\b\u0006\u000e\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003\u0005\u0002*\u0001!)Q'\u0004a\u0001m!)\u0011)\u0004a\u0001\u0005\")q*\u0004a\u0001!\")q+\u0004a\u00011\")A,\u0004a\u0001;\")\u0001-\u0004a\u0001C\")!.\u0004a\u0001W\")\u0011/\u0004a\u0001e\")q/\u0004a\u0001q\"910\u0004I\u0001\u0002\u0004a\bbB@\u000e!\u0003\u0005\r\u0001 \u0005\t\u0003\u000bi\u0001\u0013!a\u0001y\u0006AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002*A)\u0011+a\u000b\u00020%\u0019\u0011Q\u0006%\u0003\r=\u0003H/[8o!\rI\u0013\u0011G\u0005\u0004\u0003gy\"a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004#\u0006m\u0012bAA\u001f\u0011\n!QK\\5u\u0011%\t\teDA\u0001\u0002\u0004\tI#A\u0002yIE\n\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007A\t9\u0005E\u0002R\u0003\u0013J1!a\u0013I\u0005!1x\u000e\\1uS2,\u0017a\u0001:v]R\u0011\u0011\u0011\u000b\t\u0005\u0003'\n\tGD\u0002\u0002V)rA!a\u0016\u0002`9!\u0011\u0011LA/\u001d\r)\u00151L\u0005\u0002I%\u0011!eI\u0005\u0003A\u0005J1!a\u0019/\u0005)!\u0016m]6SKN,H\u000e^\u0001\u000ee\u0016\u001cx\u000e\u001c<f)>\u0004\u0018nY:\u0015\t\u0005E\u0013\u0011\u000e\u0005\u0007\u0003W\u0012\u0002\u0019\u0001+\u0002\u0011%\u001c\b+Y;tK\u0012\fQ\u0002\u001d:pG\u0016\u001c8\u000fV8qS\u000e\u001cHCBA)\u0003c\n\u0019\b\u0003\u0004\u0002lM\u0001\r\u0001\u0016\u0005\b\u0003k\u001a\u0002\u0019AA<\u0003\u0019!x\u000e]5dgB)\u0011\u0011PAB\u0005:!\u00111PA@\u001d\r)\u0015QP\u0005\u0002\u0013&\u0019\u0011\u0011\u0011%\u0002\u000fA\f7m[1hK&!\u0011QQAD\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003C\u0015!\u00069s_\u000e,7o\u001d+pa&\u001c7oQ8na2,G/\u001a\u000b\t\u0003#\ni)a&\u0002\u001a\"9\u0011q\u0012\u000bA\u0002\u0005E\u0015a\u0003;bg.\u001cuN\u001c;fqR\u0004B!a\u0015\u0002\u0014&\u0019\u0011Q\u0013\u0018\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003W\"\u0002\u0019\u0001+\t\u000f\u0005mE\u00031\u0001\u0002\u001e\u00069!/Z:vYR\u001c\bcBAP\u0003S\u0013\u0015QV\u0007\u0003\u0003CSA!a)\u0002&\u0006!Q\u000f^5m\u0015\t\t9+\u0001\u0003kCZ\f\u0017\u0002BAV\u0003C\u00131!T1q!\u00159\u0014qVAZ\u0013\r\t\t\f\u000f\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u00026\u0006mVBAA\\\u0015\u0011\tI,!*\u0002\t1\fgnZ\u0005\u0005\u0003{\u000b9L\u0001\u0003W_&$\u0017AB1di&|g\u000eF\u0002C\u0003\u0007Da!a\u001b\u0016\u0001\u0004!\u0016\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BA\u001d\u0003\u0013Dq!a3\u0017\u0001\u0004\ti-\u0001\u0004sKN,H\u000e\u001e\t\u0004Q\u0005=\u0017bAAi]\t\u00192i\\7qY\u0016$X\r\u001a+bg.\u0014Vm];mi\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u0002*\u0005a2\t\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\bCA\u0015\u001a'\rI\u0012Q\u001c\t\u0004#\u0006}\u0017bAAq\u0011\n1\u0011I\\=SK\u001a$\"!!7\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU\u0011\u0011\u0011\u001e\u0016\u0004y\u0006-8FAAw!\u0011\ty/!?\u000e\u0005\u0005E(\u0002BAz\u0003k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\b*\u0001\u0006b]:|G/\u0019;j_:LA!a?\u0002r\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132c\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0012\u0004")
public class ClusterLinkPauseMirrorTopics
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final Function0<Object> linkIsPaused;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> localAdmin;
    private final ClusterLinkMetrics metrics;
    private final int maxTopicsPerIteration;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$12() {
        return 1000;
    }

    public static int $lessinit$greater$default$11() {
        return 5000;
    }

    public static int $lessinit$greater$default$10() {
        return 20;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.metadataManager.isLinkCoordinator(this.linkName)) {
            return this.resolveTopics(this.linkIsPaused.apply$mcZ$sp());
        }
        Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult resolveTopics(boolean isPaused) {
        Seq process = ((MapOps)this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkId).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPauseMirrorTopics.$anonfun$resolveTopics$1(this, isPaused, x0$1)))).keys().toSeq();
        if (process.nonEmpty()) {
            Seq trimmed = process.size() > this.maxTopicsPerIteration ? (Seq)process.drop(process.size() - this.maxTopicsPerIteration) : process;
            return this.processTopics(isPaused, (Seq<String>)trimmed);
        }
        Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult processTopics(boolean isPaused, Seq<String> topics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Starting ").append(this.action(isPaused)).append(" mirror topics for topics '").append(topics).append("'").toString());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)(isPaused ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions();
        AlterMirrorsResult result = ((ConfluentAdmin)this.localAdmin.apply()).alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.processTopicsComplete((ClusterLinkScheduler.TaskContext)tc, isPaused, result.values()), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult processTopicsComplete(ClusterLinkScheduler.TaskContext taskContext, boolean isPaused, java.util.Map<String, KafkaFuture<Void>> results) {
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return None$.MODULE$;
                }
                catch (ExecutionException e) {
                    return this.onError$1(e.getCause(), isPaused);
                }
                catch (Throwable e) {
                    return this.onError$1(e, isPaused);
                }
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (errs.isEmpty()) {
            if (isPaused == this.linkIsPaused.apply$mcZ$sp()) {
                return this.resolveTopics(isPaused);
            }
            Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private String action(boolean isPaused) {
        if (isPaused) {
            return "pausing";
        }
        return "unpausing";
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager.isLinkCoordinator(this.linkName)) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkPauseMirrorTopicsTaskType$.MODULE$, "run the pause mirror topics task"));
            return;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ boolean $anonfun$resolveTopics$1(ClusterLinkPauseMirrorTopics $this, boolean isPaused$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            Uuid uuid = state.linkId();
            Uuid uuid2 = $this.linkId;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return false;
            }
            try {
                if (!isPaused$1) {
                    return state.toUnpausedState(true).nonEmpty();
                }
                bl = state.toPausedState(true).nonEmpty();
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }
        throw new MatchError(null);
    }

    private final Option onError$1(Throwable e, boolean isPaused$3) {
        String errMsg = new StringBuilder(38).append("Encountered error while ").append(this.action(isPaused$3)).append(" mirror topics").toString();
        this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
        return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
    }

    public ClusterLinkPauseMirrorTopics(Uuid linkId, String linkName, Function0<Object> linkIsPaused, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> localAdmin, Time time, ClusterLinkRequestQuota quota, ClusterLinkMetrics metrics, int maxTopicsPerIteration, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.linkIsPaused = linkIsPaused;
        this.metadataManager = metadataManager;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.maxTopicsPerIteration = maxTopicsPerIteration;
        super(scheduler, "PauseMirrorTopics", intervalMs, time, quota);
        this.taskDesc = None$.MODULE$;
    }
}

