/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.security.CredentialProvider;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u001dw!B\u0016-\u0011\u0003\u0019d!B\u001b-\u0011\u00031\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031e\u0001B\u001b-\u00011D\u0001b\u001f\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\ty\u0012\u0011\t\u0011)A\u0005{\"Q\u00111\u0001\u0003\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005-AA!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u001a\u0011\u0011\t\u0011)A\u0005\u00037A!\"!\t\u0005\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\t\u0019\u0004\u0002B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0003\u0007\"!\u00111A\u0005\u0002\u0005\u0015\u0003BCA'\t\t\u0005\r\u0011\"\u0001\u0002P!Q\u00111\f\u0003\u0003\u0002\u0003\u0006K!a\u0012\t\u0015\u0005uCA!A!\u0002\u0013\ty\u0006\u0003\u0006\u0002f\u0011\u0011\t\u0011)A\u0005\u0003OB!\"!\u001c\u0005\u0005\u0003\u0005\u000b\u0011BA8\u0011)\t)\b\u0002B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003{\"!\u0011!Q\u0001\n\u0005}\u0004BCAF\t\t\u0005\t\u0015!\u0003\u0002\u000e\"Q\u00111\u0014\u0003\u0003\u0002\u0003\u0006I!!$\t\u0015\u0005uEA!A!\u0002\u0013\ty\n\u0003\u0006\u0002@\u0012\u0011\t\u0011)A\u0005\u0003\u0003D!\"a4\u0005\u0005\u0003\u0005\u000b\u0011BAi\u0011)\ty\u000e\u0002B\u0001B\u0003%\u0011\u0011\u001d\u0005\u000b\u0003_$!\u0011!Q\u0001\n\u0005E\bBB\"\u0005\t\u0003\ty\u0010C\u0005\u0003,\u0011\u0011\r\u0011\"\u0001\u0003.!A!Q\u0007\u0003!\u0002\u0013\u0011y\u0003C\u0005\u00038\u0011\u0001\r\u0011\"\u0001\u0003:!I!\u0011\t\u0003A\u0002\u0013\u0005!1\t\u0005\t\u0005\u000f\"\u0001\u0015)\u0003\u0003<!I!\u0011\n\u0003C\u0002\u0013\u0005!1\n\u0005\t\u0005G\"\u0001\u0015!\u0003\u0003N!9!Q\r\u0003\u0005B\t\u001d\u0004b\u0002B5\t\u0011\u0005#1\u000e\u0005\b\u0005\u0003#A\u0011\u0002BB\u0011\u001d\u0011\u0019\n\u0002C\u0001\u0005+CqA!)\u0005\t\u0003\u0011\u0019\u000bC\u0004\u0003<\u0012!IA!0\t\u000f\t\u0005G\u0001\"\u0003\u0003D\"9!Q\u0019\u0003\u0005B\t\r\u0017a\u0006\"s_.,'/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0015\tic&\u0001\u0005nKR\fG-\u0019;b\u0015\ty\u0003'\u0001\u0004tKJ4XM\u001d\u0006\u0002c\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001b\u0002\u001b\u0005a#a\u0006\"s_.,'/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s'\r\tq'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\nU\"A \u000b\u0005\u0001\u0003\u0014!B;uS2\u001c\u0018B\u0001\"@\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001a\u0002\u001b\u001d,G\u000fV8qS\u000e$U\r\u001c;b)\u00119UKY4\u0011\u0007aB%*\u0003\u0002Js\t1q\n\u001d;j_:\u0004\"aS*\u000e\u00031S!!\u0014(\u0002\u000b%l\u0017mZ3\u000b\u0005Ez%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016'\u0003\u0015Q{\u0007/[2EK2$\u0018\rC\u0003W\u0007\u0001\u0007q+A\u0005u_BL7MT1nKB\u0011\u0001l\u0018\b\u00033v\u0003\"AW\u001d\u000e\u0003mS!\u0001\u0018\u001a\u0002\rq\u0012xn\u001c;?\u0013\tq\u0016(\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010:\u0011\u0015\u00197\u00011\u0001e\u0003!qWm^%nC\u001e,\u0007CA&f\u0013\t1GJA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\u0006Q\u000e\u0001\r![\u0001\u0006I\u0016dG/\u0019\t\u0003\u0017*L!a\u001b'\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b'\u0011!Q.^\u001f\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n1qJ\u00196fGR\u0004\"A^=\u000e\u0003]T!\u0001\u001f'\u0002\u0013A,(\r\\5tQ\u0016\u0014\u0018B\u0001>x\u0005EiU\r^1eCR\f\u0007+\u001e2mSNDWM]\u0001\nG2,8\u000f^3s\u0013\u0012\fAaY8oMB\u0011ap`\u0007\u0002]%\u0019\u0011\u0011\u0001\u0018\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0007Q\n9!C\u0002\u0002\n1\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK\u0006QAn\\4NC:\fw-\u001a:\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u00051\u0003\rawnZ\u0005\u0005\u0003/\t\tB\u0001\u0006M_\u001el\u0015M\\1hKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002\u007f\u0003;I1!a\b/\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005)qM]8va*\u0019\u0011Q\u0006(\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u0003c\t9C\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\b\u0003BA\u001c\u0003\u007fi!!!\u000f\u000b\t\u0005m\u0012QH\u0001\fiJ\fgn]1di&|gNC\u0002\u0002.AJA!!\u0011\u0002:\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\fes:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3s+\t\t9\u0005E\u00025\u0003\u0013J1!a\u0013-\u0005Y!\u0015P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014\u0018A\u00073z]\u0006l\u0017nY\"p]\u001aLw\rU;cY&\u001c\b.\u001a:`I\u0015\fH\u0003BA)\u0003/\u00022\u0001OA*\u0013\r\t)&\u000f\u0002\u0005+:LG\u000fC\u0005\u0002Z5\t\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010J\u0019\u0002/\u0011Lh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ\u0004\u0013a\u00073z]\u0006l\u0017nY\"mS\u0016tG/U;pi\u0006\u0004VO\u00197jg\",'\u000fE\u00025\u0003CJ1!a\u0019-\u0005m!\u0015P\\1nS\u000e\u001cE.[3oiF+x\u000e^1Qk\nd\u0017n\u001d5fe\u0006q1o\u0019:b[B+(\r\\5tQ\u0016\u0014\bc\u0001\u001b\u0002j%\u0019\u00111\u000e\u0017\u0003\u001dM\u001b'/Y7Qk\nd\u0017n\u001d5fe\u0006AB-\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000eU;cY&\u001c\b.\u001a:\u0011\u0007Q\n\t(C\u0002\u0002t1\u0012\u0001\u0004R3mK\u001e\fG/[8o)>\\WM\u001c)vE2L7\u000f[3s\u00031\t7\r\u001c)vE2L7\u000f[3s!\r!\u0014\u0011P\u0005\u0004\u0003wb#\u0001D!dYB+(\r\\5tQ\u0016\u0014\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000b\u0003\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005%\u00151\u0011\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/A\tgCR\fGNR1vYRD\u0015M\u001c3mKJ\u0004B!a$\u0002\u00186\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0003gCVdGO\u0003\u00020\u001d&!\u0011\u0011TAI\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003yiW\r^1eCR\f\u0007+\u001e2mSND\u0017N\\4GCVdG\u000fS1oI2,'/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b\u0003\u0002\u001dI\u0003C\u0003B!a)\u0002::!\u0011QUAZ\u001d\u0011\t9+a,\u000f\t\u0005%\u0016Q\u0016\b\u00045\u0006-\u0016\"A\u0019\n\u0005=\u0002\u0014bAAY]\u0005!A.\u001b8l\u0013\u0011\t),a.\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/\u001f\u0006\u0004\u0003cs\u0013\u0002BA^\u0003{\u00131\u0002T5oW6\u000bg.Y4fe*!\u0011QWA\\\u0003E!\u0018.\u001a:fI\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005q!\u000b\u0019\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tI\rM\u0001\u0005i&,'/\u0003\u0003\u0002N\u0006\u001d'\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\f!FY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;pe>\u0003H\u000f\u0005\u00039\u0011\u0006M\u0007\u0003BAk\u00037l!!a6\u000b\t\u0005e\u0017qY\u0001\u0016E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u0013\u0011\ti.a6\u0003O\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN]\u0001 i&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$8i\\8sI&t\u0017\r^8s\u001fB$\b\u0003\u0002\u001dI\u0003G\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0005\u0003S\f9-\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\ti/a:\u00039QKWM\u001d+pa&\u001c7K\\1qg\"|GoQ8pe\u0012Lg.\u0019;pe\u0006\u0019\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN](qiB!\u0001\bSAz!\u0011\t)0a?\u000e\u0005\u0005](\u0002BA}\u0003{\tQ!];pi\u0006LA!!@\u0002x\n\u0001\u0012+^8uC\u000e{wN\u001d3j]\u0006$xN\u001d\u000b+\u0005\u0003\u0011\u0019A!\u0002\u0003\b\t%!1\u0002B\u0007\u0005\u001f\u0011\tBa\u0005\u0003\u0016\t]!\u0011\u0004B\u000e\u0005;\u0011yB!\t\u0003$\t\u0015\"q\u0005B\u0015!\t!D\u0001C\u0003|7\u0001\u0007q\u000bC\u0003}7\u0001\u0007Q\u0010C\u0004\u0002\u0004m\u0001\r!!\u0002\t\u000f\u0005-1\u00041\u0001\u0002\u000e!9\u0011\u0011D\u000eA\u0002\u0005m\u0001bBA\u00117\u0001\u0007\u00111\u0005\u0005\b\u0003gY\u0002\u0019AA\u001b\u0011\u001d\t\u0019e\u0007a\u0001\u0003\u000fBq!!\u0018\u001c\u0001\u0004\ty\u0006C\u0004\u0002fm\u0001\r!a\u001a\t\u000f\u000554\u00041\u0001\u0002p!9\u0011QO\u000eA\u0002\u0005]\u0004bBA?7\u0001\u0007\u0011q\u0010\u0005\b\u0003\u0017[\u0002\u0019AAG\u0011\u001d\tYj\u0007a\u0001\u0003\u001bCq!!(\u001c\u0001\u0004\ty\nC\u0004\u0002@n\u0001\r!!1\t\u000f\u0005=7\u00041\u0001\u0002R\"9\u0011q\\\u000eA\u0002\u0005\u0005\bbBAx7\u0001\u0007\u0011\u0011_\u0001\tEJ|7.\u001a:JIV\u0011!q\u0006\t\u0004q\tE\u0012b\u0001B\u001as\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013!D0gSJ\u001cH\u000fU;cY&\u001c\b.\u0006\u0002\u0003<A\u0019\u0001H!\u0010\n\u0007\t}\u0012HA\u0004C_>dW-\u00198\u0002#}3\u0017N]:u!V\u0014G.[:i?\u0012*\u0017\u000f\u0006\u0003\u0002R\t\u0015\u0003\"CA-?\u0005\u0005\t\u0019\u0001B\u001e\u00039yf-\u001b:tiB+(\r\\5tQ\u0002\n!CZ5sgR\u0004VO\u00197jg\"4U\u000f^;sKV\u0011!Q\n\t\u0007\u0005\u001f\u0012IF!\u0018\u000e\u0005\tE#\u0002\u0002B*\u0005+\n!bY8oGV\u0014(/\u001a8u\u0015\r\u00119&]\u0001\u0005kRLG.\u0003\u0003\u0003\\\tE#!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0019aNa\u0018\n\u0007\t\u0005tN\u0001\u0003W_&$\u0017a\u00054jeN$\b+\u001e2mSNDg)\u001e;ve\u0016\u0004\u0013\u0001\u00028b[\u0016$\u0012aV\u0001\u0011_:lU\r^1eCR\fW\u000b\u001d3bi\u0016$\u0002\"!\u0015\u0003n\t=$\u0011\u000f\u0005\u0006Q\u0012\u0002\r!\u001b\u0005\u0006G\u0012\u0002\r\u0001\u001a\u0005\b\u0005g\"\u0003\u0019\u0001B;\u0003!i\u0017M\\5gKN$\b\u0003\u0002B<\u0005{j!A!\u001f\u000b\u0007\tmD*\u0001\u0004m_\u0006$WM]\u0005\u0005\u0005\u007f\u0012IH\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0002\u001bQ|w\n\u001d;j_:\fG.\u00138u)\u0011\u0011)I!$\u0011\t\t\u001d%\u0011R\u0007\u0003\u0005+JAAa#\u0003V\tYq\n\u001d;j_:\fG.\u00138u\u0011\u001d\u0011y)\na\u0001\u0005#\u000baa\u001c9uS>t\u0007\u0003\u0002\u001dI\u0005_\tQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005E#q\u0013\u0005\b\u000533\u0003\u0019\u0001BN\u0003\u0015\u0001(o\u001c9t!\u0011\u00119I!(\n\t\t}%Q\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!E;qI\u0006$XmQ8pe\u0012Lg.\u0019;peRa\u0011\u0011\u000bBS\u0005O\u0013IKa+\u00036\")Qj\na\u0001I\")\u0001n\na\u0001S\")ak\na\u0001/\"9!QV\u0014A\u0002\t=\u0016\u0001C3mK\u000e$\u0018n\u001c8\u0011\u0013a\u0012\tLa\f\u00030\u0005E\u0013b\u0001BZs\tIa)\u001e8di&|gN\r\u0005\b\u0005o;\u0003\u0019\u0001B]\u0003-\u0011Xm]5h]\u0006$\u0018n\u001c8\u0011\u0013a\u0012\tLa\f\u0003\u0012\u0006E\u0013AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$B!!\u0015\u0003@\")1\r\u000ba\u0001I\u0006\u0001c-\u001b8jg\"Le.\u001b;jC2L'0\u001b8h%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\t\t\t&A\u0003dY>\u001cX\r")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final CredentialProvider credentialProvider;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$4(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tieredCoordinator.foreach((Function1 & Serializable)tieredCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionId, x$2) -> {
                                tieredCoord.handleEmigration(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(64).append("Error updating ").append("tiered storage coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.quotaCoordinatorOpt.foreach((Function1 & Serializable)quotaCoordinator -> {
                            this.updateCoordinator(newImage, delta, "_confluent-quotas", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                quotaCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)quotaTopicPartitionId), (Option<Object>)coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating ").append("quota coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1 & Serializable)backupObjectLifecycleManagerCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionId, x$4) -> {
                                backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(81).append("Error updating ").append("backup object lifecycle manager coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tierTopicSnapshotCoordinatorOpt.foreach((Function1 & Serializable)tierSnapshotCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(partitionId, x$5) -> tierSnapshotCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionId, x$6) -> {
                                tierSnapshotCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(69).append("Error updating ").append("tier topic snapshot coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.clusterLinkManager.foreach((Function1 & Serializable)manager -> {
                            this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionId, leaderEpoch) -> {
                                manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt((Object)partitionId), (Option<Object>)leaderEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(58).append("Error updating ").append("cluster link manager with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                Option$.MODULE$.apply((Object)delta.scramDelta()).foreach((Function1 & Serializable)scramDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$29(this, scramDelta);
                    return BoxedUnit.UNIT;
                });
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics((Option<String>)None$.MODULE$));
            this.logManager.deleteStrayKRaftReplicas(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1 & Serializable)x$7 -> {
                x$7.startup();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1 & Serializable)x$8 -> {
                x$8.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("_confluent-quotas").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.confluentConfig().quotasTopicPartitions()))));
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$29(BrokerMetadataPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> x1$1.forEach((x0$2, x1$2) -> {
            if (x1$2.isPresent()) {
                $this.credentialProvider.updateCredential((ScramMechanism)x0$1, (String)x0$2, ((ScramCredentialData)x1$2.get()).toCredential(x0$1));
                return;
            }
            $this.credentialProvider.removeCredentials((ScramMechanism)x0$1, (String)x0$2);
        }));
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, CredentialProvider credentialProvider, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.credentialProvider = credentialProvider;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.tierTopicSnapshotCoordinatorOpt = tierTopicSnapshotCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

