/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultTenantEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.TenantEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0006\r\u0001MA\u0011\u0002\t\u0001\u0003\u0006\u0004%\t\u0001D\u0011\t\u0011A\u0002!\u0011!Q\u0001\n\tB\u0011\"\r\u0001\u0003\u0006\u0004%\t\u0001\u0004\u001a\t\u0011e\u0002!\u0011!Q\u0001\nMBQA\u000f\u0001\u0005\u0002mBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0011\u0001\u0005\nICQA\u0019\u0001\u0005\u0002\rDQA\u001b\u0001\u0005\u0002-DQa\u001c\u0001\u0005\u0002A\u0014!d\u00117jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJT!!\u0004\b\u0002\u00115,G/\u00193bi\u0006T!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e!\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\t!\u0005\u0005\u0002$[9\u0011Ae\u000b\b\u0003K)r!AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tac\"\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0002/_\ti\u0011+^8uC6\u000bg.Y4feNT!\u0001\f\b\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011a\u0007E\u0001\b]\u0016$xo\u001c:l\u0013\tATG\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\u0002\rqJg.\u001b;?)\radh\u0010\t\u0003{\u0001i\u0011\u0001\u0004\u0005\u0006A\u0015\u0001\rA\t\u0005\u0006c\u0015\u0001\raM\u0001\u0007kB$\u0017\r^3\u0015\u0005\t+\u0005CA\u000bD\u0013\t!eC\u0001\u0003V]&$\b\"\u0002$\u0007\u0001\u00049\u0015aC9v_R\f7\u000fR3mi\u0006\u0004\"\u0001\u0013)\u000e\u0003%S!AS&\u0002\u000b%l\u0017mZ3\u000b\u0005Ea%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!U%\u0003#\rc\u0017.\u001a8u#V|G/Y:EK2$\u0018\rF\u0002C'vCQ\u0001V\u0004A\u0002U\u000ba!\u001a8uSRL\bC\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015\tXo\u001c;b\u0015\tQ6*\u0001\u0004d_6lwN\\\u0005\u00039^\u0013\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u0015qv\u00011\u0001`\u0003)\tXo\u001c;b\t\u0016dG/\u0019\t\u0003\u0011\u0002L!!Y%\u0003!\rc\u0017.\u001a8u#V|G/\u0019#fYR\f\u0017!\u00045b]\u0012dW-\u00139Rk>$\u0018\rF\u0002CI&DQ!\u001a\u0005A\u0002\u0019\f\u0001\"\u001b9F]RLG/\u001f\t\u0003{\u001dL!\u0001\u001b\u0007\u0003\u0017E+x\u000e^1F]RLG/\u001f\u0005\u0006=\"\u0001\raX\u0001\u0012Q\u0006tG\r\\3UK:\fg\u000e^)v_R\fGc\u0001\"m]\")Q.\u0003a\u0001M\u0006aA/\u001a8b]R,e\u000e^5us\")a,\u0003a\u0001?\u0006Y\u0002.\u00198eY\u0016,6/\u001a:DY&,g\u000e^)v_R\f7\t[1oO\u0016$BAQ9t{\")!O\u0003a\u0001M\u0006Y\u0011/^8uC\u0016sG/\u001b;z\u0011\u0015!(\u00021\u0001v\u0003\rYW-\u001f\t\u0003mjt!a\u001e=\u0011\u0005\u00192\u0012BA=\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e4\u0002\"\u0002@\u000b\u0001\u0004y\u0018\u0001\u00038foZ\u000bG.^3\u0011\u000bU\t\t!!\u0002\n\u0007\u0005\raC\u0001\u0004PaRLwN\u001c\t\u0004+\u0005\u001d\u0011bAA\u0005-\t1Ai\\;cY\u0016\u0004")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().entrySet().forEach(e -> this.update((ClientQuotaEntity)e.getKey(), (ClientQuotaDelta)e.getValue()));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product ipEntity = product;
            this.handleIpQuota((QuotaEntity)ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("confluent-tenant")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("confluent-tenant"));
            if (option instanceof Some) {
                String tenant = (String)((Some)option).value();
                product = new TenantEntity(tenant);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultTenantEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product tenantEntity = product;
            this.handleTenantQuota((QuotaEntity)tenantEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().entrySet().forEach(e -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)e.getKey(), (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble((OptionalDouble)e.getValue())).map((Function1)(JFunction1.mcDD.sp & Serializable)x$1 -> x$1)));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Ignoring unsupported quota entity ").append(entity).append(".").toString());
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            String ip = ((IpEntity)ipEntity).ip();
            try {
                none$ = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unable to resolve address ").append(ip).toString());
            }
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = none$;
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)inetAddress, arg_0));
    }

    public void handleTenantQuota(QuotaEntity tenantEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (tenantEntity instanceof TenantEntity) {
            String tenant = ((TenantEntity)tenantEntity).tenant();
            none$ = new Some((Object)tenant);
        } else if (DefaultTenantEntity$.MODULE$.equals(tenantEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle tenant quota entities here");
        }
        None$ tenantOpt = none$;
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$1(this, tenantEntity, (Option)tenantOpt, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        None$ none$;
        Some some;
        ClientQuotaManager clientQuotaManager;
        block26: {
            switch (key == null ? 0 : key.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block26;
                }
                case -965904822: {
                    if (!"request_percentage".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block26;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block26;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block26;
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(key).append(" for entity ").append(quotaEntity).toString());
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        if (quotaEntity instanceof UserEntity) {
            String user = ((UserEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = None$.MODULE$;
        } else if (DefaultUserEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = None$.MODULE$;
        } else if (quotaEntity instanceof ClientIdEntity) {
            String clientId = ((ClientIdEntity)quotaEntity).clientId();
            some = None$.MODULE$;
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = None$.MODULE$;
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof ExplicitUserExplicitClientIdEntity) {
            ExplicitUserExplicitClientIdEntity explicitUserExplicitClientIdEntity = (ExplicitUserExplicitClientIdEntity)quotaEntity;
            String user = explicitUserExplicitClientIdEntity.user();
            String clientId = explicitUserExplicitClientIdEntity.clientId();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (quotaEntity instanceof ExplicitUserDefaultClientIdEntity) {
            String user = ((ExplicitUserDefaultClientIdEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof DefaultUserExplicitClientIdEntity) {
            String clientId = ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId();
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else {
            if (quotaEntity instanceof IpEntity ? true : DefaultIpEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see IP quota entities here");
            }
            if (quotaEntity instanceof TenantEntity ? true : DefaultTenantEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see tenant quota entities here");
            }
            throw new MatchError((Object)quotaEntity);
        }
        None$ none$2 = none$;
        Option sanitizedUser = (Option)some;
        Option sanitizedClientId = (Option)none$2;
        Option quotaValue = newValue.map((Function1 & Serializable)x$3 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)x$3)));
        try {
            void var13_14;
            void var12_13;
            manager.updateQuota((Option<String>)var12_13, (Option<String>)var13_14.map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1)), (Option<String>)var13_14, (Option<Quota>)quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Failed to update user-client quota ").append(quotaEntity).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (!quotaName.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(ipEntity$1).toString());
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to update IP quota ").append(ipEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$1(ClientQuotaMetadataManager $this, QuotaEntity tenantEntity$1, Option tenantOpt$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (!quotaName.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(tenantEntity$1).toString());
            return;
        }
        try {
            $this.connectionQuotas().updateTenantConnectionRateQuota((Option<String>)tenantOpt$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tennat quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$3) {
        return new Quota(x$3, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
    }
}

